<?php
/**
 * Name:  Blog Carousel
 **/
?>
<?php
$prefix   = 'main_post_';
$data     = array(
	'infinite'     => false,
	'dots'         => true,
	'slidesToShow' => (int)ocolus_get_option( $prefix . 'items', 3 ),
	'responsive'   => array(
		array(
			'breakpoint' => 1500,
			'settings'   => array(
				'slidesToShow' => (int)ocolus_get_option( $prefix . 'desktop', 3 ),
			),
		),
		array(
			'breakpoint' => 1200,
			'settings'   => array(
				'slidesToShow' => (int)ocolus_get_option( $prefix . 'laptop', 3 ),
			),
		),
		array(
			'breakpoint' => 992,
			'settings'   => array(
				'slidesToShow' => (int)ocolus_get_option( $prefix . 'tablet', 2 ),
			),
		),
		array(
			'breakpoint' => 768,
			'settings'   => array(
				'slidesToShow' => (int)ocolus_get_option( $prefix . 'ipad', 2 ),
			),
		),
		array(
			'breakpoint' => 480,
			'settings'   => array(
				'slidesToShow' => (int)ocolus_get_option( $prefix . 'mobile', 2 ),
			),
		),
	),
);
$generate = ' data-slick=' . json_encode( $data ) . ' ';
?>
<?php if ( have_posts() ): ?>
    <div class="blog-content">
        <div class="owl-slick equal-container better-height" <?php echo esc_attr( $generate ); ?>>
			<?php while ( have_posts() ): the_post(); ?>
                <article <?php post_class( 'post-item style-02' ); ?>>
					<?php get_template_part( 'templates/blog/blog-style/content-blog', 'style-02' ); ?>
                </article>
			<?php endwhile;
			wp_reset_postdata(); ?>
        </div>
		<?php ocolus_post_pagination(); ?>
    </div>
<?php else :
	get_template_part( 'content', 'none' );
endif;

