<?php
/**
 * The sidebar containing the main widget area
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package WordPress
 * @subpackage Ocolus
 * @since 1.0
 * @version 1.0
 */
$page_layout = ocolus_page_layout();
?>
<?php if ( $page_layout['layout'] != 'full' ) : ?>
    <aside id="secondary" class="widget-area ocolus-dropdown overlay" role="complementary"
           aria-label="<?php esc_attr_e( 'Shop Sidebar', 'ocolus' ); ?>">
        <a href="#" class="sidebar-button"
           data-ocolus="ocolus-dropdown"><?php echo esc_html__( 'Sidebar', 'ocolus' ); ?></a>
		<?php dynamic_sidebar( $page_layout['sidebar'] ); ?>
    </aside><!-- #secondary -->
<?php endif; ?>
</div><!-- .site-content-contain -->
