<?php
/**
 * The template for displaying all pages
 *
 * This is the template that displays all pages by default.
 * Please note that this is the WordPress construct of pages
 * and that other 'pages' on your WordPress site may use a
 * different template.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package WordPress
 * @subpackage Ocolus
 * @since 1.0
 * @version 1.0
 */
get_header(); ?>
<?php
$page_layout = ocolus_page_layout();
$meta_class  = ocolus_theme_option_meta( '_custom_page_side_options', null, 'page_extra_class' );
$meta_title  = ocolus_theme_option_meta( '_custom_page_side_options', null, 'disable_page_title' );
if ( class_exists( 'WooCommerce' ) ) {
	if ( is_checkout() || is_account_page() || is_cart() ) {
		$page_layout['layout'] = 'full';
	}
}
/* CLASS */
$main_class   = array( "site-content", $meta_class );
$main_class[] = "container";
$main_class[] = "sidebar-{$page_layout['layout']}";
?>
    <!-- .site-content-contain -->
    <div id="content" class="<?php echo implode( ' ', $main_class ); ?>">

		<?php
		if ( $meta_title != 1 ) :
			ocolus_post_breadcrumb();
		else : ?>
            <div class="page-header style-1 no-page-title">
				<?php do_action( 'ovic_breadcrumb' ); ?>
            </div>
		<?php endif; ?>

        <div id="primary" class="content-area">
            <main id="main" class="site-main" role="main">

				<?php
				while ( have_posts() ) :
					the_post();
					?>
                    <article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
                        <div class="entry-content">
							<?php
							the_content();
							wp_link_pages( array(
									'before'      => '<div class="post-pagination"><span class="title">' . esc_html__( 'Pages:', 'ocolus' ) . '</span>',
									'after'       => '</div>',
									'link_before' => '<span>',
									'link_after'  => '</span>',
								)
							);
							?>
                        </div><!-- .entry-content -->
                    </article><!-- #post-## -->
					<?php
					// If comments are open or we have at least one comment, load up the comment template.
					if ( comments_open() || get_comments_number() ) :
						comments_template();
					endif;
				endwhile; // End of the loop.
				?>

            </main><!-- #main -->
        </div><!-- #primary -->

		<?php if ( $page_layout['layout'] != 'full' ) : ?>
            <aside id="secondary" class="widget-area ocolus-dropdown overlay" role="complementary"
                   aria-label="<?php esc_attr_e( 'Page Sidebar', 'ocolus' ); ?>">
                <a href="#" class="sidebar-button"
                   data-ocolus="ocolus-dropdown"><?php echo esc_html__( 'Sidebar', 'ocolus' ); ?></a>
				<?php dynamic_sidebar( $page_layout['sidebar'] ); ?>
            </aside><!-- #secondary -->
		<?php endif; ?>

    </div><!-- .site-content-contain -->

<?php
get_footer();
