<?php
/**
 * The main template file
 *
 * This is the most generic template file in a WordPress theme
 * and one of the two required files for a theme (the other being style.css).
 * It is used to display a page when nothing more specific matches a query.
 * E.g., it puts together the home page when no home.php file exists.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package WordPress
 * @subpackage Ocolus
 * @since 1.0
 * @version 1.0
 */
get_header();
global $post;
$enable_small = 0;
$page_layout  = ocolus_page_layout();
$post_style   = ocolus_get_option( 'blog_list_style', 'list_v1' );
if ( is_single() ) {
	$post_style   = ocolus_get_option( 'single_layout', 'standard' );
	$enable_small = ocolus_get_option( 'single_enable_small' );
}
if ( is_search() ) {
	$post_style            = 'list_v1';
	$page_layout['layout'] = 'full';
}
if (
	$post_style == 'grid' ||
	$post_style == 'grid_2' ||
	$post_style == 'grid_with_text' ||
	$post_style == 'grid_full_width' ||
	$post_style == 'list_with_text' ||
	$post_style == 'carousel' ||
	$post_style == 'full_screen' ||
	$post_style == 'masonry' ||
	$post_style == 'metro' ||
	$post_style == 'split' ||
	$post_style == 'column' ||
	$post_style == 'zigzag'
) {
	$page_layout['layout'] = 'full';
}
/* CLASS */
$match                 = array(
	'full_screen',
	'metro',
	'split',
	'masonry',
	'grid_full_width',
);
$match_isotope         = array(
	'grid',
	'grid_2',
	'metro',
	'split',
	'masonry',
	'grid_with_text',
	'grid_full_width',
);
$main_class            = array( "site-content" );
$main_class[]          = "sidebar-{$page_layout['layout']}";
$main_class['style']   = "style-{$post_style}";
$main_class['content'] = "container";
if ( is_single() ) {
	$main_class['style'] = "style-single-{$post_style}";
	if ( $enable_small == 1 ) {
		$main_class[] = "layout-small";
	}
	if ( is_sticky() ) {
		$main_class[] = 'sticky';
	}
	wp_enqueue_style( 'ocolus-blog-single' );
} else {
	if ( in_array( $post_style, $match ) ) {
		$main_class['content'] = "";
	}
	wp_enqueue_style( 'ocolus-blog-main' );
}
if ( in_array( $post_style, $match_isotope ) ) {
	wp_enqueue_script( 'ocolus-grid-isotope' );
}
if ( $post_style == 'split' || is_single() ) {
	wp_enqueue_script( 'ocolus-sticky' );
}
?>

    <!-- .site-content-contain -->
    <div id="content" class="<?php echo implode( ' ', $main_class ); ?>">

		<?php
		if ( $post_style != 'full_screen' && $post_style != 'split' ) {
			ocolus_post_breadcrumb();
		}
		if ( is_single() ) {
			ocolus_scroll_sticky();
		}
		?>
		<?php if ( isset( $post->ID ) && has_post_thumbnail( $post->ID ) && is_single() && $post_style == 'full_width_v1' ): ?>
            <div class="post-item">
                <div class="post-thumb">
                    <figure>
						<?php
						echo wp_get_attachment_image( get_post_thumbnail_id( $post->ID ), 'full' );
						?>
                    </figure>
					<?php ocolus_post_meta_single(); ?>
                </div>
            </div>
		<?php endif; ?>

        <div id="primary" class="content-area">
            <main id="main" class="site-main" role="main">

				<?php
				$path = 'content';
				if ( is_single() )
					$path = 'single';
				get_template_part( "templates/blog/blog-{$path}/{$post_style}" );
				?>

            </main><!-- #main -->
        </div><!-- #primary -->

		<?php if ( $page_layout['layout'] != 'full' ) : ?>
            <aside id="secondary" class="widget-area ocolus-dropdown overlay" role="complementary"
                   aria-label="<?php esc_attr_e( 'Post Sidebar', 'ocolus' ); ?>">
                <a href="#" class="sidebar-button"
                   data-ocolus="ocolus-dropdown"><?php echo esc_html__( 'Sidebar', 'ocolus' ); ?></a>
				<?php dynamic_sidebar( $page_layout['sidebar'] ); ?>
            </aside><!-- #secondary -->
		<?php endif; ?>

		<?php
		if ( is_single() )
			get_template_part( '/templates/blog/blog', 'related' );
		?>

    </div><!-- .site-content-contain -->
<?php get_footer();
