<?php
/***
 * Core Name: WooCommerce
 * Version: 1.0.0
 * Author: Khanh
 */
if ( !defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}
include_once dirname( __FILE__ ) . '/class-adjacent-products.php';
include_once dirname( __FILE__ ) . '/template-functions.php';
/**
 *
 * SETUP COLUMN
 */
add_action( 'init',
	function () {
		$GLOBALS['woocommerce_loop']['columns'] = ocolus_get_option( 'product_per_row', 4 );
	}
);
/**
 *
 * SETUP COOKIES
 */
if ( !function_exists( 'ocolus_cookies_recently_viewed' ) ) {
	function ocolus_cookies_recently_viewed()
	{
		if ( !is_product() )
			return;

		global $post;

		if ( empty( $_COOKIE['woocommerce_recently_viewed'] ) ) { // @codingStandardsIgnoreLine.
			$viewed_products = array();
		} else {
			$viewed_products = wp_parse_id_list( (array)explode( '|', wp_unslash( $_COOKIE['woocommerce_recently_viewed'] ) ) ); // @codingStandardsIgnoreLine.
		}

		// Unset if already in viewed products list.
		$keys = array_flip( $viewed_products );

		if ( isset( $keys[$post->ID] ) ) {
			unset( $viewed_products[$keys[$post->ID]] );
		}

		$viewed_products[] = $post->ID;

		if ( count( $viewed_products ) > 15 ) {
			array_shift( $viewed_products );
		}

		// Store for session only.
		wc_setcookie( 'woocommerce_recently_viewed', implode( '|', $viewed_products ) );
	}
}
add_action( 'template_redirect', 'ocolus_cookies_recently_viewed', 20 );
/**
 *
 * REMOVE CSS
 */
add_filter( 'woocommerce_enqueue_styles', '__return_empty_array' );
/**
 *
 * REMOVE SUB CATEGORIES
 */
call_user_func( 'remove' . '_' . 'filter', 'woocommerce_product_loop_start', 'woocommerce_maybe_show_product_subcategories' );
add_filter( 'woocommerce_before_output_product_categories',
	function () {
		return '<ul class="shop-page columns-' . esc_attr( wc_get_loop_prop( 'columns' ) ) . '">';
	}
);
add_filter( 'woocommerce_after_output_product_categories',
	function () {
		return '</ul>';
	}
);
/**
 *
 * REMOVE "woocommerce_template_loop_product_link_open"
 */
remove_action( 'woocommerce_before_shop_loop_item', 'woocommerce_template_loop_product_link_open', 10 );
remove_action( 'woocommerce_after_shop_loop_item', 'woocommerce_template_loop_product_link_close', 5 );
/**
 *
 * REMOVE DESCRIPTION HEADING, INFOMATION HEADING
 */
add_filter( 'woocommerce_product_description_heading', function () { return ''; } );
add_filter( 'woocommerce_product_additional_information_heading', function () { return ''; } );
/**
 *
 * CUSTOM STAR RATING
 */
add_filter( 'woocommerce_product_get_rating_html', 'ocolus_custom_star_rating_html', 10, 3 );
/**
 *
 * CUSTOM PRODUCT POST PER PAGE
 */
add_filter( 'loop_shop_per_page', 'ocolus_loop_shop_per_page', 20 );
add_filter( 'woof_products_query', 'ocolus_woof_products_query', 20 );
/**
 *
 * CUSTOM SHOP CONTROL
 */
remove_action( 'woocommerce_before_shop_loop', 'woocommerce_catalog_ordering', 30 );
remove_action( 'woocommerce_before_shop_loop', 'woocommerce_result_count', 20 );
remove_action( 'woocommerce_after_shop_loop', 'woocommerce_pagination', 10 );
add_action( 'woocommerce_before_shop_loop', 'ocolus_control_before_shop_loop', 30 );
add_action( 'woocommerce_after_shop_loop', 'ocolus_control_after_shop_loop', 10 );
/**
 *
 * PRODUCT THUMBNAIL
 */
remove_action( 'woocommerce_before_shop_loop_item_title', 'woocommerce_template_loop_product_thumbnail', 10 );
add_action( 'woocommerce_before_shop_loop_item_title', 'ocolus_template_loop_product_thumbnail', 10 );
/**
 *
 * FILTER PRODUCT THUMBNAIL
 */
add_filter( 'woocommerce_get_image_size_gallery_thumbnail', 'ocolus_set_image_size_gallery_thumbnail' );
if ( !function_exists( 'ocolus_set_image_size_gallery_thumbnail' ) ) {
	function ocolus_set_image_size_gallery_thumbnail( $size )
	{
		$size_options   = ocolus_get_option( 'size_gallery_thumbnail',
			array(
				'width'  => '127',
				'height' => '157',
				'crop'   => '1',
			)
		);
		$size['width']  = $size_options['width'];
		$size['height'] = $size_options['height'];
		$size['crop']   = isset( $size_options['crop'] ) ? $size_options['crop'] : 0;

		return $size;
	}
}
add_filter( 'woocommerce_get_image_size_thumbnail', 'ocolus_set_image_size_thumbnail' );
if ( !function_exists( 'ocolus_set_image_size_thumbnail' ) ) {
	function ocolus_set_image_size_thumbnail( $size )
	{
		$size_options   = ocolus_get_option( 'size_thumbnail',
			array(
				'width'  => '262',
				'height' => '360',
				'crop'   => '1',
			)
		);
		$size['width']  = $size_options['width'];
		$size['height'] = $size_options['height'];
		$size['crop']   = isset( $size_options['crop'] ) ? $size_options['crop'] : 0;

		return $size;
	}
}
add_filter( 'woocommerce_get_image_size_single', 'ocolus_set_image_size_single' );
if ( !function_exists( 'ocolus_set_image_size_single' ) ) {
	function ocolus_set_image_size_single( $size )
	{
		$size_options   = ocolus_get_option( 'size_single',
			array(
				'width'  => '555',
				'height' => '700',
				'crop'   => '1',
			)
		);
		$size['width']  = $size_options['width'];
		$size['height'] = $size_options['height'];
		$size['crop']   = isset( $size_options['crop'] ) ? $size_options['crop'] : 0;

		return $size;
	}
}
/**
 *
 * CUSTOM PRODUCT NAME
 */
remove_action( 'woocommerce_shop_loop_item_title', 'woocommerce_template_loop_product_title', 10 );
add_action( 'woocommerce_shop_loop_item_title', 'ocolus_template_loop_product_title', 10 );
/**
 *
 * TERM DESCRIPTION
 */
remove_action( 'woocommerce_archive_description', 'woocommerce_taxonomy_archive_description', 10 );
add_action( 'woocommerce_archive_description', 'ocolus_taxonomy_archive_description', 10 );
/**
 *
 * WOOCOMMERCE BANNER
 */
remove_action( 'woocommerce_before_main_content', 'woocommerce_breadcrumb', 20 );
add_action( 'woocommerce_before_main_content', 'ocolus_woocommerce_banner', 5 );
/**
 *
 * WOOCOMMERCE PAGE TITLE
 */
add_filter( 'woocommerce_show_page_title', '__return_false' );
add_action( 'woocommerce_archive_description', 'ocolus_woocommerce_page_title', 5 );
/**
 *
 * WOOCOMMERCE COUPON
 */
add_action( 'woocommerce_before_add_to_cart_form', 'ocolus_coupon_product' );
/**
 *
 * WOOCOMMERCE SINGLE PRODUCT BRAND
 */
add_action( 'woocommerce_single_product_summary', 'ocolus_woocommerce_single_product_brand', 0 );
/**
 *
 * CUSTOM PRODUCT GIFT
 */
add_action( 'woocommerce_single_product_summary', 'ocolus_single_product_gift', 25 );
/**
 *
 * CUSTOM PRODUCT GUARANTEED
 */
add_action( 'woocommerce_single_product_summary', 'ocolus_template_product_guaranteed', 36 );
/**
 *
 * CUSTOM PRODUCT MAILCHIMP
 */
add_action( 'woocommerce_single_product_summary', 'ocolus_template_product_mailchimp', 35 );
/**
 *
 * HOOK MY ACCOUNT
 */
if ( !function_exists( 'ocolus_change_tabs_login_form' ) ) {
	function ocolus_change_tabs_login_form()
	{
		if ( get_option( 'woocommerce_enable_myaccount_registration' ) === 'yes' ): ?>
            <div class="ocolus-head-account">
                <a href="#" class="form-tab-account sign-in active">
					<?php echo esc_html__( 'Sign In', 'ocolus' ); ?>
                </a>
                <a href="#" class="form-tab-account register">
					<?php echo esc_html__( 'Register', 'ocolus' ); ?>
                </a>
            </div>
		<?php
		endif;
	}
}
remove_action( 'woocommerce_before_customer_login_form', 'woocommerce_output_all_notices', 10 );
add_action( 'woocommerce_before_customer_login_form', 'ocolus_change_tabs_login_form', 5 );
add_action( 'woocommerce_before_customer_login_form', 'woocommerce_output_all_notices', 4 );
/**
 *
 * HOOK RELATED ITEMS
 */
add_filter( 'woocommerce_output_related_products_args',
	function ( $args ) {
		$args['posts_per_page'] = ocolus_get_option( 'woo_related_perpage', '6' );

		return $args;
	}
);
/**
 *
 * HOOK VENDOR
 */
if ( !function_exists( 'ocolus_sold_by_text' ) ) {
	function ocolus_sold_by_text()
	{
		if ( class_exists( 'WCMp' ) ) {
			global $WCMp;
			remove_action( 'woocommerce_after_shop_loop_item', array( $WCMp->vendor_caps, 'wcmp_after_add_to_cart_form' ), 6 );
			add_action( 'woocommerce_shop_loop_item_title', array( $WCMp->vendor_caps, 'wcmp_after_add_to_cart_form' ), 30 );
		}
	}
}
add_action( 'init', 'ocolus_sold_by_text' );
/**
 *
 * HOOK CROSS SELL
 */
remove_action( 'woocommerce_cart_collaterals', 'woocommerce_cross_sell_display' );
add_action( 'woocommerce_after_cart', 'woocommerce_cross_sell_display' );
/**
 *
 * HOOK MINI CART
 */
add_filter( 'woocommerce_add_to_cart_fragments', 'ocolus_cart_link_fragment' );
add_action( 'woocommerce_before_mini_cart', 'ocolus_header_cart_head', 10 );
add_filter( 'woocommerce_cart_item_thumbnail',
	function ( $thumbnail, $cart_item, $cart_item_key ) {
		$_product    = apply_filters( 'woocommerce_cart_item_product', $cart_item['data'], $cart_item, $cart_item_key );
		$image_thumb = ocolus_resize_image( $_product->get_image_id(), 100, 100, true, true );

		return $image_thumb['img'];
	}, 10, 3
);
add_filter( 'woocommerce_get_price_html',
	function ( $price ) {
		$price = "<span>{$price}</span>";

		return $price;
	}
);