<?php
/***
 * Core Name: WooCommerce
 * Version: 1.0.0
 * Author: Khanh
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}
/**
 *
 * WOOCOMMERCE SINGLE PRODUCT BRAND
 */
if ( ! function_exists( 'ocolus_woocommerce_single_product_brand' ) ) {
	function ocolus_woocommerce_single_product_brand()
	{
		global $product;
		$terms = get_the_terms( $product->get_id(), 'product_brand' );
		if ( ! empty( $terms ) && ! is_wp_error( $terms ) ) : ?>
            <div class="product-brand">
				<?php foreach ( $terms as $term ) : ?>
					<?php
					$term_url = get_term_link( $term->term_id, 'product_brand' );
					$logo     = get_term_meta( $term->term_id, 'logo_id', true );
					?>
                    <a href="<?php echo esc_url( $term_url ); ?>" class="brand-item">
						<?php if ( $logo ) : ?>
							<?php echo wp_get_attachment_image( $logo, 'full' ); ?>
						<?php else: ?>
							<?php echo esc_html( $term->name ); ?>
						<?php endif; ?>
                    </a>
				<?php endforeach; ?>
            </div>
		<?php endif;
	}
}
/**
 *
 * WOOCOMMERCE CUSTOM SHOP CONTROL
 */
if ( ! function_exists( 'ocolus_loop_shop_per_page' ) ) {
	function ocolus_loop_shop_per_page()
	{
		$products_perpage = ocolus_get_option( 'product_per_page', '12' );

		return $products_perpage;
	}
}
if ( ! function_exists( 'ocolus_woof_products_query' ) ) {
	function ocolus_woof_products_query( $wr )
	{
		$products_perpage     = ocolus_get_option( 'product_per_page', '12' );
		$wr['posts_per_page'] = $products_perpage;

		return $wr;
	}
}
if ( ! function_exists( 'ocolus_shop_display_mode_tmp' ) ) {
	function ocolus_shop_display_mode_tmp()
	{
		global $wp;
		if ( '' === get_option( 'permalink_structure' ) ) {
			$form_action = remove_query_arg( array(
				'page',
				'paged',
				'product-page'
			), add_query_arg( $wp->query_string, '', home_url( $wp->request ) ) );
		} else {
			$form_action = preg_replace( '%\/page/[0-9]+%', '', home_url( trailingslashit( $wp->request ) ) );
		}
		$shop_display_mode = ocolus_get_option( 'shop_list_style', 'grid' );
		?>
        <div class="grid-view-mode">
            <form method="get" action="<?php echo esc_url( $form_action ); ?>">
                <button type="submit"
                        class="modes-mode mode-grid display-mode <?php if ( $shop_display_mode == 'grid' ): ?>active<?php endif; ?>"
                        value="grid"
                        name="shop_list_style">
                        <span class="button-inner">
                            <span></span>
                            <span></span>
                            <span></span>
                            <span></span>
                        </span>
                </button>
                <button type="submit"
                        class="modes-mode mode-list display-mode <?php if ( $shop_display_mode == 'list' ): ?>active<?php endif; ?>"
                        value="list"
                        name="shop_list_style">
                        <span class="button-inner">
                            <span></span>
                            <span></span>
                            <span></span>
                        </span>
                </button>
				<?php wc_query_string_form_fields( null, array(
					'shop_list_style',
					'submit',
					'paged',
					'product-page'
				) ); ?>
            </form>
        </div>
		<?php
	}
}
if ( ! function_exists( 'ocolus_shop_filter_tmp' ) ) {
	function ocolus_shop_filter_tmp()
	{
		$page_layout = ocolus_page_layout();
		if ( $page_layout['layout'] == 'full' && is_active_sidebar( $page_layout['sidebar'] ) ):
			?>
            <div class="product-filter ocolus-dropdown overlay">
                <a href="#" class="button-filter" data-ocolus="ocolus-dropdown">
                    <span class="fa fa-filter"></span>
					<?php echo esc_html__( 'FILTER', 'ocolus' ); ?>
                </a>
                <div class="filter-content">
                    <a href="javascript:void(0)" class="filter-close"></a>
                    <div class="widget-area">
						<?php dynamic_sidebar( $page_layout['sidebar'] ); ?>
                    </div>
                </div>
            </div>
		<?php
		endif;
	}
}
if ( ! function_exists( 'ocolus_control_before_shop_loop' ) ) {
	function ocolus_control_before_shop_loop()
	{
		$template = 'default';
		wc_get_template( "product-control/{$template}-before-control.php",
			array(
				'template_type' => $template,
			)
		);
	}
}
if ( ! function_exists( 'ocolus_control_after_shop_loop' ) ) {
	function ocolus_control_after_shop_loop()
	{
		$template = 'default';
		wc_get_template( "product-control/{$template}-after-control.php",
			array(
				'template_type' => $template,
			)
		);
	}
}
/**
 *
 * WOOCOMMERCE PAGE TITLE
 */
if ( ! function_exists( 'ocolus_woocommerce_page_title' ) ) {
	function ocolus_woocommerce_page_title()
	{
		$classes = array(
			'page-title',
			'woocommerce-products-header__title',
		);
		if ( is_product_taxonomy() && 0 === absint( get_query_var( 'paged' ) ) ) {
			$term = get_queried_object();
			if ( $term && $term->taxonomy != 'dc_vendor_shop' ) {
				$logo_id  = get_term_meta( $term->term_id, 'logo_id', true );
				$image_id = get_term_meta( $term->term_id, 'thumbnail_id', true );
				if ( $image_id ) {
					$classes[] = 'is_archive';
				}
				echo '<h1 class="' . implode( ' ', $classes ) . '">';
				if ( $term->taxonomy == 'product_brand' && $logo_id ) {
					echo '<figure>' . wp_get_attachment_image( $logo_id, 'full' ) . '</figure>';
				} else {
					woocommerce_page_title();
				}
				echo '</h1>';
			}
		} else {
			echo '<h1 class="' . implode( ' ', $classes ) . '">';
			woocommerce_page_title();
			echo '</h1>';
		}
	}
}
/**
 *
 * WOOCOMMERCE BANNER
 */
if ( ! function_exists( 'ocolus_woocommerce_banner' ) ) {
	function ocolus_woocommerce_banner()
	{
		$background      = '';
		$class           = array( 'page-header style-1' );
		$shop_background = ocolus_get_option( 'shop_background', '' );
		if ( $shop_background && $shop_background != '' ) {
			$background = wp_get_attachment_image_url( $shop_background, 'full' );
			$class[]    = 'has-banner lazy';
		}
		if ( ! is_product() ): ?>
            <div class="<?php echo esc_attr( implode( ' ', $class ) ); ?>"
                 data-src="<?php echo esc_attr( $background ); ?>">
                <h1 class="page-title">
					<?php woocommerce_page_title(); ?>
                </h1>
				<?php woocommerce_breadcrumb(); ?>
            </div>
		<?php else : ?>
            <div class="page-header style-2">
				<?php woocommerce_breadcrumb(); ?>
            </div>
		<?php endif;
	}
}
/**
 *
 * QUICK VIEW
 */
if ( class_exists( 'YITH_WCQV_Frontend' ) ) {
	// Class frontend
	$enable           = get_option( 'yith-wcqv-enable' ) == 'yes' ? true : false;
	$enable_on_mobile = get_option( 'yith-wcqv-enable-mobile' ) == 'yes' ? true : false;
	$quickview_style  = ocolus_get_option( 'quickview_style', 'style-01' );
	// Class frontend
	if ( ( ! wp_is_mobile() && $enable ) || ( wp_is_mobile() && $enable_on_mobile && $enable ) ) {
		/**
		 *
		 * QUICKVIEW SCRIPT
		 */
		if ( ! function_exists( 'ocolus_quick_view_add_scripts' ) ) {
			function ocolus_quick_view_add_scripts()
			{
				if ( current_theme_supports( 'wc-product-gallery-slider' ) && ! is_product() && ! ocolus_is_mobile( true ) ) {
					wp_enqueue_script( 'flexslider' );
				}
			}

			add_action( 'yith_quick_view_custom_style_scripts', 'ocolus_quick_view_add_scripts' );
		}
		/**
		 *
		 * QUICKVIEW BUTTON
		 */
		remove_action( 'woocommerce_after_shop_loop_item', array(
			YITH_WCQV_Frontend::get_instance(),
			'yith_add_quick_view_button'
		), 15 );
		add_action( 'ocolus_function_shop_loop_item_quickview', array(
			YITH_WCQV_Frontend::get_instance(),
			'yith_add_quick_view_button'
		), 5 );
	}
}
/**
 *
 * WISHLIST
 */
if ( defined( 'YITH_WCWL' ) ) {
	if ( ! function_exists( 'ocolus_function_shop_loop_item_wishlist' ) ) {
		function ocolus_function_shop_loop_item_wishlist()
		{
			echo do_shortcode( "[yith_wcwl_add_to_wishlist]" );
		}
	}
	add_action( 'ocolus_function_shop_loop_item_wishlist', 'ocolus_function_shop_loop_item_wishlist', 1 );
}
/**
 *
 * COMPARE
 */
if ( class_exists( 'YITH_Woocompare' ) && get_option( 'yith_woocompare_compare_button_in_products_list' ) == 'yes' ) {
	global $yith_woocompare;
	$is_ajax = ( defined( 'DOING_AJAX' ) && DOING_AJAX );
	if ( $yith_woocompare->is_frontend() || $is_ajax ) {
		if ( $is_ajax ) {
			if ( ! class_exists( 'YITH_Woocompare_Frontend' ) && file_exists( YITH_WOOCOMPARE_DIR . 'includes/class.yith-woocompare-frontend.php' ) ) {
				require_once YITH_WOOCOMPARE_DIR . 'includes/class.yith-woocompare-frontend.php';
			}
			$yith_woocompare->obj = new YITH_Woocompare_Frontend();
		}
		/* Remove button */
		remove_action( 'woocommerce_single_product_summary', array( $yith_woocompare->obj, 'add_compare_link' ), 35 );
		remove_action( 'woocommerce_after_shop_loop_item', array( $yith_woocompare->obj, 'add_compare_link' ), 20 );
		/* Add compare button */
		if ( ! function_exists( 'ocolus_wc_loop_product_compare_btn' ) ) {
			function ocolus_wc_loop_product_compare_btn()
			{
				global $product;
				if ( shortcode_exists( 'yith_compare_button' ) ) {
					echo do_shortcode( '[yith_compare_button product_id="' . $product->get_id() . '"]' );
				} else {
					if ( class_exists( 'YITH_Woocompare_Frontend' ) ) {
						echo do_shortcode( '[yith_compare_button product_id="' . $product->get_id() . '"]' );
					}
				}
			}
		}
		add_action( 'ocolus_function_shop_loop_item_compare', 'ocolus_wc_loop_product_compare_btn', 1 );
	}
}
if ( ! function_exists( 'ocolus_taxonomy_archive_description' ) ) {
	function ocolus_taxonomy_archive_description()
	{
		if ( is_product_taxonomy() && 0 === absint( get_query_var( 'paged' ) ) ) {
			$term = get_queried_object();
			if ( $term && $term->taxonomy !== 'dc_vendor_shop' ) {
				$image = get_term_meta( $term->term_id, 'thumbnail_id', true );
				if ( $image ) {
					echo '<figure>' . wp_get_attachment_image( $image, 'full' ) . '</figure>';
				}
				if ( $term->description ) {
					echo '<div class="term-description">' . wc_format_content( $term->description ) . '</div>'; // WPCS: XSS ok.
				}
			}
		}
	}
}
if ( ! function_exists( 'ocolus_generate_carousel_products' ) ) {
	function ocolus_generate_carousel_products( $prefix )
	{
		$enable_product = ocolus_get_option( $prefix . '_enable', 'enable' );
		if ( $enable_product == 'disable' ) {
			return array();
		}
		$style_product = ocolus_get_option( $prefix . '_style', 'style-01' );
		$title_product = ocolus_get_option( $prefix . '_title', '' );
		$data          = array(
			'infinite'     => false,
			'slidesToShow' => (int) ocolus_get_option( $prefix . '_items', 3 ),
			'responsive'   => array(
				array(
					'breakpoint' => 1500,
					'settings'   => array(
						'slidesToShow' => (int) ocolus_get_option( $prefix . '_desktop', 3 ),
					),
				),
				array(
					'breakpoint' => 1200,
					'settings'   => array(
						'slidesToShow' => (int) ocolus_get_option( $prefix . '_laptop', 3 ),
					),
				),
				array(
					'breakpoint' => 992,
					'settings'   => array(
						'slidesMargin' => 20,
						'slidesToShow' => (int) ocolus_get_option( $prefix . '_tablet', 2 ),
					),
				),
				array(
					'breakpoint' => 768,
					'settings'   => array(
						'slidesMargin' => 15,
						'slidesToShow' => (int) ocolus_get_option( $prefix . '_ipad', 2 ),
					),
				),
				array(
					'breakpoint' => 480,
					'settings'   => array(
						'slidesMargin' => 10,
						'slidesToShow' => (int) ocolus_get_option( $prefix . '_mobile', 2 ),
					),
				),
			),
		);
		$generate      = ' data-slick=' . json_encode( $data ) . ' ';

		return array(
			'title'    => $title_product,
			'style'    => $style_product,
			'carousel' => $generate,
		);
	}
}
if ( ! function_exists( 'ocolus_woocommerce_grid_products' ) ) {
	function ocolus_woocommerce_grid_products()
	{
		$shop_display_mode = ocolus_get_option( 'shop_list_style', 'grid' );
		$product_style     = ocolus_get_option( 'shop_product_style', 'style-01' );
		$classes           = array( 'product-item' );
		if ( $shop_display_mode == 'grid' ) {
			$classes[] = $product_style;
		} else {
			$product_style = 'list';
			$classes[]     = 'list col-sm-12';
		}

		return array(
			'class' => $classes,
			'style' => $product_style,
		);
	}
}
if ( ! function_exists( 'ocolus_custom_available_variation' ) ) {
	function ocolus_custom_available_variation( $data, $product, $variation )
	{
		if ( isset( $_POST['custom_data'] ) && $_POST['custom_data'] != '' ) {
			// GET SIZE IMAGE SETTING
			list( $width, $height ) = explode( 'x', $_POST['custom_data'] );
			$image_variable             = ocolus_resize_image( $data['image_id'], $width, $height, true, false );
			$data['image']['src']       = $image_variable['url'];
			$data['image']['url']       = $image_variable['url'];
			$data['image']['full_src']  = $image_variable['url'];
			$data['image']['thumb_src'] = $image_variable['url'];
			$data['image']['srcset']    = $image_variable['url'];
			$data['image']['src_w']     = $width;
			$data['image']['src_h']     = $height;
		}

		return $data;
	}

	add_filter( 'woocommerce_available_variation', 'ocolus_custom_available_variation', 10, 3 );
}
/**
 *
 * PRODUCT THUMBNAIL
 */
if ( ! function_exists( 'ocolus_template_loop_product_thumbnail' ) ) {
	function ocolus_template_loop_product_thumbnail()
	{
		global $product;
		// GET SIZE IMAGE SETTING
		$width  = 300;
		$height = 300;
		$size   = wc_get_image_size( 'shop_catalog' );
		if ( $size ) {
			$width  = $size['width'];
			$height = $size['height'];
		}
		$crop               = true;
		$width              = apply_filters( 'ocolus_shop_product_thumb_width', $width );
		$height             = apply_filters( 'ocolus_shop_product_thumb_height', $height );
		$lazy_load          = true;
		$thumbnail_id       = $product->get_image_id();
		$attachment_ids     = $product->get_gallery_image_ids();
		$default_attributes = $product->get_default_attributes();
		$image_full         = wp_get_attachment_image_url( $thumbnail_id, 'full' );
		$products_hover     = ocolus_get_option( 'products_hover', 'none' );
		$class_product      = apply_filters( 'ocolus_filter_product_item', '' );
		if ( isset( $class_product['list_style'] ) && $class_product['list_style'] == 'isotope' ) {
			$meta_product = get_post_meta( $product->get_id(), '_custom_product_side_options', true );
			if ( isset( $meta_product['image_isotope'] ) ) {
				if ( isset( $class_product['current_size'] ) && $class_product['current_size'] == 'enable' ) {
					$meta_product['image_isotope'] = '1x1';
				}
				list( $ratio_width, $ratio_height ) = explode( 'x', $meta_product['image_isotope'] );
				$width  = $width * $ratio_width;
				$height = $height * $ratio_height;
				if ( isset( $class_product['rows_space'] ) ) {
					$add_size = str_replace( 'rows-space-', '', $class_product['rows_space'] );
					$width    = $width + $add_size;
					$height   = $height + $add_size;
				}
			}
		}
		if ( ! empty( $default_attributes ) ) {
			$lazy_load = false;
		}
		$class     = array(
			'thumb-link',
			'woocommerce-product-gallery__image',
			$products_hover,
		);
		$class_img = '';
		/* SECOND THUMB */
		$image_second = '';
		if ( isset( $attachment_ids[0] ) && has_post_thumbnail() && $products_hover == 'change' && ! wp_is_mobile() ) {
			$second_thumb = ocolus_resize_image( $attachment_ids[0], $width, $height, $crop, $lazy_load, true, 'wp-post-image' );
			$image_second = '<figure class="second-thumb">' . $second_thumb['img'] . '</figure>';
		} else {
			$class_img = 'wp-post-image';
		}
		$image_thumb = ocolus_resize_image( $thumbnail_id, $width, $height, $crop, $lazy_load, true, $class_img );
		?>
        <a class="<?php echo implode( ' ', $class ) ?>" href="<?php echo esc_url( $product->get_permalink() ); ?>">
            <figure class="primary-thumb" data-image="<?php echo esc_attr( $image_full ); ?>">
				<?php echo wp_specialchars_decode( $image_thumb['img'] ); ?>
            </figure>
			<?php echo wp_specialchars_decode( $image_second ); ?>
        </a>
		<?php
	}
}
/**
 *
 * PRODUCT GALLERY
 */
if ( ! function_exists( 'ocolus_template_product_gallery' ) ) {
	function ocolus_template_product_gallery()
	{
		global $product;
		// GET SIZE IMAGE SETTING
		$width  = 300;
		$height = 300;
		$size   = wc_get_image_size( 'shop_catalog' );
		if ( $size ) {
			$width  = $size['width'];
			$height = $size['height'];
		}
		if ( has_filter( 'ocolus_shop_product_thumb_width' ) && has_filter( 'ocolus_shop_product_thumb_height' ) ) {
			$width  = apply_filters( 'ocolus_shop_product_thumb_width', $width );
			$height = apply_filters( 'ocolus_shop_product_thumb_height', $height );
		}
		$attachment_ids = $product->get_gallery_image_ids();
		$primary_full   = ocolus_resize_image( $product->get_image_id(), $width, $height, true, true );
		$primary_thumb  = ocolus_resize_image( $product->get_image_id(), 66, 66, true, true );
		if ( ! empty( $attachment_ids ) && has_post_thumbnail() && ! ocolus_is_mobile( true ) ) : ?>
            <ul class="product-gallery">
                <li class="active">
                    <a href="<?php echo esc_url( $primary_full['url'] ); ?>">
						<?php echo wp_specialchars_decode( $primary_thumb['img'] ); ?>
                    </a>
                </li>
				<?php foreach ( $attachment_ids as $attachment_id ) : ?>
					<?php
					$gallery_full  = ocolus_resize_image( $attachment_id, $width, $height, true, true );
					$gallery_thumb = ocolus_resize_image( $attachment_id, 66, 66, true, true );
					?>
                    <li>
                        <a href="<?php echo esc_url( $gallery_full['url'] ); ?>">
							<?php echo wp_specialchars_decode( $gallery_thumb['img'] ); ?>
                        </a>
                    </li>
				<?php endforeach; ?>
            </ul>
		<?php endif;
	}
}
/**
 *
 * HEADER WISHLIST
 */
if ( ! function_exists( 'ocolus_header_wishlist' ) ) {
	function ocolus_header_wishlist()
	{
		if ( defined( 'YITH_WCWL' ) ) :
			$wishlist_url = YITH_WCWL()->get_wishlist_url();
			$count = YITH_WCWL()->count_products();
			if ( $wishlist_url != '' ) : ?>
                <div class="block-wishlist block-woo">
                    <a class="woo-wishlist-link icon-link"
                       href="<?php echo esc_url( $wishlist_url ); ?>">
                        <span class="fa fa-heart icon"></span>
                        <span class="text"><?php echo esc_html__( 'Wishlist', 'ocolus' ) ?></span>
                        <span class="count"><?php echo esc_html( $count ); ?></span>
                    </a>
                </div>
			<?php endif;
		endif;
	}
}
if ( ! function_exists( 'ocolus_header_cart_head' ) ) {
	function ocolus_header_cart_head()
	{
		echo sprintf( '<h4 class="mini-cart-title">' . esc_html__( 'Your Cart', 'ocolus' ) . '</h4><a href="#" data-ocolus="ocolus-dropdown" class="close-mini-cart"></a>' );
	}
}
if ( ! function_exists( 'ocolus_header_cart_link' ) ) {
	function ocolus_header_cart_link()
	{
		?>
        <a class="woo-cart-link icon-link" href="<?php echo wc_get_cart_url(); ?>"
           data-ocolus="ocolus-dropdown">
            <span class="fa fa-shopping-basket icon"></span>
            <span class="text"><?php echo esc_html__( 'Your Cart', 'ocolus' ); ?></span>
            <span class="count">
                <span class="count-number"><?php echo WC()->cart->get_cart_contents_count(); ?></span>
                <span class="count-text"><?php echo esc_html__( 'item(s)', 'ocolus' ); ?></span>
            </span>
        </a>
		<?php
	}
}
if ( ! function_exists( 'ocolus_header_mini_cart' ) ) {
	function ocolus_header_mini_cart( $overlay = false )
	{
		$class = array(
			'block-woo',
			'block-minicart',
		);
		if ( $overlay ) {
			$class[] = 'overlay';
		}
		if ( ! is_checkout() && ! is_cart() ) {
			$class[] = 'ocolus-dropdown';
		}
		?>
        <div class="<?php echo esc_attr( implode( ' ', $class ) ); ?>">
			<?php
			ocolus_header_cart_link();
			the_widget( 'WC_Widget_Cart', 'title=' );
			?>
        </div>
		<?php
	}
}
if ( ! function_exists( 'ocolus_cart_link_fragment' ) ) {
	function ocolus_cart_link_fragment( $fragments )
	{
		ob_start();
		ocolus_header_cart_link();
		$fragments['a.woo-cart-link'] = ob_get_clean();

		return $fragments;
	}
}
if ( ! function_exists( 'ocolus_template_loop_product_title' ) ) {
	function ocolus_template_loop_product_title()
	{
		echo '<h3 class="product-title"><a href="' . get_the_permalink() . '">' . get_the_title() . '</a></h3>';
	}
}
if ( ! function_exists( 'ocolus_product_get_label' ) ) {
	/**
	 *
	 * PRODUCT LABEL
	 *
	 * @param $product
	 *
	 * @return string
	 */
	function ocolus_product_get_label( $product )
	{
		$html             = '';
		$output           = array();
		$percentage_label = ocolus_get_option( 'onsale_label' );
		$product_label    = ocolus_get_option( 'product_label', array( 'sale,new' ) );
		if ( $product->is_on_sale() && in_array( 'sale', $product_label ) ) {
			$percentage = '';
			if ( $product->get_type() == 'variable' && $percentage_label ) {
				$available_variations = $product->get_variation_prices();
				$max_percentage       = 0;
				if ( ! empty( $available_variations['regular_price'] ) ) {
					foreach ( $available_variations['regular_price'] as $key => $regular_price ) {
						$sale_price = $available_variations['sale_price'][ $key ];
						if ( $sale_price < $regular_price ) {
							$percentage = round( ( ( $regular_price - $sale_price ) / $regular_price ) * 100 );
							if ( $percentage > $max_percentage ) {
								$max_percentage = $percentage;
							}
						}
					}
				}
				$percentage = $max_percentage;
			} elseif ( ( $product->get_type() == 'simple' || $product->get_type() == 'external' ) && $percentage_label == 1 ) {
				$percentage = round( ( ( $product->get_regular_price() - $product->get_sale_price() ) / $product->get_regular_price() ) * 100 );
			}
			if ( $percentage ) {
				$output[] = '<span class="onsale product-label">' . sprintf( esc_html__( '%s', 'ocolus' ), "-$percentage%" ) . '</span>';
			} else {
				$output[] = '<span class="onsale product-label">' . esc_html__( 'Sale', 'ocolus' ) . '</span>';
			}
		}
		if ( ! $product->is_in_stock() && ! is_product() && in_array( 'out', $product_label ) ) {
			$output[] = '<span class="out-of-stock product-label">' . esc_html__( 'Sold out', 'ocolus' ) . '</span>';
		}
		if ( $product->is_featured() && in_array( 'hot', $product_label ) ) {
			$output[] = '<span class="featured product-label">' . esc_html__( 'Hot', 'ocolus' ) . '</span>';
		}
		if ( in_array( 'new', $product_label ) ) {
			$postdatestamp = strtotime( get_the_time( 'Y-m-d' ) );
			$newness       = ocolus_get_option( 'product_newness', 0 );
			if ( ( time() - ( 60 * 60 * 24 * (int) $newness ) ) < (int) $postdatestamp ) {
				$output[] = '<span class="onnew product-label">' . esc_html__( 'New', 'ocolus' ) . '</span>';
			}
		}
		if ( in_array( 'gift', $product_label ) ) {
			$product_gift = get_post_meta( $product->get_id(), '_wfg_single_gift_products', true );
			if ( ! empty( $product_gift ) ) {
				$output[] = '<span class="gift product-label">' . esc_html__( 'Gift', 'ocolus' ) . '</span>';
			}
		}
		if ( $output && ! empty( $product_label ) ) {
			$html = '<div class="product-labels">' . implode( '', $output ) . '</div>';
		}

		return $html;
	}
}

/**
 * Retrieves the previous product.
 *
 * @param  bool  $in_same_term  Optional. Whether post should be in a same taxonomy term. Default false.
 * @param  array|string  $excluded_terms  Optional. Comma-separated list of excluded term IDs. Default empty.
 * @param  string  $taxonomy  Optional. Taxonomy, if $in_same_term is true. Default 'product_cat'.
 *
 * @return WC_Product|false Product object if successful. False if no valid product is found.
 * @since 2.4.3
 *
 */
if ( ! function_exists( 'ocolus_get_previous_product' ) ) {
	function ocolus_get_previous_product( $in_same_term = false, $excluded_terms = '', $taxonomy = 'product_cat' )
	{
		$product = new Ocolus_WooCommerce_Adjacent_Products( $in_same_term, $excluded_terms, $taxonomy, true );

		return $product->get_product();
	}
}

/**
 * Retrieves the next product.
 *
 * @param  bool  $in_same_term  Optional. Whether post should be in a same taxonomy term. Default false.
 * @param  array|string  $excluded_terms  Optional. Comma-separated list of excluded term IDs. Default empty.
 * @param  string  $taxonomy  Optional. Taxonomy, if $in_same_term is true. Default 'product_cat'.
 *
 * @return WC_Product|false Product object if successful. False if no valid product is found.
 * @since 2.4.3
 *
 */
if ( ! function_exists( 'ocolus_get_next_product' ) ) {
	function ocolus_get_next_product( $in_same_term = false, $excluded_terms = '', $taxonomy = 'product_cat' )
	{
		$product = new Ocolus_WooCommerce_Adjacent_Products( $in_same_term, $excluded_terms, $taxonomy );

		return $product->get_product();
	}
}

if ( ! function_exists( 'ocolus_single_product_pagination' ) ) {
	function ocolus_single_product_pagination()
	{
		// Show only products in the same category?
		$in_same_term   = apply_filters( 'ocolus_single_product_pagination_same_category', true );
		$excluded_terms = apply_filters( 'ocolus_single_product_pagination_excluded_terms', '' );
		$taxonomy       = apply_filters( 'ocolus_single_product_pagination_taxonomy', 'product_cat' );
		// Get previous and next products.
		$previous_product = ocolus_get_previous_product( $in_same_term, $excluded_terms, $taxonomy );
		$next_product     = ocolus_get_next_product( $in_same_term, $excluded_terms, $taxonomy );

		if ( ! $previous_product && ! $next_product ) {
			return;
		}
		?>
        <nav class="pagination-thumb ocolus-product-pagination">
			<?php if ( $previous_product ): ?>
                <a class="other-post prev" href="<?php echo esc_url( $previous_product->get_permalink() ); ?>">
                    <figure>
						<?php echo wp_specialchars_decode( $previous_product->get_image( array( 100, 100 ) ) ); ?>
                    </figure>
                    <span class="product-info">
                        <span class="ocolus-product-pagination__title">
                            <?php echo wp_kses_post( $previous_product->get_name() ); ?>
                        </span>
						<?php if ( $price_html = $previous_product->get_price_html() ): ?>
                            <span class="price"><?php echo wp_kses_post( $price_html ); ?></span>
						<?php endif; ?>
                    </span>
                </a>
			<?php endif; ?>
			<?php if ( $next_product ): ?>
                <a class="other-post next" href="<?php echo esc_url( $next_product->get_permalink() ); ?>">
                    <figure>
						<?php echo wp_specialchars_decode( $next_product->get_image( array( 100, 100 ) ) ); ?>
                    </figure>
                    <span class="product-info">
                        <span class="ocolus-product-pagination__title">
                            <?php echo wp_kses_post( $next_product->get_name() ); ?>
                        </span>
						<?php if ( $price_html = $next_product->get_price_html() ): ?>
                            <span class="price"><?php echo wp_kses_post( $price_html ); ?></span>
						<?php endif; ?>
                    </span>
                </a>
			<?php endif; ?>
        </nav>
		<?php
	}
}
if ( ! function_exists( 'ocolus_sticky_single_add_to_cart' ) ) {
	function ocolus_sticky_single_add_to_cart()
	{
		global $product;
		$enable = ocolus_get_option( 'sticky_add_to_cart' );
		if ( ! is_product() || $enable != 1 ) {
			return;
		}
		$params = apply_filters( 'ocolus_sticky_add_to_cart_params', array(
				'trigger_class' => 'entry-summary',
			)
		);
		wp_localize_script( 'ocolus-sticky-add-to-cart', 'ocolus_sticky_add_to_cart_params', $params );
		wp_enqueue_script( 'ocolus-sticky-add-to-cart' );
		?>
        <section class="ocolus-sticky-add-to-cart scroll-percent">
            <div class="ocolus-sticky-add-to-cart__content content">
                <div class="info">
                    <h4 class="title"><?php echo esc_html( $product->get_title() ); ?></h4>
                    <span class="price"><?php echo wp_kses_post( $product->get_price_html() ); ?></span>
                </div>
                <div class="group-button">
					<?php if ( $product->get_type() == 'simple' ) : ?>
						<?php woocommerce_template_single_add_to_cart(); ?>
					<?php else: ?>
                        <a href="<?php echo esc_url( $product->add_to_cart_url() ); ?>"
                           class="ocolus-sticky-add-to-cart__content-button button alt">
							<?php echo esc_attr( $product->add_to_cart_text() ); ?>
                        </a>
					<?php endif; ?>
                </div>
            </div>
            <span class="percent"></span>
        </section><!-- .ocolus-sticky-add-to-cart -->
		<?php
	}
}
if ( ! function_exists( 'ocolus_function_shop_loop_item_countdown' ) ) {
	function ocolus_function_shop_loop_item_countdown( $title = true, $args = array() )
	{
		global $product;
		$date = ocolus_get_max_date_sale( $product->get_id() );
		if ( $product->is_on_sale() ) {
			$date = apply_filters( 'ovic_change_datetime_countdown', $date, $product->get_id() );
		}
		if ( $date > 0 ) {
			$params = array(
				'days_text' => esc_html__( 'Days', 'ocolus' ),
				'hrs_text'  => esc_html__( 'Hrs', 'ocolus' ),
				'mins_text' => esc_html__( 'Mins', 'ocolus' ),
				'secs_text' => esc_html__( 'Secs', 'ocolus' ),
			);
			$params = wp_parse_args( $args, $params );
			wp_enqueue_script( 'ocolus-countdown' );
			?>
            <div class="ocolus-countdown-wrapper">
				<?php if ( $title !== false ): ?>
                    <h4 class="title">
                        <span class="fa fa-clock-o"></span>
						<?php echo esc_html__( 'Expires In', 'ocolus' ); ?>
                    </h4>
				<?php endif; ?>
                <div class="ocolus-countdown"
                     data-datetime="<?php echo date( 'm/j/Y g:i:s', $date ); ?>"
                     data-params="<?php echo esc_attr( wp_json_encode( $params ) ) ?>">
                </div>
            </div>
			<?php
		}
	}
}
if ( ! function_exists( 'ocolus_get_max_date_sale' ) ) {
	function ocolus_get_max_date_sale( $product_id )
	{
		$date_now = current_time( 'timestamp', 0 );
		// Get variations
		$args          = array(
			'post_type'   => 'product_variation',
			'post_status' => array( 'private', 'publish' ),
			'numberposts' => - 1,
			'orderby'     => 'menu_order',
			'order'       => 'asc',
			'post_parent' => $product_id,
		);
		$variations    = get_posts( $args );
		$variation_ids = array();
		if ( $variations ) {
			foreach ( $variations as $variation ) {
				$variation_ids[] = $variation->ID;
			}
		}
		$sale_price_dates_to = false;
		if ( ! empty( $variation_ids ) ) {
			global $wpdb;
			$sale_price_dates_to = $wpdb->get_var( "SELECT meta_value FROM $wpdb->postmeta WHERE meta_key = '_sale_price_dates_to' and post_id IN(" . join( ',', $variation_ids ) . ") ORDER BY meta_value DESC LIMIT 1" );
			if ( $sale_price_dates_to != '' ) {
				return $sale_price_dates_to;
			}
		}
		if ( ! $sale_price_dates_to ) {
			$sale_price_dates_to   = get_post_meta( $product_id, '_sale_price_dates_to', true );
			$sale_price_dates_from = get_post_meta( $product_id, '_sale_price_dates_from', true );
			if ( $sale_price_dates_to == '' || $date_now < $sale_price_dates_from ) {
				$sale_price_dates_to = '0';
			}
		}

		return $sale_price_dates_to;
	}
}
if ( ! function_exists( 'ocolus_coupon_product' ) ) {
	function ocolus_coupon_product()
	{
		global $product;
		$product_coupon = array();
		// get all coupons that are published
		$coupons = get_posts(
			array(
				'posts_per_page' => - 1,
				'orderby'        => 'title',
				'order'          => 'asc',
				'post_type'      => 'shop_coupon',
				'post_status'    => 'publish',
			)
		);
		// loop through the coupons
		if ( ! empty( $coupons ) ) {
			foreach ( $coupons as $coupon ) {
				// get the product ids meta value
				$product_ids  = get_post_meta( $coupon->ID, 'product_ids', true );
				$product_cats = get_post_meta( $coupon->ID, 'product_categories', true );
				// make sure something has been saved
				if ( ! empty( $product_ids ) ) {
					// convert from comma separated string to array
					$id_list = explode( ',', $product_ids );
					if ( in_array( $product->get_id(), $id_list ) ) {
						$product_coupon[ $coupon->ID ] = array(
							'title'   => $coupon->post_title,
							'excerpt' => $coupon->post_excerpt,
						);
					}
				}
				if ( ! empty( $product_cats ) ) {
					$terms = get_the_terms( $product->get_id(), 'product_cat' );
					if ( ! is_wp_error( $terms ) && ! empty( $terms ) ) {
						foreach ( $terms as $term ) {
							if ( in_array( $term->id, $product_cats ) ) {
								$product_coupon[ $coupon->ID ] = array(
									'title'   => $coupon->post_title,
									'excerpt' => $coupon->post_excerpt,
								);
							}
						}
					}
				}
			}
			wp_reset_postdata();
		}
		if ( ! empty( $product_coupon ) ):
			?>
            <div class="coupon-code">
                <label>
                    <span class="title"><?php echo esc_html__( 'Coupon Code: ', 'ocolus' ); ?></span>
                    <select class="coupon-options">
						<?php foreach ( $product_coupon as $key => $coupon ) : ?>
                            <option value="<?php echo esc_attr( $key ) ?>"
                                    data-excerpt="<?php echo esc_attr( $coupon['excerpt'] ); ?>">
								<?php echo esc_html( $coupon['title'] ); ?>
                            </option>
						<?php endforeach; ?>
                    </select>
                </label>
            </div>
		<?php
		endif;
	}
}
if ( ! function_exists( 'ocolus_template_loop_add_to_cart' ) ) {
	function ocolus_template_loop_add_to_cart( $add_to_cart = true )
	{
		global $product;
		$disable_attribute = ocolus_get_option( 'disable_attribute' );
		if ( $disable_attribute == 1 ) {
			$add_to_cart = true;
		}
		if ( $product->get_type() == 'variable' && ! ocolus_is_mobile( true ) && $disable_attribute != 1 ) : ?>
			<?php
			wp_enqueue_script( 'wc-add-to-cart-variation' );
			$attributes = $product->get_variation_attributes();
			// GET SIZE IMAGE SETTING
			$width  = 300;
			$height = 300;
			$size   = wc_get_image_size( 'shop_catalog' );
			if ( $size ) {
				$width  = $size['width'];
				$height = $size['height'];
			}
			$width  = apply_filters( 'ocolus_shop_product_thumb_width', $width );
			$height = apply_filters( 'ocolus_shop_product_thumb_height', $height );
			if ( ! empty( $attributes ) ):?>
                <form class="variations_form cart" method="post" enctype='multipart/form-data'
                      data-product_id="<?php echo absint( $product->get_id() ); ?>"
                      data-product_variations="false"
                      data-custom_data="<?php echo absint( $width ); ?>x<?php echo absint( $height ); ?>">
                    <table class="variations">
                        <tbody>
						<?php
						foreach ( $attributes as $attribute_name => $options ) : ?>
                            <tr>
                                <td class="label">
                                    <label>
										<?php echo wc_attribute_label( $attribute_name ); // WPCS: XSS ok. ?>
                                    </label>
                                </td>
                                <td class="value">
									<?php
									$selected = isset( $_REQUEST[ 'attribute_' . sanitize_title( $attribute_name ) ] ) ? wc_clean( stripslashes( urldecode( $_REQUEST[ 'attribute_' . sanitize_title( $attribute_name ) ] ) ) ) : $product->get_variation_default_attribute( $attribute_name );
									wc_dropdown_variation_attribute_options(
										array(
											'options'   => $options,
											'attribute' => $attribute_name,
											'product'   => $product,
											'selected'  => $selected,
										)
									);
									?>
                                </td>
                            </tr>
						<?php endforeach; ?>
                        </tbody>
                    </table>
                    <div class="single_variation_wrap add-to-cart">
						<?php
						if ( $add_to_cart == true ) {
							/**
							 * Hook: woocommerce_single_variation. Used to output the cart button and placeholder for variation data.
							 *
							 * @since 2.4.0
							 * @hooked woocommerce_single_variation - 10 Empty div for variation data.
							 * @hooked woocommerce_single_variation_add_to_cart_button - 20 Qty and cart button.
							 */
							do_action( 'woocommerce_single_variation' );
						}
						?>
                    </div>
                </form>
			<?php
			endif;
		endif;
		if ( $add_to_cart == true ) : ?>
			<?php
			/**
			 * woocommerce_after_shop_loop_item hook.
			 *
			 * @hooked woocommerce_template_loop_product_link_close - 5
			 * @hooked woocommerce_template_loop_add_to_cart - 10
			 */
			do_action( 'woocommerce_after_shop_loop_item' );
			?>
		<?php
		endif;
	}
}
/**
 *
 * CUSTOM PRODUCT VIDEO BUTTON
 */
if ( ! function_exists( 'ocolus_single_product_meta_button' ) ) {
	function ocolus_single_product_meta_button()
	{
		global $product;
		$meta_product = get_post_meta( $product->get_id(), '_custom_product_side_options', true );
		?>
        <div class="meta-button">
			<?php if ( isset( $meta_product['product_360degree'] ) && $meta_product['product_360degree'] ): ?>
				<?php
				wp_enqueue_style( 'magnific-popup' );
				wp_enqueue_script( 'ocolus-magnific-popup' );
				$shortcode_id = 'ovic_vc_custom_' . uniqid();
				echo ocolus_do_shortcode( 'ovic_360degree',
					array(
						'el_class'          => 'mfp-hide',
						'ovic_vc_custom_id' => $shortcode_id,
						'gallery_degree'    => $meta_product['product_360degree'],
					)
				);
				?>
                <a href="#" class="ovic-magnific-popup popup-content"
                   data-popup=".<?php echo esc_attr( $shortcode_id ); ?>">
                    <span class="fa fa-play-circle"></span>
					<?php echo esc_html__( '360 Degree', 'ocolus' ); ?>
                </a>
			<?php endif; ?>
			<?php if ( isset( $meta_product['product_video'] ) && $meta_product['product_video'] ): ?>
				<?php
				wp_enqueue_style( 'magnific-popup' );
				wp_enqueue_script( 'ocolus-magnific-popup' );
				?>
                <a href="<?php echo esc_url( $meta_product['product_video'] ); ?>"
                   class="ovic-magnific-popup video">
                    <span class="fa fa-video-camera"></span>
					<?php echo esc_html__( 'Video clip', 'ocolus' ); ?>
                </a>
			<?php endif; ?>
        </div>
		<?php
	}
}
/**
 *
 * CUSTOM PRODUCT GIFT
 */
if ( ! function_exists( 'ocolus_single_product_gift' ) ) {
	function ocolus_single_product_gift()
	{
		global $product;
		$product_gift = get_post_meta( $product->get_id(), '_wfg_single_gift_products', true );
		if ( ! is_wp_error( $product_gift ) && ! empty( $product_gift ) ):
			?>
            <div class="product-gift">
                <h3 class="title">
                    <span class="icomoon-Gift"></span>
					<?php echo esc_html__( 'Gift when purchasing this product', 'ocolus' ) ?>
                </h3>
                <ul class="list-gift">
					<?php foreach ( $product_gift as $gift ) : ?>
						<?php $_product = wc_get_product( $gift ); ?>
                        <li>
                            <span class="thumb">
                                <?php echo wp_kses_post( $_product->get_image( array( 60, 60 ) ) ); ?>
                            </span>
                            <a href="<?php echo esc_url( $_product->get_permalink() ); ?>" class="title-gift"
                               target="_blank">
								<?php echo wp_kses_post( $_product->get_title() ); ?>
                            </a>
                            <span class="price"><?php echo wp_kses_post( $_product->get_price_html() ); ?></span>
                        </li>
					<?php endforeach; ?>
                </ul>
            </div>
		<?php
		endif;
	}
}
/**
 *
 * CUSTOM PRODUCT STOCK
 */
if ( ! function_exists( 'ocolus_template_single_available' ) ) {
	function ocolus_template_single_available()
	{
		global $product;
		$availability = $product->get_availability();
		$class        = 'available-product ' . $availability['class'];
		$text         = $availability['availability'];
		if ( ! empty( $availability['availability'] ) && ! $product->is_type( 'variable' ) && ! $product->is_type( 'external' ) ):
			?>
            <p class="stock <?php echo esc_attr( $class ); ?>">
                <span class="title"><?php echo esc_html__( 'Availability:', 'ocolus' ); ?></span>
                <span class="text"><?php echo esc_html( $text ); ?></span>
            </p>
		<?php
		endif;
	}
}
/**
 *
 * CUSTOM PRODUCT GUARANTEED
 */
if ( ! function_exists( 'ocolus_template_product_guaranteed' ) ) {
	function ocolus_template_product_guaranteed()
	{
		$enable_guaranteed  = ocolus_get_option( 'enable_product_guaranteed' );
		$title              = ocolus_get_option( 'title_product_guaranteed' );
		$product_guaranteed = ocolus_get_option( 'product_guaranteed' );
		if ( $enable_guaranteed == 1 ):
			?>
            <div class="product-guaranteed">
                <span class="title"><?php echo esc_html( $title ); ?></span>
				<?php
				if ( $product_guaranteed != '' ) {
					$product_guaranteed = explode( ',', $product_guaranteed );
					foreach ( $product_guaranteed as $guaranteed ) {
						echo '<figure class="image-guaranteed">' . wp_get_attachment_image( $guaranteed, 'full' ) . '</figure>';
					}
				}
				?>
            </div>
		<?php
		endif;
	}
}
/**
 *
 * SHIPPING METHODS
 */
if ( ! function_exists( 'ocolus_shipping_methods' ) ) {
	function ocolus_shipping_methods()
	{
		global $product;
		// Initializing variable
		$zones = $data = $classes_keys = array();
		// Rest of the World zone
		$zone                                                = new \WC_Shipping_Zone( 0 );
		$zones[ $zone->get_id() ]                            = $zone->get_data();
		$zones[ $zone->get_id() ]['formatted_zone_location'] = $zone->get_formatted_location();
		$zones[ $zone->get_id() ]['shipping_methods']        = $zone->get_shipping_methods();
		// Merging shipping zones
		$shipping_zones = array_merge( $zones, WC_Shipping_Zones::get_zones() );
		// Shipping Classes
		$shipping         = new \WC_Shipping();
		$shipping_classes = $shipping->get_shipping_classes();
		// The Shipping Classes for costs in "Flat rate" Shipping Method
		foreach ( $shipping_classes as $shipping_class ) {
			//
			$key_class_cost = 'class_cost_' . $shipping_class->term_id;
			// The shipping classes
			$classes_keys[ $shipping_class->term_id ] = array(
				'term_id'  => $shipping_class->term_id,
				'name'     => $shipping_class->name,
				'slug'     => $shipping_class->slug,
				'count'    => $shipping_class->count,
				'key_cost' => $key_class_cost,
			);
		}
		// For 'No class" cost
		$classes_keys[0] = array(
			'term_id'  => '',
			'name'     => 'No shipping class',
			'slug'     => 'no_class',
			'count'    => '',
			'key_cost' => 'no_class_cost',
		);
		foreach ( $shipping_zones as $shipping_zone ) {
			$zone_id            = $shipping_zone['id'];
			$zone_name          = $zone_id == '0' ? esc_html__( 'Rest of the word', 'ocolus' ) : $shipping_zone['zone_name'];
			$zone_locations     = $shipping_zone['zone_locations']; // array
			$zone_location_name = $shipping_zone['formatted_zone_location'];
			// Set the data in an array:
			$data[ $zone_id ] = array(
				'zone_id'            => $zone_id,
				'zone_name'          => $zone_name,
				'zone_location_name' => $zone_location_name,
				'zone_locations'     => $zone_locations,
				'shipping_methods'   => array(),
			);
			foreach ( $shipping_zone['shipping_methods'] as $sm_obj ) {
				$method_id   = $sm_obj->id;
				$instance_id = $sm_obj->get_instance_id();
				$enabled     = $sm_obj->is_enabled() ? true : 0;
				// Settings specific to each shipping method
				$instance_settings = $sm_obj->instance_settings;
				if ( $enabled ) {
					$data[ $zone_id ]['shipping_methods'][ $instance_id ] = array(
						'$method_id'   => $sm_obj->id,
						'instance_id'  => $instance_id,
						'rate_id'      => $sm_obj->get_rate_id(),
						'default_name' => $sm_obj->get_method_title(),
						'custom_name'  => $sm_obj->get_title(),
					);
					if ( $method_id == 'free_shipping' ) {
						$data[ $zone_id ]['shipping_methods'][ $instance_id ]['requires']   = $instance_settings['requires'];
						$data[ $zone_id ]['shipping_methods'][ $instance_id ]['min_amount'] = $instance_settings['min_amount'];
					}
					if ( $method_id == 'flat_rate' || $method_id == 'local_pickup' ) {
						$data[ $zone_id ]['shipping_methods'][ $instance_id ]['tax_status'] = $instance_settings['tax_status'];
						$data[ $zone_id ]['shipping_methods'][ $instance_id ]['cost']       = $sm_obj->cost;
					}
					if ( $method_id == 'flat_rate' ) {
						if ( isset( $instance_settings['class_costs'] ) ) {
							$data[ $zone_id ]['shipping_methods'][ $instance_id ]['class_costs'] = $instance_settings['class_costs'];
						}
						if ( isset( $instance_settings['type'] ) ) {
							$data[ $zone_id ]['shipping_methods'][ $instance_id ]['calculation_type'] = $instance_settings['type'];
						}
						if ( isset( $instance_settings['no_class_cost'] ) ) {
							$classes_keys[0]['cost'] = $instance_settings['no_class_cost'];
						}
						foreach ( $instance_settings as $key => $setting ) {
							if ( strpos( $key, 'class_cost_' ) !== false ) {
								$class_id                          = str_replace( 'class_cost_', '', $key );
								$classes_keys[ $class_id ]['cost'] = $setting;
							}
						}
						$data[ $zone_id ]['shipping_methods'][ $instance_id ]['classes_&_costs'] = $classes_keys;
					}
				}
			}
		}
		$shipping_methods = $data;
		?>
        <div class="content-popup-shipping mfp-hide" style="background-color:#ffffff">
            <div class="popup-shipping-inner">
				<?php if ( $product->get_shipping_class() ): ?>
                    <p>
						<?php
						$product = wc_get_product( $product->get_id() );
						echo sprintf( esc_html__( 'Shipping Class "%s": %s', 'ocolus' ), $product->get_name(), $product->get_shipping_class() );
						?>
                    </p>
				<?php endif; ?>
                <table>
                    <thead>
                    <tr>
                        <th><strong><?php echo esc_html__( 'Zone Name', 'ocolus' ); ?></strong></th>
                        <th><strong><?php echo esc_html__( 'Locations', 'ocolus' ); ?></strong></th>
                        <th><strong><?php echo esc_html__( 'Shipping Methods', 'ocolus' ); ?></strong></th>
                        <th><strong><?php echo esc_html__( 'Shipping Class', 'ocolus' ); ?></strong></th>
                    </tr>
                    </thead>
                    <tbody>
					<?php foreach ( $shipping_methods as $datum ) : ?>
                        <tr>
                            <td>
								<?php echo esc_html( $datum['zone_name'] ); ?>
                            </td>
                            <td>
								<?php echo esc_html( $datum['zone_location_name'] ); ?>
                            </td>
                            <td>
                                <ul>
									<?php
									if ( ! empty( $datum['shipping_methods'] ) ) {
										foreach ( $datum['shipping_methods'] as $method ) {
											$cost = '';
											if ( isset( $method['cost'] ) && $method['cost'] != '' ) {
												$cost = $method['cost'];
											}
											$price = ! empty( $cost ) ? ': ' . wc_price( $cost ) : '';
											echo '<li>' . esc_html( $method['custom_name'] ) . $price . '</li>';
										}
									}
									?>
                                </ul>
                            </td>
                            <td>
                                <ul>
									<?php
									if ( ! empty( $datum['shipping_methods'] ) ) {
										foreach ( $datum['shipping_methods'] as $method ) {
											if ( isset( $method['classes_&_costs'] ) ) {
												$cost = '0';
												if ( isset( $method['cost'] ) && $method['cost'] != '' ) {
													$cost = $method['cost'];
												}
												$price = ! empty( $cost ) ? ': ' . wc_price( $cost ) : '';
												echo '<li>' . esc_html( $method['custom_name'] ) . $price;
												echo '<ul>';
												if ( ! empty( $method['classes_&_costs'] ) ) {
													foreach ( $method['classes_&_costs'] as $classes ) {
														$cost = '';
														if ( isset( $classes['cost'] ) && $classes['cost'] != '' ) {
															$cost = $classes['cost'];
														}
														$price = ! empty( $cost ) ? ': ' . wc_price( $cost ) : '';
														echo '<li>' . esc_html( $classes['slug'] ) . $price . '</li>';
													}
												}
												echo '</ul></li>';
											}
										}
									}
									?>
                                </ul>
                            </td>
                        </tr>
					<?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
		<?php
	}
}
if ( ! function_exists( 'ocolus_product_info_button' ) ) {
	function ocolus_product_info_button()
	{
		global $product;
		if ( ! $product->is_in_stock() ) {
			return;
		}
		$size_chart = get_post_meta( $product->get_id(), 'prod-chart', true );
		wp_enqueue_style( 'magnific-popup' );
		wp_enqueue_script( 'ocolus-magnific-popup' );
		ocolus_shipping_methods();
		?>
        <div class="product_info">
            <a href="#" data-popup=".content-popup-shipping"
               class="ovic-magnific-popup popup-content shipping-info">
                <span class="fa fa-truck icon"></span>
                <span class="text"><?php echo esc_html__( 'Shipping info', 'ocolus' ); ?></span>
            </a>
			<?php if ( ! empty( $size_chart ) && function_exists( 'run_size_chart_for_woocommerce' ) ) : ?>
                <a href="#" class="button-size-chart">
                    <span class="fa fa-scissors icon"></span>
                    <span class="text"><?php echo esc_html__( 'Size guide', 'ocolus' ); ?></span>
                </a>
			<?php endif; ?>
        </div>
		<?php
	}
}
/**
 *
 * CUSTOM PRODUCT MAILCHIMP
 */
if ( ! function_exists( 'ocolus_template_product_mailchimp' ) ) {
	function ocolus_template_product_mailchimp()
	{
		global $product;
		if ( ! $product->is_in_stock() ): ?>
			<?php
			$id      = 'ovic_vc_custom_' . uniqid();
			$form_id = ocolus_get_option( 'product_mailchimp' );
			$atts    = array(
				'ovic_vc_custom_id' => $id,
				'style'             => 'style-11',
				'title'             => '',
				'desc'              => '',
				'button_text'       => esc_html__( 'SEND', 'ocolus' ),
				'placeholder'       => esc_html__( 'Enter your email', 'ocolus' ),
			);
			if ( $form_id ) {
				$atts['form_id'] = $form_id;
			}
			?>
            <div class="product-notify-mailchimp">
                <h4 class="title"><?php echo esc_html__( 'This product is currently out of stock and unavailable.', 'ocolus' ); ?></h4>
                <div class="product-notify-inner">
                    <p class="subtitle"><?php echo esc_html__( 'Notify me when this product is in stock', 'ocolus' ); ?></p>
					<?php echo ocolus_do_shortcode( 'ovic_newsletter', $atts ); ?>
                </div>
            </div>
		<?php
		endif;
	}
}
if ( ! function_exists( 'ocolus_process_availability' ) ) {
	function ocolus_process_availability()
	{
		global $product;
		$units_sold   = get_post_meta( $product->get_id(), 'total_sales', true );
		$availability = $product->get_stock_quantity();
		if ( $availability ) :
			$total_percent = $availability + $units_sold;
			$percent  = round( ( ( $units_sold / $total_percent ) * 100 ), 0 );
			?>
            <div class="process-availability">
            <span class="availability-total total">
                <span class="process"
                      style="width: <?php echo esc_attr( $percent ) . '%' ?>"></span>
            </span>
                <div class="availability-text">
                <span class="text">
                    <?php echo sprintf( esc_html__( 'Sold: %s', 'ocolus' ), $units_sold ); ?>
                </span>
                    <!--<span class="text">-->
					<?php
					/*
					$stock = esc_html__( 'Unlimit', 'ocolus' );
					if ( $availability != '' ) {
						$stock = $availability - $units_sold;
					}
					echo sprintf( '%s <span>%s</span>', esc_html__( 'Available:', 'ocolus' ), $stock );
					*/
					?>
                    <!--</span>-->
                </div>
            </div>
		<?php
		endif;
	}
}
if ( ! function_exists( 'ocolus_buy_now_button' ) ) {
	function ocolus_buy_now_button()
	{
		global $product;
		if ( $product->get_type() == 'simple' ) {
			echo '<button type="submit" name="add-to-cart" value="' . esc_attr( $product->get_id() ) . '" class="single_add_to_cart_button button alt buy-now">' . esc_html__( 'BUY NOW', 'ocolus' ) . '</button>';
		} else {
			echo '<button type="submit" name="add-to-cart" class="single_add_to_cart_button button alt buy-now">' . esc_html__( 'BUY NOW', 'ocolus' ) . '</button>';
		}
	}
}
if ( ! function_exists( 'ocolus_button_product_gallery' ) ) {
	function ocolus_button_product_gallery()
	{
		echo '<div class="zoom-button">';
		do_action( 'ocolus_function_shop_loop_item_wishlist' );
		do_action( 'ocolus_function_shop_loop_item_compare' );
		echo '</div>';
	}
}
if ( ! function_exists( 'ocolus_simple_add_to_cart_button' ) ) {
	function ocolus_simple_add_to_cart_button()
	{
		global $product;
		if ( ! $product->is_purchasable() ) {
			return;
		}
		if ( $product->is_in_stock() ) :
			?>
            <form class="cart"
                  action="<?php echo esc_url( apply_filters( 'woocommerce_add_to_cart_form_action', $product->get_permalink() ) ); ?>"
                  method="post" enctype='multipart/form-data'>

				<?php
				woocommerce_quantity_input( array(
						'min_value'   => apply_filters( 'woocommerce_quantity_input_min', $product->get_min_purchase_quantity(), $product ),
						'max_value'   => apply_filters( 'woocommerce_quantity_input_max', $product->get_max_purchase_quantity(), $product ),
						'input_value' => isset( $_POST['quantity'] ) ? wc_stock_amount( wp_unslash( $_POST['quantity'] ) ) : $product->get_min_purchase_quantity(),
						// WPCS: CSRF ok, input var ok.
					)
				);
				?>

                <button type="submit" name="add-to-cart" value="<?php echo esc_attr( $product->get_id() ); ?>"
                        class="single_add_to_cart_button button alt">
					<?php echo esc_html( $product->single_add_to_cart_text() ); ?>
                </button>
            </form>
		<?php
		endif;
	}
}
if ( ! function_exists( 'ocolus_custom_star_rating_html' ) ) {
	function ocolus_custom_star_rating_html( $html, $rating, $count )
	{
		global $product;
		if ( 0 < $rating ) {
			$html .= sprintf( '<span class="review-count">%s %s</span>',
				$product->get_review_count(),
				esc_html__( 'Reviews', 'ocolus' )
			);
		}

		return $html;
	}
}