<?php if ( !defined( 'ABSPATH' ) ) {
	die;
} // Cannot access pages directly.
if ( !class_exists( 'Ocolus_Visual_Composer' ) ) {
	class Ocolus_Visual_Composer
	{
		public function __construct()
		{
			$this->autocomplete();
			add_filter( 'ovic_include_templates_shortcode', array( $this, 'include_templates_shortcode' ), 10, 2 );
			add_filter( 'ovic_vc_add_param_visual_composer', array( $this, 'add_param_visual_composer' ) );
			add_filter( 'vc_grid_item_shortcodes', array( $this, 'module_add_grid_shortcodes' ) );
			add_filter( 'vc_iconpicker-type-oviccustomfonts', array( $this, 'iconpicker_type_oviccustomfonts' ) );
			add_filter( 'vc_google_fonts_get_fonts_filter', array( $this, 'add_vc_fonts' ) );
			add_action( 'vc_after_init', array( $this, 'add_button_style' ) );
		}

		public function add_button_style()
		{
			/* param button */
			$param_button = WPBMap::getParam( 'vc_btn', 'style' );

			$param_button['value'][esc_html__( 'Ovic Button', 'ocolus' )]   = 'ovic-button';
			$param_button['value'][esc_html__( 'Ovic Button 2', 'ocolus' )] = 'ovic-button ovic-button-2';
			$param_button['value'][esc_html__( 'Ovic Button 3', 'ocolus' )] = 'ovic-button ovic-button-3';
			/* param tabs*/
			$param_tabs = WPBMap::getParam( 'vc_tta_section', 'i_type' );

			$param_tabs['value'][esc_html__( 'Custom Fonts', 'ocolus' )] = 'oviccustomfonts';
			$param_tabs['value'][esc_html__( 'Image', 'ocolus' )]        = 'image';
			/* update params */
			vc_update_shortcode_param( 'vc_btn', $param_button );
			vc_update_shortcode_param( 'vc_tta_section', $param_tabs );
		}

		public function include_templates_shortcode( $default, $template_name )
		{
			return 'vc_templates/' . $template_name;
		}

		public function add_vc_fonts( $fonts_list )
		{
			/* Poppins */
			$Poppins              = new stdClass();
			$Poppins->font_family = "Poppins";
			$Poppins->font_styles = "300,300i,400,400i,500,500i,600,600i,700,700i";
			$Poppins->font_types  = '300 light :300:normal,300 light italic :300:italic,400 regular:400:normal,400 regular italic:400:italic,500 medium:500:normal,500 medium italic:500:italic,600 semi bold:600:normal,600 semi bold italic:600:italic,700 bold :700:normal,700 bold italic:700:italic';
			$Poppins->font_styles = 'regular';
			$fonts_poppins        = array( $Poppins );
			/* Playfair Display */
			$Playfair              = new stdClass();
			$Playfair->font_family = "Playfair Display";
			$Playfair->font_styles = "400,400i,700,700i";
			$Playfair->font_types  = '400 regular:400:normal,400 regular italic:400:italic,700 bold :700:normal,700 bold italic:700:italic';
			$Playfair->font_styles = 'regular';
			$fonts_playfair        = array( $Playfair );

			return array_merge( $fonts_playfair, $fonts_poppins, $fonts_list );
		}

		public function post_autocomplete_suggester( $query )
		{
			global $wpdb;
			$post_id      = (int)$query;
			$post_results = $wpdb->get_results(
				$wpdb->prepare( "SELECT a.ID AS id, a.post_title AS title FROM {$wpdb->posts} AS a WHERE a.post_type = 'post' AND a.post_status != 'trash' AND ( a.ID = '%d' OR a.post_title LIKE '%%%s%%' )", $post_id > 0 ? $post_id : -1, stripslashes( $query ), stripslashes( $query )
				), ARRAY_A
			);
			$results      = array();
			if ( is_array( $post_results ) && !empty( $post_results ) ) {
				foreach ( $post_results as $value ) {
					$data          = array();
					$data['value'] = $value['id'];
					$data['label'] = $value['title'];
					$results[]     = $data;
				}
			}

			return $results;
		}

		public function post_autocomplete_suggester_render( $query )
		{
			$query = trim( $query['value'] );
			// get value from requested
			if ( !empty( $query ) ) {
				$post_object = get_post( (int)$query );
				if ( is_object( $post_object ) ) {
					$post_title    = $post_object->post_title;
					$post_id       = $post_object->ID;
					$data          = array();
					$data['value'] = $post_id;
					$data['label'] = $post_title;

					return !empty( $data ) ? $data : false;
				}

				return false;
			}

			return false;
		}

		public function iconpicker_type_oviccustomfonts()
		{
			$icons['Custom Fonts'] = array(
				array( "icomoon-Badge" => esc_html__( "Icomoon Badge", "ocolus" ) ),
				array( "icomoon-Budget" => esc_html__( "Icomoon Budget", "ocolus" ) ),
				array( "icomoon-List" => esc_html__( "Icomoon List", "ocolus" ) ),
				array( "icomoon-Smartwatch" => esc_html__( "Icomoon Smartwatch", "ocolus" ) ),
				array( "icomoon-Tablet" => esc_html__( "Icomoon Tablet", "ocolus" ) ),
				array( "icomoon-Web-Design" => esc_html__( "Icomoon Web Design", "ocolus" ) ),
				array( "icomoon-Mail" => esc_html__( "Icomoon Mail", "ocolus" ) ),
				array( "icomoon-Point" => esc_html__( "Icomoon Point", "ocolus" ) ),
				array( "icomoon-Support" => esc_html__( "Icomoon Support", "ocolus" ) ),
				array( "icomoon-Square" => esc_html__( "Icomoon Square", "ocolus" ) ),
				array( "icomoon-Armchair" => esc_html__( "Icomoon Armchair", "ocolus" ) ),
				array( "icomoon-Back" => esc_html__( "Icomoon Back", "ocolus" ) ),
				array( "icomoon-Cancel" => esc_html__( "Icomoon Cancel", "ocolus" ) ),
				array( "icomoon-Carrier" => esc_html__( "Icomoon Carrier", "ocolus" ) ),
				array( "icomoon-Chat" => esc_html__( "Icomoon Chat", "ocolus" ) ),
				array( "icomoon-Close" => esc_html__( "Icomoon Close", "ocolus" ) ),
				array( "icomoon-Closet" => esc_html__( "Icomoon Closet", "ocolus" ) ),
				array( "icomoon-Comment-Other" => esc_html__( "Icomoon Comment Other", "ocolus" ) ),
				array( "icomoon-Comment" => esc_html__( "Icomoon Comment", "ocolus" ) ),
				array( "icomoon-Compare" => esc_html__( "Icomoon Compare", "ocolus" ) ),
				array( "icomoon-Console" => esc_html__( "Icomoon Console", "ocolus" ) ),
				array( "icomoon-Cosmetics" => esc_html__( "Icomoon Cosmetics", "ocolus" ) ),
				array( "icomoon-Cross-out" => esc_html__( "Icomoon Cross out", "ocolus" ) ),
				array( "icomoon-Cursor-More" => esc_html__( "Icomoon Cursor More", "ocolus" ) ),
				array( "icomoon-Cursor-Pause" => esc_html__( "Icomoon Cursor Pause", "ocolus" ) ),
				array( "icomoon-Cursor-Play" => esc_html__( "Icomoon Cursor Play", "ocolus" ) ),
				array( "icomoon-Discuss-issue" => esc_html__( "Icomoon Discuss issue", "ocolus" ) ),
				array( "icomoon-Double-sofa" => esc_html__( "Icomoon Double sofa", "ocolus" ) ),
				array( "icomoon-Dumbbell" => esc_html__( "Icomoon Dumbbell", "ocolus" ) ),
				array( "icomoon-Empty-shopping-cart" => esc_html__( "Icomoon Empty shopping cart", "ocolus" ) ),
				array( "icomoon-Fabric" => esc_html__( "Icomoon Fabric", "ocolus" ) ),
				array( "icomoon-Full-screen" => esc_html__( "Icomoon Full screen", "ocolus" ) ),
				array( "icomoon-Gift" => esc_html__( "Icomoon Gift", "ocolus" ) ),
				array( "icomoon-Grid" => esc_html__( "Icomoon Grid", "ocolus" ) ),
				array( "icomoon-Heart" => esc_html__( "Icomoon Heart", "ocolus" ) ),
				array( "icomoon-Home" => esc_html__( "Icomoon Home", "ocolus" ) ),
				array( "icomoon-Idea" => esc_html__( "Icomoon Idea", "ocolus" ) ),
				array( "icomoon-Layers-round" => esc_html__( "Icomoon Layers round", "ocolus" ) ),
				array( "icomoon-Layers" => esc_html__( "Icomoon Layers", "ocolus" ) ),
				array( "icomoon-Left-arrow" => esc_html__( "Icomoon Left arrow", "ocolus" ) ),
				array( "icomoon-List-Menu" => esc_html__( "Icomoon List Menu", "ocolus" ) ),
				array( "icomoon-Magnifying-glass" => esc_html__( "Icomoon Magnifying glass", "ocolus" ) ),
				array( "icomoon-Map-marker" => esc_html__( "Icomoon Map marker", "ocolus" ) ),
				array( "icomoon-Money" => esc_html__( "Icomoon Money", "ocolus" ) ),
				array( "icomoon-Next" => esc_html__( "Icomoon Next", "ocolus" ) ),
				array( "icomoon-Pencil-Case" => esc_html__( "Icomoon Pencil Case", "ocolus" ) ),
				array( "icomoon-Photographer" => esc_html__( "Icomoon Photographer", "ocolus" ) ),
				array( "icomoon-Plant" => esc_html__( "Icomoon Plant", "ocolus" ) ),
				array( "icomoon-Quality" => esc_html__( "Icomoon Quality", "ocolus" ) ),
				array( "icomoon-Right-arrow" => esc_html__( "Icomoon Right arrow", "ocolus" ) ),
				array( "icomoon-Shipped" => esc_html__( "Icomoon Shipped", "ocolus" ) ),
				array( "icomoon-Shirt" => esc_html__( "Icomoon Shirt", "ocolus" ) ),
				array( "icomoon-Shopping-bag" => esc_html__( "Icomoon Shopping bag", "ocolus" ) ),
				array( "icomoon-Sketch" => esc_html__( "Icomoon Sketch", "ocolus" ) ),
				array( "icomoon-Small-diamond" => esc_html__( "Icomoon Small diamond", "ocolus" ) ),
				array( "icomoon-Table-classic" => esc_html__( "Icomoon Table classic", "ocolus" ) ),
				array( "icomoon-Table" => esc_html__( "Icomoon Table", "ocolus" ) ),
				array( "icomoon-Three-dots" => esc_html__( "Icomoon Three dots", "ocolus" ) ),
				array( "icomoon-Up-arrow" => esc_html__( "Icomoon Up arrow", "ocolus" ) ),
				array( "icomoon-User" => esc_html__( "Icomoon User", "ocolus" ) ),
				array( "icomoon-Washing-machine" => esc_html__( "Icomoon Washing machine", "ocolus" ) ),
				array( "icomoon-Wedding-rings" => esc_html__( "Icomoon Wedding rings", "ocolus" ) ),
			);

			return $icons;
		}

		public function params_shortcode( $params, $add_grid = false )
		{
			$categories_array = array(
				esc_html__( 'All', 'ocolus' ) => '',
			);
			$args             = array();
			$categories       = get_categories( $args );
			if ( !empty( $categories ) ) {
				foreach ( $categories as $category ) {
					$categories_array[$category->name] = $category->slug;
				}
			}
			// Icon Field
			$icon_field = array(
				array(
					'type'        => 'dropdown',
					'heading'     => esc_html__( 'Icon library', 'ocolus' ),
					'value'       => array(
						esc_html__( 'Font Awesome', 'ocolus' ) => 'fontawesome',
						esc_html__( 'Open Iconic', 'ocolus' )  => 'openiconic',
						esc_html__( 'Typicons', 'ocolus' )     => 'typicons',
						esc_html__( 'Entypo', 'ocolus' )       => 'entypo',
						esc_html__( 'Linecons', 'ocolus' )     => 'linecons',
						esc_html__( 'Mono Social', 'ocolus' )  => 'monosocial',
						esc_html__( 'Material', 'ocolus' )     => 'material',
						esc_html__( 'Custom Fonts', 'ocolus' ) => 'oviccustomfonts',
						esc_html__( 'Image', 'ocolus' )        => 'image',
					),
					'admin_label' => true,
					'param_name'  => 'type',
					'description' => esc_html__( 'Select icon library.', 'ocolus' ),
				),
				array(
					'type'       => 'attach_image',
					'heading'    => esc_html__( 'Image', 'ocolus' ),
					'param_name' => 'image_icon',
					'dependency' => array(
						'element' => 'type',
						'value'   => 'image',
					),
				),
				array(
					'param_name'  => 'icon_oviccustomfonts',
					'heading'     => esc_html__( 'Icon', 'ocolus' ),
					'description' => esc_html__( 'Select icon from library.', 'ocolus' ),
					'type'        => 'iconpicker',
					'settings'    => array(
						'emptyIcon' => false,
						'type'      => 'oviccustomfonts',
					),
					'dependency'  => array(
						'element' => 'type',
						'value'   => 'oviccustomfonts',
					),
				),
				array(
					'type'        => 'iconpicker',
					'heading'     => esc_html__( 'Icon', 'ocolus' ),
					'param_name'  => 'icon_fontawesome',
					'value'       => 'fa fa-adjust',
					'settings'    => array(
						'emptyIcon'    => false,
						'iconsPerPage' => 100,
					),
					'dependency'  => array(
						'element' => 'type',
						'value'   => 'fontawesome',
					),
					'description' => esc_html__( 'Select icon from library.', 'ocolus' ),
				),
				array(
					'type'        => 'iconpicker',
					'heading'     => esc_html__( 'Icon', 'ocolus' ),
					'param_name'  => 'icon_openiconic',
					'value'       => 'vc-oi vc-oi-dial',
					'settings'    => array(
						'emptyIcon'    => false,
						'type'         => 'openiconic',
						'iconsPerPage' => 100,
					),
					'dependency'  => array(
						'element' => 'type',
						'value'   => 'openiconic',
					),
					'description' => esc_html__( 'Select icon from library.', 'ocolus' ),
				),
				array(
					'type'        => 'iconpicker',
					'heading'     => esc_html__( 'Icon', 'ocolus' ),
					'param_name'  => 'icon_typicons',
					'value'       => 'typcn typcn-adjust-brightness',
					'settings'    => array(
						'emptyIcon'    => false,
						'type'         => 'typicons',
						'iconsPerPage' => 100,
					),
					'dependency'  => array(
						'element' => 'type',
						'value'   => 'typicons',
					),
					'description' => esc_html__( 'Select icon from library.', 'ocolus' ),
				),
				array(
					'type'       => 'iconpicker',
					'heading'    => esc_html__( 'Icon', 'ocolus' ),
					'param_name' => 'icon_entypo',
					'value'      => 'entypo-icon entypo-icon-note',
					'settings'   => array(
						'emptyIcon'    => false,
						'type'         => 'entypo',
						'iconsPerPage' => 100,
					),
					'dependency' => array(
						'element' => 'type',
						'value'   => 'entypo',
					),
				),
				array(
					'type'        => 'iconpicker',
					'heading'     => esc_html__( 'Icon', 'ocolus' ),
					'param_name'  => 'icon_linecons',
					'value'       => 'vc_li vc_li-heart',
					'settings'    => array(
						'emptyIcon'    => false,
						'type'         => 'linecons',
						'iconsPerPage' => 100,
					),
					'dependency'  => array(
						'element' => 'type',
						'value'   => 'linecons',
					),
					'description' => esc_html__( 'Select icon from library.', 'ocolus' ),
				),
				array(
					'type'        => 'iconpicker',
					'heading'     => esc_html__( 'Icon', 'ocolus' ),
					'param_name'  => 'icon_monosocial',
					'value'       => 'vc-mono vc-mono-fivehundredpx',
					'settings'    => array(
						'emptyIcon'    => false,
						'type'         => 'monosocial',
						'iconsPerPage' => 100,
					),
					'dependency'  => array(
						'element' => 'type',
						'value'   => 'monosocial',
					),
					'description' => esc_html__( 'Select icon from library.', 'ocolus' ),
				),
				array(
					'type'        => 'iconpicker',
					'heading'     => esc_html__( 'Icon', 'ocolus' ),
					'param_name'  => 'icon_material',
					'value'       => 'vc-material vc-material-cake',
					'settings'    => array(
						'emptyIcon'    => false,
						'type'         => 'material',
						'iconsPerPage' => 100,
					),
					'dependency'  => array(
						'element' => 'type',
						'value'   => 'material',
					),
					'description' => esc_html__( 'Select icon from library.', 'ocolus' ),
				),
			);
			if ( !$add_grid ) {
				vc_add_params(
					'vc_single_image',
					array(
						array(
							'param_name' => 'image_effect',
							'heading'    => esc_html__( 'Effect', 'ocolus' ),
							'group'      => esc_html__( 'Image Effect', 'ocolus' ),
							'type'       => 'dropdown',
							'value'      => array(
								esc_html__( 'None', 'ocolus' )               => 'none',
								esc_html__( 'Normal Effect', 'ocolus' )      => 'effect normal-effect',
								esc_html__( 'Normal Effect Dark', 'ocolus' ) => 'effect normal-effect dark-bg',
								esc_html__( 'Faded In', 'ocolus' )           => 'effect faded-in',
								esc_html__( 'Bounce In', 'ocolus' )          => 'effect bounce-in',
								esc_html__( 'Background Zoom', 'ocolus' )    => 'effect background-zoom',
								esc_html__( 'Rotate Left In', 'ocolus' )     => 'effect rotate-in rotate-left',
								esc_html__( 'Rotate Right In', 'ocolus' )    => 'effect rotate-in rotate-right',
								esc_html__( 'Translate Left', 'ocolus' )     => 'effect translate-left',
								esc_html__( 'Translate Right', 'ocolus' )    => 'effect translate-right',
								esc_html__( 'Plus Zoom', 'ocolus' )          => 'effect plus-zoom',
								esc_html__( 'Border Zoom', 'ocolus' )        => 'effect border-zoom',
								esc_html__( 'Border ScaleUp', 'ocolus' )     => 'effect border-scale',
							),
							'std'        => 'none',
						),
					)
				);
				/* Custom tab shortcode */
				vc_remove_param( 'vc_tta_section', 'el_class' );
				vc_add_params(
					'vc_tta_section',
					array(
						array(
							'param_name'  => 'i_icon_oviccustomfonts',
							'heading'     => esc_html__( 'Icon', 'ocolus' ),
							'description' => esc_html__( 'Select icon from library.', 'ocolus' ),
							'type'        => 'iconpicker',
							'settings'    => array(
								'emptyIcon' => false,
								'type'      => 'oviccustomfonts',
							),
							'dependency'  => array(
								'element' => 'i_type',
								'value'   => 'oviccustomfonts',
							),
						),
						array(
							'type'       => 'attach_image',
							'heading'    => esc_html__( 'Image', 'ocolus' ),
							'param_name' => 'image_icon',
							'dependency' => array(
								'element' => 'i_type',
								'value'   => 'image',
							),
						),
						array(
							'type'        => 'textfield',
							'heading'     => esc_html__( 'Extra class name', 'ocolus' ),
							'param_name'  => 'el_class',
							'description' => esc_html__( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'ocolus' ),
						),
					)
				);
			}
			$params['ovic_disabled_popup']        = array(
				'base'        => 'ovic_disabled_popup',
				'name'        => esc_html__( 'Ovic: Disable Popup', 'ocolus' ),
				'icon'        => get_theme_file_uri( 'assets/images/icon/disabled.svg' ),
				'category'    => esc_html__( 'Ocolus Shortcode', 'ocolus' ),
				'description' => esc_html__( 'Checkbox Disable Popup', 'ocolus' ),
				'params'      => array(
					array(
						'type'       => 'textfield',
						'heading'    => esc_html__( 'Text', 'ocolus' ),
						'param_name' => 'text',
						'std'        => esc_html__( 'Don&rsquo;t show this popup again', 'ocolus' ),
					),
				),
			);
			$params['ovic_pricing_box']           = array(
				'base'        => 'ovic_pricing_box',
				'name'        => esc_html__( 'Ovic: Pricing Box', 'ocolus' ),
				'icon'        => get_theme_file_uri( 'assets/images/icon/price-down.svg' ),
				'category'    => esc_html__( 'Ocolus Shortcode', 'ocolus' ),
				'description' => esc_html__( 'Display Pricing Box', 'ocolus' ),
				'params'      => array(),
			);
			$params['ovic_pricing_box']['params'] = array_merge(
				$params['ovic_pricing_box']['params'],
				$icon_field,
				array(
					array(
						'type'       => 'textfield',
						'heading'    => esc_html__( 'Title', 'ocolus' ),
						'param_name' => 'title',
					),
					array(
						'type'        => 'exploded_textarea_safe',
						'heading'     => esc_html__( 'List info price', 'ocolus' ),
						'param_name'  => 'list_text',
						'description' => esc_html__( 'Enter links for each slide (Note: divide links with linebreaks (Enter)).', 'ocolus' ),
					),
					array(
						'type'       => 'vc_link',
						'heading'    => esc_html__( 'Link Button', 'ocolus' ),
						'param_name' => 'button',
					),
					array(
						'type'       => 'textfield',
						'heading'    => esc_html__( 'Currency', 'ocolus' ),
						'param_name' => 'cur',
						'std'        => '$',
						'group'      => esc_html__( 'Price Options', 'ocolus' ),
					),
					array(
						'type'       => 'textfield',
						'heading'    => esc_html__( 'Price', 'ocolus' ),
						'param_name' => 'price',
						'std'        => '89',
						'group'      => esc_html__( 'Price Options', 'ocolus' ),
					),
					array(
						'type'       => 'textfield',
						'heading'    => esc_html__( 'Time', 'ocolus' ),
						'param_name' => 'time',
						'std'        => 'mon',
						'group'      => esc_html__( 'Price Options', 'ocolus' ),
					),
					vc_map_add_css_animation(),
				)
			);
			$params['ovic_iconbox']               = array(
				'base'        => 'ovic_iconbox',
				'name'        => esc_html__( 'Ocolus: Icon Box', 'ocolus' ),
				'icon'        => get_theme_file_uri( 'assets/images/icon/happiness.svg' ),
				'category'    => esc_html__( 'Ocolus Shortcode', 'ocolus' ),
				'description' => esc_html__( 'Display Icon Box', 'ocolus' ),
				'params'      => array(
					$this->get_preview_options( 'ovic_iconbox' ),
					array(
						'type'        => 'textfield',
						'heading'     => esc_html__( 'Title', 'ocolus' ),
						'param_name'  => 'title',
						'admin_label' => true,
					),
					array(
						'param_name' => 'text_content',
						'heading'    => esc_html__( 'Content', 'ocolus' ),
						'type'       => 'textarea',
						'dependency' => array(
							'element'            => 'style',
							'value_not_equal_to' => array(
								'style-02',
								'style-05',
								'style-06',
							),
						),
					),
				),
			);
			$params['ovic_iconbox']['params']     = array_merge(
				$params['ovic_iconbox']['params'],
				$icon_field,
				array(
					array(
						'type'        => 'vc_link',
						'heading'     => esc_html__( 'Link', 'ocolus' ),
						'param_name'  => 'link',
						'description' => esc_html__( 'The Link to Icon', 'ocolus' ),
					),
					vc_map_add_css_animation(),
				)
			);
			$params['ovic_pinmapper']             = array(
				'base'        => 'ovic_pinmapper',
				'name'        => esc_html__( 'Ocolus: Pin Map', 'ocolus' ),
				'icon'        => get_theme_file_uri( 'assets/images/icon/push-pin.svg' ),
				'category'    => esc_html__( 'Ocolus Shortcode', 'ocolus' ),
				'description' => esc_html__( 'Display Pin Map', 'ocolus' ),
				'params'      => array(
					array(
						'type'        => 'select_preview',
						'heading'     => esc_html__( 'Pinmap style', 'ocolus' ),
						'value'       => ocolus_pinmap_options(),
						'admin_label' => true,
						'param_name'  => 'pinmap_style',
						'description' => esc_html__( 'Select a style for pinmap item', 'ocolus' ),
					),
					vc_map_add_css_animation(),
				),
			);
			$params['ovic_socials']               = array(
				'base'        => 'ovic_socials',
				'name'        => esc_html__( 'Ocolus: Social', 'ocolus' ),
				'icon'        => get_theme_file_uri( 'assets/images/icon/share.svg' ),
				'category'    => esc_html__( 'Ocolus Shortcode', 'ocolus' ),
				'description' => esc_html__( 'Display Social', 'ocolus' ),
				'params'      => array(
					$this->get_preview_options( 'ovic_socials' ),
					array(
						'type'       => 'checkbox',
						'heading'    => esc_html__( 'List Social', 'ocolus' ),
						'param_name' => 'socials',
						'value'      => ocolus_social_option( true ),
					),
					vc_map_add_css_animation(),
				),
			);
			$params['ovic_blog']                  = array(
				'base'        => 'ovic_blog',
				'icon'        => get_theme_file_uri( 'assets/images/icon/blogger.svg' ),
				'name'        => esc_html__( 'Ocolus: Blog', 'ocolus' ),
				'category'    => esc_html__( 'Ocolus Shortcode', 'ocolus' ),
				'description' => esc_html__( 'Display Blog', 'ocolus' ),
				'params'      => array(
					array(
						'type'        => 'textfield',
						'heading'     => esc_html__( 'Title', 'ocolus' ),
						'param_name'  => 'title',
						'description' => esc_html__( 'The title of shortcode', 'ocolus' ),
						'admin_label' => true,
					),
					array(
						'type'        => 'select_preview',
						'heading'     => esc_html__( 'Blog style', 'ocolus' ),
						'value'       => ocolus_file_options( '/templates/blog/blog-shortcode/', 'content-blog' ),
						'default'     => 'style-01',
						'admin_label' => true,
						'param_name'  => 'style',
						'description' => esc_html__( 'Select a style for blog item', 'ocolus' ),
					),
					array(
						'type'        => 'checkbox',
						'heading'     => esc_html__( 'Full Size Image', 'ocolus' ),
						'param_name'  => 'full_size',
						'value'       => array(
							esc_html__( 'Enable', 'ocolus' ) => 'enable',
						),
						'group'       => esc_html__( 'Blog Settings', 'ocolus' ),
						'description' => esc_html__( 'Use original full size image posts and no crop', 'ocolus' ),
					),
					array(
						'type'        => 'dropdown',
						'heading'     => esc_html__( 'Post List style', 'ocolus' ),
						'param_name'  => 'postliststyle',
						'value'       => array(
							esc_html__( 'Grid Bootstrap', 'ocolus' ) => 'grid',
							esc_html__( 'Owl Carousel', 'ocolus' )   => 'owl',
							esc_html__( 'Grid Isotope', 'ocolus' )   => 'isotope',
						),
						'std'         => 'grid',
						'group'       => esc_html__( 'Blog Settings', 'ocolus' ),
						'description' => esc_html__( 'Select view blog shortcode', 'ocolus' ),
					),
					array(
						'type'        => 'dropdown',
						'heading'     => esc_html__( 'Target', 'ocolus' ),
						'param_name'  => 'target',
						'value'       => array(
							esc_html__( 'Recent Post', 'ocolus' ) => 'recent_post',
							esc_html__( 'Popularity', 'ocolus' )  => 'popularity',
							esc_html__( 'Select Post', 'ocolus' ) => 'post',
						),
						'admin_label' => true,
						'description' => esc_html__( 'Choose the target to filter Blog', 'ocolus' ),
						'std'         => 'recent_post',
						'group'       => esc_html__( 'Blog Settings', 'ocolus' ),
					),
					array(
						'type'       => 'autocomplete',
						'heading'    => esc_html__( 'Select a Post', 'ocolus' ),
						'param_name' => 'ids',
						'settings'   => array(
							'multiple' => true,
							'sortable' => true,
							'groups'   => false,
						),
						'dependency' => array(
							'element' => 'target',
							'value'   => array( 'post' ),
						),
						'group'      => esc_html__( 'Blog Settings', 'ocolus' ),
					),
					array(
						'type'        => 'dropdown',
						'heading'     => esc_html__( 'Category Blog', 'ocolus' ),
						'param_name'  => 'category',
						'value'       => $categories_array,
						'dependency'  => array(
							'element'            => 'target',
							'value_not_equal_to' => 'post',
						),
						'group'       => esc_html__( 'Blog Settings', 'ocolus' ),
						'description' => esc_html__( 'Note: If you want to narrow output, select Category(s) above. Only selected Brand will be displayed.', 'ocolus' ),
					),
					array(
						'type'        => 'textfield',
						'heading'     => esc_html__( 'Per page', 'ocolus' ),
						'value'       => 6,
						'param_name'  => 'limit',
						'admin_label' => true,
						'dependency'  => array(
							'element'            => 'target',
							'value_not_equal_to' => 'post',
						),
						'group'       => esc_html__( 'Blog Settings', 'ocolus' ),
						'description' => esc_html__( 'How much items per page to show', 'ocolus' ),
					),
					array(
						'type'        => 'dropdown',
						'heading'     => esc_html__( 'Order by', 'ocolus' ),
						'param_name'  => 'orderby',
						'value'       => array(
							'',
							esc_html__( 'Date', 'ocolus' )          => 'date',
							esc_html__( 'ID', 'ocolus' )            => 'ID',
							esc_html__( 'Author', 'ocolus' )        => 'author',
							esc_html__( 'Title', 'ocolus' )         => 'title',
							esc_html__( 'Modified', 'ocolus' )      => 'modified',
							esc_html__( 'Random', 'ocolus' )        => 'rand',
							esc_html__( 'Comment count', 'ocolus' ) => 'comment_count',
							esc_html__( 'Menu order', 'ocolus' )    => 'menu_order',
							esc_html__( 'Post In', 'ocolus' )       => 'post__in',
						),
						'dependency'  => array(
							'element'            => 'target',
							'value_not_equal_to' => 'popularity',
						),
						'group'       => esc_html__( 'Blog Settings', 'ocolus' ),
						'description' => sprintf( esc_html__( 'Select how to sort retrieved products. More at %s.', 'ocolus' ), '<a href="' . esc_url( 'http://codex.wordpress.org/Class_Reference/WP_Query#Order_.26_Orderby_Parameters' ) . '" target="_blank">' . esc_html__( 'WordPress codex page', 'ocolus' ) . '</a>' ),
					),
					array(
						'type'        => 'dropdown',
						'heading'     => esc_html__( 'Sort order', 'ocolus' ),
						'param_name'  => 'order',
						'value'       => array(
							'',
							esc_html__( 'Descending', 'ocolus' ) => 'DESC',
							esc_html__( 'Ascending', 'ocolus' )  => 'ASC',
						),
						'group'       => esc_html__( 'Blog Settings', 'ocolus' ),
						'description' => sprintf( esc_html__( 'Designates the ascending or descending order. More at %s.', 'ocolus' ), '<a href="' . esc_url( 'http://codex.wordpress.org/Class_Reference/WP_Query#Order_.26_Orderby_Parameters' ) . '" target="_blank">' . esc_html__( 'WordPress codex page', 'ocolus' ) . '</a>' ),
					),
					array(
						'type'       => 'dropdown',
						'heading'    => esc_html__( 'Layout Mode', 'ocolus' ),
						'param_name' => 'layout_mode',
						'value'      => array(
							esc_html__( 'Packery', 'ocolus' )    => 'packery',
							esc_html__( 'Masonry', 'ocolus' )    => 'masonry',
							esc_html__( 'FitRows', 'ocolus' )    => 'fitRows',
							esc_html__( 'FitColumns', 'ocolus' ) => 'fitColumns',
						),
						'std'        => 'packery',
						'dependency' => array(
							'element' => 'postliststyle',
							'value'   => array( 'isotope' ),
						),
						'group'      => esc_html__( 'Isotope Settings', 'ocolus' ),
					),
					array(
						'type'        => 'checkbox',
						'heading'     => esc_html__( 'Use current size', 'ocolus' ),
						'param_name'  => 'current_size',
						'value'       => array(
							esc_html__( 'Enable', 'ocolus' ) => 'enable',
						),
						'dependency'  => array(
							'element' => 'postliststyle',
							'value'   => array( 'isotope' ),
						),
						'description' => esc_html__( 'Enable if you want all product use current size setting.', 'ocolus' ),
						'group'       => esc_html__( 'Isotope Settings', 'ocolus' ),
					),
					array(
						'type'       => 'dropdown',
						'heading'    => esc_html__( 'Column', 'ocolus' ),
						'param_name' => 'col',
						'value'      => array(
							esc_html__( 'Auto', 'ocolus' )     => '0',
							esc_html__( '1 Column', 'ocolus' ) => '1',
							esc_html__( '2 Column', 'ocolus' ) => '2',
							esc_html__( '3 Column', 'ocolus' ) => '3',
							esc_html__( '4 Column', 'ocolus' ) => '4',
							esc_html__( '5 Column', 'ocolus' ) => '5',
							esc_html__( '6 Column', 'ocolus' ) => '6',
						),
						'std'        => '4',
						'dependency' => array(
							'element' => 'postliststyle',
							'value'   => array( 'isotope' ),
						),
						'group'      => esc_html__( 'Isotope Settings', 'ocolus' ),
					),
					array(
						'type'        => 'dropdown',
						'heading'     => esc_html__( 'Rows space', 'ocolus' ),
						'param_name'  => 'isotope_rows_space',
						'value'       => array(
							esc_html__( 'Default', 'ocolus' ) => 'rows-space-0',
							esc_html__( '5px', 'ocolus' )     => 'rows-space-5',
							esc_html__( '10px', 'ocolus' )    => 'rows-space-10',
							esc_html__( '15px', 'ocolus' )    => 'rows-space-15',
							esc_html__( '20px', 'ocolus' )    => 'rows-space-20',
							esc_html__( '25px', 'ocolus' )    => 'rows-space-25',
							esc_html__( '30px', 'ocolus' )    => 'rows-space-30',
							esc_html__( '35px', 'ocolus' )    => 'rows-space-35',
							esc_html__( '40px', 'ocolus' )    => 'rows-space-40',
							esc_html__( '45px', 'ocolus' )    => 'rows-space-45',
							esc_html__( '50px', 'ocolus' )    => 'rows-space-50',
						),
						'std'         => 'rows-space-0',
						'dependency'  => array(
							'element' => 'postliststyle',
							'value'   => array( 'isotope' ),
						),
						'description' => esc_html__( 'Space between each isotope item.', 'ocolus' ),
						'group'       => esc_html__( 'Isotope Settings', 'ocolus' ),
					),
					array(
						'type'       => 'bootstrap_v3',
						'heading'    => esc_html__( 'Bootstrap Settings', 'ocolus' ),
						'param_name' => 'bootstrap',
						'dependency' => array(
							'element' => 'postliststyle',
							'value'   => array( 'grid' ),
						),
						'group'      => esc_html__( 'Bootstrap Settings', 'ocolus' ),
					),
					array(
						'type'       => 'dropdown',
						'heading'    => esc_html__( 'Rows space', 'ocolus' ),
						'param_name' => 'owl_rows_space',
						'value'      => array(
							esc_html__( 'Default', 'ocolus' ) => 'rows-space-0',
							esc_html__( '5px', 'ocolus' )     => 'rows-space-5',
							esc_html__( '10px', 'ocolus' )    => 'rows-space-10',
							esc_html__( '15px', 'ocolus' )    => 'rows-space-15',
							esc_html__( '20px', 'ocolus' )    => 'rows-space-20',
							esc_html__( '30px', 'ocolus' )    => 'rows-space-30',
							esc_html__( '40px', 'ocolus' )    => 'rows-space-40',
							esc_html__( '50px', 'ocolus' )    => 'rows-space-50',
							esc_html__( '60px', 'ocolus' )    => 'rows-space-60',
							esc_html__( '70px', 'ocolus' )    => 'rows-space-70',
							esc_html__( '80px', 'ocolus' )    => 'rows-space-80',
							esc_html__( '90px', 'ocolus' )    => 'rows-space-90',
							esc_html__( '100px', 'ocolus' )   => 'rows-space-100',
						),
						'std'        => 'rows-space-0',
						'group'      => esc_html__( 'Carousel Settings', 'ocolus' ),
						'dependency' => array(
							'element' => 'postliststyle',
							'value'   => array( 'owl' ),
						),
					),
					array(
						'type'        => 'dropdown',
						'heading'     => esc_html__( 'Navigation style', 'ocolus' ),
						'param_name'  => 'owl_navigation_style',
						'value'       => array(
							esc_html__( 'Default', 'ocolus' )    => '',
							esc_html__( 'Nav Circle', 'ocolus' ) => 'nav-circle',
						),
						'std'         => '',
						'save_always' => true,
						'group'       => esc_html__( 'Carousel Settings', 'ocolus' ),
						'dependency'  => array(
							'element' => 'postliststyle',
							'value'   => array( 'owl' ),
						),
					),

					array(
						'type'        => 'dropdown',
						'heading'     => esc_html__( 'Dot style', 'ocolus' ),
						'param_name'  => 'owl_dot_style',
						'value'       => array(
							esc_html__( 'Default', 'ocolus' )      => '',
							esc_html__( 'Dot Equal', 'ocolus' )    => 'dot-equal',
							esc_html__( 'Dot Line', 'ocolus' )     => 'dot-line',
							esc_html__( 'Dot Inside', 'ocolus' )   => 'dot-inside',
							esc_html__( 'Dot Inside 2', 'ocolus' ) => 'dot-inside-2',
							esc_html__( 'Dot Stretch', 'ocolus' )  => 'dot-stretch',
						),
						'std'         => '',
						'save_always' => true,
						'group'       => esc_html__( 'Carousel Settings', 'ocolus' ),
						'dependency'  => array(
							'element' => 'postliststyle',
							'value'   => array( 'owl' ),
						),
					),
					array(
						'type'       => 'carousel',
						'heading'    => esc_html__( 'Carousel Settings', 'ocolus' ),
						'param_name' => 'carousel',
						'group'      => esc_html__( 'Carousel Settings', 'ocolus' ),
						'dependency' => array(
							'element' => 'postliststyle',
							'value'   => array( 'owl' ),
						),
					),
					vc_map_add_css_animation(),
				),
			);
			$params['ovic_accordion']             = array(
				'base'                    => 'ovic_accordion',
				'icon'                    => 'icon-wpb-ui-accordion',
				'name'                    => esc_html__( 'Ocolus: Accordion', 'ocolus' ),
				'category'                => esc_html__( 'Ocolus Shortcode', 'ocolus' ),
				'description'             => esc_html__( 'Display Accordion', 'ocolus' ),
				'is_container'            => true,
				'show_settings_on_create' => false,
				'as_parent'               => array(
					'only' => 'vc_tta_section',
				),
				'params'                  => array(
					$this->get_preview_options( 'ovic_accordion' ),
					array(
						'type'        => 'textfield',
						'heading'     => esc_html__( 'Title', 'ocolus' ),
						'param_name'  => 'tab_title',
						'description' => esc_html__( 'The title of shortcode', 'ocolus' ),
						'admin_label' => true,
					),
					vc_map_add_css_animation(),
					array(
						'param_name'       => 'ajax_check',
						'heading'          => esc_html__( 'Enable Ajax', 'ocolus' ),
						'type'             => 'dropdown',
						'value'            => array(
							esc_html__( 'Yes', 'ocolus' ) => '1',
							esc_html__( 'No', 'ocolus' )  => '0',
						),
						'std'              => '0',
						'edit_field_class' => 'vc_col-xs-12 vc_col-sm-6',
					),
					array(
						'type'             => 'number',
						'heading'          => esc_html__( 'Active Section', 'ocolus' ),
						'param_name'       => 'active_section',
						'std'              => 0,
						'edit_field_class' => 'vc_col-xs-12 vc_col-sm-6',
					),
				),
				'js_view'                 => 'VcBackendTtaAccordionView',
				'custom_markup'           => '
                        <div class="vc_tta-container" data-vc-action="collapseAll">
                            <div class="vc_general vc_tta vc_tta-accordion vc_tta-color-backend-accordion-white vc_tta-style-flat vc_tta-shape-rounded vc_tta-o-shape-group vc_tta-controls-align-left vc_tta-gap-2">
                               <div class="vc_tta-panels vc_clearfix {{container-class}}">
                                  {{ content }}
                                  <div class="vc_tta-panel vc_tta-section-append">
                                     <div class="vc_tta-panel-heading">
                                        <h4 class="vc_tta-panel-title vc_tta-controls-icon-position-left">
                                           <a href="javascript:;" aria-expanded="false" class="vc_tta-backend-add-control">
                                               <span class="vc_tta-title-text">' . esc_html__( 'Add Section', 'ocolus' ) . '</span>
                                                <i class="vc_tta-controls-icon vc_tta-controls-icon-plus"></i>
                                            </a>
                                        </h4>
                                     </div>
                                  </div>
                               </div>
                            </div>
                        </div>',
				'default_content'         => '
                        [vc_tta_section title="' . sprintf( '%s %d', esc_attr__( 'Section', 'ocolus' ), 1 ) . '"][/vc_tta_section]
                        [vc_tta_section title="' . sprintf( '%s %d', esc_attr__( 'Section', 'ocolus' ), 2 ) . '"][/vc_tta_section]
					',
			);
			$params['ovic_tabs']                  = array(
				'base'                    => 'ovic_tabs',
				'icon'                    => 'icon-wpb-ui-tab-content',
				'name'                    => esc_html__( 'Ocolus: Tabs', 'ocolus' ),
				'category'                => esc_html__( 'Ocolus Shortcode', 'ocolus' ),
				'description'             => esc_html__( 'Display Tabs', 'ocolus' ),
				'is_container'            => true,
				'show_settings_on_create' => false,
				'as_parent'               => array(
					'only' => 'vc_tta_section',
				),
				'params'                  => array(
					$this->get_preview_options( 'ovic_tabs' ),
					array(
						'type'        => 'textfield',
						'heading'     => esc_html__( 'Title', 'ocolus' ),
						'param_name'  => 'tab_title',
						'description' => esc_html__( 'The title of shortcode', 'ocolus' ),
						'admin_label' => true,
					),
					vc_map_add_css_animation(),
					array(
						'param_name'       => 'ajax_check',
						'heading'          => esc_html__( 'Enable Ajax', 'ocolus' ),
						'type'             => 'dropdown',
						'value'            => array(
							esc_html__( 'Yes', 'ocolus' ) => '1',
							esc_html__( 'No', 'ocolus' )  => '0',
						),
						'std'              => '0',
						'edit_field_class' => 'vc_col-xs-12 vc_col-sm-6',
					),
					array(
						'type'             => 'number',
						'heading'          => esc_html__( 'Active Section', 'ocolus' ),
						'param_name'       => 'active_section',
						'std'              => 0,
						'edit_field_class' => 'vc_col-xs-12 vc_col-sm-6',
					),
				),
				'js_view'                 => 'VcBackendTtaTabsView',
				'custom_markup'           => '
                    <div class="vc_tta-container" data-vc-action="collapse">
                        <div class="vc_general vc_tta vc_tta-tabs vc_tta-color-backend-tabs-white vc_tta-style-flat vc_tta-shape-rounded vc_tta-spacing-1 vc_tta-tabs-position-top vc_tta-controls-align-left">
                            <div class="vc_tta-tabs-container">'
					. '<ul class="vc_tta-tabs-list">'
					. '<li class="vc_tta-tab" data-vc-tab data-vc-target-model-id="{{ model_id }}" data-element_type="vc_tta_section"><a href="javascript:;" data-vc-tabs data-vc-container=".vc_tta" data-vc-target="[data-model-id=\'{{ model_id }}\']" data-vc-target-model-id="{{ model_id }}"><span class="vc_tta-title-text">{{ section_title }}</span></a></li>'
					. '</ul>
                            </div>
                            <div class="vc_tta-panels vc_clearfix {{container-class}}">
                              {{ content }}
                            </div>
                        </div>
                    </div>',
				'default_content'         => '
                        [vc_tta_section title="' . sprintf( '%s %d', esc_html__( 'Tab', 'ocolus' ), 1 ) . '"][/vc_tta_section]
                        [vc_tta_section title="' . sprintf( '%s %d', esc_html__( 'Tab', 'ocolus' ), 2 ) . '"][/vc_tta_section]
                    ',
				'admin_enqueue_js'        => array(
					vc_asset_url( 'lib/vc_tabs/vc-tabs.min.js' ),
				),
			);
			$params['ovic_slide']                 = array(
				'base'                    => 'ovic_slide',
				'icon'                    => get_theme_file_uri( 'assets/images/icon/slider.svg' ),
				'name'                    => esc_html__( 'Ocolus: Slide', 'ocolus' ),
				'category'                => esc_html__( 'Ocolus Shortcode', 'ocolus' ),
				'description'             => esc_html__( 'Display Slide', 'ocolus' ),
				'as_parent'               => array(
					'only' => 'vc_single_image, vc_custom_heading, ovic_custom_heading, ovic_person, vc_column_text,ovic_category, ovic_iconbox, ovic_socials, vc_row',
				),
				'content_element'         => true,
				'show_settings_on_create' => true,
				'js_view'                 => 'VcColumnView',
				'params'                  => array(
					array(
						'type'        => 'textfield',
						'heading'     => esc_html__( 'Title', 'ocolus' ),
						'param_name'  => 'slider_title',
						'admin_label' => true,
					),
					array(
						'type'       => 'dropdown',
						'heading'    => esc_html__( 'Layout', 'ocolus' ),
						'param_name' => 'layout',
						'value'      => array(
							esc_html__( 'Default', 'ocolus' )          => '',
							esc_html__( 'Content Overflow', 'ocolus' ) => 'content-overflow',
						),
					),
					array(
						'type'        => 'dropdown',
						'heading'     => esc_html__( 'Rows space', 'ocolus' ),
						'param_name'  => 'owl_rows_space',
						'value'       => array(
							esc_html__( 'Default', 'ocolus' ) => 'rows-space-0',
							esc_html__( '5px', 'ocolus' )     => 'rows-space-5',
							esc_html__( '10px', 'ocolus' )    => 'rows-space-10',
							esc_html__( '15px', 'ocolus' )    => 'rows-space-15',
							esc_html__( '20px', 'ocolus' )    => 'rows-space-20',
							esc_html__( '30px', 'ocolus' )    => 'rows-space-30',
							esc_html__( '40px', 'ocolus' )    => 'rows-space-40',
							esc_html__( '50px', 'ocolus' )    => 'rows-space-50',
							esc_html__( '60px', 'ocolus' )    => 'rows-space-60',
							esc_html__( '70px', 'ocolus' )    => 'rows-space-70',
							esc_html__( '80px', 'ocolus' )    => 'rows-space-80',
							esc_html__( '90px', 'ocolus' )    => 'rows-space-90',
							esc_html__( '100px', 'ocolus' )   => 'rows-space-100',
						),
						'std'         => 'rows-space-0',
						'save_always' => true,
						'group'       => esc_html__( 'Carousel Settings', 'ocolus' ),
					),
					array(
						'type'        => 'dropdown',
						'heading'     => esc_html__( 'Navigation style', 'ocolus' ),
						'param_name'  => 'owl_navigation_style',
						'value'       => array(
							esc_html__( 'Default', 'ocolus' )          => '',
							esc_html__( 'Nav Circle', 'ocolus' )       => 'nav-circle',
							esc_html__( 'Nav Long Arrow', 'ocolus' )   => 'nav-long-arrow',
							esc_html__( 'Nav Bottom Right', 'ocolus' ) => 'nav-bottom-right',
						),
						'std'         => '',
						'save_always' => true,
						'group'       => esc_html__( 'Carousel Settings', 'ocolus' ),
					),
					array(
						'type'        => 'dropdown',
						'heading'     => esc_html__( 'Dot style', 'ocolus' ),
						'param_name'  => 'owl_dot_style',
						'value'       => array(
							esc_html__( 'Default', 'ocolus' )      => '',
							esc_html__( 'Dot Equal', 'ocolus' )    => 'dot-equal',
							esc_html__( 'Dot Line', 'ocolus' )     => 'dot-line',
							esc_html__( 'Dot Inside', 'ocolus' )   => 'dot-inside',
							esc_html__( 'Dot Inside 2', 'ocolus' ) => 'dot-inside-2',
							esc_html__( 'Dot Stretch', 'ocolus' )  => 'dot-stretch',
						),
						'std'         => '',
						'save_always' => true,
						'group'       => esc_html__( 'Carousel Settings', 'ocolus' ),
					),
					array(
						'type'        => 'carousel',
						'heading'     => esc_html__( 'Carousel Settings', 'ocolus' ),
						'param_name'  => 'carousel',
						'save_always' => true,
						'group'       => esc_html__( 'Carousel Settings', 'ocolus' ),
					),
					vc_map_add_css_animation(),
				),
			);
			$params['ovic_instagram']             = array(
				'base'        => 'ovic_instagram',
				'icon'        => get_theme_file_uri( 'assets/images/icon/instagram.svg' ),
				'name'        => esc_html__( 'Ocolus: Instagram', 'ocolus' ),
				'category'    => esc_html__( 'Ocolus Shortcode', 'ocolus' ),
				'description' => esc_html__( 'Display Instagram', 'ocolus' ),
				'params'      => array(
					array(
						'type'        => 'textfield',
						'heading'     => esc_html__( 'Title', 'ocolus' ),
						'param_name'  => 'title',
						'description' => esc_html__( 'The title of shortcode', 'ocolus' ),
						'admin_label' => true,
					),
					array(
						'type'       => 'dropdown',
						'heading'    => esc_html__( 'Instagram List style', 'ocolus' ),
						'param_name' => 'instagramliststyle',
						'value'      => array(
							esc_html__( 'Grid Bootstrap', 'ocolus' ) => 'grid',
							esc_html__( 'Owl Carousel', 'ocolus' )   => 'owl',
						),
						'std'        => 'grid',
					),
					array(
						'type'       => 'bootstrap_v3',
						'heading'    => esc_html__( 'Bootstrap Settings', 'ocolus' ),
						'param_name' => 'bootstrap',
						'dependency' => array(
							'element' => 'instagramliststyle',
							'value'   => array( 'grid' ),
						),
						'group'      => esc_html__( 'Bootstrap Settings', 'ocolus' ),
					),
					array(
						'type'        => 'dropdown',
						'heading'     => esc_html__( 'Rows space', 'ocolus' ),
						'param_name'  => 'owl_rows_space',
						'value'       => array(
							esc_html__( 'Default', 'ocolus' ) => 'rows-space-0',
							esc_html__( '5px', 'ocolus' )     => 'rows-space-5',
							esc_html__( '10px', 'ocolus' )    => 'rows-space-10',
							esc_html__( '15px', 'ocolus' )    => 'rows-space-15',
							esc_html__( '20px', 'ocolus' )    => 'rows-space-20',
							esc_html__( '30px', 'ocolus' )    => 'rows-space-30',
							esc_html__( '40px', 'ocolus' )    => 'rows-space-40',
							esc_html__( '50px', 'ocolus' )    => 'rows-space-50',
							esc_html__( '60px', 'ocolus' )    => 'rows-space-60',
							esc_html__( '70px', 'ocolus' )    => 'rows-space-70',
							esc_html__( '80px', 'ocolus' )    => 'rows-space-80',
							esc_html__( '90px', 'ocolus' )    => 'rows-space-90',
							esc_html__( '100px', 'ocolus' )   => 'rows-space-100',
						),
						'std'         => 'rows-space-0',
						'save_always' => true,
						'group'       => esc_html__( 'Carousel Settings', 'ocolus' ),
						'dependency'  => array(
							'element' => 'instagramliststyle',
							'value'   => array( 'owl' ),
						),
					),
					array(
						'type'        => 'carousel',
						'heading'     => esc_html__( 'Carousel Settings', 'ocolus' ),
						'param_name'  => 'carousel',
						'dependency'  => array(
							'element' => 'instagramliststyle',
							'value'   => array( 'owl' ),
						),
						'save_always' => true,
						'group'       => esc_html__( 'Carousel Settings', 'ocolus' ),
					),
					array(
						'type'        => 'dropdown',
						'heading'     => esc_html__( 'Image Source', 'ocolus' ),
						'param_name'  => 'image_source',
						'value'       => array(
							esc_html__( 'From Instagram', 'ocolus' )   => 'instagram',
							esc_html__( 'From Local Image', 'ocolus' ) => 'gallery',
						),
						'std'         => 'instagram',
						'admin_label' => true,
					),
					array(
						'type'       => 'attach_images',
						'heading'    => esc_html__( 'Image Gallery', 'ocolus' ),
						'param_name' => 'image_gallery',
						'dependency' => array(
							'element' => 'image_source',
							'value'   => array( 'gallery' ),
						),
					),
					array(
						'type'       => 'dropdown',
						'heading'    => esc_html__( 'Image Resolution', 'ocolus' ),
						'param_name' => 'image_resolution',
						'value'      => array(
							esc_html__( 'Thumbnail', 'ocolus' )           => 'thumbnail',
							esc_html__( 'Low Resolution', 'ocolus' )      => 'low_resolution',
							esc_html__( 'Standard Resolution', 'ocolus' ) => 'standard_resolution',
						),
						'std'        => 'thumbnail',
						'dependency' => array(
							'element' => 'image_source',
							'value'   => array( 'instagram' ),
						),
					),
					array(
						'type'        => 'textfield',
						'heading'     => esc_html__( 'ID Instagram', 'ocolus' ),
						'param_name'  => 'id_instagram',
						'admin_label' => true,
						'dependency'  => array(
							'element' => 'image_source',
							'value'   => array( 'instagram' ),
						),
					),
					array(
						'type'        => 'textfield',
						'heading'     => esc_html__( 'Token Instagram', 'ocolus' ),
						'param_name'  => 'token',
						'dependency'  => array(
							'element' => 'image_source',
							'value'   => array( 'instagram' ),
						),
						'description' => wp_kses( sprintf( '<a href="%s" target="_blank">' . esc_html__( 'Get Token Instagram Here!', 'ocolus' ) . '</a>', esc_url( 'http://instagram.pixelunion.net' ) ), array( 'a' => array( 'href' => array(), 'target' => array() ) ) ),
					),
					array(
						'type'        => 'number',
						'heading'     => esc_html__( 'Items Instagram', 'ocolus' ),
						'param_name'  => 'items_limit',
						'description' => esc_html__( 'the number items show', 'ocolus' ),
						'std'         => '4',
						'dependency'  => array(
							'element' => 'image_source',
							'value'   => array( 'instagram' ),
						),
					),
					vc_map_add_css_animation(),
				),
			);
			$params['ovic_maps']                  = array(
				'base'        => 'ovic_maps',
				'icon'        => get_theme_file_uri( 'assets/images/icon/google.svg' ),
				'name'        => esc_html__( 'Ocolus: Google Map', 'ocolus' ),
				'category'    => esc_html__( 'Ocolus Shortcode', 'ocolus' ),
				'description' => esc_html__( 'Display Google Map', 'ocolus' ),
				'params'      => array(
					$this->get_preview_options( 'ovic_maps' ),
					array(
						'type'       => 'param_group',
						'heading'    => esc_html__( 'List Locations', 'ocolus' ),
						'param_name' => 'locations',
						'params'     => array(
							array(
								'type'        => 'textfield',
								'heading'     => esc_html__( 'Title', 'ocolus' ),
								'param_name'  => 'title',
								'admin_label' => true,
								'std'         => 'KuteThemes',
							),
							array(
								'type'        => 'textfield',
								'heading'     => esc_html__( 'Address', 'ocolus' ),
								'param_name'  => 'address',
								'admin_label' => true,
								'std'         => esc_html__( 'Z115 TP. Thai Nguyen', 'ocolus' ),
							),
							array(
								'type'       => 'textfield',
								'heading'    => esc_html__( 'Address Url', 'ocolus' ),
								'param_name' => 'url',
								'std'        => '#',
							),
							array(
								'type'       => 'textfield',
								'heading'    => esc_html__( 'Longitude', 'ocolus' ),
								'param_name' => 'longitude',
								'std'        => '21.587001',
							),
							array(
								'type'       => 'textfield',
								'heading'    => esc_html__( 'Latitude', 'ocolus' ),
								'param_name' => 'latitude',
								'std'        => '105.800286',
							),
						),
					),
					array(
						'type'        => 'number',
						'heading'     => esc_html__( 'Zoom', 'ocolus' ),
						'param_name'  => 'zoom',
						'admin_label' => true,
						'description' => esc_html__( 'zoom.', 'ocolus' ),
						'std'         => '14',
					),
					array(
						'type'       => 'number',
						'heading'    => esc_html__( 'Map Height', 'ocolus' ),
						'param_name' => 'map_height',
						'std'        => '400',
					),
					array(
						'param_name' => 'map_type',
						'heading'    => esc_html__( 'Map Style', 'ocolus' ),
						'type'       => 'dropdown',
						'value'      => array(
							esc_html__( 'ROADMAP', 'ocolus' )   => 'roadmap',
							esc_html__( 'SATELLITE', 'ocolus' ) => 'satellite',
							esc_html__( 'HYBRID', 'ocolus' )    => 'hybrid',
							esc_html__( 'TERRAIN', 'ocolus' )   => 'terrain',
							esc_html__( 'STYLED', 'ocolus' )    => 'Styled',
						),
						'std'        => 'roadmap',
					),
					vc_map_add_css_animation(),
				),
			);
			$params['ovic_custommenu']            = array(
				'base'        => 'ovic_custommenu',
				'name'        => esc_html__( 'Ocolus: Custom Menu', 'ocolus' ),
				'icon'        => get_theme_file_uri( 'assets/images/icon/menu.svg' ),
				'category'    => esc_html__( 'Ocolus Shortcode', 'ocolus' ),
				'description' => esc_html__( 'Display Custom Menu', 'ocolus' ),
				'params'      => array(
					$this->get_preview_options( 'ovic_custommenu', 'style-01' ),
					array(
						'type'        => 'textfield',
						'heading'     => esc_html__( 'Title', 'ocolus' ),
						'param_name'  => 'title',
						'description' => esc_html__( 'What text use as a widget title. Leave blank to use default widget title.', 'ocolus' ),
						'admin_label' => true,
					),
					array(
						'type'        => 'dropdown',
						'heading'     => esc_html__( 'Menu', 'ocolus' ),
						'value'       => ocolus_wordpress_menus( true ),
						'admin_label' => true,
						'param_name'  => 'nav_menu',
						'description' => esc_html__( 'Select menu to display.', 'ocolus' ),
					),
					vc_map_add_css_animation(),
				),
			);
			$params['ovic_360degree']             = array(
				'base'        => 'ovic_360degree',
				'name'        => esc_html__( 'Ocolus: 360 Degree', 'ocolus' ),
				'icon'        => get_theme_file_uri( 'assets/images/icon/360-degrees.svg' ),
				'category'    => esc_html__( 'Ocolus Shortcode', 'ocolus' ),
				'description' => esc_html__( 'Display 360 Degree Image', 'ocolus' ),
				'params'      => array(
					array(
						'type'        => 'textfield',
						'heading'     => esc_html__( 'Title', 'ocolus' ),
						'param_name'  => 'title',
						'admin_label' => true,
						'description' => esc_html__( 'shortcode title.', 'ocolus' ),
					),
					array(
						'type'       => 'attach_images',
						'heading'    => esc_html__( 'Gallery 360 Degree', 'ocolus' ),
						'param_name' => 'gallery_degree',
					),
					vc_map_add_css_animation(),
				),
			);
			$params['ovic_video']                 = array(
				'base'        => 'ovic_video',
				'name'        => esc_html__( 'Ocolus: Video', 'ocolus' ),
				'icon'        => get_theme_file_uri( 'assets/images/icon/youtube.svg' ),
				'category'    => esc_html__( 'Ocolus Shortcode', 'ocolus' ),
				'description' => esc_html__( 'Display Video', 'ocolus' ),
				'params'      => array(
					$this->get_preview_options( 'ovic_video' ),
					array(
						'type'       => 'attach_image',
						'heading'    => esc_html__( 'Poster', 'ocolus' ),
						'param_name' => 'video_bg',
						'dependency' => array(
							'element'            => 'style',
							'value_not_equal_to' => array( 'style-02' ),
						),
					),
					array(
						'type'        => 'textarea',
						'heading'     => esc_html__( 'Title', 'ocolus' ),
						'param_name'  => 'title',
						'admin_label' => true,
						'dependency'  => array(
							'element' => 'style',
							'value'   => array(
								'default',
								'style-02',
								'style-03',
							),
						),
					),
					array(
						'type'       => 'textarea',
						'heading'    => esc_html__( 'Descriptions', 'ocolus' ),
						'param_name' => 'desc',
						'dependency' => array(
							'element' => 'style',
							'value'   => array(
								'style-02',
							),
						),
					),
					array(
						'type'        => 'textfield',
						'heading'     => esc_html__( 'Button Video', 'ocolus' ),
						'param_name'  => 'button_video',
						'admin_label' => true,
						'std'         => 'Play',
						'dependency'  => array(
							'element' => 'style',
							'value'   => array(
								'style-03',
							),
						),
					),
					array(
						'type'        => 'textfield',
						'heading'     => esc_html__( 'Link Video', 'ocolus' ),
						'param_name'  => 'link_video',
						'admin_label' => true,
					),
					array(
						'param_name' => 'autoplay',
						'heading'    => esc_html__( 'Autoplay', 'ocolus' ),
						'type'       => 'dropdown',
						'value'      => array(
							esc_html__( 'On', 'ocolus' )  => 'on',
							esc_html__( 'Off', 'ocolus' ) => 'off',
						),
						'std'        => 'off',
						'dependency' => array(
							'element'            => 'style',
							'value_not_equal_to' => array( 'style-02' ),
						),
					),
					array(
						'param_name' => 'loop',
						'heading'    => esc_html__( 'Loop', 'ocolus' ),
						'type'       => 'dropdown',
						'value'      => array(
							esc_html__( 'On', 'ocolus' )  => 'on',
							esc_html__( 'Off', 'ocolus' ) => 'off',
						),
						'std'        => 'off',
						'dependency' => array(
							'element'            => 'style',
							'value_not_equal_to' => array( 'style-02' ),
						),
					),
					vc_map_add_css_animation(),
				),
			);
			$params['ovic_custom_heading']        = array(
				'base'        => 'ovic_custom_heading',
				'name'        => esc_html__( 'Ocolus: Custom Heading', 'ocolus' ),
				'icon'        => get_theme_file_uri( 'assets/images/icon/text.svg' ),
				'category'    => esc_html__( 'Ocolus Shortcode', 'ocolus' ),
				'description' => esc_html__( 'Display Custom Heading', 'ocolus' ),
				'params'      => array(
					$this->get_preview_options( 'ovic_custom_heading' ),
					array(
						'type'       => 'attach_image',
						'param_name' => 'background',
						'heading'    => esc_html__( 'Background', 'ocolus' ),
						'dependency' => array(
							'element' => 'style',
							'value'   => array(
								'style-13',
								'style-14',
								'style-15',
								'style-16',
								'style-18',
								'style-21',
								'style-25',
								'style-26',
								'style-28',
								'style-29',
								'style-31',
								'style-32',
								'style-33',
							),
						),
					),
					array(
						'type'       => 'dropdown',
						'heading'    => esc_html__( 'Content Size', 'ocolus' ),
						'param_name' => 'content_size',
						'value'      => array(
							esc_html__( 'Small', 'ocolus' ) => 'size-small',
							esc_html__( 'Big', 'ocolus' )   => 'size-big',
						),
						'dependency' => array(
							'element' => 'style',
							'value'   => array(
								'style-26',
							),
						),
						'std'        => 'size-small',
					),
					array(
						'type'        => 'textfield',
						'heading'     => esc_html__( 'Sub Title', 'ocolus' ),
						'param_name'  => 'sub_title',
						'admin_label' => true,
						'dependency'  => array(
							'element' => 'style',
							'value'   => array(
								'style-19',
								'style-24',
								'style-32',
							),
						),
					),
					array(
						'type'        => 'textarea',
						'heading'     => esc_html__( 'Title', 'ocolus' ),
						'param_name'  => 'title',
						'admin_label' => true,
						'dependency'  => array(
							'element'            => 'style',
							'value_not_equal_to' => array(
								'style-14',
							),
						),
						'description' => esc_html__( 'Using tag: <strong></strong> for highlight text', 'ocolus' ),
					),
					array(
						'type'       => 'textarea',
						'heading'    => esc_html__( 'Descriptions', 'ocolus' ),
						'param_name' => 'desc',
						'dependency' => array(
							'element'            => 'style',
							'value_not_equal_to' => array(
								'style-04',
								'style-05',
								'style-16',
								'style-17',
								'style-18',
								'style-19',
								'style-28',
								'style-30',
								'style-31',
								'style-32',
								'style-33',
							),
						),
					),
					array(
						'type'       => 'dropdown',
						'heading'    => esc_html__( 'Text Position', 'ocolus' ),
						'param_name' => 'text_position',
						'value'      => array(
							esc_html__( 'Left', 'ocolus' )  => 'posi-left',
							esc_html__( 'Right', 'ocolus' ) => 'posi-right',
						),
						'dependency' => array(
							'element' => 'style',
							'value'   => array(
								'style-13',
								'style-21',
							),
						),
						'std'        => 'posi-left',
					),
					array(
						'type'       => 'dropdown',
						'heading'    => esc_html__( 'Text Position', 'ocolus' ),
						'param_name' => 'text_position_vertical',
						'value'      => array(
							esc_html__( 'Top', 'ocolus' )    => 'posi-top',
							esc_html__( 'Bottom', 'ocolus' ) => 'posi-bot',
						),
						'dependency' => array(
							'element' => 'style',
							'value'   => array(
								'style-33',
							),
						),
						'std'        => 'posi-top',
					),
					array(
						'type'       => 'dropdown',
						'heading'    => esc_html__( 'Text Color', 'ocolus' ),
						'param_name' => 'text_color',
						'value'      => array(
							esc_html__( 'Dark', 'ocolus' )  => 'dark',
							esc_html__( 'Light', 'ocolus' ) => 'light',
						),
						'dependency' => array(
							'element' => 'style',
							'value'   => array(
								'style-33',
							),
						),
						'std'        => 'dark',
					),
					array(
						'type'       => 'checkbox',
						'heading'    => esc_html__( 'Enable Countdown', 'ocolus' ),
						'param_name' => 'enable_countdown',
						'dependency' => array(
							'element' => 'style',
							'value'   => array(
								'style-30',
							),
						),
					),
					array(
						'type'       => 'datepicker',
						'heading'    => esc_html__( 'Countdown', 'ocolus' ),
						'param_name' => 'countdown',
						'dependency' => array(
							'element' => 'enable_countdown',
							'value'   => 'true',
						),
					),
					array(
						'type'       => 'vc_link',
						'heading'    => esc_html__( 'Button Link', 'ocolus' ),
						'param_name' => 'button_url',
						'dependency' => array(
							'element' => 'style',
							'value'   => array(
								'style-01',
								'style-03',
								'style-05',
								'style-12',
								'style-13',
								'style-14',
								'style-15',
								'style-16',
								'style-18',
								'style-19',
								'style-21',
								'style-24',
								'style-25',
								'style-26',
								'style-27',
								'style-28',
								'style-29',
								'style-30',
								'style-31',
								'style-32',
								'style-33',
							),
						),
					),
					array(
						'param_name' => 'image_effect',
						'heading'    => esc_html__( 'Effect', 'ocolus' ),
						'type'       => 'dropdown',
						'value'      => array(
							esc_html__( 'None', 'ocolus' )               => 'none',
							esc_html__( 'Normal Effect', 'ocolus' )      => 'effect normal-effect',
							esc_html__( 'Normal Effect Dark', 'ocolus' ) => 'effect normal-effect dark-bg',
							esc_html__( 'Background Zoom', 'ocolus' )    => 'effect background-zoom',
							esc_html__( 'Plus Zoom', 'ocolus' )          => 'effect plus-zoom',
							esc_html__( 'Border Zoom', 'ocolus' )        => 'effect border-zoom',
							esc_html__( 'Border ScaleUp', 'ocolus' )     => 'effect border-scale',
							esc_html__( 'Rotate In Left', 'ocolus' )     => 'effect rotate-in rotate-left',
							esc_html__( 'Rotate In Right', 'ocolus' )    => 'effect rotate-in rotate-right',
						),
						'dependency' => array(
							'element' => 'style',
							'value'   => array(
								'style-13',
								'style-14',
								'style-15',
								'style-16',
								'style-18',
								'style-25',
								'style-26',
								'style-28',
								'style-29',
								'style-31',
								'style-32',
								'style-33',
							),
						),
						'std'        => 'none',
					),
					vc_map_add_css_animation(),
				),
			);
			$params['ovic_newsletter']            = array(
				'base'        => 'ovic_newsletter',
				'name'        => esc_html__( 'Ocolus: Newsletter', 'ocolus' ),
				'icon'        => get_theme_file_uri( 'assets/images/icon/newsletter.svg' ),
				'category'    => esc_html__( 'Ocolus Shortcode', 'ocolus' ),
				'description' => esc_html__( 'Display Newsletter', 'ocolus' ),
				'params'      => array(
					$this->get_preview_options( 'ovic_newsletter' ),
					array(
						'type'        => 'dropdown',
						'heading'     => esc_html__( 'Newsletter Form', 'ocolus' ),
						'param_name'  => 'form_id',
						'value'       => ocolus_get_form_newsletter( true ),
						'std'         => '0',
						'description' => sprintf( '%s <a href="%s" target="_blank">%s</a>',
							esc_html__( 'Add new form', 'ocolus' ),
							admin_url( 'admin.php?page=mailchimp-for-wp-forms&view=add-form' ),
							esc_html__( 'Here!', 'ocolus' )
						),
					),
					array(
						'type'       => 'attach_image',
						'param_name' => 'background',
						'heading'    => esc_html__( 'Background', 'ocolus' ),
						'dependency' => array(
							'element' => 'style',
							'value'   => array( 'default' ),
						),
					),
					array(
						'type'        => 'textfield',
						'heading'     => esc_html__( 'Title', 'ocolus' ),
						'param_name'  => 'title',
						'admin_label' => true,
					),
					array(
						'type'       => 'textarea',
						'heading'    => esc_html__( 'Descriptions', 'ocolus' ),
						'param_name' => 'desc',
						'dependency' => array(
							'element'            => 'style',
							'value_not_equal_to' => array(
								'style-03',
								'style-07',
								'style-10',
								'style-11',
								'style-12',
								'style-14',
							),
						),
					),
					array(
						'type'       => 'textfield',
						'heading'    => esc_html__( 'Placeholder', 'ocolus' ),
						'param_name' => 'placeholder',
						'std'        => esc_html__( 'Enter your email address', 'ocolus' ),
					),
					array(
						'type'       => 'textfield',
						'heading'    => esc_html__( 'Button', 'ocolus' ),
						'param_name' => 'button_text',
						'std'        => esc_html__( 'SUBSCRIBE', 'ocolus' ),
						'dependency' => array(
							'element'            => 'style',
							'value_not_equal_to' => array(
								'style-01',
								'style-02',
								'style-03',
								'style-04',
								'style-13',
								'style-14',
							),
						),
					),
					vc_map_add_css_animation(),
				),
			);
			$params['ovic_countdown']             = array(
				'base'        => 'ovic_countdown',
				'name'        => esc_html__( 'Ocolus: Countdown', 'ocolus' ),
				'icon'        => get_theme_file_uri( 'assets/images/icon/countdown.svg' ),
				'category'    => esc_html__( 'Ocolus Shortcode', 'ocolus' ),
				'description' => esc_html__( 'Display Countdown', 'ocolus' ),
				'params'      => array(
					$this->get_preview_options( 'ovic_countdown' ),
					array(
						'type'        => 'textfield',
						'heading'     => esc_html__( 'Title', 'ocolus' ),
						'param_name'  => 'title',
						'admin_label' => true,
						'dependency'  => array(
							'element' => 'style',
							'value'   => array( 'style-01' ),
						),
					),
					array(
						'type'        => 'datepicker',
						'heading'     => esc_html__( 'Date', 'ocolus' ),
						'param_name'  => 'date',
						'admin_label' => true,
					),
					array(
						'type'       => 'checkbox',
						'heading'    => esc_html__( 'Format Date Time', 'ocolus' ),
						'param_name' => 'format',
						'value'      => array(
							esc_html__( 'Days', 'ocolus' )  => 'days_text',
							esc_html__( 'Hours', 'ocolus' ) => 'hrs_text',
							esc_html__( 'Mins', 'ocolus' )  => 'mins_text',
							esc_html__( 'Secs', 'ocolus' )  => 'secs_text',
						),
						'std'        => 'days_text,hrs_text,mins_text,secs_text',
					),
					array(
						'type'        => 'autocomplete',
						'heading'     => esc_html__( 'Products', 'ocolus' ),
						'param_name'  => 'ids',
						'settings'    => array(
							'multiple'      => false,
							'sortable'      => true,
							'unique_values' => true,
							// In UI show results except selected. NB! You should manually check values in backend
						),
						'admin_label' => true,
						'save_always' => true,
						'description' => esc_html__( 'Enter List of Products', 'ocolus' ),
						'dependency'  => array(
							'element' => 'style',
							'value'   => array( 'default' ),
						),
					),
					array(
						'type'       => 'vc_link',
						'heading'    => esc_html__( 'Button', 'ocolus' ),
						'param_name' => 'button',
						'dependency' => array(
							'element' => 'style',
							'value'   => array( 'style-01' ),
						),
					),
					vc_map_add_css_animation(),
				),
			);
			$params['ovic_person']                = array(
				'base'        => 'ovic_person',
				'name'        => esc_html__( 'Ocolus: Person', 'ocolus' ),
				'icon'        => get_theme_file_uri( 'assets/images/icon/rating.svg' ),
				'category'    => esc_html__( 'Ocolus Shortcode', 'ocolus' ),
				'description' => esc_html__( 'Display Person', 'ocolus' ),
				'params'      => array(
					$this->get_preview_options( 'ovic_person' ),
					array(
						'type'       => 'attach_image',
						'heading'    => esc_html__( 'Avatar Person', 'ocolus' ),
						'param_name' => 'avatar',
						'dependency' => array(
							'element'            => 'style',
							'value_not_equal_to' => array(
								'style-02',
								'style-03',
								'style-08',
							),
						),
					),
					array(
						'type'        => 'textfield',
						'heading'     => esc_html__( 'Name', 'ocolus' ),
						'param_name'  => 'name',
						'description' => esc_html__( 'Name of Person.', 'ocolus' ),
						'admin_label' => true,
						'dependency'  => array(
							'element'            => 'style',
							'value_not_equal_to' => array(
								'style-08',
							),
						),
					),
					array(
						'type'        => 'textfield',
						'heading'     => esc_html__( 'Positions', 'ocolus' ),
						'param_name'  => 'positions',
						'admin_label' => true,
						'dependency'  => array(
							'element'            => 'style',
							'value_not_equal_to' => array(
								'style-08',
							),
						),
					),
					array(
						'type'       => 'textarea',
						'heading'    => esc_html__( 'Descriptions', 'ocolus' ),
						'param_name' => 'desc',
						'dependency' => array(
							'element'            => 'style',
							'value_not_equal_to' => array(
								'style-01',
								'style-04',
								'style-08',
							),
						),
					),
					array(
						'type'       => 'vc_link',
						'heading'    => esc_html__( 'Link Person', 'ocolus' ),
						'param_name' => 'link',
						'dependency' => array(
							'element'            => 'style',
							'value_not_equal_to' => array(
								'style-08',
							),
						),
					),
					array(
						'type'       => 'param_group',
						'heading'    => esc_html__( 'Socials', 'ocolus' ),
						'param_name' => 'socials',
						'params'     => array(
							array(
								'type'        => 'iconpicker',
								'heading'     => esc_html__( 'Icon', 'ocolus' ),
								'param_name'  => 'icon_fontawesome',
								'value'       => 'fa fa-adjust',
								'settings'    => array(
									'emptyIcon'    => false,
									'iconsPerPage' => 100,
								),
								'dependency'  => array(
									'element' => 'type',
									'value'   => 'fontawesome',
								),
								'description' => esc_html__( 'Select icon from library.', 'ocolus' ),
							),
							array(
								'type'        => 'href',
								'heading'     => esc_html__( 'Url', 'ocolus' ),
								'param_name'  => 'url',
								'admin_label' => true,
							),
						),
						'dependency' => array(
							'element' => 'style',
							'value'   => array(
								'style-04',
							),
						),
					),
					array(
						'type'       => 'param_group',
						'heading'    => esc_html__( 'List Persons', 'ocolus' ),
						'param_name' => 'persons',
						'params'     => array(
							array(
								'type'       => 'attach_image',
								'heading'    => esc_html__( 'Avatar Person', 'ocolus' ),
								'param_name' => 'avatar',
							),
							array(
								'type'        => 'textfield',
								'heading'     => esc_html__( 'Name', 'ocolus' ),
								'param_name'  => 'name',
								'description' => esc_html__( 'Name of Person.', 'ocolus' ),
								'admin_label' => true,
							),
							array(
								'type'        => 'textfield',
								'heading'     => esc_html__( 'Positions', 'ocolus' ),
								'param_name'  => 'positions',
								'admin_label' => true,
							),
							array(
								'type'       => 'textarea',
								'heading'    => esc_html__( 'Descriptions', 'ocolus' ),
								'param_name' => 'desc',
							),
							array(
								'type'       => 'href',
								'heading'    => esc_html__( 'Url', 'ocolus' ),
								'param_name' => 'link',
							),
						),
						'dependency' => array(
							'element' => 'style',
							'value'   => array(
								'style-08',
							),
						),
					),
					vc_map_add_css_animation(),
				),
			);
			if ( function_exists( 'wcmp_plugin_init' ) ) {
				$params['ovic_vendor_list'] = array(
					'base'        => 'ovic_vendor_list',
					'name'        => esc_html__( 'Ocolus: Vendor List', 'ocolus' ),
					'icon'        => get_theme_file_uri( 'assets/images/icon/team.svg' ),
					'category'    => esc_html__( 'Ocolus Shortcode', 'ocolus' ),
					'description' => esc_html__( 'Display Vendor List WC Marketplace', 'ocolus' ),
					'params'      => array(
						$this->get_preview_options( 'ovic_vendor_list' ),
					),
				);
			}
			if ( class_exists( 'WooCommerce' ) ) {
				$params['ovic_coupon']   = array(
					'base'        => 'ovic_coupon',
					'icon'        => get_theme_file_uri( 'assets/images/icon/coupon.svg' ),
					'name'        => esc_html__( 'Ocolus: Coupon', 'ocolus' ),
					'category'    => esc_html__( 'Ocolus Shortcode', 'ocolus' ),
					'description' => esc_html__( 'Display Coupon', 'ocolus' ),
					'params'      => array(
						$this->get_preview_options( 'ovic_coupon' ),
						array(
							'type'       => 'attach_image',
							'heading'    => esc_html__( 'Background', 'ocolus' ),
							'param_name' => 'bg',
						),
						array(
							'type'        => 'multiselect',
							'heading'     => esc_html__( 'List Coupon', 'ocolus' ),
							'param_name'  => 'coupons',
							'admin_label' => true,
							'value'       => ocolus_shop_coupon_options(),
							'description' => esc_html__( 'Select a Coupon for list', 'ocolus' ),
						),
						vc_map_add_css_animation(),
					),
				);
				$params['ovic_category'] = array(
					'base'        => 'ovic_category',
					'icon'        => get_theme_file_uri( 'assets/images/icon/diagram.svg' ),
					'name'        => esc_html__( 'Ocolus: Category', 'ocolus' ),
					'category'    => esc_html__( 'Ocolus Shortcode', 'ocolus' ),
					'description' => esc_html__( 'Display Category', 'ocolus' ),
					'params'      => array(
						array(
							'type'        => 'textfield',
							'heading'     => esc_html__( 'Title', 'ocolus' ),
							'param_name'  => 'title',
							'admin_label' => true,
							'dependency'  => array(
								'element' => 'style',
								'value'   => array(
									'style-01',
									'style-06',
								),
							),
						),
						$this->get_preview_options( 'ovic_category' ),
						array(
							'type'        => 'attach_image',
							'heading'     => esc_html__( 'Image', 'ocolus' ),
							'param_name'  => 'image',
							'dependency'  => array(
								'element' => 'style',
								'value'   => array(
									'style-06',
								),
							),
							'description' => esc_html__( 'empty for use image from category product.', 'ocolus' ),
						),
						array(
							'type'        => 'taxonomy',
							'heading'     => esc_html__( 'Product Category', 'ocolus' ),
							'param_name'  => 'taxonomy',
							'settings'    => array(
								'multiple'    => true,
								'hide_empty'  => true,
								'taxonomy'    => 'product_cat',
								'placeholder' => esc_html__( 'Select Products Category', 'ocolus' ),
							),
							'dependency'  => array(
								'element' => 'style',
								'value'   => array(
									'style-06',
								),
							),
							'description' => esc_html__( 'Note: If you want to narrow output, select category(s) above. Only selected categories will be displayed.', 'ocolus' ),
						),
						array(
							'type'        => 'dropdown',
							'heading'     => esc_html__( 'Categories List style', 'ocolus' ),
							'param_name'  => 'categoriesliststyle',
							'value'       => array(
								esc_html__( 'Grid Bootstrap', 'ocolus' ) => 'grid',
								esc_html__( 'Owl Carousel', 'ocolus' )   => 'owl',
							),
							'description' => esc_html__( 'Select a style for list', 'ocolus' ),
							'std'         => 'owl',
							'dependency'  => array(
								'element'            => 'style',
								'value_not_equal_to' => array(
									'style-01',
									'style-04',
									'style-06',
								),
							),
							'admin_label' => true,
						),
						array(
							'type'       => 'param_group',
							'heading'    => esc_html__( 'Product Categories', 'ocolus' ),
							'param_name' => 'categories',
							'params'     => array(
								array(
									'type'        => 'attach_image',
									'heading'     => esc_html__( 'Image', 'ocolus' ),
									'param_name'  => 'image',
									'description' => esc_html__( 'empty for use image from category product.', 'ocolus' ),
								),
								array(
									'type'        => 'taxonomy',
									'heading'     => esc_html__( 'Product Category', 'ocolus' ),
									'param_name'  => 'taxonomy',
									'settings'    => array(
										'multiple'    => false,
										'hide_empty'  => true,
										'taxonomy'    => 'product_cat',
										'placeholder' => esc_html__( 'Select Products Category', 'ocolus' ),
									),
									'admin_label' => true,
									'description' => esc_html__( 'Note: If you want to narrow output, select category(s) above. Only selected categories will be displayed.', 'ocolus' ),
								),
							),
							'dependency' => array(
								'element'            => 'style',
								'value_not_equal_to' => array(
									'style-06',
								),
							),
						),
						array(
							'type'       => 'textfield',
							'heading'    => esc_html__( 'Text Button', 'ocolus' ),
							'param_name' => 'text_button',
							'std'        => esc_html__( 'VIEW COLLECTION', 'ocolus' ),
							'dependency' => array(
								'element'            => 'style',
								'value_not_equal_to' => array(
									'style-04',
									'style-06',
									'style-07',
									'style-08',
								),
							),
						),
						array(
							'type'       => 'bootstrap_v3',
							'heading'    => esc_html__( 'Bootstrap Settings', 'ocolus' ),
							'param_name' => 'bootstrap',
							'group'      => esc_html__( 'Bootstrap Settings', 'ocolus' ),
							'dependency' => array(
								'element' => 'categoriesliststyle',
								'value'   => array( 'grid' ),
							),
						),
						array(
							'type'        => 'dropdown',
							'heading'     => esc_html__( 'Rows space', 'ocolus' ),
							'param_name'  => 'owl_rows_space',
							'value'       => array(
								esc_html__( 'Default', 'ocolus' ) => 'rows-space-0',
								esc_html__( '5px', 'ocolus' )     => 'rows-space-5',
								esc_html__( '10px', 'ocolus' )    => 'rows-space-10',
								esc_html__( '15px', 'ocolus' )    => 'rows-space-15',
								esc_html__( '20px', 'ocolus' )    => 'rows-space-20',
								esc_html__( '30px', 'ocolus' )    => 'rows-space-30',
								esc_html__( '40px', 'ocolus' )    => 'rows-space-40',
								esc_html__( '50px', 'ocolus' )    => 'rows-space-50',
								esc_html__( '60px', 'ocolus' )    => 'rows-space-60',
								esc_html__( '70px', 'ocolus' )    => 'rows-space-70',
								esc_html__( '80px', 'ocolus' )    => 'rows-space-80',
								esc_html__( '90px', 'ocolus' )    => 'rows-space-90',
								esc_html__( '100px', 'ocolus' )   => 'rows-space-100',
							),
							'std'         => 'rows-space-0',
							'save_always' => true,
							'group'       => esc_html__( 'Carousel Settings', 'ocolus' ),
							'dependency'  => array(
								'element' => 'categoriesliststyle',
								'value'   => array( 'owl' ),
							),
						),
						array(
							'type'        => 'carousel',
							'heading'     => esc_html__( 'Carousel Settings', 'ocolus' ),
							'param_name'  => 'carousel',
							'save_always' => true,
							'group'       => esc_html__( 'Carousel Settings', 'ocolus' ),
							'dependency'  => array(
								'element' => 'categoriesliststyle',
								'value'   => array( 'owl' ),
							),
						),
						vc_map_add_css_animation(),
					),
				);
				$params['ovic_products'] = $this->get_params_products();
			}

			if ( $add_grid ) {
				foreach ( $params as $key => $param ) {
					$params[$key]['post_type'] = Vc_Grid_Item_Editor::postType();
				}
			}

			return $params;
		}

		public function module_add_grid_shortcodes( $shortcodes )
		{
			return $this->params_shortcode( $shortcodes, true );
		}

		public function add_param_visual_composer( $param )
		{
			return $this->params_shortcode( $param );
		}

		public function get_preview_options( $name, $default = 'default', $param_name = 'style' )
		{
			$path            = trailingslashit( get_template_directory() ) . "vc_templates/{$name}/layout/";
			$preview_options = array();
			if ( is_dir( $path ) ) {
				$files = scandir( $path );
				if ( $files && is_array( $files ) ) {
					foreach ( $files as $file ) {
						if ( $file != '.' && $file != '..' ) {
							$fileInfo = pathinfo( $file );
							if ( $fileInfo['extension'] == 'jpg' ) {
								$fileName = str_replace(
									array( '_', '-' ),
									array( ' ', ' ' ),
									$fileInfo['filename']
								);
								/* PRINT OPTION */
								$preview_options[$fileInfo['filename']] = array(
									'title'   => ucwords( $fileName ),
									'preview' => get_theme_file_uri( "vc_templates/{$name}/layout/{$fileInfo['filename']}.jpg" ),
								);
							}
						}
					}
				}
			}

			return array(
				'type'        => 'select_preview',
				'heading'     => esc_html__( 'Select style', 'ocolus' ),
				'value'       => $preview_options,
				'default'     => $default,
				'admin_label' => true,
				'param_name'  => $param_name,
			);
		}

		public function get_vendor_list()
		{
			$vendors_array = array( '' );
			$args          = array(
				'role'    => 'dc_vendor',
				'fields'  => array( 'ID', 'display_name' ),
				'orderby' => 'registered',
				'order'   => 'ASC',
			);
			$user_query    = new WP_User_Query( $args );
			$results       = $user_query->get_results();
			if ( isset( $results ) && !empty( $results ) && function_exists( 'wcmp_plugin_init' ) ) {
				foreach ( $user_query->get_results() as $user ) {
					$vendors_array[$user->display_name] = $user->ID;
				}
			} else {
				$vendors_array = array( 'No users found.' );
			}

			return $vendors_array;
		}

		public function get_params_products()
		{
			$order_by_values  = array(
				'',
				esc_html__( 'Date', 'ocolus' )               => 'date',
				esc_html__( 'ID', 'ocolus' )                 => 'ID',
				esc_html__( 'Author', 'ocolus' )             => 'author',
				esc_html__( 'Title', 'ocolus' )              => 'title',
				esc_html__( 'Modified', 'ocolus' )           => 'modified',
				esc_html__( 'Random', 'ocolus' )             => 'rand',
				esc_html__( 'Comment count', 'ocolus' )      => 'comment_count',
				esc_html__( 'Menu order', 'ocolus' )         => 'menu_order',
				esc_html__( 'Price: low to high', 'ocolus' ) => 'price',
				esc_html__( 'Price: high to low', 'ocolus' ) => 'price-desc',
				esc_html__( 'Average Rating', 'ocolus' )     => 'rating',
				esc_html__( 'Popularity', 'ocolus' )         => 'popularity',
				esc_html__( 'Post In', 'ocolus' )            => 'post__in',
			);
			$order_way_values = array(
				'',
				esc_html__( 'Descending', 'ocolus' ) => 'DESC',
				esc_html__( 'Ascending', 'ocolus' )  => 'ASC',
			);
			$attributes_tax   = wc_get_attribute_taxonomies();
			$attributes       = array( '' );
			foreach ( $attributes_tax as $attribute ) {
				$attributes[$attribute->attribute_label] = $attribute->attribute_name;
			}
			// CUSTOM PRODUCT SIZE
			$product_size_width_list = array();
			$width                   = 300;
			$height                  = 300;
			if ( function_exists( 'wc_get_image_size' ) ) {
				$size   = wc_get_image_size( 'shop_catalog' );
				$width  = isset( $size['width'] ) ? $size['width'] : $width;
				$height = isset( $size['height'] ) ? $size['height'] : $height;
			}
			for ( $i = 100; $i < $width; $i = $i + 10 ) {
				array_push( $product_size_width_list, $i );
			}
			$product_size_list                         = array();
			$product_size_list[$width . 'x' . $height] = $width . 'x' . $height;
			foreach ( $product_size_width_list as $k => $w ) {
				$w = intval( $w );
				if ( isset( $width ) && $width > 0 ) {
					$h = round( $height * $w / $width );
				} else {
					$h = $w;
				}
				$product_size_list[$w . 'x' . $h] = $w . 'x' . $h;
			}
			$product_size_list['Custom'] = 'custom';
			// All this move to product
			$param_maps['ovic_products'] = array(
				'base'        => 'ovic_products',
				'icon'        => get_theme_file_uri( 'assets/images/icon/shopping-bag.svg' ),
				'name'        => esc_html__( 'Ocolus: Products', 'ocolus' ),
				'category'    => esc_html__( 'Ocolus Shortcode', 'ocolus' ),
				'description' => esc_html__( 'Display Products', 'ocolus' ),
				'params'      => array(
					array(
						'type'        => 'textfield',
						'heading'     => esc_html__( 'Title', 'ocolus' ),
						'param_name'  => 'title',
						'admin_label' => true,
					),
					array(
						'type'        => 'dropdown',
						'heading'     => esc_html__( 'Product List style', 'ocolus' ),
						'param_name'  => 'productsliststyle',
						'value'       => array(
							esc_html__( 'Grid Bootstrap', 'ocolus' ) => 'grid',
							esc_html__( 'Owl Carousel', 'ocolus' )   => 'owl',
							esc_html__( 'Grid Isotope', 'ocolus' )   => 'isotope',
						),
						'save_always' => true,
						'admin_label' => true,
						'description' => esc_html__( 'Select a style for list', 'ocolus' ),
						'std'         => 'grid',
					),
					array(
						'type'        => 'select_preview',
						'heading'     => esc_html__( 'Product style', 'ocolus' ),
						'value'       => ocolus_product_options( 'Shortcode' ),
						'default'     => 'style-01',
						'admin_label' => true,
						'save_always' => true,
						'param_name'  => 'product_style',
						'description' => esc_html__( 'Select a style for product item', 'ocolus' ),
					),
					array(
						'type'        => 'dropdown',
						'heading'     => esc_html__( 'Image size', 'ocolus' ),
						'param_name'  => 'product_image_size',
						'value'       => $product_size_list,
						'save_always' => true,
						'description' => esc_html__( 'Select a size for product', 'ocolus' ),
					),
					array(
						'type'        => 'number',
						'heading'     => esc_html__( 'Width', 'ocolus' ),
						'param_name'  => 'product_custom_thumb_width',
						'value'       => $width,
						'save_always' => true,
						'suffix'      => esc_html__( 'px', 'ocolus' ),
						'dependency'  => array(
							'element' => 'product_image_size',
							'value'   => array( 'custom' ),
						),
					),
					array(
						'type'        => 'number',
						'heading'     => esc_html__( 'Height', 'ocolus' ),
						'param_name'  => 'product_custom_thumb_height',
						'value'       => $height,
						'save_always' => true,
						'suffix'      => esc_html__( 'px', 'ocolus' ),
						'dependency'  => array(
							'element' => 'product_image_size',
							'value'   => array( 'custom' ),
						),
					),
					array(
						'type'       => 'dropdown',
						'heading'    => esc_html__( 'Pagination', 'ocolus' ),
						'param_name' => 'pagination',
						'value'      => array(
							esc_html__( 'None', 'ocolus' )               => 'none',
							esc_html__( 'View All', 'ocolus' )           => 'view_all',
							esc_html__( 'Load More', 'ocolus' )          => 'load_more',
							esc_html__( 'Infinite Scrolling', 'ocolus' ) => 'infinite',
						),
						'std'        => 'none',
						'group'      => esc_html__( 'Product Options', 'ocolus' ),
					),
					array(
						'type'       => 'vc_link',
						'heading'    => esc_html__( 'Button', 'ocolus' ),
						'param_name' => 'view_all_button',
						'group'      => esc_html__( 'Product Options', 'ocolus' ),
						'dependency' => array(
							'element' => 'pagination',
							'value'   => array( 'view_all' ),
						),
					),
					array(
						'type'        => 'dropdown',
						'heading'     => esc_html__( 'Target', 'ocolus' ),
						'param_name'  => 'target',
						'value'       => array(
							esc_html__( 'Recent Viewed', 'ocolus' )         => 'recent_viewed',
							esc_html__( 'Recent Products', 'ocolus' )       => 'recent_products',
							esc_html__( 'Feature Products', 'ocolus' )      => 'featured_products',
							esc_html__( 'Sale Products', 'ocolus' )         => 'sale_products',
							esc_html__( 'Best Selling Products', 'ocolus' ) => 'best_selling_products',
							esc_html__( 'Top Rated Products', 'ocolus' )    => 'top_rated_products',
							esc_html__( 'Products', 'ocolus' )              => 'products',
							esc_html__( 'Products Category', 'ocolus' )     => 'product_category',
							esc_html__( 'Products Attribute', 'ocolus' )    => 'product_attribute',
							esc_html__( 'Products Related', 'ocolus' )      => 'related_products',
						),
						'admin_label' => true,
						'description' => esc_html__( 'Choose the target to filter products', 'ocolus' ),
						'std'         => 'recent_products',
						'group'       => esc_html__( 'Product Options', 'ocolus' ),
					),
					array(
						'type'        => 'autocomplete',
						'heading'     => esc_html__( 'Products', 'ocolus' ),
						'param_name'  => 'ids',
						'settings'    => array(
							'multiple'      => true,
							'sortable'      => true,
							'unique_values' => true,
							// In UI show results except selected. NB! You should manually check values in backend
						),
						'group'       => esc_html__( 'Product Options', 'ocolus' ),
						'description' => esc_html__( 'Enter List of Products', 'ocolus' ),
						'dependency'  => array(
							'element' => 'target',
							'value'   => array( 'products' ),
						),
					),
					array(
						'type'        => 'dropdown',
						'heading'     => esc_html__( 'Vendor List', 'ocolus' ),
						'param_name'  => 'vendor_list',
						'value'       => $this->get_vendor_list(),
						'group'       => esc_html__( 'Product Options', 'ocolus' ),
						'dependency'  => array(
							'element'            => 'target',
							'value_not_equal_to' => 'products',
						),
						'description' => esc_html__( 'Note: If you want to narrow output, select Vendor(s) above. Only selected Vendor will be displayed.', 'ocolus' ),
					),
					array(
						'type'        => 'taxonomy',
						'heading'     => esc_html__( 'Product Categories', 'ocolus' ),
						'param_name'  => 'category',
						'settings'    => array(
							'multiple'    => true,
							'hide_empty'  => true,
							'taxonomy'    => 'product_cat',
							'placeholder' => esc_html__( 'Select Products Category', 'ocolus' ),
						),
						'dependency'  => array(
							'element'            => 'target',
							'value_not_equal_to' => 'products',
						),
						'group'       => esc_html__( 'Product Options', 'ocolus' ),
						'description' => esc_html__( 'Note: If you want to narrow output, select category(s) above. Only selected categories will be displayed.', 'ocolus' ),
					),
					array(
						'type'        => 'taxonomy',
						'heading'     => esc_html__( 'Product Brand', 'ocolus' ),
						'param_name'  => 'category_brand',
						'settings'    => array(
							'multiple'    => true,
							'hide_empty'  => true,
							'taxonomy'    => 'product_brand',
							'placeholder' => esc_html__( 'Select Products Brand', 'ocolus' ),
						),
						'dependency'  => array(
							'element'            => 'target',
							'value_not_equal_to' => 'products',
						),
						'group'       => esc_html__( 'Product Options', 'ocolus' ),
						'description' => esc_html__( 'Note: If you want to narrow output, select Brand(s) above. Only selected Brand will be displayed.', 'ocolus' ),
					),
					array(
						'type'       => 'hidden',
						'param_name' => 'skus',
					),
					array(
						'type'        => 'textfield',
						'heading'     => esc_html__( 'Per page', 'ocolus' ),
						'value'       => 6,
						'param_name'  => 'limit',
						'admin_label' => true,
						'group'       => esc_html__( 'Product Options', 'ocolus' ),
						'description' => esc_html__( 'How much items per page to show', 'ocolus' ),
					),
					array(
						'type'        => 'dropdown',
						'heading'     => esc_html__( 'Order by', 'ocolus' ),
						'param_name'  => 'orderby',
						'value'       => $order_by_values,
						'group'       => esc_html__( 'Product Options', 'ocolus' ),
						'description' => sprintf( esc_html__( 'Select how to sort retrieved products. More at %s.', 'ocolus' ), '<a href="' . esc_url( 'http://codex.wordpress.org/Class_Reference/WP_Query#Order_.26_Orderby_Parameters' ) . '" target="_blank">' . esc_html__( 'WordPress codex page', 'ocolus' ) . '</a>' ),
					),
					array(
						'type'        => 'dropdown',
						'heading'     => esc_html__( 'Sort order', 'ocolus' ),
						'param_name'  => 'order',
						'value'       => $order_way_values,
						'group'       => esc_html__( 'Product Options', 'ocolus' ),
						'description' => sprintf( esc_html__( 'Designates the ascending or descending order. More at %s.', 'ocolus' ), '<a href="' . esc_url( 'http://codex.wordpress.org/Class_Reference/WP_Query#Order_.26_Orderby_Parameters' ) . '" target="_blank">' . esc_html__( 'WordPress codex page', 'ocolus' ) . '</a>' ),
					),
					array(
						'type'        => 'dropdown',
						'heading'     => esc_html__( 'Attribute', 'ocolus' ),
						'param_name'  => 'attribute',
						'value'       => $attributes,
						'group'       => esc_html__( 'Product Options', 'ocolus' ),
						'description' => esc_html__( 'List of product taxonomy attribute', 'ocolus' ),
					),
					array(
						'type'        => 'checkbox',
						'heading'     => esc_html__( 'Filter', 'ocolus' ),
						'param_name'  => 'filter',
						'value'       => array( 'empty' => 'empty' ),
						'group'       => esc_html__( 'Product Options', 'ocolus' ),
						'description' => esc_html__( 'Taxonomy values', 'ocolus' ),
						'dependency'  => array(
							'callback' => 'vcWoocommerceProductAttributeFilterDependencyCallback',
						),
					),
					array(
						'type'       => 'dropdown',
						'heading'    => esc_html__( 'Layout Mode', 'ocolus' ),
						'param_name' => 'layout_mode',
						'value'      => array(
							esc_html__( 'Packery', 'ocolus' )    => 'packery',
							esc_html__( 'Masonry', 'ocolus' )    => 'masonry',
							esc_html__( 'FitRows', 'ocolus' )    => 'fitRows',
							esc_html__( 'FitColumns', 'ocolus' ) => 'fitColumns',
						),
						'std'        => 'packery',
						'dependency' => array(
							'element' => 'productsliststyle',
							'value'   => array( 'isotope' ),
						),
						'group'      => esc_html__( 'Isotope Settings', 'ocolus' ),
					),
					array(
						'type'        => 'checkbox',
						'heading'     => esc_html__( 'Use current size', 'ocolus' ),
						'param_name'  => 'current_size',
						'value'       => array(
							esc_html__( 'Enable', 'ocolus' ) => 'enable',
						),
						'dependency'  => array(
							'element' => 'productsliststyle',
							'value'   => array( 'isotope' ),
						),
						'description' => esc_html__( 'Enable if you want all product use current size setting.', 'ocolus' ),
						'group'       => esc_html__( 'Isotope Settings', 'ocolus' ),
					),
					array(
						'type'       => 'dropdown',
						'heading'    => esc_html__( 'Column', 'ocolus' ),
						'param_name' => 'col',
						'value'      => array(
							esc_html__( 'Auto', 'ocolus' )     => '0',
							esc_html__( '1 Column', 'ocolus' ) => '1',
							esc_html__( '2 Column', 'ocolus' ) => '2',
							esc_html__( '3 Column', 'ocolus' ) => '3',
							esc_html__( '4 Column', 'ocolus' ) => '4',
							esc_html__( '5 Column', 'ocolus' ) => '5',
							esc_html__( '6 Column', 'ocolus' ) => '6',
						),
						'std'        => '4',
						'dependency' => array(
							'element' => 'productsliststyle',
							'value'   => array( 'isotope' ),
						),
						'group'      => esc_html__( 'Isotope Settings', 'ocolus' ),
					),
					array(
						'type'        => 'dropdown',
						'heading'     => esc_html__( 'Rows space', 'ocolus' ),
						'param_name'  => 'isotope_rows_space',
						'value'       => array(
							esc_html__( 'Default', 'ocolus' ) => 'rows-space-0',
							esc_html__( '5px', 'ocolus' )     => 'rows-space-5',
							esc_html__( '10px', 'ocolus' )    => 'rows-space-10',
							esc_html__( '15px', 'ocolus' )    => 'rows-space-15',
							esc_html__( '20px', 'ocolus' )    => 'rows-space-20',
							esc_html__( '25px', 'ocolus' )    => 'rows-space-25',
							esc_html__( '30px', 'ocolus' )    => 'rows-space-30',
							esc_html__( '35px', 'ocolus' )    => 'rows-space-35',
							esc_html__( '40px', 'ocolus' )    => 'rows-space-40',
							esc_html__( '45px', 'ocolus' )    => 'rows-space-45',
							esc_html__( '50px', 'ocolus' )    => 'rows-space-50',
						),
						'std'         => 'rows-space-0',
						'dependency'  => array(
							'element' => 'productsliststyle',
							'value'   => array( 'isotope' ),
						),
						'description' => esc_html__( 'Space between each isotope item.', 'ocolus' ),
						'group'       => esc_html__( 'Isotope Settings', 'ocolus' ),
					),
					array(
						'type'       => 'dropdown',
						'heading'    => esc_html__( 'Rows space', 'ocolus' ),
						'param_name' => 'owl_rows_space',
						'value'      => array(
							esc_html__( 'Default', 'ocolus' ) => 'rows-space-0',
							esc_html__( '5px', 'ocolus' )     => 'rows-space-5',
							esc_html__( '10px', 'ocolus' )    => 'rows-space-10',
							esc_html__( '15px', 'ocolus' )    => 'rows-space-15',
							esc_html__( '20px', 'ocolus' )    => 'rows-space-20',
							esc_html__( '30px', 'ocolus' )    => 'rows-space-30',
							esc_html__( '40px', 'ocolus' )    => 'rows-space-40',
							esc_html__( '50px', 'ocolus' )    => 'rows-space-50',
							esc_html__( '60px', 'ocolus' )    => 'rows-space-60',
							esc_html__( '70px', 'ocolus' )    => 'rows-space-70',
							esc_html__( '80px', 'ocolus' )    => 'rows-space-80',
							esc_html__( '90px', 'ocolus' )    => 'rows-space-90',
							esc_html__( '100px', 'ocolus' )   => 'rows-space-100',
						),
						'std'        => 'rows-space-0',
						'dependency' => array(
							'element' => 'productsliststyle',
							'value'   => array( 'owl' ),
						),
						'group'      => esc_html__( 'Carousel Settings', 'ocolus' ),
					),
					array(
						'type'       => 'dropdown',
						'heading'    => esc_html__( 'Navigation style', 'ocolus' ),
						'param_name' => 'owl_navigation_style',
						'value'      => array(
							esc_html__( 'Default', 'ocolus' )          => '',
							esc_html__( 'Nav Top', 'ocolus' )          => 'nav-top',
							esc_html__( 'Nav Top Right', 'ocolus' )    => 'nav-top-right',
							esc_html__( 'Nav Circle', 'ocolus' )       => 'nav-circle',
							esc_html__( 'Nav Long Arrow', 'ocolus' )   => 'nav-long-arrow',
							esc_html__( 'Nav Text Arrow', 'ocolus' )   => 'nav-text-arrow',
							esc_html__( 'Nav Square Arrow', 'ocolus' ) => 'nav-square-arrow',
						),
						'std'        => '',
						'dependency' => array(
							'element' => 'productsliststyle',
							'value'   => array( 'owl' ),
						),
						'group'      => esc_html__( 'Carousel Settings', 'ocolus' ),
					),
					array(
						'type'        => 'dropdown',
						'heading'     => esc_html__( 'Dot style', 'ocolus' ),
						'param_name'  => 'owl_dot_style',
						'value'       => array(
							esc_html__( 'Default', 'ocolus' )      => '',
							esc_html__( 'Dot Equal', 'ocolus' )    => 'dot-equal',
							esc_html__( 'Dot Line', 'ocolus' )     => 'dot-line',
							esc_html__( 'Dot Inside', 'ocolus' )   => 'dot-inside',
							esc_html__( 'Dot Inside 2', 'ocolus' ) => 'dot-inside-2',
							esc_html__( 'Dot Stretch', 'ocolus' )  => 'dot-stretch',
						),
						'std'         => '',
						'dependency'  => array(
							'element' => 'productsliststyle',
							'value'   => array( 'owl' ),
						),
						'save_always' => true,
						'group'       => esc_html__( 'Carousel Settings', 'ocolus' ),
					),
					array(
						'type'       => 'carousel',
						'heading'    => esc_html__( 'Carousel Settings', 'ocolus' ),
						'param_name' => 'carousel',
						'group'      => esc_html__( 'Carousel Settings', 'ocolus' ),
						'dependency' => array(
							'element' => 'productsliststyle',
							'value'   => array( 'owl' ),
						),
					),
					array(
						'type'       => 'bootstrap_v3',
						'heading'    => esc_html__( 'Bootstrap Settings', 'ocolus' ),
						'param_name' => 'bootstrap',
						'group'      => esc_html__( 'Bootstrap Settings', 'ocolus' ),
						'dependency' => array(
							'element' => 'productsliststyle',
							'value'   => array( 'grid' ),
						),
					),
				),
			);

			return $param_maps['ovic_products'];
		}

		public function autocomplete()
		{
			if ( class_exists( 'Vc_Vendor_Woocommerce' ) ) {
				$vendor_woocommerce = new Vc_Vendor_Woocommerce();
				//Filters For autocomplete param:
				//For suggestion: vc_autocomplete_[shortcode_name]_[param_name]_callback
				add_filter( 'vc_autocomplete_ovic_products_ids_callback',
					array(
						$vendor_woocommerce,
						'productIdAutocompleteSuggester',
					), 10, 1
				); // Get suggestion(find). Must return an array
				add_filter( 'vc_autocomplete_ovic_products_ids_render',
					array(
						$vendor_woocommerce,
						'productIdAutocompleteRender',
					), 10, 1
				); // Render exact product. Must return an array (label,value)
				//For param: ID default value filter
				add_filter( 'vc_form_fields_render_field_ovic_products_ids_param_value',
					array(
						$vendor_woocommerce,
						'productsIdsDefaultValue',
					), 10, 4
				); // Defines default value for param if not provided. Takes from other param value.
				//For param: "filter" param value
				//vc_form_fields_render_field_{shortcode_name}_{param_name}_param
				add_filter( 'vc_form_fields_render_field_ovic_products_filter_param',
					array(
						$vendor_woocommerce,
						'productAttributeFilterParamValue',
					), 10, 4
				); // Defines default value for param if not provided. Takes from other param value.
				/* COUNTDOWN */
				//For suggestion: vc_autocomplete_[shortcode_name]_[param_name]_callback
				add_filter( 'vc_autocomplete_ovic_countdown_ids_callback',
					array(
						$vendor_woocommerce,
						'productIdAutocompleteSuggester',
					), 10, 1
				); // Get suggestion(find). Must return an array
				add_filter( 'vc_autocomplete_ovic_countdown_ids_render',
					array(
						$vendor_woocommerce,
						'productIdAutocompleteRender',
					), 10, 1
				); // Render exact product. Must return an array (label,value)
				add_filter( 'vc_form_fields_render_field_ovic_countdown_ids_param_value',
					array(
						$vendor_woocommerce,
						'productsIdsDefaultValue',
					), 10, 4
				); // Defines default value for param if not provided. Takes from other param value.
			}
			/* AUTOCOMPLETE POST */
			add_filter( 'vc_autocomplete_ovic_blog_ids_callback', array( $this, 'post_autocomplete_suggester' ), 10, 1 );
			add_filter( 'vc_autocomplete_ovic_blog_ids_render', array( $this, 'post_autocomplete_suggester_render' ), 10, 1 );
		}
	}

	new Ocolus_Visual_Composer();
}
VcShortcodeAutoloader::getInstance()->includeClass( 'WPBakeryShortCode_VC_Tta_Accordion' );
if ( !class_exists( 'WPBakeryShortCode_Ovic_Tabs' ) ) {
	class WPBakeryShortCode_Ovic_Tabs extends WPBakeryShortCode_VC_Tta_Accordion
	{
	}
}
if ( !class_exists( 'WPBakeryShortCode_Ovic_Accordion' ) ) {
	class WPBakeryShortCode_Ovic_Accordion extends WPBakeryShortCode_VC_Tta_Accordion
	{
	}
}
if ( !class_exists( 'WPBakeryShortCode_Ovic_Slide' ) ) {
	class WPBakeryShortCode_Ovic_Slide extends WPBakeryShortCodesContainer
	{
		/**
		 * @param string $controls
		 * @param string $extended_css
		 *
		 * @return string
		 * @throws \Exception
		 */
		public function getColumnControls( $settings = 'full', $extended_css = '' )
		{
			$controls = array();

			$controls['start'] = '<div class="vc_controls vc_controls-visible controls_column' . ( !empty( $extended_css ) ? " {$extended_css}" : '' ) . '">';
			$controls['end']   = '</div>';

			if ( 'bottom-controls' === $extended_css ) {
				$controls['title'] = sprintf( esc_attr__( 'Append to this %s', 'ocolus' ), strtolower( $this->settings( 'name' ) ) );
			} else {
				$controls['title'] = sprintf( esc_attr__( 'Prepend to this %s', 'ocolus' ), strtolower( $this->settings( 'name' ) ) );
			}

			$controls['move'] = '<a class="vc_control column_move vc_column-move" data-vc-control="move" href="#" title="' . sprintf( esc_attr__( 'Move this %s', 'ocolus' ), strtolower( $this->settings( 'name' ) ) ) . '"><i class="vc-composer-icon vc-c-icon-dragndrop"></i></a>';
			$moveAccess       = vc_user_access()->part( 'dragndrop' )->checkStateAny( true, null )->get();
			if ( !$moveAccess ) {
				$controls['move'] = '';
			}
			$controls['add']    = '<a class="vc_control column_add" data-vc-control="add" href="#" title="' . $controls['title'] . '"><i class="vc-composer-icon vc-c-icon-add"></i></a>';
			$controls['edit']   = '<a class="vc_control column_edit" data-vc-control="edit" href="#" title="' . sprintf( esc_html__( 'Edit this %s', 'ocolus' ), strtolower( $this->settings( 'name' ) ) ) . '"><i class="vc-composer-icon vc-c-icon-mode_edit"></i></a>';
			$controls['clone']  = '<a class="vc_control column_clone" data-vc-control="clone" href="#" title="' . sprintf( esc_html__( 'Clone this %s', 'ocolus' ), strtolower( $this->settings( 'name' ) ) ) . '"><i class="vc-composer-icon vc-c-icon-content_copy"></i></a>';
			$controls['delete'] = '<a class="vc_control column_delete" data-vc-control="delete" href="#" title="' . sprintf( esc_html__( 'Delete this %s', 'ocolus' ), strtolower( $this->settings( 'name' ) ) ) . '"><i class="vc-composer-icon vc-c-icon-delete_empty"></i></a>';
			$controls['full']   = $controls['move'] . $controls['add'] . $controls['edit'] . $controls['clone'] . $controls['delete'];

			$editAccess = vc_user_access_check_shortcode_edit( $this->shortcode );
			$allAccess  = vc_user_access_check_shortcode_all( $this->shortcode );

			if ( !empty( $settings ) ) {
				if ( is_string( $settings ) ) {
					$settings = array( $settings );
				}
				$controls_string = $controls['start'];
				foreach ( $settings as $setting ) {
					if ( ( $editAccess && 'edit' === $setting ) || $allAccess ) {
						if ( isset( $controls[$setting] ) ) {
							$controls_string .= $controls[$setting];
						}
					}
				}

				return $controls_string . $controls['end'];
			}

			if ( $allAccess ) {
				return $controls['start'] . $controls['full'] . $controls['end'];
			} elseif ( $editAccess ) {
				return $controls['start'] . $controls['edit'] . $controls['end'];
			}

			return $controls['start'] . $controls['end'];
		}
	}
}