<?php if ( !defined( 'ABSPATH' ) ) {
	die;
} // Cannot access pages directly.
add_filter( 'wp_tag_cloud',
	function ( $return, $args ) {
		if ( $args['number'] > 6 ) {
			$return = $return . '<span class="view-all">' . esc_html__( 'View All', 'ocolus' ) . '</span>';
		}

		return $return;
	}, 10, 2
);
add_action( 'ocolus_header_content', 'ocolus_header_template' );
/**
 *
 * TEMPLATE HEADER
 */
if ( !function_exists( 'ocolus_header_template' ) ) {
	function ocolus_header_template()
	{
		$header_mobile_template = ocolus_get_option( 'header_mobile_template', array( 'Primary Menu' ) );
		if ( ocolus_is_mobile() ) {
			$header_mobile_template = ocolus_get_option( 'mobile_version_template', array( 'Primary Menu' ) );
		}
		if ( !empty( $header_mobile_template ) ) {
			if ( class_exists( 'Ovic_Megamenu_Settings' ) ) {
				call_user_func( 'Ovic_Megamenu_Settings::install_mobile_menu', $header_mobile_template );
			}
		}
		if ( !ocolus_is_mobile() ) {
			$header_options = ocolus_theme_option_meta(
				'_custom_metabox_theme_options',
				'header_template',
				'metabox_header_template',
				'style-05'
			);
			get_template_part( 'templates/header/header', $header_options );
            ocolus_header_sticky();
		} else {
			$header_options = ocolus_get_option( 'mobile_style', 'style-01' );
			get_template_part( 'templates/mobile/mobile', $header_options );
		}
	}
}
/**
 *
 * MEGA MENU ICON
 */
add_filter( 'ovic_menu_icons_setting', 'ocolus_menu_icons_setting' );
if ( !function_exists( 'ocolus_menu_icons_setting' ) ) {
	function ocolus_menu_icons_setting( $icons )
	{
		$new_icons = array(
			array( "icomoon-Magnifying-glass" => "Icomoon Magnifying glass" ),
			array( "icomoon-Map-marker" => "Icomoon Map marker" ),
			array( "icomoon-Money" => "Icomoon Money" ),
			array( "icomoon-Next" => "Icomoon Next" ),
			array( "icomoon-Pencil-Case" => "Icomoon Pencil Case" ),
			array( "icomoon-Photographer" => "Icomoon Photographer" ),
			array( "icomoon-Plant" => "Icomoon Plant" ),
			array( "icomoon-Quality" => "Icomoon Quality" ),
			array( "icomoon-Right-arrow" => "Icomoon Right arrow" ),
			array( "icomoon-Shipped" => "Icomoon Shipped" ),
			array( "icomoon-Shirt" => "Icomoon Shirt" ),
			array( "icomoon-Shopping-bag" => "Icomoon Shopping bag" ),
			array( "icomoon-Sketch" => "Icomoon Sketch" ),
			array( "icomoon-Small-diamond" => "Icomoon Small diamond" ),
			array( "icomoon-Table-classic" => "Icomoon Table classic" ),
			array( "icomoon-Table" => "Icomoon Table" ),
			array( "icomoon-Three-dots" => "Icomoon Three dots" ),
			array( "icomoon-Up-arrow" => "Icomoon Up arrow" ),
			array( "icomoon-User" => "Icomoon User" ),
			array( "icomoon-Washing-machine" => "Icomoon Washing machine" ),
			array( "icomoon-Wedding-rings" => "Icomoon Wedding rings" ),
			array( "icomoon-Badge" => "Icomoon Badge" ),
			array( "icomoon-Budget" => "Icomoon Budget" ),
			array( "icomoon-List" => "Icomoon List" ),
			array( "icomoon-Smartwatch" => "Icomoon Smartwatch" ),
			array( "icomoon-Tablet" => "Icomoon Tablet" ),
			array( "icomoon-Web-Design" => "Icomoon Web Design" ),
			array( "icomoon-Mail" => "Icomoon Mail" ),
			array( "icomoon-Point" => "Icomoon Point" ),
			array( "icomoon-Support" => "Icomoon Support" ),
			array( "icomoon-Square" => "Icomoon Square" ),
			array( "icomoon-Armchair" => "Icomoon Armchair" ),
			array( "icomoon-Back" => "Icomoon Back" ),
			array( "icomoon-Cancel" => "Icomoon Cancel" ),
			array( "icomoon-Carrier" => "Icomoon Carrier" ),
			array( "icomoon-Chat" => "Icomoon Chat" ),
			array( "icomoon-Close" => "Icomoon Close" ),
			array( "icomoon-Closet" => "Icomoon Closet" ),
			array( "icomoon-Comment-Other" => "Icomoon Comment Other" ),
			array( "icomoon-Comment" => "Icomoon Comment" ),
			array( "icomoon-Compare" => "Icomoon Compare" ),
			array( "icomoon-Console" => "Icomoon Console" ),
			array( "icomoon-Cosmetics" => "Icomoon Cosmetics" ),
			array( "icomoon-Cross-out" => "Icomoon Cross out" ),
			array( "icomoon-Cursor-More" => "Icomoon Cursor More" ),
			array( "icomoon-Cursor-Pause" => "Icomoon Cursor Pause" ),
			array( "icomoon-Cursor-Play" => "Icomoon Cursor Play" ),
			array( "icomoon-Discuss-issue" => "Icomoon Discuss issue" ),
			array( "icomoon-Double-sofa" => "Icomoon Double sofa" ),
			array( "icomoon-Dumbbell" => "Icomoon Dumbbell" ),
			array( "icomoon-Empty-shopping-cart" => "Icomoon Empty shopping cart" ),
			array( "icomoon-Fabric" => "Icomoon Fabric" ),
			array( "icomoon-Full-screen" => "Icomoon Full screen" ),
			array( "icomoon-Gift" => "Icomoon Gift" ),
			array( "icomoon-Grid" => "Icomoon Grid" ),
			array( "icomoon-Heart" => "Icomoon Heart" ),
			array( "icomoon-Home" => "Icomoon Home" ),
			array( "icomoon-Idea" => "Icomoon Idea" ),
			array( "icomoon-Layers-round" => "Icomoon Layers round" ),
			array( "icomoon-Layers" => "Icomoon Layers" ),
			array( "icomoon-Left-arrow" => "Icomoon Left arrow" ),
			array( "icomoon-List-Menu" => "Icomoon List Menu" ),
		);

		return array_merge( $new_icons, $icons );
	}
}
/**
 *
 * HEADER SEARCH
 */
if ( !function_exists( 'ocolus_header_search' ) ) {
	function ocolus_header_search( $style = 'style-01', $class = '', $button_text = '' )
	{
		$options      = get_option( '_ovic_ins_options_settings' );
		$search_style = isset( $options['search_style'] ) ? $options['search_style'] : 'style-01';
		$selected     = '';
		if ( isset( $_GET['product_cat'] ) && $_GET['product_cat'] ) {
			$selected = $_GET['product_cat'];
		}
		$args    = array(
			'show_option_none'  => esc_html__( 'All Categories', 'ocolus' ),
			'taxonomy'          => 'product_cat',
			'class'             => 'category-search-option',
			'hide_empty'        => 1,
			'orderby'           => 'name',
			'order'             => "ASC",
			'tab_index'         => true,
			'hierarchical'      => true,
			'id'                => rand(),
			'name'              => 'product_cat',
			'value_field'       => 'slug',
			'selected'          => $selected,
			'option_none_value' => '0',
		);
		$classes = array( 'block-search', $style, $class );
		if ( $style == 'style-02' ) {
			$classes[] = 'ocolus-dropdown';
		}
		?>
        <div class="<?php echo esc_attr( implode( ' ', $classes ) ); ?>">
			<?php if ( $style == 'style-02' ) : ?>
                <a href="#" data-ocolus="ocolus-dropdown" class="woo-search-link">
                    <span class="icomoon-Magnifying-glass icon"></span>
                </a>
			<?php endif; ?>
            <form class="search-form ovic-instant-search sub-menu" method="get"
                  action="<?php echo esc_url( home_url( '/' ) ) ?>">
                <a href="#" class="close-search" data-ocolus="ocolus-dropdown"></a>
                <div class="instant-search-box <?php echo esc_attr( $search_style ); ?>">
                    <div class="search-form-inner">
						<?php if ( class_exists( 'WooCommerce' ) ): ?>
                            <input type="hidden" name="post_type" value="product"/>
                            <input type="hidden" name="taxonomy" value="product_cat">
						<?php endif; ?>
                        <label class="search-input">
                            <input type="search" class="key-instant-search search-field" name="s"
                                   value="<?php echo esc_attr( get_search_query() ); ?>"
                                   placeholder="<?php echo esc_attr_x( 'Search &hellip;', 'placeholder', 'ocolus' ); ?>">
                            <span class="input-focus"></span>
                        </label>
						<?php if ( class_exists( 'WooCommerce' ) ): ?>
							<?php if ( $style == 'style-03' ) : ?>
                                <div class="category">
									<?php wp_dropdown_categories( $args ); ?>
                                </div>
							<?php endif; ?>
						<?php endif; ?>
                        <button type="submit" class="btn-submit">
                            <span class="icomoon-Magnifying-glass icon"></span>
							<?php if ( !empty( $button_text ) ) {
								echo esc_html( $button_text );
							} ?>
                        </button>
                    </div>
                </div>
            </form>
        </div>
		<?php
	}
}
if ( class_exists( 'Ocolus_Toolkit' ) ) {
	if ( !function_exists( 'ocolus_instant_search_image_size' ) ) {
		function ocolus_instant_search_image_size()
		{
			return $image_size = 'woocommerce_thumbnail';
		}

		add_filter( 'ovic_instant_search_image_size', 'ocolus_instant_search_image_size' );
	}
	if ( !function_exists( 'ocolus_generate_data_instant_search' ) ) {
		function ocolus_generate_data_instant_search( $data, $product )
		{
			if ( $product ) {
				$postdatestamp                    = strtotime( get_the_time( 'Y-m-d', $product->get_id() ) );
				$newness                          = ocolus_get_option( 'product_newness', 0 );
				$data[$product->get_id()]['sale'] = '';
				$data[$product->get_id()]['new']  = '';
				if ( $product->is_on_sale() ) {
					$data[$product->get_id()]['sale'] = esc_html__( 'Sale', 'ocolus' );
				}
				if ( ( time() - ( 60 * 60 * 24 * (int)$newness ) ) < (int)$postdatestamp ) {
					$data[$product->get_id()]['new'] = esc_html__( 'New', 'ocolus' );
				}
			}

			return $data;
		}

		add_filter( 'ovic_generate_data_instant_search', 'ocolus_generate_data_instant_search', 10, 2 );
	}
	if ( !function_exists( 'ocolus_instant_search_templates_script' ) ) {
		function ocolus_instant_search_templates_script()
		{
			ob_start();
			?>
            <div class="product-search-item">
                <div class="product-thumb">
                    <# if ( data.sale != '' || data.new != '' ) { #>
                    <div class="product-labels style-02">
                        <# if ( data.sale != '' ) { #>
                        <span class="onsale">{{data.sale}}</span>
                        <# } #>
                        <# if ( data.new != '' ) { #>
                        <span class="onnew">{{data.new}}</span>
                        <# } #>
                    </div>
                    <# } #>
                    <a class="thumb-link" href="{{data.url}}">
                        {{{data.image}}}
                    </a>
                </div>
                <div class="product-info">
                    <div class="product-title"><a href="{{data.url}}">{{data.title}}</a></div>
                    <div class="price">{{{data.price}}}</div>
                </div>
            </div>
			<?php
			return ob_get_clean();
		}

		add_filter( 'ovic_instant_search_templates_script', 'ocolus_instant_search_templates_script' );
	}
	if ( !function_exists( 'ocolus_instant_search_option' ) ) {
		function ocolus_instant_search_option( $options )
		{
			$preview1 = get_theme_file_uri( 'assets/images/preview/instant1.jpg' );
			$preview2 = get_theme_file_uri( 'assets/images/preview/instant2.jpg' );
			$style    = isset( $options['search_style'] ) ? $options['search_style'] : 'style-01';
			if ( $style == 'style-01' ) {
				$placeholder = $preview1;
			} else {
				$placeholder = $preview2;
			}
			?>
            <script type="application/javascript">
                jQuery(document).ready(function ($) {
                    $('.container-select_preview').each(function () {
                        var $this   = $(this),
                            $url    = $this.find(':selected').data('preview'),
                            $img    = $this.find('.image-preview img'),
                            $select = $this.find('.ovic_select_preview');

                        $img.attr('src', $url);
                        $select.on('change', function () {
                            $url = $this.find(':selected').data('preview');
                            $img.attr('src', $url);
                        });
                    });
                });
            </script>
            <div class="field-item">
                <strong class="title"><?php echo esc_html__( 'Search Results Style', 'ocolus' ); ?></strong>
                <div class="inner-field">
                    <div class="container-select_preview">
                        <select name="search_style" class="ovic_select_preview">
                            <option data-preview="<?php echo esc_url( $preview1 ); ?>"
                                    value="style-01" <?php echo selected( 'style-01', $style ); ?>>
								<?php echo esc_html__( 'Style 01', 'ocolus' ); ?>
                            </option>
                            <option data-preview="<?php echo esc_url( $preview2 ); ?>"
                                    value="style-02" <?php echo selected( 'style-02', $style ); ?>>
								<?php echo esc_html__( 'Style 02', 'ocolus' ); ?>
                            </option>
                        </select>
                        <div class="image-preview" style="margin-top:10px;display:inline-block;width:100%;">
                            <img src="<?php echo esc_url( $placeholder ); ?>"
                                 alt="<?php echo esc_attr( 'select_preview' ); ?>">
                        </div>
                    </div>
                </div>
            </div>
			<?php
		}

		add_action( 'ovic_instant_search_custom_options', 'ocolus_instant_search_option' );
	}
}
/**
 *
 * HEADER USERLINK
 */
if ( !function_exists( 'ocolus_mobile_user_link' ) ) {
	function ocolus_mobile_user_link()
	{
		global $post;
		$is_vendor    = false;
		$account_link = wp_login_url();
		$currentUser  = wp_get_current_user();
		if ( class_exists( 'WooCommerce' ) ) {
			$account_link = get_permalink( get_option( 'woocommerce_myaccount_page_id' ) );
		}
		$wcmp_vendor = get_option( 'wcmp_vendor_general_settings_name' );
		if ( class_exists( 'WCMp' ) && is_page() && isset( $post->ID ) && in_array( $post->ID, $wcmp_vendor ) ) {
			$is_vendor = true;
		}
		?>
        <div class="block-userlink-mobile ocolus-dropdown overlay">
            <a class="woo-user-link"
               data-ocolus="ocolus-dropdown"
               href="<?php echo esc_url( $account_link ); ?>">
                <span class="icomoon-User icon"></span>
            </a>
            <div class="block-userlink">
                <div class="head-account-menu">
                    <span class="title"><?php echo esc_html__( 'ACCOUNT & SETTINGS', 'ocolus' ); ?></span>
                    <a href="#" data-ocolus="ocolus-dropdown" class="close-account">x</a>
                </div>
                <div class="content-account-menu">
                    <ul class="account-menu">
                        <li class="menu-item menu-item-has-children">
							<?php if ( is_user_logged_in() ): ?>
                                <a class="woo-user-link"
                                   href="<?php echo esc_url( $account_link ); ?>">
                                    <span class="text"><?php echo esc_html( $currentUser->display_name ); ?></span>
                                </a>
                                <span class="caret"></span>
								<?php if ( function_exists( 'wc_get_account_menu_items' ) ): ?>
                                    <ul class="sub-menu">
										<?php foreach ( wc_get_account_menu_items() as $endpoint => $label ) : ?>
                                            <li class="menu-item <?php echo wc_get_account_menu_item_classes( $endpoint ); ?>">
                                                <a href="<?php echo esc_url( wc_get_account_endpoint_url( $endpoint ) ); ?>"><?php echo esc_html( $label ); ?></a>
                                            </li>
										<?php endforeach; ?>
                                    </ul>
								<?php else: ?>
                                    <ul class="sub-menu">
                                        <li class="menu-item">
                                            <a href="<?php echo wp_logout_url( get_permalink() ); ?>"><?php esc_html_e( 'Logout', 'ocolus' ); ?></a>
                                        </li>
                                    </ul>
								<?php endif;
							else: ?>
								<?php if ( class_exists( 'WooCommerce' ) && !is_account_page() && !is_checkout() && !$is_vendor ) : ?>
									<?php echo do_shortcode( '[woocommerce_my_account]' ); ?>
								<?php else: ?>
                                    <a class="woo-user-link"
                                       href="<?php echo esc_url( $account_link ); ?>">
                                        <span class="text"><?php echo esc_html__( 'Login/Register', 'ocolus' ); ?></span>
                                    </a>
								<?php endif; ?>
							<?php endif; ?>
                        </li>
                    </ul>
					<?php
					if ( has_nav_menu( 'account' ) )
						wp_nav_menu( array(
								'menu'           => 'account',
								'theme_location' => 'account',
								'depth'          => 2,
								'after'          => '<span class="caret"></span>',
								'menu_class'     => 'account-menu',
							)
						);
					?>
                </div>
            </div>
        </div>
		<?php
	}
}
if ( !function_exists( 'ocolus_user_link' ) ) {
	function ocolus_user_link( $title = null )
	{
		$account_link = wp_login_url();
		$currentUser  = wp_get_current_user();
		if ( class_exists( 'WooCommerce' ) ) {
			$account_link = get_permalink( get_option( 'woocommerce_myaccount_page_id' ) );
		}
		if ( $title == null ) {
			$title = esc_html__( 'Account', 'ocolus' );
		}
		?>
        <div class="block-userlink ocolus-dropdown">
			<?php if ( is_user_logged_in() ): ?>
                <a data-ocolus="ocolus-dropdown" class="woo-user-link"
                   href="<?php echo esc_url( $account_link ); ?>">
                    <span class="fa fa-user icon"></span>
                    <span class="text"><?php echo esc_html( $currentUser->display_name ); ?></span>
                </a>
				<?php if ( function_exists( 'wc_get_account_menu_items' ) ): ?>
                    <ul class="sub-menu">
						<?php foreach ( wc_get_account_menu_items() as $endpoint => $label ) : ?>
                            <li class="menu-item <?php echo wc_get_account_menu_item_classes( $endpoint ); ?>">
                                <a href="<?php echo esc_url( wc_get_account_endpoint_url( $endpoint ) ); ?>"><?php echo esc_html( $label ); ?></a>
                            </li>
						<?php endforeach; ?>
                    </ul>
				<?php else: ?>
                    <ul class="sub-menu">
                        <li class="menu-item">
                            <a href="<?php echo wp_logout_url( get_permalink() ); ?>"><?php esc_html_e( 'Logout', 'ocolus' ); ?></a>
                        </li>
                    </ul>
				<?php endif;
			else: ?>
                <a class="woo-user-link"
                   href="<?php echo esc_url( $account_link ); ?>">
                    <span class="fa fa-user icon"></span>
                    <span class="text"><?php echo esc_html( $title ); ?></span>
                </a>
			<?php endif; ?>
        </div>
		<?php
	}
}
/**
 *
 * HEADER TOP MENU
 */
if ( !function_exists( 'ocolus_get_header_menu' ) ) {
	function ocolus_get_header_menu( $menu_location, $class = 'top-bar-menu' )
	{
		$header_menu = ocolus_theme_option_meta(
			'_custom_metabox_theme_options',
			$menu_location,
			"metabox_{$menu_location}"
		);
		if ( $header_menu ) {
			do_action( "ocolus_before_header_menu_{$header_menu}", $header_menu );
			wp_nav_menu( array(
					'menu'           => $header_menu,
					'theme_location' => $header_menu,
					'link_before'    => '<span class="text">',
					'link_after'     => '</span>',
					'depth'          => 2,
					'menu_class'     => $class,
				)
			);
			do_action( "ocolus_after_header_menu_{$header_menu}", $header_menu );
		}
	}
}
/**
 *
 * HEADER VERTICAL
 */
if ( !function_exists( 'ocolus_content_vertical' ) ) {
	function ocolus_content_vertical( $args )
	{
		$default     = array(
			'item_visible' => 10,
			'class'        => array(),
			'menu'         => 'primary',
			'title'        => esc_html__( 'All CATEGORIES', 'ocolus' ),
			'button_all'   => esc_html__( 'View More', 'ocolus' ),
			'button_close' => esc_html__( 'View Less', 'ocolus' ),
		);
		$args        = wp_parse_args( $args, $default );
		$block_class = array_merge(
			array( 'vertical-wrapper block-nav-category' ),
			$args['class']
		);
		$count       = 0;
		$locations   = get_nav_menu_locations();
		if ( !empty( $locations[$args['menu']] ) ) {
			$menu_id    = $locations[$args['menu']];
			$menu_items = wp_get_nav_menu_items( $menu_id );
			foreach ( $menu_items as $menu_item ) {
				if ( $menu_item->menu_item_parent == 0 )
					$count++;
			}
		}
		?>
        <!-- block category -->
        <div data-items="<?php echo esc_attr( $args['item_visible'] ); ?>"
             class="<?php echo implode( ' ', $block_class ); ?>">
            <a href="javascript:void(0)" class="block-title">
                <span class="icon before">
                    <span>
                        <span></span>
                        <span></span>
                        <span></span>
                    </span>
                </span>
				<?php if ( $args['title'] && $args['title'] != '' ) : ?>
                    <span class="text"><?php echo esc_html( $args['title'] ); ?></span>
				<?php endif; ?>
                <span class="icon after">
                    <span>
                        <span></span>
                        <span></span>
                        <span></span>
                    </span>
                </span>
            </a>
            <div class="block-content vertical-menu-content">
				<?php
				wp_nav_menu( array(
						'menu'            => $args['menu'],
						'theme_location'  => $args['menu'],
						'depth'           => 4,
						'container'       => '',
						'container_class' => '',
						'container_id'    => '',
						'menu_class'      => 'main-menu vertical-menu',
						'megamenu_layout' => 'vertical',
						'after'           => '<span class="caret"></span>',
					)
				);
				if ( $count > $args['item_visible'] ) : ?>
                    <div class="view-all-category">
                        <a href="#" data-closetext="<?php echo esc_attr( $args['button_close'] ); ?>"
                           data-alltext="<?php echo esc_attr( $args['button_all'] ) ?>"
                           class="btn-view-all open-cate">
                            <span class="text"><?php echo esc_html( $args['button_all'] ) ?></span>
                        </a>
                    </div>
				<?php endif; ?>
            </div>
        </div>
        <!-- block category -->
		<?php
	}
}
if ( !function_exists( 'ocolus_header_vertical' ) ) {
	function ocolus_header_vertical( $menu_location )
	{
		global $post;
		/* MAIN THEME OPTIONS */
		$enable_vertical = ocolus_get_option( 'enable_vertical_menu' );
		$block_vertical  = ocolus_get_option( 'block_vertical_menu' );
		$item_visible    = ocolus_get_option( 'vertical_item_visible', 10 );
		if ( $enable_vertical == 1 && has_nav_menu( $menu_location ) ) : ?>
			<?php
			/* MAIN THEME OPTIONS */
			$vertical_title        = ocolus_get_option( 'vertical_menu_title', 'ALL CATEGORIES' );
			$vertical_button_all   = ocolus_get_option( 'vertical_menu_button_all_text', 'View More' );
			$vertical_button_close = ocolus_get_option( 'vertical_menu_button_close_text', 'View Less' );
			$block_class           = array();
			$id                    = '';
			$post_type             = '';
			if ( $enable_vertical == 1 )
				$block_class[] = 'has-vertical-menu';
			if ( isset( $post->ID ) )
				$id = $post->ID;
			if ( isset( $post->post_type ) )
				$post_type = $post->post_type;
			if ( is_array( $block_vertical ) && in_array( $id, $block_vertical ) && $post_type == 'page' )
				$block_class[] = 'always-open';
			ocolus_content_vertical(
				array(
					'item_visible' => $item_visible,
					'class'        => $block_class,
					'menu'         => $menu_location,
					'title'        => $vertical_title,
					'button_all'   => $vertical_button_all,
					'button_close' => $vertical_button_close,
				)
			);
		endif;
	}
}
/**
 *
 * HEADER STICKY
 */
if ( !function_exists( 'ocolus_header_sticky' ) ) {
	function ocolus_header_sticky()
	{
		$sticky_menu    = ocolus_get_option( 'sticky_menu' );
		$sticky_product = ocolus_get_option( 'sticky_add_to_cart' );
		$sticky_post    = ocolus_get_option( 'sticky_post_title' );
		$header_options = ocolus_theme_option_meta(
			'_custom_metabox_theme_options',
			'header_template',
			'metabox_header_template',
			'style-05'
		);
		if ( $header_options == 'style-11' || $header_options == 'style-16' ) {
			return;
		}
		if ( $sticky_menu != 1 ) {
			return;
		}
		if ( is_single() && $sticky_post == 1 ) {
			return;
		}
		if ( function_exists( 'is_product' ) && is_product() && $sticky_product == 1 ) {
			return;
		}
		?>
        <div class="header-sticky">
            <div class="header-inner megamenu-wrap">
                <div class="header-left">
                    <div class="logo"><?php ocolus_get_logo(); ?></div>
                </div>
                <div class="header-right">
                    <div class="box-header-nav">
						<?php
						if ( has_nav_menu( 'primary' ) )
							wp_nav_menu( array(
									'menu'            => 'primary',
									'theme_location'  => 'primary',
									'depth'           => 3,
									'container'       => '',
									'container_class' => '',
									'container_id'    => '',
									'menu_class'      => 'main-menu',
								)
							);
						?>
                    </div>
                    <div class="header-control">
						<?php
						ocolus_header_search( 'style-02' );
						ocolus_user_link();
						if ( function_exists( 'ocolus_header_mini_cart' ) )
							ocolus_header_mini_cart();
						?>
                    </div>
                </div>
            </div>
        </div>
		<?php
	}
}
/**
 *
 * HEADER CANVAS
 */
if ( !function_exists( 'ocolus_header_canvas' ) ) {
	function ocolus_header_canvas( $menu_canvas = 'primary', $is_menu = true )
	{
		?>
        <div class="header-canvas <?php if ( $is_menu != true ) echo esc_attr( 'canvas-sidebar' ); ?>">

            <a href="javascript:void(0)" class="canvas-close"></a>

			<?php do_action( 'ocolus_before_menu_canvas' ); ?>

			<?php if ( $is_menu ): ?>

                <div class="logo"><?php ocolus_get_logo(); ?></div>
                <div class="box-header-nav">
					<?php
					if ( has_nav_menu( 'primary' ) )
						wp_nav_menu( array(
								'menu'            => $menu_canvas,
								'theme_location'  => $menu_canvas,
								'depth'           => 3,
								'container'       => '',
								'container_class' => '',
								'container_id'    => '',
								'menu_class'      => 'main-menu',
								'megamenu_layout' => 'vertical',
							)
						);
					?>
                </div>
				<?php
				$socials = ocolus_theme_option_meta(
					'_custom_metabox_theme_options',
					'header_social'
				);
				if ( !empty( $socials ) ):
					echo ocolus_do_shortcode( 'ovic_socials',
						array(
							'socials' => $socials,
						)
					);
				endif; ?>

			<?php else: ?>

                <aside class="widget-area" role="complementary"
                       aria-label="<?php esc_attr_e( 'Header Sidebar', 'ocolus' ); ?>">
					<?php dynamic_sidebar( $menu_canvas ); ?>
                </aside><!-- #secondary -->

			<?php endif; ?>

			<?php do_action( 'ocolus_after_menu_canvas' ); ?>

        </div>
		<?php
	}
}