<?php if ( !defined( 'ABSPATH' ) ) {
	die;
} // Cannot access pages directly.
/*==========================================================================
THEME BOX OPTIONS
===========================================================================*/
add_filter( 'ovic_config_theme_options', 'ocolus_config_options' );
if ( !function_exists( 'ocolus_config_options' ) ) {
	function ocolus_config_options( $options )
	{
		$list_id          = array();
		$quickview_params = array(
			'type'    => 'notice',
			'class'   => 'warning',
			'content' => esc_html__( 'Warning: Active Plugin Quick view in this setting.', 'ocolus' ),
		);
		$mailchimp_params = array(
			'type'    => 'notice',
			'class'   => 'warning',
			'content' => esc_html__( 'Warning: Mailchimp Do Not Settings Yet...!', 'ocolus' ),
		);
		if ( function_exists( 'mc4wp_show_form' ) ) {
			$api_key = mc4wp_get_api_key();
			if ( !empty( $api_key ) ) {
				$mailchimp_params = array(
					'id'      => 'product_mailchimp',
					'type'    => 'select',
					'options' => ocolus_get_form_newsletter(),
					'title'   => esc_html__( 'Mailchimp Notify Out Stock Products', 'ocolus' ),
					'desc'    => sprintf( '%s <a href="%s" target="_blank">%s</a>',
						esc_html__( 'Add new form', 'ocolus' ),
						admin_url( 'admin.php?page=mailchimp-for-wp-forms&view=add-form' ),
						esc_html__( 'Here!', 'ocolus' )
					),
					'default' => '0',
				);
			}
		}
		if ( class_exists( 'YITH_WCQV_Frontend' ) ) {
			$quickview_params = array(
				'id'      => 'quickview_style',
				'type'    => 'image_select',
				'after'   => esc_html__( 'Select Quick View', 'ocolus' ),
				'options' => array(
					'style-01' => get_theme_file_uri( 'woocommerce/quick-view/quick-view-style-01.jpg' ),
					'style-02' => get_theme_file_uri( 'woocommerce/quick-view/quick-view-style-02.jpg' ),
				),
				'default' => 'style-01',
			);
		}
		$options                   = array();
		$options['ver_mobile']     = array(
			'name'   => 'ver_mobile',
			'icon'   => 'fa fa-mobile',
			'title'  => esc_html__( 'Version Mobile', 'ocolus' ),
			'fields' => array(
				array(
					'id'   => 'tabs_mobile',
					'type' => 'tabbed',
					'tabs' => array(
						array(
							'title'  => esc_html__( 'General', 'ocolus' ),
							'fields' => array(
								'mobile_enable' => array(
									'id'    => 'mobile_enable',
									'type'  => 'switcher',
									'title' => esc_html__( 'Enable Version Mobile', 'ocolus' ),
									'desc'  => esc_html__( 'Minimize site in device mobile', 'ocolus' ),
								),
								'mobile_style'  => array(
									'id'         => 'mobile_style',
									'type'       => 'image_select',
									'after'      => esc_html__( 'Select Style Version Mobile', 'ocolus' ),
									'options'    => array(
										'style-01' => get_theme_file_uri( 'templates/mobile/mobile-style-01.png' ),
										'style-02' => esc_url( 'https://via.placeholder.com/200x300&text=COMMING SOON' ),
										'style-03' => esc_url( 'https://via.placeholder.com/200x300&text=COMMING SOON' ),
									),
									'default'    => 'style-01',
									'dependency' => array(
										'mobile_enable', '==', true,
									),
								),
								'mobile_logo'   => array(
									'id'    => 'mobile_logo',
									'type'  => 'image',
									'title' => esc_html__( 'Logo', 'ocolus' ),
									'desc'  => esc_html__( 'Setting Logo For Site', 'ocolus' ),
								),
							),
						),
						array(
							'title'  => esc_html__( 'Mobile Options', 'ocolus' ),
							'fields' => array(
								'mobile_version_template' => array(
									'id'         => 'mobile_version_template',
									'type'       => 'select',
									'title'      => esc_html__( 'Header Mobile', 'ocolus' ),
									'options'    => ocolus_wordpress_menus(),
									'class'      => 'chosen',
									'attributes' => array(
										'placeholder' => 'Select a Header',
										'multiple'    => 'multiple',
									),
									'desc'       => esc_html__( 'Header menu will be shown in mobile', 'ocolus' ),
								),
								'mobile_footer_template'  => array(
									'id'      => 'mobile_footer_template',
									'type'    => 'select_preview',
									'default' => 'footer-01',
									'title'   => esc_html__( 'Mobile Footer Template', 'ocolus' ),
									'desc'    => esc_html__( 'Select a Footer layout in page mobile', 'ocolus' ),
									'options' => ocolus_footer_preview(),
								),
							),
						),
					),
				),
			),
		);
		$options['general_main']   = array(
			'name'   => 'general_main',
			'icon'   => 'fa fa-wordpress',
			'title'  => esc_html__( 'General', 'ocolus' ),
			'fields' => array(
				array(
					'id'   => 'tabs_general',
					'type' => 'tabbed',
					'tabs' => array(
						array(
							'title'  => esc_html__( 'General', 'ocolus' ),
							'fields' => array(
								'logo'                 => array(
									'id'    => 'logo',
									'type'  => 'image',
									'title' => esc_html__( 'Logo', 'ocolus' ),
									'desc'  => esc_html__( 'Setting Logo For Site', 'ocolus' ),
								),
								'site_background'      => array(
									'id'    => 'site_background',
									'type'  => 'background',
									'title' => esc_html__( 'Site Background', 'ocolus' ),
									'desc'  => esc_html__( 'Setting Background For Site', 'ocolus' ),
								),
								'main_color'           => array(
									'id'      => 'main_color',
									'type'    => 'color_picker',
									'rgba'    => true,
									'default' => '#293341',
									'title'   => esc_html__( 'Main Color 1', 'ocolus' ),
								),
								'main_color_hover'     => array(
									'id'      => 'main_color_hover',
									'type'    => 'color_picker',
									'rgba'    => true,
									'default' => '#c91f28',
									'title'   => esc_html__( 'Main Color 2', 'ocolus' ),
								),
								'google_map_api'       => array(
									'id'    => 'google_map_api',
									'type'  => 'text',
									'title' => esc_html__( 'Google Map API Key', 'ocolus' ),
									'desc'  => esc_html__( 'Enter your Google Map API key. ', 'ocolus' ) . '<a href="' . esc_url( 'https://developers.google.com/maps/documentation/javascript/get-api-key' ) . '" target="_blank">' . esc_html__( 'How to get?', 'ocolus' ) . '</a>',
								),
								'enable_theme_options' => array(
									'id'    => 'enable_theme_options',
									'type'  => 'switcher',
									'title' => esc_html__( 'Enable Metabox Options', 'ocolus' ),
								),
								'theme_lazy_load'      => array(
									'id'    => 'theme_lazy_load',
									'type'  => 'switcher',
									'title' => esc_html__( 'Enable Lazy Load', 'ocolus' ),
								),
								'placeholder_lazy'     => array(
									'id'         => 'placeholder_lazy',
									'type'       => 'image',
									'title'      => esc_html__( 'Placeholder', 'ocolus' ),
									'dependency' => array( 'theme_lazy_load', '==', 'true', ),
								),
								'theme_crop_image'     => array(
									'id'    => 'theme_crop_image',
									'type'  => 'switcher',
									'title' => esc_html__( 'Disable Crop Image', 'ocolus' ),
								),
								'enable_backtotop'     => array(
									'id'    => 'enable_backtotop',
									'type'  => 'switcher',
									'title' => esc_html__( 'Enable Back To Top Button', 'ocolus' ),
								),
							),
						),
						array(
							'title'  => esc_html__( 'Sidebar Settings', 'ocolus' ),
							'fields' => array(
								array(
									'id'           => 'multi_sidebar',
									'type'         => 'repeater',
									'button_title' => esc_html__( 'Add Sidebar', 'ocolus' ),
									'title'        => esc_html__( 'Multi Sidebar', 'ocolus' ),
									'fields'       => array(
										array(
											'id'    => 'add_sidebar',
											'type'  => 'text',
											'title' => esc_html__( 'Name Sidebar', 'ocolus' ),
										),
									),
								),
							),
						),
						array(
							'title'  => esc_html__( 'ACE Settings', 'ocolus' ),
							'fields' => array(
								'ace_style'  => array(
									'id'      => 'ace_style',
									'type'    => 'ace_editor',
									'options' => array(
										'theme'           => 'ace/theme/chrome',
										'mode'            => 'ace/mode/css',
										'showGutter'      => true,
										'showPrintMargin' => true,
									),
									'title'   => esc_html__( 'Editor Style', 'ocolus' ),
								),
								'ace_script' => array(
									'id'      => 'ace_script',
									'type'    => 'ace_editor',
									'options' => array(
										'theme'           => 'ace/theme/chrome',
										'showGutter'      => true,
										'showPrintMargin' => true,
									),
									'title'   => esc_html__( 'Editor Javascript', 'ocolus' ),
								),
							),
						),
					),
				),
			),
		);
		$options['header_main']    = array(
			'name'   => 'header_main',
			'icon'   => 'fa fa-folder-open-o',
			'title'  => esc_html__( 'Header', 'ocolus' ),
			'fields' => array(
				array(
					'id'   => 'tabs_header',
					'type' => 'tabbed',
					'tabs' => array(
						array(
							'title'  => esc_html__( 'Header Settings', 'ocolus' ),
							'fields' => array(
								'header_mobile_template' => array(
									'id'             => 'header_mobile_template',
									'type'           => 'select',
									'title'          => esc_html__( 'Header Mobile', 'ocolus' ),
									'options'        => ocolus_wordpress_menus(),
									'class'          => 'chosen',
									'attributes'     => array(
										'placeholder' => 'Select a Header',
										'multiple'    => 'multiple',
									),
									'default_option' => 'Primary Menu',
									'desc'           => esc_html__( 'Header menu will be shown in mobile', 'ocolus' ),
								),
								'sticky_menu'            => array(
									'id'    => 'sticky_menu',
									'type'  => 'switcher',
									'title' => esc_html__( 'Sticky Menu', 'ocolus' ),
								),
								'header_top_menu'        => array(
									'id'             => 'header_top_menu',
									'type'           => 'select',
									'title'          => esc_html__( 'Header Sub 01', 'ocolus' ),
									'options'        => ocolus_wordpress_menus( 'slug' ),
									'default_option' => esc_html__( 'Select a Menu', 'ocolus' ),
									'dependency'     => array(
										'header_template',
										'any',
										'style-01,style-04,style-05,style-07,style-08,style-09,style-11,style-12,style-13,style-14,style-16,style-18,style-19,style-22,style-23,style-24',
									),
								),
								'header_second_menu'     => array(
									'id'             => 'header_second_menu',
									'type'           => 'select',
									'title'          => esc_html__( 'Header Sub 02', 'ocolus' ),
									'options'        => ocolus_wordpress_menus( 'slug' ),
									'default_option' => esc_html__( 'Select a Menu', 'ocolus' ),
									'dependency'     => array(
										'header_template',
										'any',
										'style-07,style-12,style-18,style-22',
									),
								),
								'header_sidebar'         => array(
									'id'         => 'header_sidebar',
									'type'       => 'select',
									'default'    => 'header-widget-area',
									'title'      => esc_html__( 'Header Sidebar', 'ocolus' ),
									'options'    => ocolus_sidebar_options(),
									'dependency' => array(
										'header_template',
										'any',
										'style-08,style-21',
									),
								),
								'header_template'        => array(
									'id'      => 'header_template',
									'type'    => 'select_preview',
									'options' => ocolus_file_options( '/templates/header/', 'header' ),
									'default' => 'style-05',
								),
								'header_banner'          => array(
									'id'         => 'header_banner',
									'type'       => 'image',
									'title'      => esc_html__( 'Header Banner', 'ocolus' ),
									'dependency' => array(
										'header_template',
										'any',
										'style-18,style-19',
									),
								),
								'header_banner_url'      => array(
									'id'         => 'header_banner_url',
									'type'       => 'text',
									'title'      => esc_html__( 'Banner Url', 'ocolus' ),
									'dependency' => array(
										'header_template',
										'any',
										'style-18,style-19',
									),
									'default'    => '#',
								),
								'header_social'          => array(
									'id'         => 'header_social',
									'type'       => 'select',
									'title'      => esc_html__( 'Header Social', 'ocolus' ),
									'options'    => ocolus_social_option(),
									'class'      => 'chosen',
									'attributes' => array(
										'multiple' => true,
										'style'    => 'width:100%',
									),
									'dependency' => array(
										'header_template',
										'any',
										'style-01,style-12,style-16,style-20,style-21,style-23',
									),
								),
								'header_slide'           => array(
									'id'         => 'header_slide',
									'type'       => 'select',
									'title'      => esc_html__( 'Header Slide', 'ocolus' ),
									'options'    => ocolus_rev_slide_options(),
									'dependency' => array(
										'header_template',
										'any',
										'style-04,style-20',
									),
								),
								'header_text'            => array(
									'id'         => 'header_text',
									'type'       => 'textarea',
									'title'      => esc_html__( 'Header Text', 'ocolus' ),
									'default'    => 'Start earning Octopus Rewards points when you shop!  <span>JOIN NOW</span>',
									'dependency' => array(
										'header_template',
										'any',
										'style-14,style-19,style-21,style-23,style-24',
									),
								),
							),
						),
						array(
							'title'  => esc_html__( 'Vertical Settings', 'ocolus' ),
							'fields' => array(
								array(
									'id'         => 'enable_vertical_menu',
									'type'       => 'switcher',
									'attributes' => array(
										'data-depend-id' => 'enable_vertical_menu',
									),
									'title'      => esc_html__( 'Enable Vertical Menu', 'ocolus' ),
								),
								array(
									'id'         => 'block_vertical_menu',
									'type'       => 'select',
									'title'      => esc_html__( 'Vertical Menu Always Open', 'ocolus' ),
									'options'    => 'page',
									'class'      => 'chosen',
									'attributes' => array(
										'placeholder' => 'Select a page',
										'multiple'    => 'multiple',
										'style'       => 'width:100%',
									),
									'dependency' => array(
										'enable_vertical_menu', '==', true,
									),
									'desc'       => esc_html__( 'Vertical menu will be always open', 'ocolus' ),
								),
								array(
									'id'         => 'vertical_menu_title',
									'type'       => 'text',
									'title'      => esc_html__( 'Vertical Menu Title', 'ocolus' ),
									'dependency' => array(
										'enable_vertical_menu', '==', true,
									),
									'default'    => esc_html__( 'All CATEGORIES', 'ocolus' ),
								),
								array(
									'id'         => 'vertical_menu_button_all_text',
									'type'       => 'text',
									'title'      => esc_html__( 'Vertical Menu Button show all text', 'ocolus' ),
									'dependency' => array(
										'enable_vertical_menu', '==', true,
									),
									'default'    => esc_html__( 'View More', 'ocolus' ),
								),
								array(
									'id'         => 'vertical_menu_button_close_text',
									'type'       => 'text',
									'title'      => esc_html__( 'Vertical Menu Button close text', 'ocolus' ),
									'dependency' => array(
										'enable_vertical_menu', '==', true,
									),
									'default'    => esc_html__( 'View Less', 'ocolus' ),
								),
								array(
									'id'         => 'vertical_item_visible',
									'type'       => 'number',
									'title'      => esc_html__( 'The number of visible vertical menu items', 'ocolus' ),
									'desc'       => esc_html__( 'The number of visible vertical menu items', 'ocolus' ),
									'dependency' => array(
										'enable_vertical_menu', '==', true,
									),
									'default'    => 10,
								),
							),
						),
					),
				),
			),
		);
		$options['footer_main']    = array(
			'name'   => 'footer_main',
			'icon'   => 'fa fa-folder-open-o',
			'title'  => esc_html__( 'Footer', 'ocolus' ),
			'fields' => array(
				'footer_settings' => array(
					'id'      => 'footer_settings',
					'type'    => 'heading',
					'content' => esc_html__( 'Footer Settings', 'ocolus' ),
				),
				'footer_template' => array(
					'id'      => 'footer_template',
					'type'    => 'select_preview',
					'default' => 'footer-05',
					'options' => ocolus_footer_preview(),
				),
			),
		);
		$options['posts_main']     = array(
			'name'   => 'posts_main',
			'icon'   => 'fa fa-rss',
			'title'  => esc_html__( 'Posts Settings', 'ocolus' ),
			'fields' => array(
				array(
					'id'   => 'tabs_posts',
					'type' => 'tabbed',
					'tabs' => array(
						array(
							'title'  => esc_html__( 'General', 'ocolus' ),
							'fields' => array(
								'blog_list_style'     => array(
									'id'      => 'blog_list_style',
									'type'    => 'select_preview',
									'title'   => esc_html__( 'Blog Style', 'ocolus' ),
									'options' => ocolus_file_options( '/templates/blog/blog-content/', '' ),
									'default' => 'list_v1',
								),
								'blog_column'         => array(
									'id'         => 'blog_column',
									'type'       => 'select',
									'title'      => esc_html__( 'Blog Column', 'ocolus' ),
									'options'    => array(
										'1' => esc_html__( '1 Column', 'ocolus' ),
										'2' => esc_html__( '2 Columns', 'ocolus' ),
										'3' => esc_html__( '3 Columns', 'ocolus' ),
										'4' => esc_html__( '4 Columns', 'ocolus' ),
										'5' => esc_html__( '5 Columns', 'ocolus' ),
									),
									'default'    => '3',
									'dependency' => array( 'blog_list_style', 'any', 'grid,grid_2,grid_full_width,grid_with_text,masonry' ),
								),
								'blog_post_perpage'   => array(
									'id'      => 'blog_post_perpage',
									'type'    => 'number',
									'title'   => esc_html__( 'Post Perpage', 'ocolus' ),
									'desc'    => esc_html__( 'default in Reading Settings', 'ocolus' ),
									'default' => '',
								),
								'blog_pagination'     => array(
									'id'      => 'blog_pagination',
									'type'    => 'select',
									'title'   => esc_html__( 'Blog Pagination', 'ocolus' ),
									'options' => array(
										'pagination' => esc_html__( 'Pagination', 'ocolus' ),
										'load_more'  => esc_html__( 'Load More', 'ocolus' ),
										'infinite'   => esc_html__( 'Infinite Scrolling', 'ocolus' ),
									),
									'default' => 'pagination',
								),
								'sidebar_blog_layout' => array(
									'id'         => 'sidebar_blog_layout',
									'type'       => 'image_select',
									'title'      => esc_html__( 'Sidebar Blog Layout', 'ocolus' ),
									'desc'       => esc_html__( 'Select sidebar position on Blog.', 'ocolus' ),
									'options'    => array(
										'left'  => get_theme_file_uri( 'assets/images/left-sidebar.png' ),
										'right' => get_theme_file_uri( 'assets/images/right-sidebar.png' ),
										'full'  => get_theme_file_uri( 'assets/images/no-sidebar.png' ),
									),
									'default'    => 'right',
									'dependency' => array( 'blog_list_style', 'any', 'grid,grid_2,grid_with_text,list_v1,list_v2,list_v3,list_with_text' ),
								),
								'blog_used_sidebar'   => array(
									'id'         => 'blog_used_sidebar',
									'type'       => 'select',
									'default'    => 'widget-area',
									'title'      => esc_html__( 'Blog Sidebar', 'ocolus' ),
									'options'    => ocolus_sidebar_options(),
									'dependency' => array( 'sidebar_blog_layout_full', '==', false ),
								),
								'main_post_items'     => array(
									'id'         => 'main_post_items',
									'type'       => 'slider',
									'title'      => esc_html__( 'Thumbnail items per row on Desktop', 'ocolus' ),
									'desc'       => esc_html__( '(Screen resolution of device >= 1500px )', 'ocolus' ),
									'options'    => array(
										'min'  => 1,
										'max'  => 6,
										'step' => 1,
										'unit' => esc_html__( 'item(s)', 'ocolus' ),
									),
									'default'    => '3',
									'dependency' => array( 'blog_list_style', '==', 'carousel' ),
								),
								'main_post_desktop'   => array(
									'id'         => 'main_post_desktop',
									'type'       => 'slider',
									'title'      => esc_html__( 'Thumbnail items per row on Desktop', 'ocolus' ),
									'desc'       => esc_html__( '(Screen resolution of device >= 1200px < 1500px )', 'ocolus' ),
									'options'    => array(
										'min'  => 1,
										'max'  => 6,
										'step' => 1,
										'unit' => esc_html__( 'item(s)', 'ocolus' ),
									),
									'default'    => '3',
									'dependency' => array( 'blog_list_style', '==', 'carousel' ),
								),
								'main_post_laptop'    => array(
									'id'         => 'main_post_laptop',
									'type'       => 'slider',
									'title'      => esc_html__( 'Thumbnail items per row on landscape tablet', 'ocolus' ),
									'desc'       => esc_html__( '(Screen resolution of device >=992px and < 1200px )', 'ocolus' ),
									'options'    => array(
										'min'  => 1,
										'max'  => 6,
										'step' => 1,
										'unit' => esc_html__( 'item(s)', 'ocolus' ),
									),
									'default'    => '3',
									'dependency' => array( 'blog_list_style', '==', 'carousel' ),
								),
								'main_post_tablet'    => array(
									'id'         => 'main_post_tablet',
									'type'       => 'slider',
									'title'      => esc_html__( 'Thumbnail items per row on portrait tablet', 'ocolus' ),
									'desc'       => esc_html__( '(Screen resolution of device >=768px and < 992px )', 'ocolus' ),
									'options'    => array(
										'min'  => 1,
										'max'  => 6,
										'step' => 1,
										'unit' => esc_html__( 'item(s)', 'ocolus' ),
									),
									'default'    => '2',
									'dependency' => array( 'blog_list_style', '==', 'carousel' ),
								),
								'main_post_ipad'      => array(
									'id'         => 'main_post_ipad',
									'type'       => 'slider',
									'title'      => esc_html__( 'Thumbnail items per row on Mobile', 'ocolus' ),
									'desc'       => esc_html__( '(Screen resolution of device >=480  add < 768px)', 'ocolus' ),
									'options'    => array(
										'min'  => 1,
										'max'  => 6,
										'step' => 1,
										'unit' => esc_html__( 'item(s)', 'ocolus' ),
									),
									'default'    => '1',
									'dependency' => array( 'blog_list_style', '==', 'carousel' ),
								),
								'main_post_mobile'    => array(
									'id'         => 'main_post_mobile',
									'type'       => 'slider',
									'title'      => esc_html__( 'Thumbnail items per row on Mobile', 'ocolus' ),
									'desc'       => esc_html__( '(Screen resolution of device < 480px)', 'ocolus' ),
									'options'    => array(
										'min'  => 1,
										'max'  => 6,
										'step' => 1,
										'unit' => esc_html__( 'item(s)', 'ocolus' ),
									),
									'default'    => '1',
									'dependency' => array( 'blog_list_style', '==', 'carousel' ),
								),
							),
						),
						array(
							'title'  => esc_html__( 'Single', 'ocolus' ),
							'fields' => array(
								'single_layout'         => array(
									'id'         => 'single_layout',
									'type'       => 'select',
									'default'    => 'standard',
									'title'      => esc_html__( 'Single Post Layout', 'ocolus' ),
									'options'    => array(
										'standard'      => esc_html__( 'Standard', 'ocolus' ),
										'standard_v2'   => esc_html__( 'Standard v2', 'ocolus' ),
										'full_width_v1' => esc_html__( 'Full Width v1', 'ocolus' ),
										'full_width_v2' => esc_html__( 'Full Width v2', 'ocolus' ),
										'full_screen'   => esc_html__( 'Full Screen', 'ocolus' ),
									),
									'attributes' => array(
										'data-depend-id' => 'single_layout',
									),
								),
								'enable_share'          => array(
									'id'    => 'enable_share',
									'type'  => 'switcher',
									'title' => esc_html__( 'Enable Share Social', 'ocolus' ),
								),
								'sticky_post_title'     => array(
									'id'    => 'sticky_post_title',
									'type'  => 'switcher',
									'title' => esc_html__( 'Enable Sticky Heading', 'ocolus' ),
								),
								'sidebar_single_layout' => array(
									'id'         => 'sidebar_single_layout',
									'type'       => 'image_select',
									'default'    => 'right',
									'title'      => esc_html__( ' Sidebar Single Post Layout', 'ocolus' ),
									'desc'       => esc_html__( 'Select sidebar position on Blog.', 'ocolus' ),
									'options'    => array(
										'left'  => get_theme_file_uri( 'assets/images/left-sidebar.png' ),
										'right' => get_theme_file_uri( 'assets/images/right-sidebar.png' ),
										'full'  => get_theme_file_uri( 'assets/images/no-sidebar.png' ),
									),
									'attributes' => array(
										'data-depend-id' => 'sidebar_single_layout',
									),
									'dependency' => array( 'single_layout', 'any', 'standard,standard_v2,full_width_v1' ),
								),
								'single_used_sidebar'   => array(
									'id'         => 'single_used_sidebar',
									'type'       => 'select',
									'default'    => 'widget-area',
									'title'      => esc_html__( 'Blog Single Sidebar', 'ocolus' ),
									'options'    => ocolus_sidebar_options(),
									'dependency' => array( 'sidebar_single_layout|single_layout', '!=|any', 'full|standard,standard_v2,full_width_v1' ),
								),
								'single_enable_small'   => array(
									'id'         => 'single_enable_small',
									'type'       => 'switcher',
									'title'      => esc_html__( 'Enable Small Content', 'ocolus' ),
									'dependency' => array( 'single_layout|sidebar_single_layout', 'any|==', 'standard,standard_v2|full' ),
								),
							),
						),
						array(
							'title'  => esc_html__( 'Related', 'ocolus' ),
							'fields' => array(
								'enable_related_post'   => array(
									'id'    => 'enable_related_post',
									'type'  => 'switcher',
									'title' => esc_html__( 'Enable Related Post', 'ocolus' ),
								),
								'related_post_title'    => array(
									'id'         => 'related_post_title',
									'type'       => 'text',
									'title'      => esc_html__( 'Title', 'ocolus' ),
									'default'    => esc_html__( 'Related Posts', 'ocolus' ),
									'dependency' => array( 'enable_related_post', '==', '1' ),
								),
								'related_post_layout'   => array(
									'id'         => 'related_post_layout',
									'type'       => 'select',
									'title'      => esc_html__( 'Related Layout', 'ocolus' ),
									'options'    => array(
										'normal'    => esc_html__( 'Normal', 'ocolus' ),
										'full-site' => esc_html__( 'Full Screen', 'ocolus' ),
									),
									'default'    => 'normal',
									'dependency' => array( 'enable_related_post', '==', '1' ),
								),
								'related_post_per_page' => array(
									'id'         => 'related_post_per_page',
									'type'       => 'number',
									'title'      => esc_html__( 'Number Post Items', 'ocolus' ),
									'default'    => '6',
									'dependency' => array( 'enable_related_post', '==', '1' ),
								),
							),
						),
					),
				),
			),
		);
		$options['portfolio_main'] = array(
			'name'   => 'portfolio_main',
			'icon'   => 'fa fa-podcast',
			'title'  => esc_html__( 'Portfolio Settings', 'ocolus' ),
			'fields' => array(
				array(
					'id'   => 'tabs_portfolio',
					'type' => 'tabbed',
					'tabs' => array(
						array(
							'title'  => esc_html__( 'General', 'ocolus' ),
							'fields' => array(
								'portfolio_title'      => array(
									'id'    => 'portfolio_title',
									'type'  => 'text',
									'title' => esc_html__( 'Title', 'ocolus' ),
								),
								'portfolio_desc'       => array(
									'id'    => 'portfolio_desc',
									'type'  => 'textarea',
									'title' => esc_html__( 'Descriptions', 'ocolus' ),
								),
								'portfolio_cat'        => array(
									'id'         => 'portfolio_cat',
									'type'       => 'select',
									'title'      => esc_html__( 'Category Filter', 'ocolus' ),
									'options'    => 'categories',
									'query_args' => array(
										'type'     => 'portfolio',
										'taxonomy' => 'portfolio-category',
									),
									'attributes' => array(
										'multiple' => 'only-key',
										'style'    => 'width:100%',
									),
									'class'      => 'chosen',
								),
								'portfolio_list_style' => array(
									'id'      => 'portfolio_list_style',
									'type'    => 'select_preview',
									'title'   => esc_html__( 'Portfolio Style', 'ocolus' ),
									'options' => ocolus_file_options( '/templates/portfolio/portfolio-content/', '' ),
									'default' => 'grid',
								),
								'portfolio_column'     => array(
									'id'         => 'portfolio_column',
									'type'       => 'slider',
									'options'    => array(
										'min'  => 2,
										'max'  => 4,
										'step' => 1,
										'unit' => 'Columns',
									),
									'default'    => '3',
									'title'      => esc_html__( 'Portfolio Column', 'ocolus' ),
									'dependency' => array( 'portfolio_list_style', 'not-any', 'metro,carousel' ),
								),
							),
						),
						array(
							'title'  => esc_html__( 'Settings', 'ocolus' ),
							'fields' => array(
								'portfolio_perpage'    => array(
									'id'      => 'portfolio_perpage',
									'type'    => 'number',
									'title'   => esc_html__( 'Portfolio Perpage', 'ocolus' ),
									'desc'    => esc_html__( 'default in Reading Settings', 'ocolus' ),
									'default' => '',
								),
								'portfolio_full_width' => array(
									'id'    => 'portfolio_full_width',
									'type'  => 'switcher',
									'title' => esc_html__( 'Full Width', 'ocolus' ),
								),
								'portfolio_gutter'     => array(
									'id'    => 'portfolio_gutter',
									'type'  => 'switcher',
									'title' => esc_html__( 'Gutter', 'ocolus' ),
								),
								'portfolio_pagination' => array(
									'id'      => 'portfolio_pagination',
									'type'    => 'select',
									'title'   => esc_html__( 'Pagination', 'ocolus' ),
									'options' => array(
										'pagination' => esc_html__( 'Pagination', 'ocolus' ),
										'load_more'  => esc_html__( 'Load More', 'ocolus' ),
										'infinite'   => esc_html__( 'Infinite Scrolling', 'ocolus' ),
									),
									'default' => 'pagination',
								),
							),
						),
						array(
							'title'  => esc_html__( 'Single', 'ocolus' ),
							'fields' => array(
								'portfolio_single_layout' => array(
									'id'      => 'portfolio_single_layout',
									'type'    => 'select',
									'default' => 'carousel',
									'title'   => esc_html__( 'Single Portfolio Layout', 'ocolus' ),
									'options' => array(
										'carousel' => esc_html__( 'Single Pages Carousel', 'ocolus' ),
									),
								),
							),
						),
					),
				),
			),
		);
		if ( class_exists( 'WooCommerce' ) ) {
			$options['woocommerce_mains']  = array(
				'name'   => 'woocommerce_mains',
				'icon'   => 'fa fa-shopping-bag',
				'title'  => esc_html__( 'WooCommerce', 'ocolus' ),
				'fields' => array(
					array(
						'id'   => 'tabs_woocommerce_settings',
						'type' => 'tabbed',
						'tabs' => array(
							array(
								'title'  => esc_html__( 'General', 'ocolus' ),
								'fields' => array(
									'woo_enable_ajax'          => array(
										'id'    => 'woo_enable_ajax',
										'type'  => 'switcher',
										'title' => esc_html__( 'Enable Ajax WooCommerce', 'ocolus' ),
									),
									'woo_short_title'          => array(
										'id'    => 'woo_short_title',
										'type'  => 'switcher',
										'title' => esc_html__( 'Enable Short Title', 'ocolus' ),
										'desc'  => esc_html__( 'Collapse title in aline on mobile.', 'ocolus' ),
									),
									'disable_attribute'        => array(
										'id'    => 'disable_attribute',
										'type'  => 'switcher',
										'title' => esc_html__( 'Disable Attribute in All Product Style', 'ocolus' ),
									),
									'products_hover'           => array(
										'id'      => 'products_hover',
										'type'    => 'select',
										'title'   => esc_html__( 'Products Hover', 'ocolus' ),
										'options' => array(
											'none'      => esc_html__( 'None', 'ocolus' ),
											'change'    => esc_html__( 'Change Image', 'ocolus' ),
											'zoom'      => esc_html__( 'Zoom Image', 'ocolus' ),
											'transform' => esc_html__( 'Transform Image', 'ocolus' ),
										),
										'default' => 'none',
										'desc'    => esc_html__( 'Select style hover products.', 'ocolus' ),
									),
									'woocommerce_pagination'   => array(
										'id'      => 'woocommerce_pagination',
										'type'    => 'select',
										'title'   => esc_html__( 'WooCommerce Pagination', 'ocolus' ),
										'options' => array(
											'pagination' => esc_html__( 'Pagination', 'ocolus' ),
											'load_more'  => esc_html__( 'Load More', 'ocolus' ),
											'infinite'   => esc_html__( 'Infinite Scrolling', 'ocolus' ),
										),
										'default' => 'pagination',
										'desc'    => esc_html__( 'Select style pagination on shop page.', 'ocolus' ),
									),
									'sidebar_shop_layout'      => array(
										'id'      => 'sidebar_shop_layout',
										'type'    => 'image_select',
										'default' => 'left',
										'title'   => esc_html__( 'Shop Page Sidebar Layout', 'ocolus' ),
										'desc'    => esc_html__( 'Select sidebar position on Shop Page.', 'ocolus' ),
										'options' => array(
											'left'  => get_theme_file_uri( 'assets/images/left-sidebar.png' ),
											'right' => get_theme_file_uri( 'assets/images/right-sidebar.png' ),
											'full'  => get_theme_file_uri( 'assets/images/no-sidebar.png' ),
										),
									),
									'shop_used_sidebar'        => array(
										'id'         => 'shop_used_sidebar',
										'type'       => 'select',
										'default'    => 'shop-widget-area',
										'title'      => esc_html__( 'Sidebar Used For Shop', 'ocolus' ),
										'options'    => ocolus_sidebar_options(),
										'dependency' => array( 'sidebar_shop_layout_full', '==', false ),
									),
									'shop_vendor_used_sidebar' => array(
										'id'      => 'shop_vendor_used_sidebar',
										'type'    => 'select',
										'default' => 'vendor-widget-area',
										'title'   => esc_html__( 'Sidebar Used For Vendor', 'ocolus' ),
										'options' => ocolus_sidebar_options(),
									),
									'shop_list_style'          => array(
										'id'      => 'shop_list_style',
										'type'    => 'image_select',
										'default' => 'grid',
										'title'   => esc_html__( 'Shop Default Layout', 'ocolus' ),
										'desc'    => esc_html__( 'Select default layout for shop, product category archive.', 'ocolus' ),
										'options' => array(
											'grid' => get_theme_file_uri( 'assets/images/grid-display.png' ),
											'list' => get_theme_file_uri( 'assets/images/list-display.png' ),
										),
									),
								),
							),
							array(
								'title'  => esc_html__( 'Layout', 'ocolus' ),
								'fields' => array(
									'shop_product_style'     => array(
										'id'      => 'shop_product_style',
										'type'    => 'select_preview',
										'default' => 'style-01',
										'title'   => esc_html__( 'Product shop style', 'ocolus' ),
										'desc'    => esc_html__( 'Select a product style in shop page', 'ocolus' ),
										'options' => ocolus_product_options( 'Theme Option' ),
									),
									'size_gallery_thumbnail' => array(
										'id'     => 'size_gallery_thumbnail',
										'type'   => 'fieldset',
										'title'  => esc_html__( 'Size Gallery Thumbnail', 'ocolus' ),
										'fields' => array(
											array(
												'id'      => 'width',
												'type'    => 'number',
												'default' => '126',
												'title'   => esc_html__( 'Width', 'ocolus' ),
											),
											array(
												'id'      => 'height',
												'type'    => 'number',
												'default' => '156',
												'title'   => esc_html__( 'Height', 'ocolus' ),
											),
											array(
												'id'    => 'crop',
												'type'  => 'switcher',
												'title' => esc_html__( 'Crop?', 'ocolus' ),
											),
										),
									),
									'size_thumbnail'         => array(
										'id'     => 'size_thumbnail',
										'type'   => 'fieldset',
										'title'  => esc_html__( 'Size Thumbnail', 'ocolus' ),
										'fields' => array(
											array(
												'id'      => 'width',
												'type'    => 'number',
												'default' => '262',
												'title'   => esc_html__( 'Width', 'ocolus' ),
											),
											array(
												'id'      => 'height',
												'type'    => 'number',
												'default' => '360',
												'title'   => esc_html__( 'Height', 'ocolus' ),
											),
											array(
												'id'    => 'crop',
												'type'  => 'switcher',
												'title' => esc_html__( 'Crop?', 'ocolus' ),
											),
										),
									),
									'size_single'            => array(
										'id'     => 'size_single',
										'type'   => 'fieldset',
										'title'  => esc_html__( 'Size Single', 'ocolus' ),
										'fields' => array(
											array(
												'id'      => 'width',
												'type'    => 'number',
												'default' => '555',
												'title'   => esc_html__( 'Width', 'ocolus' ),
											),
											array(
												'id'      => 'height',
												'type'    => 'number',
												'default' => '700',
												'title'   => esc_html__( 'Height', 'ocolus' ),
											),
											array(
												'id'    => 'crop',
												'type'  => 'switcher',
												'title' => esc_html__( 'Crop?', 'ocolus' ),
											),
										),
									),
								),
							),
							array(
								'title'  => esc_html__( 'Quick View', 'ocolus' ),
								'fields' => array(
									'quickview_style' => $quickview_params,
								),
							),
							array(
								'title'  => esc_html__( 'Settings', 'ocolus' ),
								'fields' => array(
									'disable_zoom'     => array(
										'id'    => 'disable_zoom',
										'type'  => 'switcher',
										'title' => esc_html__( 'Disable Zoom Lib WooCommerce', 'ocolus' ),
									),
									'shop_background'  => array(
										'id'    => 'shop_background',
										'type'  => 'image',
										'title' => esc_html__( 'Shop Banner', 'ocolus' ),
									),
									'product_per_row'  => array(
										'id'      => 'product_per_row',
										'type'    => 'slider',
										'options' => array(
											'min'  => 1,
											'max'  => 6,
											'step' => 1,
											'unit' => 'row',
										),
										'default' => '4',
										'title'   => esc_html__( 'Products Per Row', 'ocolus' ),
										'desc'    => esc_html__( 'Number Row of products on shop page.', 'ocolus' ),
									),
									'product_per_page' => array(
										'id'      => 'product_per_page',
										'type'    => 'number',
										'default' => '10',
										'title'   => esc_html__( 'Products Per Page', 'ocolus' ),
										'desc'    => esc_html__( 'Number of products on shop page.', 'ocolus' ),
									),
									'product_newness'  => array(
										'id'      => 'product_newness',
										'default' => '100',
										'type'    => 'number',
										'title'   => esc_html__( 'Products Newness', 'ocolus' ),
									),
									'onsale_label'     => array(
										'id'    => 'onsale_label',
										'type'  => 'switcher',
										'title' => esc_html__( 'Enable Percent', 'ocolus' ),
										'info'  => esc_html__( 'Replace "Sale" by Percent', 'ocolus' ),
									),
									'product_label'    => array(
										'id'         => 'product_label',
										'type'       => 'select',
										'options'    => array(
											'sale' => esc_html__( 'Sale', 'ocolus' ),
											'out'  => esc_html__( 'Sold out', 'ocolus' ),
											'hot'  => esc_html__( 'Hot', 'ocolus' ),
											'new'  => esc_html__( 'New', 'ocolus' ),
											'gift' => esc_html__( 'Gift', 'ocolus' ),
										),
										'attributes' => array(
											'multiple' => 'only-key',
											'style'    => 'width:100%',
										),
										'class'      => 'chosen',
										'default'    => array( 'sale', 'new' ),
										'title'      => esc_html__( 'Product Label', 'ocolus' ),
										'info'       => esc_html__( 'Choose your Product Label.', 'ocolus' ),
									),
								),
							),
						),
					),
				),
			);
			$options['woocommerce_single'] = array(
				'name'   => 'woocommerce_single',
				'icon'   => 'fa fa-product-hunt',
				'title'  => esc_html__( 'WooCommerce Single', 'ocolus' ),
				'fields' => array(
					array(
						'id'   => 'tabs_woocommerce_single',
						'type' => 'tabbed',
						'tabs' => array(
							array(
								'title'  => esc_html__( 'Layout Settings', 'ocolus' ),
								'fields' => array(
									'sticky_add_to_cart'        => array(
										'id'    => 'sticky_add_to_cart',
										'type'  => 'switcher',
										'title' => esc_html__( 'Enable Sticky Add To Cart', 'ocolus' ),
									),
									'single_product_thumbnail'  => array(
										'id'      => 'single_product_thumbnail',
										'type'    => 'select',
										'title'   => esc_html__( 'Single Product Thumbnail', 'ocolus' ),
										'options' => array(
											'horizontal'     => esc_html__( 'Product Horizontal Bottom', 'ocolus' ),
											'vertical_left'  => esc_html__( 'Product Vertical Left v1', 'ocolus' ),
											'vertical_right' => esc_html__( 'Product Vertical Right', 'ocolus' ),
											'gallery_grid'   => esc_html__( 'Product With Gallery Grid v1', 'ocolus' ),
											'sticky_info'    => esc_html__( 'Product With Sticky Info', 'ocolus' ),
										),
										'default' => 'horizontal',
									),
									'product_description_style' => array(
										'id'      => 'product_description_style',
										'type'    => 'select_preview',
										'default' => 'desc_01',
										'title'   => esc_html__( 'Product Descriptions Layout', 'ocolus' ),
										'desc'    => esc_html__( 'Select a Product Descriptions layout in Product Page', 'ocolus' ),
										'options' => array(
											'desc_01' => array(
												'title'   => esc_html__( 'Descriptions 01', 'ocolus' ),
												'preview' => get_theme_file_uri( 'assets/images/preview/desc1.jpg' ),
											),
											'desc_02' => array(
												'title'   => esc_html__( 'Descriptions 02', 'ocolus' ),
												'preview' => get_theme_file_uri( 'assets/images/preview/desc2.jpg' ),
											),
											'desc_03' => array(
												'title'   => esc_html__( 'Descriptions 03', 'ocolus' ),
												'preview' => get_theme_file_uri( 'assets/images/preview/desc3.jpg' ),
											),
										),
									),
								),
							),
							array(
								'title'  => esc_html__( 'Product Settings', 'ocolus' ),
								'fields' => array(
                                    'enable_ajax_add_to_cart' => array(
                                        'id'      => 'enable_ajax_add_to_cart',
                                        'type'    => 'switcher',
                                        'title'   => esc_html__( 'Enable Ajax add-to-cart', 'ocolus' ),
                                    ),
									'product_mailchimp'         => $mailchimp_params,
									'enable_product_guaranteed' => array(
										'id'    => 'enable_product_guaranteed',
										'type'  => 'switcher',
										'title' => esc_html__( 'Enable Guaranteed', 'ocolus' ),
									),
									'title_product_guaranteed'  => array(
										'id'         => 'title_product_guaranteed',
										'type'       => 'text',
										'title'      => esc_html__( 'Title Guaranteed', 'ocolus' ),
										'default'    => esc_html__( 'GUARANTEED SAFE CHECKOUT', 'ocolus' ),
										'dependency' => array( 'enable_product_guaranteed', '==', true ),
									),
									'product_guaranteed'        => array(
										'id'         => 'product_guaranteed',
										'type'       => 'gallery',
										'title'      => esc_html__( 'Product Guaranteed', 'ocolus' ),
										'dependency' => array( 'enable_product_guaranteed', '==', true ),
									),
								),
							),
							array(
								'title'  => esc_html__( 'Related Products', 'ocolus' ),
								'fields' => array(
									'woo_related_enable'  => array(
										'id'      => 'woo_related_enable',
										'type'    => 'select',
										'default' => 'enable',
										'options' => array(
											'enable'  => esc_html__( 'Enable', 'ocolus' ),
											'disable' => esc_html__( 'Disable', 'ocolus' ),
										),
										'title'   => esc_html__( 'Enable Related Products', 'ocolus' ),
									),
									'woo_related_title'   => array(
										'id'         => 'woo_related_title',
										'type'       => 'text',
										'title'      => esc_html__( 'Related products title', 'ocolus' ),
										'desc'       => esc_html__( 'Related products title', 'ocolus' ),
										'dependency' => array( 'woo_related_enable', '==', 'enable' ),
										'default'    => esc_html__( 'Related Products', 'ocolus' ),
									),
									'woo_related_style'   => array(
										'id'         => 'woo_related_style',
										'type'       => 'select_preview',
										'default'    => 'style-01',
										'title'      => esc_html__( 'Product Related Layout', 'ocolus' ),
										'options'    => ocolus_product_options( 'Theme Option' ),
										'dependency' => array( 'woo_related_enable', '==', 'enable' ),
									),
									'woo_related_perpage' => array(
										'id'         => 'woo_related_perpage',
										'type'       => 'number',
										'title'      => esc_html__( 'Related products Items', 'ocolus' ),
										'desc'       => esc_html__( 'Number Related products to show', 'ocolus' ),
										'dependency' => array( 'woo_related_enable', '==', 'enable' ),
										'default'    => '6',
									),
									'woo_related_items'   => array(
										'id'         => 'woo_related_items',
										'type'       => 'slider',
										'title'      => esc_html__( 'Related products items per row on Desktop', 'ocolus' ),
										'desc'       => esc_html__( '(Screen resolution of device >= 1500px )', 'ocolus' ),
										'options'    => array(
											'min'  => 1,
											'max'  => 6,
											'step' => 1,
											'unit' => esc_html__( 'item(s)', 'ocolus' ),
										),
										'default'    => '3',
										'dependency' => array( 'woo_related_enable', '==', 'enable' ),
									),
									'woo_related_desktop' => array(
										'id'         => 'woo_related_desktop',
										'type'       => 'slider',
										'title'      => esc_html__( 'Related products items per row on Desktop', 'ocolus' ),
										'desc'       => esc_html__( '(Screen resolution of device >= 1200px < 1500px )', 'ocolus' ),
										'options'    => array(
											'min'  => 1,
											'max'  => 6,
											'step' => 1,
											'unit' => esc_html__( 'item(s)', 'ocolus' ),
										),
										'default'    => '3',
										'dependency' => array( 'woo_related_enable', '==', 'enable' ),
									),
									'woo_related_laptop'  => array(
										'id'         => 'woo_related_laptop',
										'type'       => 'slider',
										'title'      => esc_html__( 'Related products items per row on Laptop', 'ocolus' ),
										'desc'       => esc_html__( '(Screen resolution of device >=992px and < 1200px )', 'ocolus' ),
										'options'    => array(
											'min'  => 1,
											'max'  => 6,
											'step' => 1,
											'unit' => esc_html__( 'item(s)', 'ocolus' ),
										),
										'default'    => '3',
										'dependency' => array( 'woo_related_enable', '==', 'enable' ),
									),
									'woo_related_tablet'  => array(
										'id'         => 'woo_related_tablet',
										'type'       => 'slider',
										'title'      => esc_html__( 'Related product items per row on portrait tablet', 'ocolus' ),
										'desc'       => esc_html__( '(Screen resolution of device >=768px and < 992px )', 'ocolus' ),
										'options'    => array(
											'min'  => 1,
											'max'  => 6,
											'step' => 1,
											'unit' => esc_html__( 'item(s)', 'ocolus' ),
										),
										'default'    => '2',
										'dependency' => array( 'woo_related_enable', '==', 'enable' ),
									),
									'woo_related_ipad'    => array(
										'id'         => 'woo_related_ipad',
										'type'       => 'slider',
										'title'      => esc_html__( 'Related products items per row on Ipad', 'ocolus' ),
										'desc'       => esc_html__( '(Screen resolution of device >=480  add < 768px)', 'ocolus' ),
										'options'    => array(
											'min'  => 1,
											'max'  => 6,
											'step' => 1,
											'unit' => esc_html__( 'item(s)', 'ocolus' ),
										),
										'default'    => '1',
										'dependency' => array( 'woo_related_enable', '==', 'enable' ),
									),
									'woo_related_mobile'  => array(
										'id'         => 'woo_related_mobile',
										'type'       => 'slider',
										'title'      => esc_html__( 'Related products items per row on Mobile', 'ocolus' ),
										'desc'       => esc_html__( '(Screen resolution of device < 480px)', 'ocolus' ),
										'options'    => array(
											'min'  => 1,
											'max'  => 6,
											'step' => 1,
											'unit' => esc_html__( 'item(s)', 'ocolus' ),
										),
										'default'    => '1',
										'dependency' => array( 'woo_related_enable', '==', 'enable' ),
									),
								),
							),
							array(
								'title'  => esc_html__( 'Cross Sell Products', 'ocolus' ),
								'fields' => array(
									'woo_crosssell_enable'  => array(
										'id'      => 'woo_crosssell_enable',
										'type'    => 'select',
										'default' => 'enable',
										'options' => array(
											'enable'  => esc_html__( 'Enable', 'ocolus' ),
											'disable' => esc_html__( 'Disable', 'ocolus' ),
										),
										'title'   => esc_html__( 'Enable Cross Sell Products', 'ocolus' ),
									),
									'woo_crosssell_title'   => array(
										'id'         => 'woo_crosssell_title',
										'type'       => 'text',
										'title'      => esc_html__( 'Cross Sell products title', 'ocolus' ),
										'desc'       => esc_html__( 'Cross Sell products title', 'ocolus' ),
										'dependency' => array( 'woo_crosssell_enable', '==', 'enable' ),
										'default'    => esc_html__( 'Cross Sell Products', 'ocolus' ),
									),
									'woo_crosssell_style'   => array(
										'id'         => 'woo_crosssell_style',
										'type'       => 'select_preview',
										'default'    => 'style-01',
										'title'      => esc_html__( 'Product Cross Sell Layout', 'ocolus' ),
										'options'    => ocolus_product_options( 'Theme Option' ),
										'dependency' => array( 'woo_crosssell_enable', '==', 'enable' ),
									),
									'woo_crosssell_items'   => array(
										'id'         => 'woo_crosssell_items',
										'type'       => 'slider',
										'title'      => esc_html__( 'Cross Sell products items per row on Desktop', 'ocolus' ),
										'desc'       => esc_html__( '(Screen resolution of device >= 1500px )', 'ocolus' ),
										'options'    => array(
											'min'  => 1,
											'max'  => 6,
											'step' => 1,
											'unit' => esc_html__( 'item(s)', 'ocolus' ),
										),
										'default'    => '3',
										'dependency' => array( 'woo_crosssell_enable', '==', 'enable' ),
									),
									'woo_crosssell_desktop' => array(
										'id'         => 'woo_crosssell_desktop',
										'type'       => 'slider',
										'title'      => esc_html__( 'Cross Sell products items per row on Desktop', 'ocolus' ),
										'desc'       => esc_html__( '(Screen resolution of device >= 1200px < 1500px )', 'ocolus' ),
										'options'    => array(
											'min'  => 1,
											'max'  => 6,
											'step' => 1,
											'unit' => esc_html__( 'item(s)', 'ocolus' ),
										),
										'default'    => '3',
										'dependency' => array( 'woo_crosssell_enable', '==', 'enable' ),
									),
									'woo_crosssell_laptop'  => array(
										'id'         => 'woo_crosssell_laptop',
										'type'       => 'slider',
										'title'      => esc_html__( 'Cross Sell products items per row on landscape Laptop', 'ocolus' ),
										'desc'       => esc_html__( '(Screen resolution of device >=992px and < 1200px )', 'ocolus' ),
										'options'    => array(
											'min'  => 1,
											'max'  => 6,
											'step' => 1,
											'unit' => esc_html__( 'item(s)', 'ocolus' ),
										),
										'default'    => '3',
										'dependency' => array( 'woo_crosssell_enable', '==', 'enable' ),
									),
									'woo_crosssell_tablet'  => array(
										'id'         => 'woo_crosssell_tablet',
										'type'       => 'slider',
										'title'      => esc_html__( 'Cross Sell product items per row on portrait tablet', 'ocolus' ),
										'desc'       => esc_html__( '(Screen resolution of device >=768px and < 992px )', 'ocolus' ),
										'options'    => array(
											'min'  => 1,
											'max'  => 6,
											'step' => 1,
											'unit' => esc_html__( 'item(s)', 'ocolus' ),
										),
										'default'    => '2',
										'dependency' => array( 'woo_crosssell_enable', '==', 'enable' ),
									),
									'woo_crosssell_ipad'    => array(
										'id'         => 'woo_crosssell_ipad',
										'type'       => 'slider',
										'title'      => esc_html__( 'Cross Sell products items per row on Ipad', 'ocolus' ),
										'desc'       => esc_html__( '(Screen resolution of device >=480  add < 768px)', 'ocolus' ),
										'options'    => array(
											'min'  => 1,
											'max'  => 6,
											'step' => 1,
											'unit' => esc_html__( 'item(s)', 'ocolus' ),
										),
										'default'    => '1',
										'dependency' => array( 'woo_crosssell_enable', '==', 'enable' ),
									),
									'woo_crosssell_mobile'  => array(
										'id'         => 'woo_crosssell_mobile',
										'type'       => 'slider',
										'title'      => esc_html__( 'Cross Sell products items per row on Mobile', 'ocolus' ),
										'desc'       => esc_html__( '(Screen resolution of device < 480px)', 'ocolus' ),
										'options'    => array(
											'min'  => 1,
											'max'  => 6,
											'step' => 1,
											'unit' => esc_html__( 'item(s)', 'ocolus' ),
										),
										'default'    => '1',
										'dependency' => array( 'woo_crosssell_enable', '==', 'enable' ),
									),
								),
							),
							array(
								'title'  => esc_html__( 'Upsell Products', 'ocolus' ),
								'fields' => array(
									'woo_upsell_enable'  => array(
										'id'      => 'woo_upsell_enable',
										'type'    => 'select',
										'default' => 'enable',
										'options' => array(
											'enable'  => esc_html__( 'Enable', 'ocolus' ),
											'disable' => esc_html__( 'Disable', 'ocolus' ),
										),
										'title'   => esc_html__( 'Enable Upsell Products', 'ocolus' ),
									),
									'woo_upsell_title'   => array(
										'id'         => 'woo_upsell_title',
										'type'       => 'text',
										'title'      => esc_html__( 'Upsell products title', 'ocolus' ),
										'desc'       => esc_html__( 'Upsell products title', 'ocolus' ),
										'dependency' => array( 'woo_upsell_enable', '==', 'enable' ),
										'default'    => esc_html__( 'Upsell Products', 'ocolus' ),
									),
									'woo_upsell_style'   => array(
										'id'         => 'woo_upsell_style',
										'type'       => 'select_preview',
										'default'    => 'style-01',
										'title'      => esc_html__( 'Product Upsell Layout', 'ocolus' ),
										'options'    => ocolus_product_options( 'Theme Option' ),
										'dependency' => array( 'woo_upsell_enable', '==', 'enable' ),
									),
									'woo_upsell_items'   => array(
										'id'         => 'woo_upsell_items',
										'type'       => 'slider',
										'title'      => esc_html__( 'Upsell products items per row on Desktop', 'ocolus' ),
										'desc'       => esc_html__( '(Screen resolution of device >= 1500px )', 'ocolus' ),
										'options'    => array(
											'min'  => 1,
											'max'  => 6,
											'step' => 1,
											'unit' => esc_html__( 'item(s)', 'ocolus' ),
										),
										'default'    => '3',
										'dependency' => array( 'woo_upsell_enable', '==', 'enable' ),
									),
									'woo_upsell_desktop' => array(
										'id'         => 'woo_upsell_desktop',
										'type'       => 'slider',
										'title'      => esc_html__( 'Upsell products items per row on Desktop', 'ocolus' ),
										'desc'       => esc_html__( '(Screen resolution of device >= 1200px < 1500px )', 'ocolus' ),
										'options'    => array(
											'min'  => 1,
											'max'  => 6,
											'step' => 1,
											'unit' => esc_html__( 'item(s)', 'ocolus' ),
										),
										'default'    => '3',
										'dependency' => array( 'woo_upsell_enable', '==', 'enable' ),
									),
									'woo_upsell_laptop'  => array(
										'id'         => 'woo_upsell_laptop',
										'type'       => 'slider',
										'title'      => esc_html__( 'Upsell products items per row on landscape Laptop', 'ocolus' ),
										'desc'       => esc_html__( '(Screen resolution of device >=992px and < 1200px )', 'ocolus' ),
										'options'    => array(
											'min'  => 1,
											'max'  => 6,
											'step' => 1,
											'unit' => esc_html__( 'item(s)', 'ocolus' ),
										),
										'default'    => '3',
										'dependency' => array( 'woo_upsell_enable', '==', 'enable' ),
									),
									'woo_upsell_tablet'  => array(
										'id'         => 'woo_upsell_tablet',
										'type'       => 'slider',
										'title'      => esc_html__( 'Upsell product items per row on portrait tablet', 'ocolus' ),
										'desc'       => esc_html__( '(Screen resolution of device >=768px and < 992px )', 'ocolus' ),
										'options'    => array(
											'min'  => 1,
											'max'  => 6,
											'step' => 1,
											'unit' => esc_html__( 'item(s)', 'ocolus' ),
										),
										'default'    => '2',
										'dependency' => array( 'woo_upsell_enable', '==', 'enable' ),
									),
									'woo_upsell_ipad'    => array(
										'id'         => 'woo_upsell_ipad',
										'type'       => 'slider',
										'title'      => esc_html__( 'Upsell products items per row on Ipad', 'ocolus' ),
										'desc'       => esc_html__( '(Screen resolution of device >=480  add < 768px)', 'ocolus' ),
										'options'    => array(
											'min'  => 1,
											'max'  => 6,
											'step' => 1,
											'unit' => esc_html__( 'item(s)', 'ocolus' ),
										),
										'default'    => '1',
										'dependency' => array( 'woo_upsell_enable', '==', 'enable' ),
									),
									'woo_upsell_mobile'  => array(
										'id'         => 'woo_upsell_mobile',
										'type'       => 'slider',
										'title'      => esc_html__( 'Upsell products items per row on Mobile', 'ocolus' ),
										'desc'       => esc_html__( '(Screen resolution of device < 480px)', 'ocolus' ),
										'options'    => array(
											'min'  => 1,
											'max'  => 6,
											'step' => 1,
											'unit' => esc_html__( 'item(s)', 'ocolus' ),
										),
										'default'    => '1',
										'dependency' => array( 'woo_upsell_enable', '==', 'enable' ),
									),
								),
							),
						),
					),
				),
			);
		}
		$options['social']     = array(
			'name'   => 'social',
			'icon'   => 'fa fa-users',
			'title'  => esc_html__( 'Social', 'ocolus' ),
			'fields' => array(
				array(
					'id'              => 'user_all_social',
					'type'            => 'group',
					'title'           => esc_html__( 'Social', 'ocolus' ),
					'button_title'    => esc_html__( 'Add New Social', 'ocolus' ),
					'accordion_title' => esc_html__( 'Social Settings', 'ocolus' ),
					'fields'          => array(
						array(
							'id'      => 'title_social',
							'type'    => 'text',
							'title'   => esc_html__( 'Title Social', 'ocolus' ),
							'default' => 'Facebook',
						),
						array(
							'id'      => 'link_social',
							'type'    => 'text',
							'title'   => esc_html__( 'Link Social', 'ocolus' ),
							'default' => 'https://facebook.com',
						),
						array(
							'id'      => 'icon_social',
							'type'    => 'icon',
							'title'   => esc_html__( 'Icon Social', 'ocolus' ),
							'default' => 'fa fa-facebook',
						),
					),
				),
			),
		);
		$options['typography'] = array(
			'name'   => 'typography',
			'icon'   => 'fa fa-font',
			'title'  => esc_html__( 'Typography', 'ocolus' ),
			'fields' => array(
				'enable_typography' => array(
					'id'    => 'enable_typography',
					'type'  => 'switcher',
					'title' => esc_html__( 'Enable Typography', 'ocolus' ),
				),
				'typography_group'  => array(
					'id'              => 'typography_group',
					'type'            => 'group',
					'title'           => esc_html__( 'Typography Options', 'ocolus' ),
					'button_title'    => esc_html__( 'Add New Typography', 'ocolus' ),
					'accordion_title' => esc_html__( 'Typography Item', 'ocolus' ),
					'dependency'      => array(
						'enable_typography', '==', true,
					),
					'fields'          => array(
						'element_tag'            => array(
							'id'      => 'element_tag',
							'type'    => 'select',
							'options' => array(
								'body' => esc_html__( 'Body', 'ocolus' ),
								'h1'   => esc_html__( 'H1', 'ocolus' ),
								'h2'   => esc_html__( 'H2', 'ocolus' ),
								'h3'   => esc_html__( 'H3', 'ocolus' ),
								'h4'   => esc_html__( 'H4', 'ocolus' ),
								'h5'   => esc_html__( 'H5', 'ocolus' ),
								'h6'   => esc_html__( 'H6', 'ocolus' ),
								'p'    => esc_html__( 'P', 'ocolus' ),
							),
							'title'   => esc_html__( 'Element Tag', 'ocolus' ),
							'desc'    => esc_html__( 'Select a Element Tag HTML', 'ocolus' ),
						),
						'typography_font_family' => array(
							'id'     => 'typography_font_family',
							'type'   => 'typography',
							'title'  => esc_html__( 'Font Family', 'ocolus' ),
							'desc'   => esc_html__( 'Select a Font Family', 'ocolus' ),
							'chosen' => false,
						),
						'body_text_color'        => array(
							'id'    => 'body_text_color',
							'type'  => 'color_picker',
							'title' => esc_html__( 'Body Text Color', 'ocolus' ),
						),
						'typography_font_size'   => array(
							'id'      => 'typography_font_size',
							'type'    => 'number',
							'default' => 16,
							'title'   => esc_html__( 'Font Size', 'ocolus' ),
							'desc'    => esc_html__( 'Unit PX', 'ocolus' ),
						),
						'typography_line_height' => array(
							'id'      => 'typography_line_height',
							'type'    => 'number',
							'default' => 30,
							'title'   => esc_html__( 'Line Height', 'ocolus' ),
							'desc'    => esc_html__( 'Unit PX', 'ocolus' ),
						),
					),
					'default'         => array(
						array(
							'element_tag'            => 'body',
							'typography_font_family' => 'Poppins',
							'body_text_color'        => '#293341',
							'typography_font_size'   => 16,
							'typography_line_height' => 30,
						),
					),
				),
			),
		);
		$options['backup']     = array(
			'name'   => 'backup',
			'icon'   => 'fa fa-bold',
			'title'  => esc_html__( 'Backup / Reset', 'ocolus' ),
			'fields' => array(
				'reset' => array(
					'id'    => 'reset',
					'type'  => 'backup',
					'title' => esc_html__( 'Reset', 'ocolus' ),
				),
			),
		);

		return apply_filters( 'ocolus_theme_options', $options );
	}
}
/*==========================================================================
META BOX OPTIONS
===========================================================================*/
add_filter( 'ovic_options_metabox', 'ocolus_metabox_options' );
if ( !function_exists( 'ocolus_metabox_options' ) ) {
	function ocolus_metabox_options( $sections )
	{
		// -----------------------------------------
		// Page Side Meta box Options              -
		// -----------------------------------------
		$sections[] = array(
			'id'        => '_custom_portfolio_side_options',
			'title'     => esc_html__( 'Portfolio Settings', 'ocolus' ),
			'post_type' => 'portfolio',
			'context'   => 'side',
			'priority'  => 'default',
			'sections'  => array(
				array(
					'name'   => 'portfolio_option',
					'fields' => array(
                        array(
                            'id'      => 'post_size_masonry',
                            'type'    => 'select',
                            'title'   => esc_html__( 'Post Size for Portfolio Masonry', 'ocolus' ),
                            'options' => array(
                                'small'  => esc_html__( 'Small', 'ocolus' ),
                                'medium' => esc_html__( 'Medium', 'ocolus' ),
                            ),
                            'default' => 'small',
                        ),
						array(
							'id'      => 'post_size',
							'type'    => 'select',
							'title'   => esc_html__( 'Post Size for Portfolio Metro', 'ocolus' ),
							'options' => array(
								'small'    => esc_html__( 'Small', 'ocolus' ),
								'medium_h' => esc_html__( 'Medium Horizontal', 'ocolus' ),
								'medium_v' => esc_html__( 'Medium Vertical', 'ocolus' ),
								'large'    => esc_html__( 'Large', 'ocolus' ),
							),
							'default' => 'large',
						),
						array(
							'id'    => 'gallery',
							'type'  => 'gallery',
							'title' => esc_html__( 'Gallery Portfolio', 'ocolus' ),
						),
					),
				),
			),
		);
		$sections[] = array(
			'id'        => '_custom_post_side_options',
			'title'     => esc_html__( 'Post Size for Blog Page', 'ocolus' ),
			'post_type' => 'post',
			'context'   => 'side',
			'priority'  => 'default',
			'sections'  => array(
				array(
					'name'   => 'post_option',
					'fields' => array(
						array(
							'id'      => 'post_size',
							'type'    => 'select',
							'title'   => esc_html__( 'Post Size for Blog Metro', 'ocolus' ),
							'options' => array(
								'small'    => esc_html__( 'Small', 'ocolus' ),
								'medium_h' => esc_html__( 'Medium Horizontal', 'ocolus' ),
								'medium_v' => esc_html__( 'Medium Vertical', 'ocolus' ),
								'large'    => esc_html__( 'Large', 'ocolus' ),
							),
							'default' => 'small',
						),
						array(
							'id'      => 'post_size_masonry',
							'type'    => 'select',
							'title'   => esc_html__( 'Post Size for Blog Masonry', 'ocolus' ),
							'options' => array(
								'small'  => esc_html__( 'Small', 'ocolus' ),
								'medium' => esc_html__( 'Medium', 'ocolus' ),
							),
							'default' => 'small',
						),
						array(
							'id'      => 'post_size_split',
							'type'    => 'select',
							'title'   => esc_html__( 'Post Size for Blog Split', 'ocolus' ),
							'options' => array(
								'small'    => esc_html__( 'Small', 'ocolus' ),
								'medium_h' => esc_html__( 'Medium Horizontal', 'ocolus' ),
								'medium_v' => esc_html__( 'Medium Vertical', 'ocolus' ),
								'large'    => esc_html__( 'Large', 'ocolus' ),
							),
							'default' => 'small',
						),
					),
				),
			),
		);
		$sections[] = array(
			'id'        => '_custom_page_side_options',
			'title'     => esc_html__( 'Custom Page Side Options', 'ocolus' ),
			'post_type' => 'page',
			'context'   => 'side',
			'priority'  => 'high',
			'sections'  => array(
				array(
					'name'   => 'page_option',
					'fields' => array(
						array(
							'id'             => 'content_mobile',
							'type'           => 'select',
							'title'          => esc_html__( 'Content Mobile', 'ocolus' ),
							'options'        => 'page',
							'default_option' => esc_html__( 'Select Content', 'ocolus' ),
							'desc'           => esc_html__( 'Need enable version mobile.', 'ocolus' ),
						),
						array(
							'id'      => 'page_main_container',
							'type'    => 'select',
							'title'   => esc_html__( 'Main Container Custom Width', 'ocolus' ),
							'options' => array(
								''                         => esc_html__( 'Default - 1140', 'ocolus' ),
								'page_main_container_1400' => esc_html__( 'Custom - 1400', 'ocolus' ),
								'page_main_container_1640' => esc_html__( 'Custom - 1640', 'ocolus' ),
							),
							'default' => '',
						),
						array(
							'id'    => 'disable_page_title',
							'type'  => 'switcher',
							'title' => esc_html__( 'Disable Page Title', 'ocolus' ),
						),
						array(
							'id'         => 'sidebar_page_layout',
							'type'       => 'image_select',
							'title'      => esc_html__( 'Single Page Sidebar Position', 'ocolus' ),
							'desc'       => esc_html__( 'Select sidebar position on Page.', 'ocolus' ),
							'options'    => array(
								'left'  => get_theme_file_uri( 'assets/images/left-sidebar.png' ),
								'right' => get_theme_file_uri( 'assets/images/right-sidebar.png' ),
								'full'  => get_theme_file_uri( 'assets/images/no-sidebar.png' ),
							),
							'default'    => 'left',
							'attributes' => array(
								'data-depend-id' => 'sidebar_page_layout',
							),
						),
						array(
							'id'         => 'page_sidebar',
							'type'       => 'select',
							'title'      => esc_html__( 'Page Sidebar', 'ocolus' ),
							'options'    => ocolus_sidebar_options(),
							'dependency' => array( 'sidebar_page_layout', '!=', 'full' ),
						),
						array(
							'id'    => 'page_extra_class',
							'type'  => 'text',
							'title' => esc_html__( 'Extra Class', 'ocolus' ),
						),
					),
				),
			),
		);
		// -----------------------------------------
		// Product Meta box Options                -
		// -----------------------------------------
		if ( class_exists( 'WooCommerce' ) ) {
			$sections[] = array(
				'id'        => '_custom_product_side_options',
				'title'     => esc_html__( 'Meta Product Options', 'ocolus' ),
				'post_type' => 'product',
				'context'   => 'normal',
				'priority'  => 'high',
				'sections'  => array(
					array(
						'name'   => 'product_option',
						'fields' => array(
							array(
								'id'      => 'image_isotope',
								'type'    => 'radio',
								'title'   => esc_html__( 'Ratio isotope', 'ocolus' ),
								'options' => array(
									'1x1' => esc_html__( '1:1', 'ocolus' ),
									'1x2' => esc_html__( '1:2', 'ocolus' ),
									'2x1' => esc_html__( '2:1', 'ocolus' ),
									'2x2' => esc_html__( '2:2', 'ocolus' ),
								),
								'default' => '1x1',
								'class'   => 'horizontal',
							),
							array(
								'id'       => 'product_video',
								'type'     => 'upload',
								'title'    => esc_html__( 'Product Video', 'ocolus' ),
								'settings' => array(
									'upload_type'  => 'video',
									'button_title' => esc_html__( 'Upload Video', 'ocolus' ),
									'frame_title'  => esc_html__( 'Choose a Video', 'ocolus' ),
									'insert_title' => esc_html__( 'Use This Video', 'ocolus' ),
								),
								'desc'     => esc_html__( 'Find Video in this site or using url.', 'ocolus' ),
							),
							array(
								'id'          => 'product_360degree',
								'type'        => 'gallery',
								'title'       => esc_html__( 'Gallery 360 Degree', 'ocolus' ),
								'add_title'   => esc_html__( 'Add Images', 'ocolus' ),
								'edit_title'  => esc_html__( 'Edit Images', 'ocolus' ),
								'clear_title' => esc_html__( 'Remove Images', 'ocolus' ),
							),
						),
					),
				),
			);
		}
		// -----------------------------------------
		// Page Meta box Options                   -
		// -----------------------------------------
		$sections[] = array(
			'id'        => '_custom_metabox_theme_options',
			'title'     => esc_html__( 'Custom Theme Options', 'ocolus' ),
			'post_type' => 'page',
			'context'   => 'normal',
			'priority'  => 'high',
			'sections'  => array(
				'options' => array(
					'name'   => 'options',
					'title'  => esc_html__( 'Theme Settings', 'ocolus' ),
					'icon'   => 'fa fa-wordpress',
					'fields' => array(
						'metabox_logo'             => array(
							'id'    => 'metabox_logo',
							'type'  => 'image',
							'title' => esc_html__( 'Logo', 'ocolus' ),
							'desc'  => esc_html__( 'Setting Logo For Site', 'ocolus' ),
						),
						'metabox_site_background'  => array(
							'id'    => 'metabox_site_background',
							'type'  => 'background',
							'title' => esc_html__( 'Site Background', 'ocolus' ),
							'desc'  => esc_html__( 'Setting Background For Site', 'ocolus' ),
						),
						'metabox_main_color'       => array(
							'id'      => 'metabox_main_color',
							'type'    => 'color_picker',
							'rgba'    => true,
							'default' => '#293341',
							'title'   => esc_html__( 'Main Color 1', 'ocolus' ),
						),
						'metabox_main_color_hover' => array(
							'id'      => 'metabox_main_color_hover',
							'type'    => 'color_picker',
							'rgba'    => true,
							'default' => '#c91f28',
							'title'   => esc_html__( 'Main Color 2', 'ocolus' ),
						),
					),
				),
				'header'  => array(
					'name'   => 'header',
					'title'  => esc_html__( 'Header Settings', 'ocolus' ),
					'icon'   => 'fa fa-folder-open-o',
					'fields' => array(
						'metabox_header_top_menu'    => array(
							'id'             => 'metabox_header_top_menu',
							'type'           => 'select',
							'title'          => esc_html__( 'Header Sub 01', 'ocolus' ),
							'options'        => ocolus_wordpress_menus( 'slug' ),
							'default_option' => esc_html__( 'Select a Menu', 'ocolus' ),
							'dependency'     => array(
								'metabox_header_template',
								'any',
								'style-01,style-04,style-05,style-07,style-08,style-09,style-11,style-12,style-13,style-14,style-16,style-18,style-19,style-22,style-23,style-24',
							),
						),
						'metabox_header_second_menu' => array(
							'id'             => 'metabox_header_second_menu',
							'type'           => 'select',
							'title'          => esc_html__( 'Header Sub 02', 'ocolus' ),
							'options'        => ocolus_wordpress_menus( 'slug' ),
							'default_option' => esc_html__( 'Select a Menu', 'ocolus' ),
							'dependency'     => array(
								'metabox_header_template',
								'any',
								'style-07,style-12,style-18,style-22',
							),
						),
						'metabox_header_sidebar'     => array(
							'id'         => 'metabox_header_sidebar',
							'type'       => 'select',
							'default'    => 'header-widget-area',
							'title'      => esc_html__( 'Header Sidebar', 'ocolus' ),
							'options'    => ocolus_sidebar_options(),
							'dependency' => array(
								'metabox_header_template',
								'any',
								'style-08,style-21',
							),
						),
						'metabox_header_template'    => array(
							'id'         => 'metabox_header_template',
							'type'       => 'select_preview',
							'options'    => ocolus_file_options( '/templates/header/', 'header' ),
							'default'    => 'style-05',
							'attributes' => array(
								'data-depend-id' => 'metabox_header_template',
							),
						),
						'metabox_header_banner'      => array(
							'id'         => 'metabox_header_banner',
							'type'       => 'image',
							'title'      => esc_html__( 'Header Banner', 'ocolus' ),
							'dependency' => array(
								'metabox_header_template',
								'any',
								'style-18,style-19',
							),
						),
						'metabox_header_banner_url'  => array(
							'id'         => 'metabox_header_banner_url',
							'type'       => 'text',
							'title'      => esc_html__( 'Banner Url', 'ocolus' ),
							'dependency' => array(
								'metabox_header_template',
								'any',
								'style-18,style-19',
							),
							'default'    => '#',
						),
						'metabox_header_social'      => array(
							'id'         => 'metabox_header_social',
							'type'       => 'select',
							'title'      => esc_html__( 'Header Social', 'ocolus' ),
							'options'    => ocolus_social_option(),
							'class'      => 'chosen',
							'attributes' => array(
								'multiple' => true,
								'style'    => 'width:100%',
							),
							'dependency' => array(
								'metabox_header_template',
								'any',
								'style-01,style-12,style-16,style-20,style-21,style-23',
							),
						),
						'metabox_header_slide'       => array(
							'id'         => 'metabox_header_slide',
							'type'       => 'select',
							'title'      => esc_html__( 'Header Slide', 'ocolus' ),
							'options'    => ocolus_rev_slide_options(),
							'dependency' => array(
								'metabox_header_template',
								'any',
								'style-04,style-20',
							),
						),
						'metabox_header_text'        => array(
							'id'         => 'metabox_header_text',
							'type'       => 'textarea',
							'title'      => esc_html__( 'Header Text', 'ocolus' ),
							'default'    => '',
							'dependency' => array(
								'metabox_header_template',
								'any',
								'style-14,style-19,style-21,style-23,style-24',
							),
						),
					),
				),
				'footer'  => array(
					'name'   => 'footer',
					'title'  => esc_html__( 'Footer Settings', 'ocolus' ),
					'icon'   => 'fa fa-folder-open-o',
					'fields' => array(
						array(
							'id'      => 'metabox_footer_template',
							'type'    => 'select_preview',
							'default' => 'footer-05',
							'options' => ocolus_footer_preview(),
						),
					),
				),
			),
		);

		return apply_filters( 'ocolus_metabox_options', $sections );
	}
}