<?php
/**
 * Class plugin load.
 */
require_once get_parent_theme_file_path( '/framework/classes/class-tgm-plugin-activation.php' );
if ( !defined( 'ABSPATH' ) ) {
	exit;
}
if ( !function_exists( 'ocolus_plugin_load' ) && function_exists( 'tgmpa' ) ) {
	function ocolus_plugin_load()
	{
		/*
		 * Array of plugin arrays. Required keys are name and slug.
		 * If the source is NOT from the .org repo, then source is also required.
		 */
		$plugins = array(
			array(
				'name'         => 'Ocolus Toolkit', // The plugin name
				'slug'         => 'ocolus-toolkit', // The plugin slug (typically the folder name)
				'source'       => esc_url( 'https://plugins.kutethemes.net/ocolus-toolkit.zip' ), // The plugin source
				'required'     => true, // If false, the plugin is only 'recommended' instead of required
				'version'      => '1.3.0',
				'external_url' => '', // If set, overrides default API URL and points to an external URL
			),
			array(
				'name'     => 'Revolution Slider', // The plugin name
				'slug'     => 'revslider', // The plugin slug (typically the folder name)
				'version'  => '6.2.22',
				'source'   => esc_url( 'https://plugins.kutethemes.net/revslider.zip' ), // The plugin source
				'required' => true, // If false, the plugin is only 'recommended' instead of required
			),
			array(
				'name'     => 'WPBakery Visual Composer', // The plugin name
				'slug'     => 'js_composer', // The plugin slug (typically the folder name)
				'version'  => '6.3',
				'source'   => esc_url( 'https://plugins.kutethemes.net/js_composer.zip' ), // The plugin source
				'required' => true, // If false, the plugin is only 'recommended' instead of required
			),
			array(
				'name'     => 'WooCommerce',
				'slug'     => 'woocommerce',
				'required' => true, // If false, the plugin is only 'recommended' instead of required
			),
			array(
				'name' => 'YITH WooCommerce Compare',
				'slug' => 'yith-woocommerce-compare',
			),
			array(
				'name' => 'YITH WooCommerce Wishlist', // The plugin name
				'slug' => 'yith-woocommerce-wishlist', // The plugin slug (typically the folder name)
			),
			array(
				'name' => 'YITH WooCommerce Quick View', // The plugin name
				'slug' => 'yith-woocommerce-quick-view', // The plugin slug (typically the folder name)
			),
			array(
				'name' => 'Contact Form 7',
				'slug' => 'contact-form-7',
			),
			array(
				'name' => 'Woo Advanced Product Size Chart',
				'slug' => 'woo-advanced-product-size-chart',
			),
			array(
				'name' => 'Super Socializer',
				'slug' => 'super-socializer',
			),
			array(
				'name' => 'WC Marketplace',
				'slug' => 'dc-woocommerce-multi-vendor',
			),
			array(
				'name' => 'Child Theme Configurator',
				'slug' => 'child-theme-configurator',
			),
			array(
				'name' => 'Mailchimp for WordPress',
				'slug' => 'mailchimp-for-wp',
			),
			array(
				'name' => 'Instagram Shop',
				'slug' => 'instashop',
			),
		);
		/*
		 * Array of configuration settings. Amend each line as needed.
		 *
		 * TGMPA will start providing localized text strings soon. If you already have translations of our standard
		 * strings available, please help us make TGMPA even better by giving us access to these translations or by
		 * sending in a pull-request with .po file(s) with the translations.
		 *
		 * Only uncomment the strings in the config array if you want to customize the strings.
		 */
		$config = array(
			'id'           => 'ocolus_plugins',        // Unique ID for hashing notices for multiple instances of TGMPA.
			'default_path' => '',                      // Default absolute path to bundled plugins.
			'menu'         => 'ocolus-install-plugins',// Menu slug.
			'parent_slug'  => 'themes.php',      	   // Parent menu slug.
			'capability'   => 'edit_theme_options',    // Capability needed to view plugin install page, should be a capability associated with the parent menu used.
			'has_notices'  => true,                    // Show admin notices or not.
			'dismissable'  => true,                    // If false, a user cannot dismiss the nag message.
			'dismiss_msg'  => '',                      // If 'dismissable' is false, this message will be output at top of nag.
			'is_automatic' => true,                   // Automatically activate plugins after installation or not.
			'message'      => '',                      // Message to output right before the plugins table.
		);
		tgmpa( $plugins, $config );
	}

	add_action( 'tgmpa_register', 'ocolus_plugin_load' );
}
