<?php if (!defined('ABSPATH')) {
    die;
} // Cannot access pages directly.
/**
 *
 * HOOK ACTION
 **/
if (!is_admin()) {
    add_filter('post_thumbnail_html', 'ocolus_post_thumbnail_html', 10, 5);
    add_filter('vc_wpb_getimagesize', 'ocolus_vc_wpb_getimagesize', 10, 3);
    add_filter('wp_kses_allowed_html', 'ocolus_wp_kses_allowed_html', 10, 2);
    add_filter('wp_get_attachment_image_attributes', 'ocolus_lazy_attachment_image', 10, 3);
}
add_action('pre_get_posts', 'ocolus_pre_get_posts');
add_filter('dokan_product_image_attributes', 'ocolus_dokan_image_attributes', 10, 3);
/**
 *
 * VERSION MOBILE OPTION
 **/
if (!function_exists('ocolus_is_mobile')) {
    function ocolus_is_mobile($mobile_enable = false)
    {
        $is_mobile = false;
        $detect    = new Mobile_Detect();

        if (!$mobile_enable) {
            $mobile_enable = ocolus_get_option('mobile_enable');
        }
        if (class_exists('WP_Rocket_Mobile_Detect')) {
            $detect = new \WP_Rocket_Mobile_Detect();
        }
        if (($detect->isMobile() || $detect->isTablet()) && $mobile_enable == 1) {
            $is_mobile = true;
        }

        return $is_mobile;
    }
}
if (!function_exists('ocolus_pre_get_posts')) {
    function ocolus_pre_get_posts($query)
    {
        if (is_admin()) {
            return $query;
        }
        if ($query->is_main_query()) {
            $match             = array(
                'full_screen',
                'grid_full_width',
                'list_v2',
                'split',
            );
            $sticky            = get_option('sticky_posts');
            $post_style        = ocolus_get_option('blog_list_style', 'list_v1');
            $post_perpage      = ocolus_get_option('blog_post_perpage', '');
            $portfolio_perpage = ocolus_get_option('portfolio_perpage', '');
            if (is_home()) {
                // remove sticky post
                if (in_array($post_style, $match) && !empty($sticky)) {
                    $query->set('post__not_in', $sticky);
                }
                // post per page
                if (!empty($post_perpage)) {
                    $query->set('posts_per_page', $post_perpage);
                }
                // Default homepage or blog Archive
                $page_id = get_option('page_for_posts');
            } elseif (!is_single() && !empty($query->query_vars['page_id'])) {
                // static homepage aka front page
                $page_id = $query->query_vars['page_id'];
            } else {
                //everything else
                $page_id = get_queried_object_id();
            }

            // portfolio per page
            if (!empty($portfolio_perpage) && (is_post_type_archive('portfolio') || is_tax('portfolio-category'))) {
                $query->set('posts_per_page', $portfolio_perpage);
            }
            /* USE PAGE ID */
            if (is_single()) {
                ocolus_set_post_views($page_id);
            }
            if (is_page() && ocolus_is_mobile()) {
                $page_meta = get_post_meta($page_id, '_custom_page_side_options', true);
                if (!empty($page_meta['content_mobile'])) {
                    $query->set('page_id', $page_meta['content_mobile']);
                }
            }
        }

        return $query;
    }
}
/**
 *
 * GET OPTION
 **/
if (!function_exists('ocolus_get_option')) {
    function ocolus_get_option($option_name = '', $default = '')
    {
        {
            $cs_option = array();
            if (get_option('_ovic_customize_options') !== false) {
                $cs_option = get_option('_ovic_customize_options');
            }
            if (isset($_GET[$option_name])) {
                $default                 = $_GET[$option_name];
                $cs_option[$option_name] = $_GET[$option_name];
            }
            if (isset($cs_option['mobile_enable']) && ocolus_is_mobile($cs_option['mobile_enable']) && isset($cs_option["mobile_{$option_name}"])) {
                $option_name = "mobile_{$option_name}";
            }
            $options = apply_filters('ocolus_get_customize_option', $cs_option, $option_name, $default);
            if (!empty($options) && isset($options[$option_name])) {
                $option = $options[$option_name];
                if (is_array($option) && isset($option['multilang']) && $option['multilang'] == true) {
                    if (defined('ICL_LANGUAGE_CODE')) {
                        if (isset($option[ICL_LANGUAGE_CODE])) {
                            return $option[ICL_LANGUAGE_CODE];
                        }
                    } else {
                        $option = reset($option);
                    }
                }

                return $option;
            } else {
                return $default;
            }
        }
    }
}
if (!function_exists('ocolus_theme_option_meta')) {
    function ocolus_theme_option_meta($meta_id, $option_key, $key_meta = '', $default = '')
    {
        if ($option_key == null) {
            $enable_options = 1;
            $theme_options  = $default;
        } else {
            $enable_options = ocolus_get_option('enable_theme_options');
            $theme_options  = ocolus_get_option($option_key, $default);
        }
        if ($key_meta == '') {
            $key_meta = "metabox_{$option_key}";
        }
        $data_meta = get_post_meta(get_the_ID(), $meta_id, true);
        if ($enable_options == 1 && isset($data_meta[$key_meta])) {
            $theme_options = $data_meta[$key_meta];
        }
        if ($default != '' && $theme_options == '') {
            $theme_options = $default;
        }

        return $theme_options;
    }
}
if (!function_exists('ocolus_get_logo')) {
    function ocolus_get_logo()
    {
        $logo_url  = get_theme_file_uri('/assets/images/logo.png');
        $logo      = ocolus_get_option('logo');
        $data_meta = get_post_meta(get_the_ID(), '_custom_metabox_theme_options', true);
        if (isset($data_meta['metabox_logo']) && $data_meta['metabox_logo'] != '') {
            $logo = $data_meta['metabox_logo'];
        }
        if ($logo != '') {
            $logo_url = wp_get_attachment_image_url($logo, 'full');
            $html     = '<a href="'.esc_url(home_url('/')).'"><img alt="'.esc_attr(get_bloginfo('name')).'" src="'.esc_url($logo_url).'" class="_rw" /></a>';
        } else {
            $html = '<a href="'.esc_url(home_url('/')).'" class="logo-text">'.esc_html__('ocolus', 'ocolus').'<span class="dot">.</span></a>';
        }
        echo apply_filters('ocolus_site_logo', $html);
    }
}
/**
 * Call a shortcode function by tag name.
 *
 * @param  string  $tag  The shortcode whose function to call.
 * @param  array  $atts  The attributes to pass to the shortcode function. Optional.
 * @param  array  $content  The shortcode's content. Default is null (none).
 *
 * @return string|bool False on failure, the result of the shortcode on success.
 * @since  1.4.6
 *
 */
if (!function_exists('ocolus_do_shortcode')) {
    function ocolus_do_shortcode($tag, array $atts = array(), $content = null)
    {
        global $shortcode_tags;
        if (!isset($shortcode_tags[$tag])) {
            return false;
        }

        return call_user_func($shortcode_tags[$tag], $atts, $content, $tag);
    }
}
if (!function_exists('ocolus_locate_template')) {
    function ocolus_locate_template($template_name, $template_path = '', $default_path = '')
    {
        if (!$template_path) {
            $template_path = get_template_directory();
        }
        if (!$default_path) {
            $default_path = get_template_directory();
        }
        // Look within passed path within the theme - this is priority.
        $template = locate_template(
            array(
                trailingslashit($template_path).$template_name,
                $template_name,
            )
        );
        // Get default template/.
        if (!$template) {
            $template = $default_path.$template_name;
        }

        // Return what we found.
        return apply_filters('ocolus_locate_template', $template, $template_name, $template_path);
    }
}
if (!function_exists('ocolus_get_template')) {
    function ocolus_get_template($template_name, $args = array(), $template_path = '', $default_path = '')
    {
        if (!empty($args) && is_array($args)) {
            extract($args); // @codingStandardsIgnoreLine
        }
        $located = ocolus_locate_template($template_name, $template_path, $default_path);
        if (!file_exists($located)) {
            return;
        }
        // Allow 3rd party plugin filter template file from their plugin.
        $located = apply_filters('ocolus_get_template', $located, $template_name, $args, $template_path, $default_path);
        do_action('ocolus_before_template_part', $template_name, $template_path, $located, $args);
        include $located;
        do_action('ocolus_after_template_part', $template_name, $template_path, $located, $args);
    }
}
/**
 *
 * QUERY POSTS
 **/
if (!function_exists('ocolus_shortcode_posts_query')) {
    function ocolus_shortcode_posts_query($atts, $post_type = 'post')
    {
        $args = array(
            'post_type'           => $post_type,
            'post_status'         => 'publish',
            'ignore_sticky_posts' => 1,
            'suppress_filter'     => true,
            'orderby'             => $atts['orderby'],
            'order'               => $atts['order'],
        );
        if ($atts['target'] == 'popularity') {
            $args_loop['meta_key'] = 'ocolus_post_views_count';
            $args_loop['orderby']  = 'meta_value_num';
        }
        if ($atts['target'] == 'post') {
            $args['post__in']       = explode(',', $atts['ids']);
            $args['posts_per_page'] = -1;
        } else {
            $args['posts_per_page'] = $atts['limit'];
            if ($atts['category'] != '') {
                $args['category_name'] = $atts['category'];
            }
        }

        return $args;
    }
}
/**
 *
 * QUERY PRODUCTS
 **/
if (!function_exists('ocolus_shortcode_products_query')) {
    function ocolus_shortcode_products_query($atts, $exclude_id = false)
    {
        /* QUERY DATA PRODUCTS */
        if (isset($atts['filter']) && $atts['filter'] && $atts['attribute'] != '') {
            $atts['terms'] = $atts['filter'];
        }
        add_filter('woocommerce_shortcode_products_query',
            function ($query_args) use ($atts, $exclude_id) {
                if (isset($atts['category_brand']) && $atts['category_brand'] && $atts['category_brand'] != '') {
                    $query_args['tax_query'][] = array(
                        'taxonomy' => 'product_brand',
                        'terms'    => array_map('sanitize_title', explode(',', $atts['category_brand'])),
                        'field'    => 'slug',
                        'operator' => 'IN',
                    );
                }
                if (isset($atts['vendor_list']) && $atts['vendor_list'] != '' && function_exists('wcmp_plugin_init')) {
                    global $WCMp;
                    $term_id                   = get_user_meta($atts['vendor_list'], '_vendor_term_id', true);
                    $query_args['tax_query'][] = array(
                        'taxonomy' => $WCMp->taxonomy->taxonomy_name,
                        'field'    => 'term_id',
                        'terms'    => $term_id,
                    );
                }
                if ($exclude_id) {
                    if ($atts['ids'] != '') {
                        $exclude_id             = array_diff($query_args['post__in'], (array) $exclude_id);
                        $query_args['post__in'] = !empty($exclude_id) ? $exclude_id : array('');
                    } else {
                        $query_args['post__not_in'] = (array) $exclude_id;
                    }
                }

                return $query_args;
            }
        );
        $args = array(
            'limit'     => '-1',      // Results limit.
            'columns'   => '',        // Number of columns.
            'orderby'   => 'title',   // menu_order, title, date, rand, price, popularity, rating, or id.
            'order'     => 'ASC',     // ASC or DESC.
            'ids'       => '',        // Comma separated IDs.
            'skus'      => '',        // Comma separated SKUs.
            'category'  => '',        // Comma separated category slugs or ids.
            'attribute' => '',        // Single attribute slug.
            'terms'     => '',        // Comma separated term slugs or ids.
            'class'     => '',        // HTML class.
            'page'      => '1',
            'paginate'  => true,
        );
        foreach ($args as $key => $shortcode) {
            if (isset($atts[$key]) && $atts[$key] != '') {
                $args[$key] = $atts[$key];
            }
        }

        return $args;
    }
}
/**
 *
 * RESIZE IMAGE
 * svg: <svg xmlns="http://www.w3.org/2000/svg" width="100" height="100" viewBox="0 0 100 100"></svg>
 **/
if (!function_exists('ocolus_dokan_image_attributes')) {
    function ocolus_dokan_image_attributes($image_attributes)
    {
        $image_attributes['img']['data-src'] = array();

        return $image_attributes;
    }
}
if (!function_exists('ocolus_wp_kses_allowed_html')) {
    function ocolus_wp_kses_allowed_html($allowedposttags, $context)
    {
        $allowedposttags['img']['data-src']    = true;
        $allowedposttags['img']['data-srcset'] = true;
        $allowedposttags['img']['data-sizes']  = true;

        return $allowedposttags;
    }
}
if (!function_exists('ocolus_lazy_attachment_image')) {
    function ocolus_lazy_attachment_image($attr, $attachment, $size)
    {
        $enable_lazy = ocolus_get_option('theme_lazy_load');
        $image_size  = apply_filters('woocommerce_gallery_image_size', 'woocommerce_single');
        if ($size == $image_size && class_exists('WooCommerce')) {
            if (is_product()) {
                $enable_lazy = 0;
            }
        }
        if ($enable_lazy == 1) {
            list($url, $width, $height) = wp_get_attachment_image_src($attachment->ID, $size);
            $attr['data-src'] = $attr['src'];
            $attr['src']      = "data:image/svg+xml;charset=utf-8,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%22{$width}%22%20height%3D%22{$height}%22%20viewBox%3D%220%200%20{$width}%20{$height}%22%3E%3C%2Fsvg%3E";
            $attr['class']    .= ' lazy';
            if (isset($attr['srcset']) && $attr['srcset'] != '') {
                $attr['data-srcset'] = $attr['srcset'];
                $attr['data-sizes']  = $attr['sizes'];
                unset($attr['srcset']);
                unset($attr['sizes']);
            }
        }

        return $attr;
    }
}
if (!function_exists('ocolus_post_thumbnail_html')) {
    function ocolus_post_thumbnail_html($html, $post_ID, $post_thumbnail_id, $size, $attr)
    {
        $enable_lazy = ocolus_get_option('theme_lazy_load');
        if ($enable_lazy == 1) {
            $html = '<figure>'.$html.'</figure>';
        }

        return $html;
    }
}
if (!function_exists('ocolus_vc_wpb_getimagesize')) {
    function ocolus_vc_wpb_getimagesize($img, $attach_id, $params)
    {
        $enable_lazy = ocolus_get_option('theme_lazy_load');
        if ($enable_lazy == 1) {
            $img['thumbnail'] = '<figure>'.$img['thumbnail'].'</figure>';
        }

        return $img;
    }
}
if (!function_exists('ocolus_get_attachment_image')) {
    function ocolus_get_attachment_image($attachment_id, $src, $width, $height, $lazy, $class, $image_src)
    {
        $image      = '';
        $full_image = array(
            'url'    => '',
            'width'  => '',
            'height' => '',
            'img'    => '',
        );
        $img_lazy   = "data:image/svg+xml;charset=utf-8,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%22{$width}%22%20height%3D%22{$height}%22%20viewBox%3D%220%200%20{$width}%20{$height}%22%3E%3C%2Fsvg%3E";
        if ($src) {
            $hwstring   = image_hwstring($width, $height);
            $size_class = $width.'x'.$height;
            $attachment = get_post($attachment_id);
            $alt        = trim(strip_tags(get_post_meta($attachment_id, '_wp_attachment_image_alt', true)));
            if ($alt == '') {
                $alt = $attachment->post_title;
            }
            $attr = array(
                'src'   => $src,
                'class' => "attachment-$size_class size-$size_class",
                'alt'   => $alt,
            );
            if ($class != '') {
                $attr['class'] .= " $class";
            }
            if ($lazy == true) {
                $attr['src']      = $img_lazy;
                $attr['data-src'] = $src;
                $attr['class']    .= ' lazy';
            }
            $attr  = apply_filters('ocolus_get_attachment_image_attributes', $attr, $attachment);
            $attr  = array_map('esc_attr', $attr);
            $image = rtrim("<img $hwstring");
            foreach ($attr as $name => $value) {
                $image .= " $name=".'"'.$value.'"';
            }
            $image .= ' />';
        }
        if (!empty($image_src)) {
            list($full_src, $full_width, $full_height) = $image_src;
            $full_image = ocolus_get_attachment_image($attachment_id, $full_src, $full_width, $full_height, $lazy, $class, array());
        }

        return array(
            'url'         => $src,
            'width'       => $width,
            'height'      => $height,
            'img'         => $image,
            'full_url'    => $full_image['url'],
            'full_width'  => $full_image['width'],
            'full_height' => $full_image['height'],
            'full_img'    => $full_image['img'],
        );
    }
}
if (!function_exists('ocolus_resize_image')) {
    function ocolus_resize_image($attachment_id, $width, $height, $crop = false, $use_lazy = false, $placeholder = true, $class = '')
    {
        $actual_file_path = '';
        $original         = false;
        $image_src        = array();
        $enable_lazy      = ocolus_get_option('theme_lazy_load');
        $disable_crop     = ocolus_get_option('theme_crop_image');
        if ($enable_lazy != 1 && $use_lazy == true) {
            $use_lazy = false;
        }
        if ($crop == true && $disable_crop == 1) {
            $crop = false;
        }
        if ($width == false && $height == false) {
            $original = true;
        }
        if ($attachment_id) {
            $image_src        = wp_get_attachment_image_src($attachment_id, 'full');
            $actual_file_path = get_attached_file($attachment_id);
            // this is not an attachment, let's use the image url
        }
        if (!empty($actual_file_path)) {
            $file_info = pathinfo($actual_file_path);
            $extension = '.'.$file_info['extension'];
            // the image path without the extension
            $no_ext_path      = $file_info['dirname'].'/'.$file_info['filename'];
            $cropped_img_path = $no_ext_path.'-'.$width.'x'.$height.$extension;
            // checking if the full size
            if ($original == true) {
                $vt_image = ocolus_get_attachment_image(
                    $attachment_id,
                    $image_src[0],
                    $image_src[1],
                    $image_src[2],
                    $use_lazy,
                    $class,
                    $image_src
                );

                return $vt_image;
            }
            // checking if the file size is larger than the target size
            // if it is smaller or the same size, stop right here and return
            if ($image_src[1] > $width || $image_src[2] > $height) {
                // the file is larger, check if the resized version already exists (for $crop = true but will also work for $crop = false if the sizes match)
                if (file_exists($cropped_img_path)) {
                    $cropped_img_url = str_replace(basename($image_src[0]), basename($cropped_img_path), $image_src[0]);
                    $vt_image        = ocolus_get_attachment_image(
                        $attachment_id,
                        $cropped_img_url,
                        $width,
                        $height,
                        $use_lazy,
                        $class,
                        $image_src
                    );

                    return $vt_image;
                }
                if (false == $crop) {
                    // calculate the size proportionaly
                    $proportional_size = wp_constrain_dimensions($image_src[1], $image_src[2], $width, $height);
                    $resized_img_path  = $no_ext_path.'-'.$proportional_size[0].'x'.$proportional_size[1].$extension;
                    // checking if the file already exists
                    if (file_exists($resized_img_path)) {
                        $resized_img_url = str_replace(basename($image_src[0]), basename($resized_img_path), $image_src[0]);
                        $vt_image        = ocolus_get_attachment_image(
                            $attachment_id,
                            $resized_img_url,
                            $proportional_size[0],
                            $proportional_size[1],
                            $use_lazy,
                            $class,
                            $image_src
                        );

                        return $vt_image;
                    }
                }
                // no cache files - let's finally resize it
                $img_editor = wp_get_image_editor($actual_file_path);
                if (is_wp_error($img_editor) || is_wp_error($img_editor->resize($width, $height, $crop))) {
                    $image_no_crop = wp_get_attachment_image_src($attachment_id, array($width, $height));
                    $vt_image      = ocolus_get_attachment_image(
                        $attachment_id,
                        $image_no_crop[0],
                        $image_no_crop[1],
                        $image_no_crop[2],
                        $use_lazy,
                        $class,
                        $image_src
                    );

                    return $vt_image;
                }
                $new_img_path = $img_editor->generate_filename();
                if (is_wp_error($img_editor->save($new_img_path))) {
                    $image_no_crop = wp_get_attachment_image_src($attachment_id, array($width, $height));
                    $vt_image      = ocolus_get_attachment_image(
                        $attachment_id,
                        $image_no_crop[0],
                        $image_no_crop[1],
                        $image_no_crop[2],
                        $use_lazy,
                        $class,
                        $image_src
                    );

                    return $vt_image;
                }
                if (!is_string($new_img_path)) {
                    $image_no_crop = wp_get_attachment_image_src($attachment_id, array($width, $height));
                    $vt_image      = ocolus_get_attachment_image(
                        $attachment_id,
                        $image_no_crop[0],
                        $image_no_crop[1],
                        $image_no_crop[2],
                        $use_lazy,
                        $class,
                        $image_src
                    );

                    return $vt_image;
                }
                $new_img_size = getimagesize($new_img_path);
                $new_img      = str_replace(basename($image_src[0]), basename($new_img_path), $image_src[0]);
                // resized output
                $vt_image = ocolus_get_attachment_image(
                    $attachment_id,
                    $new_img,
                    $new_img_size[0],
                    $new_img_size[1],
                    $use_lazy,
                    $class,
                    $image_src
                );

                return $vt_image;
            }
            // default output - without resizing
            $image_no_crop = wp_get_attachment_image_src($attachment_id, array($width, $height));
            $vt_image      = ocolus_get_attachment_image(
                $attachment_id,
                $image_no_crop[0],
                $image_no_crop[1],
                $image_no_crop[2],
                $use_lazy,
                $class,
                $image_src
            );

            return $vt_image;
        }
        $placeholder_option = ocolus_get_option('placeholder_lazy');
        $placeholder_url    = !empty($placeholder_option) ? wp_get_attachment_image_url($placeholder_option, 'full') : "https://via.placeholder.com/{$width}x{$height}?text={$width}x{$height}";
        $placeholder_img    = array(
            'url'         => $placeholder_url,
            'width'       => $width,
            'height'      => $height,
            'img'         => "<img class='attachment-{$width}x{$height} size-{$width}x{$height} $class' src='$placeholder_url' ".image_hwstring($width, $height)." alt='placeholder'>",
            'full_url'    => $placeholder_url,
            'full_width'  => $width,
            'full_height' => $height,
            'full_img'    => "<img class='attachment-{$width}x{$height} size-{$width}x{$height} $class' src='$placeholder_url' ".image_hwstring($width, $height)." alt='placeholder'>",
        );
        if ($placeholder == false) {
            $placeholder_img = array(
                'url'         => '',
                'width'       => $width,
                'height'      => $height,
                'img'         => '',
                'full_url'    => '',
                'full_width'  => $width,
                'full_height' => $height,
                'full_img'    => '',
            );
        }

        return $placeholder_img;
    }
}
if (!function_exists('ocolus_grid_bootstrap')) {
    function ocolus_grid_bootstrap($prefix)
    {
        $classes   = array();
        $col_bg    = ocolus_get_option("{$prefix}_bg_items", 4) != 5 ? 12 / ocolus_get_option("{$prefix}_bg_items", 4) : 15;
        $col_xl    = ocolus_get_option("{$prefix}_lg_items", 3) != 5 ? 12 / ocolus_get_option("{$prefix}_lg_items", 3) : 15;
        $col_lg    = ocolus_get_option("{$prefix}_md_items", 3) != 5 ? 12 / ocolus_get_option("{$prefix}_md_items", 3) : 15;
        $col_md    = ocolus_get_option("{$prefix}_sm_items", 2) != 5 ? 12 / ocolus_get_option("{$prefix}_sm_items", 2) : 15;
        $col_sm    = ocolus_get_option("{$prefix}_xs_items", 2) != 5 ? 12 / ocolus_get_option("{$prefix}_xs_items", 2) : 15;
        $col_ts    = ocolus_get_option("{$prefix}_ts_items", 1) != 5 ? 12 / ocolus_get_option("{$prefix}_ts_items", 1) : 15;
        $classes[] = "col-bg-{$col_bg}";
        $classes[] = "col-lg-{$col_xl}";
        $classes[] = "col-md-{$col_lg}";
        $classes[] = "col-sm-{$col_md}";
        $classes[] = "col-xs-{$col_sm}";
        $classes[] = "col-ts-{$col_ts}";

        return implode(' ', array_map('esc_attr', $classes));
    }
}
/**
 *
 * GET OPTIONS
 **/
if (!function_exists('ocolus_file_options')) {
    function ocolus_file_options($path, $name)
    {
        $layoutDir      = get_template_directory().$path;
        $header_options = array();
        if (is_dir($layoutDir)) {
            $files = scandir($layoutDir);
            if ($files && is_array($files)) {
                foreach ($files as $file) {
                    if ($file != '.' && $file != '..' && $file != 'style') {
                        $fileInfo  = pathinfo($file);
                        $file_data = get_file_data($layoutDir.$file,
                            array(
                                'Name' => 'Name',
                            )
                        );
                        if (isset($fileInfo['extension']) && $fileInfo['extension'] == 'php' && $fileInfo['basename'] != 'index.php') {
                            if ($file_data['Name'] != '') {
                                $file_name = $file_data['Name'];
                            } else {
                                $file_name = str_replace(array('_', '-', 'content'), array(
                                    ' ',
                                    ' ',
                                    ''
                                ), $fileInfo['filename']);
                            }
                            $preview = get_theme_file_uri('/assets/images/placeholder.jpg');
                            $file_id = $name != '' ? str_replace("{$name}-", '', $fileInfo['filename']) : $fileInfo['filename'];
                            if (is_file(get_template_directory()."{$path}{$fileInfo['filename']}.jpg")) {
                                $preview = get_theme_file_uri("{$path}{$fileInfo['filename']}.jpg");
                            }
                            $header_options[$file_id] = array(
                                'title'   => ucwords($file_name),
                                'preview' => $preview,
                            );
                        }
                    }
                }
            }
        }

        return $header_options;
    }
}
if (!function_exists('ocolus_footer_preview')) {
    function ocolus_footer_preview()
    {
        $footer_preview = array(
            'none' => array(
                'title'   => esc_html__('None', 'ocolus'),
                'preview' => get_theme_file_uri('/assets/images/placeholder.jpg'),
            ),
        );
        $args           = array(
            'post_type'      => 'ovic_footer',
            'posts_per_page' => -1,
            'orderby'        => 'title',
            'order'          => 'ASC',
        );
        $posts          = get_posts($args);
        if (!empty($posts)) {
            foreach ($posts as $post) {
                setup_postdata($post);
                $preview = get_theme_file_uri('/assets/images/placeholder.jpg');
                if (has_post_thumbnail($post)) {
                    $preview = wp_get_attachment_image_url(get_post_thumbnail_id($post->ID), 'full');
                }
                $footer_preview[$post->post_name] = array(
                    'title'   => $post->post_title,
                    'preview' => $preview,
                );
            }
        }
        wp_reset_postdata();

        return $footer_preview;
    }
}
if (!function_exists('ocolus_pinmap_options')) {
    function ocolus_pinmap_options()
    {
        $args           = array(
            'post_type'      => 'ovic_pinmap',
            'posts_per_page' => -1,
            'post_status'    => 'publish',
        );
        $pinmap_options = array();
        $posts          = get_posts($args);
        if (!empty($posts)) {
            foreach ($posts as $post) {
                setup_postdata($post);
                $attachment_id             = get_post_meta($post->ID, 'ovic_pinmap_image', true);
                $pinmap_options[$post->ID] = array(
                    'title'   => $post->post_title,
                    'preview' => wp_get_attachment_image_url($attachment_id, 'medium'),
                );
            }
        }
        wp_reset_postdata();

        return $pinmap_options;
    }
}
if (!function_exists('ocolus_shop_coupon_options')) {
    function ocolus_shop_coupon_options()
    {
        $coupon_options = array();
        $coupons        = get_posts(
            array(
                'posts_per_page' => -1,
                'orderby'        => 'title',
                'order'          => 'asc',
                'post_type'      => 'shop_coupon',
                'post_status'    => 'publish',
            )
        );
        if (!empty($coupons)) {
            foreach ($coupons as $coupon) {
                $coupon_options[$coupon->ID] = $coupon->post_title;
            }
        }
        wp_reset_postdata();

        return $coupon_options;
    }
}
if (!function_exists('ocolus_social_option')) {
    function ocolus_social_option($reverse = false)
    {
        $socials     = array();
        $all_socials = ocolus_get_option('user_all_social');
        if (!empty($all_socials)) {
            foreach ($all_socials as $key => $social) {
                if ($reverse) {
                    $socials[$social['title_social']] = $key;
                } else {
                    $socials[$key] = $social['title_social'];
                }
            }
        }

        return $socials;
    }
}
if (!function_exists('ocolus_sidebar_options')) {
    function ocolus_sidebar_options()
    {
        $sidebars = array();
        global $wp_registered_sidebars;
        foreach ($wp_registered_sidebars as $sidebar) {
            $sidebars[$sidebar['id']] = $sidebar['name'];
        }

        return $sidebars;
    }
}
if (!function_exists('ocolus_product_options')) {
    function ocolus_product_options($allow = 'Theme Option')
    {
        $layoutDir       = get_template_directory().'/woocommerce/product-style/';
        $product_options = array();
        if (is_dir($layoutDir)) {
            $files = scandir($layoutDir);
            if ($files && is_array($files)) {
                foreach ($files as $file) {
                    if ($file != '.' && $file != '..') {
                        $fileInfo  = pathinfo($file);
                        $file_data = get_file_data($layoutDir.$file,
                            array(
                                'Name'         => 'Name',
                                'Theme Option' => 'Theme Option',
                                'Shortcode'    => 'Shortcode',
                            )
                        );
                        $file_name = str_replace('content-product-', '', $fileInfo['filename']);
                        if ($fileInfo['extension'] == 'php' && $fileInfo['basename'] != 'index.php' && $file_data[$allow] == 'true') {
                            $product_options[$file_name] = array(
                                'title'   => $file_data['Name'],
                                'preview' => get_theme_file_uri('woocommerce/product-style/content-product-'.$file_name.'.jpg'),
                            );
                        }
                    }
                }
            }
        }

        return $product_options;
    }
}
if (!function_exists('ocolus_attributes_options')) {
    function ocolus_attributes_options()
    {
        $attributes     = array();
        $attributes_tax = array();
        if (function_exists('wc_get_attribute_taxonomies')) {
            $attributes_tax = wc_get_attribute_taxonomies();
        }
        if (is_array($attributes_tax) && count($attributes_tax) > 0) {
            foreach ($attributes_tax as $attribute) {
                $attributes[$attribute->attribute_name] = $attribute->attribute_label;
            }
        }

        return $attributes;
    }
}
if (!function_exists('ocolus_page_layout')) {
    function ocolus_page_layout()
    {
        if (class_exists('WooCommerce') && is_woocommerce()) {
            $sidebar_layout = ocolus_get_option('sidebar_shop_layout', 'left');
            $sidebar_name   = ocolus_get_option('shop_used_sidebar', 'shop-widget-area');
            if (is_product_taxonomy() && 0 === absint(get_query_var('paged'))) {
                $term = get_queried_object();
                if ($term && $term->taxonomy == 'dc_vendor_shop') {
                    $sidebar_name = ocolus_get_option('shop_vendor_used_sidebar', 'vendor-widget-area');
                }
            }
            if (!is_active_sidebar($sidebar_name) || is_product()) {
                $sidebar_layout = 'full';
            }
        } elseif (function_exists('dokan_is_store_page') && dokan_is_store_page()) {
            $sidebar_name   = 'dokan-no-sidebar';
            $sidebar_layout = 'full';
        } elseif (is_page()) {
            $sidebar_name   = ocolus_theme_option_meta('_custom_page_side_options', null, 'page_sidebar', 'widget-area');
            $sidebar_layout = ocolus_theme_option_meta('_custom_page_side_options', null, 'sidebar_page_layout', 'left');
            if (!is_active_sidebar($sidebar_name)) {
                $sidebar_layout = 'full';
            }
        } else {
            $sidebar_layout = ocolus_get_option('sidebar_blog_layout', 'right');
            $sidebar_name   = ocolus_get_option('blog_used_sidebar', 'widget-area');
            if (is_single()) {
                $sidebar_layout = ocolus_get_option('sidebar_single_layout', 'right');
                $sidebar_name   = ocolus_get_option('single_used_sidebar', 'widget-area');
            }
            if (!is_active_sidebar($sidebar_name)) {
                $sidebar_layout = 'full';
            }
        }

        return array(
            'sidebar' => $sidebar_name,
            'layout'  => $sidebar_layout,
        );
    }
}
if (!function_exists('ocolus_share_social')) {
    function ocolus_share_social()
    {
        $share_image_url  = wp_get_attachment_image_url(get_post_thumbnail_id(get_the_ID()), 'full');
        $share_link_url   = get_permalink(get_the_ID());
        $share_link_title = get_the_title();
        $share_summary    = get_the_excerpt();
        $twitter          = 'https://twitter.com/share?url='.$share_link_url.'&text='.$share_summary;
        $facebook         = 'https://www.facebook.com/sharer.php?u='.$share_link_url;
        $google           = 'https://plus.google.com/share?url='.$share_link_url.'&title='.$share_link_title;
        $pinterest        = 'https://pinterest.com/pin/create/button/?url='.$share_link_url.'&description='.$share_summary.'&media='.$share_image_url;
        ?>
        <div class="ocolus-share-socials">
            <a class="twitter"
               href="<?php echo esc_url($twitter); ?>"
               title="<?php echo esc_attr__('Twitter', 'ocolus') ?>"
               onclick='window.open(this.href, "", "menubar=no,toolbar=no,resizable=yes,scrollbars=yes,height=600,width=600");return false;'>
                <i class="fa fa-twitter"></i>
            </a>
            <a class="facebook"
               href="<?php echo esc_url($facebook); ?>"
               title="<?php echo esc_attr__('Facebook', 'ocolus') ?>"
               onclick='window.open(this.href, "", "menubar=no,toolbar=no,resizable=yes,scrollbars=yes,height=600,width=600");return false;'>
                <i class="fa fa-facebook"></i>
            </a>
            <a class="googleplus"
               href="<?php echo esc_url($google); ?>"
               title="<?php echo esc_attr__('Google+', 'ocolus') ?>"
               onclick='window.open(this.href, "", "menubar=no,toolbar=no,resizable=yes,scrollbars=yes,height=600,width=600");return false;'>
                <i class="fa fa-google"></i>
            </a>
            <a class="pinterest"
               href="<?php echo esc_url($pinterest); ?>"
               title="<?php echo esc_attr__('Pinterest', 'ocolus') ?>"
               onclick='window.open(this.href, "", "menubar=no,toolbar=no,resizable=yes,scrollbars=yes,height=600,width=600");return false;'>
                <i class="fa fa-pinterest"></i>
            </a>
            <?php do_action('ocolus_add_share_button'); ?>
        </div>
        <?php
    }
}
if (!function_exists('ocolus_rev_slide_options')) {
    function ocolus_rev_slide_options()
    {
        $arrOutput     = array();
        $arrOutput[''] = esc_html__('--- Choose Revolution Slider ---', 'ocolus');
        if (class_exists('RevSlider')) {
            $slider     = new RevSlider();
            $arrSliders = $slider->getArrSliders();
            if (!empty($arrSliders)) {
                foreach ($arrSliders as $slider) {
                    $arrOutput[$slider->getAlias()] = $slider->getTitle();
                }
            } else {
                $arrOutput = array(esc_html__('No sliders found', 'ocolus'));
            }
        }

        return $arrOutput;
    }
}
if (!function_exists('ocolus_wordpress_menus')) {
    function ocolus_wordpress_menus($return = 'name')
    {
        $locations = array();
        $menus     = get_terms('nav_menu', array('hide_empty' => true));
        if (!empty($menus)) {
            foreach ($menus as $menu) {
                if ($return == 'name') {
                    $locations[$menu->name] = $menu->name;
                } elseif ($return == 'slug') {
                    $locations[$menu->slug] = $menu->name;
                } else {
                    $locations[$menu->name] = $menu->slug;
                }
            }
        }

        return $locations;
    }
}
if (!function_exists('ocolus_author_social')) {
    function ocolus_author_social($author_id)
    {
        ?>
        <ul class="social person-socials">
            <?php if (get_the_author_meta('facebook', $author_id)) : ?>
                <li>
                    <a target="_blank" class="facebook"
                       href="<?php echo get_the_author_meta('facebook', $author_id); ?>">
                        <i class="fa fa-facebook"></i>
                    </a>
                </li>
            <?php endif; ?>
            <?php if (get_the_author_meta('twitter', $author_id)) : ?>
                <li>
                    <a target="_blank" class="twitter"
                       href="<?php echo get_the_author_meta('twitter', $author_id); ?>">
                        <i class="fa fa-twitter"></i>
                    </a>
                </li>
            <?php endif; ?>
            <?php if (get_the_author_meta('google', $author_id)) : ?>
                <li>
                    <a target="_blank" class="google-plus"
                       href="<?php echo get_the_author_meta('google', $author_id); ?>">
                        <i class="fa fa-google"></i>
                    </a>
                </li>
            <?php endif; ?>
            <?php if (get_the_author_meta('instagram', $author_id)) : ?>
                <li>
                    <a target="_blank" class="instagram"
                       href="<?php echo get_the_author_meta('instagram', $author_id); ?>">
                        <i class="fa fa-instagram"></i>
                    </a>
                </li>
            <?php endif; ?>
            <?php if (get_the_author_meta('youtube', $author_id)) : ?>
                <li>
                    <a target="_blank" class="youtube"
                       href="<?php echo get_the_author_meta('youtube', $author_id); ?>">
                        <i class="fa fa-youtube-play"></i>
                    </a>
                </li>
            <?php endif; ?>
            <?php if (get_the_author_meta('linkedin', $author_id)) : ?>
                <li>
                    <a target="_blank" class="linkedin"
                       href="<?php echo get_the_author_meta('linkedin', $author_id); ?>">
                        <i class="fa fa-linkedin-square"></i>
                    </a>
                </li>
            <?php endif; ?>
            <?php if (get_the_author_meta('pinterest', $author_id)) : ?>
                <li>
                    <a target="_blank" class="pinterest"
                       href="<?php echo get_the_author_meta('pinterest', $author_id); ?>">
                        <i class="fa fa-pinterest-p"></i>
                    </a>
                </li>
            <?php endif; ?>
        </ul>
        <?php
    }
}
/**
 *
 * ACTION
 * $functions = array(
 *      array( {action},{tag}, {callback},{priority}, {arg} ),
 *      array( {action},{tag}, {callback},{priority}, {arg} ),
 * );
 */
if (!function_exists('ocolus_add_action')) {
    function ocolus_add_action($functions, $reverse = false)
    {
        if (!empty($functions)) {
            foreach ($functions as $function) {
                $actions  = $function[0];
                $priority = isset($function[3]) ? $function[3] : 10;
                $args     = isset($function[4]) ? $function[4] : 1;
                if ($reverse) {
                    $search  = 'add_';
                    $replace = 'remove_';
                    if (strpos($actions, 'add_') === false) {
                        $search  = 'remove_';
                        $replace = 'add_';
                    }
                    $actions = str_replace($search, $replace, $actions);
                }
                call_user_func($actions, $function[1], $function[2], $priority, $args);
            }
        }
    }
}
if (!function_exists('ocolus_set_post_views')) {
    function ocolus_set_post_views($postID = false, $post_type = 'post')
    {
        if (!$postID) {
            $postID = get_the_ID();
        }
        if (get_post_type($postID) === $post_type) {
            $count_key = "ocolus_{$post_type}_views_count";
            $count     = get_post_meta($postID, $count_key, true);
            if ($count == '') {
                delete_post_meta($postID, $count_key);
                add_post_meta($postID, $count_key, '0');
            } else {
                $count++;
                update_post_meta($postID, $count_key, $count);
            }
        }
    }
}
if (!function_exists('ocolus_get_post_views')) {
    function ocolus_get_post_views($postID = false, $post_type = 'post')
    {
        if (!$postID) {
            $postID = get_the_ID();
        }
        $count_key = "ocolus_{$post_type}_views_count";
        $count     = get_post_meta($postID, $count_key, true);
        if ($count == '') {
            delete_post_meta($postID, $count_key);
            add_post_meta($postID, $count_key, '0');
            echo '0';
        }
        echo ocolus_number_format_short($count);
    }
}
/**
 * @param $n
 *
 * @return string
 * Use to convert large positive numbers in to short form like 1K+, 100K+, 199K+, 1M+, 10M+, 1B+ etc
 */
if (!function_exists('ocolus_number_format_short')) {
    function ocolus_number_format_short($n)
    {
        if ($n >= 0 && $n < 1000) {
            // 1 - 999
            $n_format = floor($n);
            $suffix   = '';
        } elseif ($n >= 1000 && $n < 1000000) {
            // 1k-999k
            $n_format = floor($n / 1000);
            $suffix   = 'K+';
        } elseif ($n >= 1000000 && $n < 1000000000) {
            // 1m-999m
            $n_format = floor($n / 1000000);
            $suffix   = 'M+';
        } elseif ($n >= 1000000000 && $n < 1000000000000) {
            // 1b-999b
            $n_format = floor($n / 1000000000);
            $suffix   = 'B+';
        } elseif ($n >= 1000000000000) {
            // 1t+
            $n_format = floor($n / 1000000000000);
            $suffix   = 'T+';
        }

        return !empty($n_format) ? $n_format.$suffix : 0;
    }
}
if (!function_exists('ocolus_get_form_newsletter')) {
    function ocolus_get_form_newsletter($visual_composer = false)
    {
        if ($visual_composer) {
            $list_form[esc_html__('Default Form', 'ocolus')] = '0';
        } else {
            $list_form['0'] = esc_html__('Default Form', 'ocolus');
        }
        if (function_exists('mc4wp_show_form')) {
            $args  = array(
                'posts_per_page' => -1,
                'post_type'      => 'mc4wp-form',
                'post_status'    => 'publish',
                'fields'         => 'ids',
            );
            $posts = get_posts($args);
            if ($posts) {
                foreach ($posts as $post_id) {
                    $post_id = intval($post_id);
                    $title   = get_the_title($post_id);
                    if ($visual_composer) {
                        $list_form[$title] = $post_id;
                    } else {
                        $list_form[$post_id] = $title;
                    }
                }
            }
        }

        return $list_form;
    }
}
if (!function_exists('ocolus_get_icon_html') && function_exists('vc_icon_element_fonts_enqueue')) {
    function ocolus_get_icon_html($atts)
    {
        if ($atts['type'] == 'none') {
            return '';
        }
        if ($atts['type'] != 'image') {
            $icon = $atts['icon_'.$atts['type']];
            // Enqueue needed icon font.
            $match = array(
                'fontawesome',
                'oviccustomfonts',
            );
            if (!in_array($atts['type'], $match)) {
                vc_icon_element_fonts_enqueue($atts['type']);
            }
            $html = '<span class="'.esc_attr($icon).'"></span>';
        } else {
            $html = wp_get_attachment_image($atts['image_icon'], 'full');
        }

        return $html;
    }
}