<?php
if ( !defined( 'ABSPATH' ) ) {
	exit;
}
if ( !function_exists( 'ocolus_custom_inline_css' ) ) {
	function ocolus_custom_inline_css()
	{
		$css               = ocolus_get_option( 'ace_style', '' );
		$enable_typography = ocolus_get_option( 'enable_typography' );
		$typography_group  = ocolus_get_option( 'typography_group' );
		if ( $enable_typography == 1 && !empty( $typography_group ) ) {
			foreach ( $typography_group as $typography ) {
				$css .= "{$typography['element_tag']}{";
				if ( $typography['typography_font_family']['family'] )
					$css .= "font-family: {$typography['typography_font_family']['family']};";
				if ( $typography['typography_font_family']['weight'] )
					$css .= "font-weight: {$typography['typography_font_family']['weight']};";
				$css .= "font-size: {$typography['typography_font_size']}px;";
				$css .= "line-height: {$typography['typography_line_height']}px;";
				$css .= "color: {$typography['body_text_color']};";
				$css .= "}";
			}
		}
		$main_color       = ocolus_theme_option_meta(
			'_custom_metabox_theme_options',
			'main_color',
			'metabox_main_color',
			'#293341'
		);
		$main_color_hover = ocolus_theme_option_meta(
			'_custom_metabox_theme_options',
			'main_color_hover',
			'metabox_main_color_hover',
			'#c91f28'
		);
		$site_background  = ocolus_theme_option_meta(
			'_custom_metabox_theme_options',
			'site_background',
			'metabox_site_background'
		);
		$rgba_color       = ocolus_hex2RGB( $main_color );
		$rgba_color_hover = ocolus_hex2RGB( $main_color_hover );
		if ( $site_background ) {
			$output = '';
			if ( !empty( $site_background['image'] ) ) {
				$output .= 'background-image: url(' . $site_background['image'] . ');';
			}
			// Common background properties
			$properties = array( 'color', 'position', 'repeat', 'attachment', 'size' );

			foreach ( $properties as $value ) {
				$property = 'background-' . $value;
				if ( !empty( $site_background[$value] ) ) {
					$output .= $property . ':' . $site_background[$value] . ';';
				}
			}
			if ( $output ) {
				$css = 'body{' . $output . '}';
			}
		}
		$css .= '
		a.backtotop,
		h1,
        h2,
        h3,
        h4,
        h5,
        h6,
        .editor-writing-flow .editor-post-title__block .editor-post-title__input,
        label,
        .post-pagination a:not(:hover) span:not(.title),
		.page-links a:not(:hover) span:not(.page-links-title),
		.woocommerce-pagination a.page-numbers,
		.woocommerce-pagination span.page-numbers,
		.navigation .page-numbers,
		.pagination .page-numbers,
		.pagination-nav .button-loadmore:not(:hover),
        .woocommerce .woocommerce-MyAccount-navigation ul li.is-active,
		.box-header-nav .main-menu > .menu-item:not(.current-menu-item):not(.current_page_item):not(.current-menu-parent) > a:not(:hover),
		.block-nav-category .block-title:not(:hover),
		.block-nav-category .view-all-category a:not(:hover),
		.block-menu-bar a:not(:hover),
		.block-canvas-bar a:not(:hover),
		.post-item.style-06 .author:not(:hover),
		.post-item.style-11 .readmore,
		.post-item.style-12 .readmore,
		body.search .post-item.style-07 .readmore,
		.header.style-05 .block-search > a:not(:hover),
		.block-search .btn-submit,
		.widget_rss ul li > a:not(:hover),
		.widget_recent_comments ul li > a:not(:hover),
		.widget_search .search-submit,
		.widget_product_search button[type="submit"],
		.widget .product_list_widget > li > a:not(:hover),
		.widget_shopping_cart .total,
		.widget_shopping_cart .buttons .button:not(.checkout):not(:hover),
		.entry-summary .price > span > *:not(del):not(ins),
		.quantity .control,
		.dropdown-menu,
		.desc_01 .woocommerce-tabs > ul > li.active > button,
		.desc_01 .woocommerce-tabs > ul > li > button:hover,
		.desc_01 .woocommerce-tabs > ul > li.active > a,
		.desc_01 .woocommerce-tabs > ul > li > a:hover,
		.desc_02 .woocommerce-tabs > ul > li.active > button,
		.desc_02 .woocommerce-tabs > ul > li > button:hover,
		.desc_02 .woocommerce-tabs > ul > li.active > a,
		.desc_02 .woocommerce-tabs > ul > li > a:hover,
		.desc_03 .woocommerce-tabs > ul > li > button,
		.desc_03 .woocommerce-tabs > ul > li > a,
		#tab-reviews #review_form .comment-reply-title,
		.product_meta > * > .title,
		.ocolus-product-pagination .other-post .ocolus-product-pagination__title,
		.woosb-products .woosb-product .woosb-title,
		.woosb-products .woosb-product .woosb-qty input,
		.product-gift .list-gift li a:not(:hover),
        table.ovic_bundle-products th,
		table.ovic_bundle-products .ovic_bundle-product .ovic_bundle-title,
		.woocommerce-cart-form .shop_table th,
		.woocommerce-cart-form .shop_table td.product-name,
		.wishlist_table td.product-name,
		.ovic-products .button-products .button:not(:hover),
		.col2-set .col-1 > h2,
        .col2-set .col-2 > h2,
        .woocommerce-billing-fields > h3,
        .woocommerce-shipping-fields > h3,
        .woocommerce-additional-fields > h3,
        #order_review_heading,
        .box-header-nav .view-all-category a:not(:hover),
		.product-item.style-02 .add-to-cart > a,
		.product-item.style-14 .add-to-cart > a,
		.product-item.style-14 .price > span > *:not(del),
		.product-item.style-20 .add-to-cart > a,
		.product-item.style-20 .price > span > *:not(del):not(ins),
		.product-item.style-26 .add-to-cart > a,
		.product-item.style-26 .price > span > *:not(del),
		.product-item.style-27 .add-to-cart > a,
		.product-item.style-27 .price > span > *:not(del),
		.header-sticky .header-control > * > a:not(:hover),
		.header.style-01 .header-bot .header-control > * > a:not(:hover),
		.header.style-02 .header-control > * > a:not(:hover),
		.header.style-04 .header-mid .header-right > * > a:not(:hover),
		.header.style-06 .header-control > * > a:not(:hover),
		.header.style-07 .header-control > * > a:not(:hover),
		.header.style-11 .header-control > * > a:not(:hover),
		.header.style-11 .top-bar-menu > li > a:not(:hover),
		.header.style-12 .header-control > * > a:not(:hover),
		.header.style-13 .header-bot .header-right > * > a:not(:hover),
		.header.style-14 .header-mid .header-right > * > a:not(:hover),
		.header.style-16 .top-bar-menu > li > a:not(:hover),
		.header.style-16 .header-top .header-right > * > a:not(:hover),
		.header.style-18 .header-mid .header-right > * > a:not(:hover),
		.header.style-20 .header-top .header-right > * > a:not(:hover),
		.header.style-24 .header-bot .header-right > * > a:not(:hover),
		.header.style-25 .header-control > * > a:not(:hover),
		.header.style-27 .header-control > * > a:not(:hover),
		.block-search .ovic-instant-search .product-search-item .product-title,
		.block-search .ovic-instant-search .wrapper-result .result-count,
		.block-search .ovic-instant-search .wrapper-result > span,
		div.ovic-menu-clone-wrap .ovic-menu-panel > ul > li > a,
		.ovic-video.default .title-video,
		.nav-top .slick-slider .slick-arrow.prev:not(:hover),
		.nav-top .slick-slider .slick-arrow.next:not(:hover),
		.nav-long-arrow .slick-slider:not(.slick-vertical) .slick-arrow:not(:hover),
        .nav-text-arrow .slick-slider .slick-arrow:not(:hover),
		.ovic-newsletter.style-01 .title,
		.ovic-custommenu.style-02,
		.ovic-tabs.default .tabs li.active,
		.ovic-tabs.style-01 .tabs li,
		.ovic-tabs.style-02 .tabs li.active,
		.ovic-tabs.style-03 .tabs-head .tabs li.active,
		.ovic-tabs.style-04 .tabs-head .tabs li,
        .ovic-tabs.style-05 .tabs li,
		.blog-item.style-09 .readmore:not(:hover),
		.blog-item.style-12 .readmore,
		.ovic-blog.style-09 .slick-slider .slick-arrow:not(:hover),
		.ovic-newsletter.style-02 .submit-newsletter,
		.ovic-person.style-02 .positions,
        .ovic-custom-heading.style-01 .button,
		.ovic-custom-heading.style-05 a,
		.ovic-iconbox.default .icon,
		.header.mobile-style-01 .header-main .block-minicart > a,
		.header.mobile-style-01 .header-stick .header-inner > * > a,
		.header.mobile-style-01 .header-stick .block-userlink-mobile .block-userlink ul > li > a,
		.ovic-category.default .button:not(:hover),
		.ovic-category.style-02 .button,
		.ovic-category.style-03 .button,
		.ocolus-head-account a.active,
		.ocolus-head-account a:hover,
		.the_champ_social_login_title,
		div.the_champ_outer_login_container::after,
		.header.mobile-style-01 .block-userlink-mobile .account-menu > li > .woocommerce .ocolus-head-account a,
		.ovic-iconbox.style-01 .icon,
		.ovic-person.default .desc::before,
		.ovic-person.default .desc::after,
		.product-item.style-07 .ocolus-countdown > *,
		.blog-item.style-02 .post-category ul li,
		.blog-item.style-03 .post-category ul li,
		.ovic-custommenu.style-03,
		.ovic-custom-heading.style-11,
		.ovic-category.style-05 .category-item .button:not(:hover),
		.price_slider_amount .price_label span,
		.ovic-person.style-01 .positions,
		div.wcmp_vendor_banner_template.template1 .wcmp_vendor_name,
		div.wcmp_regi_main form .reg_header1,
		div.wcmp_regi_main form .reg_header2,
		div#wcmp-store-conatiner .store-name:not(:hover),
		.header.style-04 .top-bar-menu > li > a:not(:hover),
		.top-bar-menu .wpml-ls-item > .sub-menu,
		.content-popup-shipping table th,
        .entry-summary .group_table th,
		.entry-summary .group_table .woocommerce-grouped-product-list-item__label a:not(:hover),
		.coupon-code .coupon-excerpt,
		form.woocommerce-checkout .shop_table b,
		form.woocommerce-checkout .shop_table strong,
		.cart_totals .shop_table th,
		.cart_totals .shop_table b,
        .cart_totals .shop_table strong,
		.cart_totals .shop_table .amount,
		.ovic-google-maps .title-maps,
		.product-guaranteed .title,
		.widget .tagcloud *.view-all,
		body .dokan-pagination-container .dokan-pagination li a,
		.logo .logo-text,
		.ovic-custom-heading.style-19 .sub-title,
		.ovic-custom-heading.style-19 .button,
		.header.style-09 .block-minicart .woo-cart-link .count,
		.ovic-newsletter.style-10 .submit-newsletter,
		.woocommerce-checkout-payment .woocommerce-terms-and-conditions-checkbox-text,
		.vc_btn3-container .vc_btn3.vc_btn3-style-ovic-button.ovic-button-2:not(:hover),
		.product-item.style-13 .add-to-cart a,
		.product-item.style-15 .add-to-cart a,
		.ovic-iconbox.style-03,
		.product-item .post-taxonomy,
		.ovic-custom-heading.style-24 .sub-title,
		.ovic-custom-heading.style-26.size-small .button,
		.ovic-custom-heading.style-26.size-big .button:not(:hover),
		.product-item.style-17 .add-to-cart .single_add_to_cart_button:not(:hover),
		.product-item.style-17 .add-to-cart .added_to_cart:not(:hover),
		.product-item.style-17 .add-to-cart > a:not(:hover),
		.product-item.style-18 .add-to-cart > a:not(:hover),
		.ovic-custom-heading.style-25 .button:not(:hover),
		.product-item.style-19 .add-to-cart > a:not(:hover),
		.wpcf7-dark-style .wpcf7 input[type="submit"]:not(:hover),
		.ovic-newsletter.style-12 .submit-newsletter:not(:hover),
		.post-item .content-author .name:not(:hover),
		.comments-area .comment-author,
		.header.style-14 .header-top,
		.ovic-pricing-box .head-price,
		.ovic-pricing-box:not(:hover) .button,
		.ovic-custom-heading.style-27 .button:not(:hover),
		.product-item.style-21 .add-to-cart a,
		.product-item.style-25 .add-to-cart a,
		.ovic-custom-heading.style-03 .button,
		.nav-bottom-right .slick-slider:not(.slick-vertical) .slick-arrow:not(:hover),
		.header.style-17 .block-search.style-03 .btn-submit:not(:hover),
		.header.style-17 .block-search.style-03 .category select:not(:hover),
		.header.style-17 .block-search.style-03 .category .chosen-container-single .chosen-single:not(:hover),
		.ovic-custom-heading.style-33 .button,
		.ocolus-countdown > *,
		.ovic-iconbox.style-07 .icon,
		.ovic-custom-heading.style-30 .title-countdown-wrapper,
		.ovic-iconbox.style-08 .icon,
		.blog-item.style-20 .date-post .date,
		.ovic-custom-heading.style-31 .button,
		.block-portfolio-title .filter-item,
		.portfolio-single .post-taxonomy ul,
		.portfolio-single .meta-data > * > .title,
		.portfolio-single .share-content > .title,
		.portfolio-single .pagination-thumb > div .name
		{
			color: ' . $main_color . ';
		}
		.normal-effect::before,
		.border-scale,
        .added_to_cart,
		.button, 
		button, 
		input[type="submit"],
		.widget #today,
		.chosen-container .chosen-results li.highlighted,
        .ovic-mapper .ovic-pin .ovic-popup-footer a:hover,
		#ship-to-different-address label span::before, 
		.post-pagination span:not(.title),
		.page-links span:not(.page-links-title),
		.woocommerce-pagination a.page-numbers:hover,
		.woocommerce-pagination .page-numbers.current,
		.navigation a.page-numbers:hover,
		.navigation .page-numbers.current,
		.pagination a.page-numbers:hover,
		.pagination .page-numbers.current,
		.post-item.style-06 .thumb-link::after,
		.post-item.style-11 .thumb-link::after,
		.header.style-05 .header-top,
		.header.style-05 .box-header-nav .main-menu > .menu-item:not(:last-child)::after,
		.desc_03 .woocommerce-tabs > ul > li > button::before,
		.desc_03 .woocommerce-tabs > ul > li > button::after,
		.desc_03 .woocommerce-tabs > ul > li > a::before,
		.desc_03 .woocommerce-tabs > ul > li > a::after,
		.header-canvas .canvas-close::before,
		.header-canvas .canvas-close::after,
		div.ovic-menu-panels-actions-wrap,
		.page-header.style-1.has-banner,
		.header.style-07 .header-top,
		.header.style-13 .header-top,
		.header.style-23 .header-top,
		.dropdown-menu > .active > a,
		.dropdown-menu > .active > a:focus,
		.dropdown-menu > .active > a:hover,
		div.ovic-menu-clone-wrap .ovic-menu-panel .ovic-menu-next-panel::before,
		div.ovic-menu-clone-wrap .ovic-menu-panel .ovic-menu-next-panel::after,
		.header.mobile-style-01 .header-stick .block-search.style-02 .close-search::before,
		.header.mobile-style-01 .header-stick .block-search.style-02 .close-search::after,
		.header.mobile-style-01 .header-stick .block-userlink-mobile .head-account-menu,
		.header.mobile-style-01 .header-stick .block-userlink-mobile .block-userlink ul > li > .caret::before,
		.header.mobile-style-01 .header-stick .block-userlink-mobile .block-userlink ul > li > .caret::after,
		.md-size-chart-modal .remodal-close::before,
		.md-size-chart-modal .remodal-close::after,
		.ovic-newsletter.style-04,
		.blog-item.style-04 .thumb-link::after,
		.ovic-category.style-05 .category-item .button:hover,
		div.wcmp_regi_main .button,
		#wcmp_vendor_reviews .submit,
		#yith-quick-view-close::before,
		#yith-quick-view-close::after,
		div.mfp-content button.mfp-close::before,
		div.mfp-content button.mfp-close::after,
		table.ovic_bundle-product .ovic_bundle-sale,
		.block-search.style-02 .woo-search-link::before,
		.block-search.style-02 .woo-search-link::after,
		.product-filter .filter-close::before,
		.product-filter .filter-close::after,
		body .dokan-pagination-container .dokan-pagination li.active a,
		body .dokan-pagination-container .dokan-pagination li a:hover,
		.comments-area .comment-reply-link,
		body #fp-nav ul li a span, 
		body .fp-slidesNav ul li a span,
		.header.style-09 .block-minicart .woo-cart-link,
		.product-item.style-12 a.yith-wcqv-button,
		.header.style-12 .header-top,
		.vc_btn3-container .vc_btn3.vc_btn3-style-ovic-button,
		.header.style-21 .header-top,
		.product-item .process-availability .process,
		.product-item.style-15 .product-labels > *,
		.ovic-custom-heading.style-25 .inner,
		.ocolus-sticky-add-to-cart .percent,
		.dot-stretch .slick-dots li.slick-active,
		.dot-stretch .slick-dots li:hover,
		.product-item.style-22 .thumb-link::after,
		.header.style-17 .header-top,
		.header.style-17 ~ .header-sticky,
		.dot-equal .slick-dots li:hover,
        .dot-equal .slick-dots li.slick-active,
        .header.style-18 .block-nav-category .block-title,
        .header.style-18 .block-search.style-03 .btn-submit,
        .block-nav-category .block-title .icon::before,
        .block-nav-category .block-title .icon::after,
        .dot-inside-2 .slick-dots li.slick-active,
        .dot-inside-2 .slick-dots li:hover,
        .header.style-24 .header-top,
        .header.style-24 .header-mid,
        .ovic-custom-heading.style-32 .content
		{
			background-color: ' . $main_color . ';
		}
		.widget_shopping_cart .buttons .button:not(.checkout):not(:hover),
        .product-item.style-01 .product-gallery li.active a::after,
        .product-item.style-01 .product-gallery li a:hover::after
		{
			border-color: ' . $main_color . ';
		}
		.ovic-category.style-05 .category-item .button,
        .vc_btn3-container .vc_btn3.vc_btn3-style-ovic-button.ovic-button-2:not(:hover),
		.ovic-custom-heading.style-26.size-big .button:not(:hover),
		.product-item.style-18 .add-to-cart > a:not(:hover),
		.ovic-products.style-17 .button-products .button:not(:hover),
		.product-item.style-19 .add-to-cart > a:not(:hover)
		{
		    box-shadow: 0 0 0 2px ' . $main_color . ' inset;
		}
		.ovic-tabs.style-04 .tabs li.active a
		{
		    box-shadow: 0 -2px ' . $main_color . ' inset;
		}
		.dot-line .slick-dots
		{
		    box-shadow: 0 -4px ' . $main_color . ' inset;
		}
		a:hover,
		a:focus,
		.post-sticky,
		.site-content.sticky > .post-item .post-title::after,
		.site-content.sticky .site-main > .post-item .post-title::after,
		.post-item.sticky .post-title::after,
		.chosen-container-single .chosen-single:hover,
        .current-menu-ancestor > a,
        .current-menu-parent > a,
        .current-menu-item > a,
        .current_page_item > a,
		.box-header-nav .main-menu > .menu-item:hover > a,
        body .vc_custom_heading a:focus,
		.ovic-disabled-popup label:hover,
		.ovic-live-search-form .keyword-current,
        .woocommerce-form-login .form-row label.woocommerce-form__label-for-checkbox:hover,
		.woocommerce #shipping_method input[type="radio"]:hover ~ label,
        .woocommerce #shipping_method input[type="radio"] ~ label:hover,
		.woocommerce #shipping_method input[type="checkbox"]:hover ~ label,
        .woocommerce #shipping_method input[type="checkbox"] ~ label:hover,
		.slick-slider .slick-arrow:hover,
        .yith-woocompare-widget ul.products-list li .remove:hover,
        div.wpml-ls li a:hover,
        div.wpml-ls li a:focus,
        div.wcml_currency_switcher li a:hover,
        div.wcml_currency_switcher li a:focus,
        div.mfp-content button.mfp-close:hover,
        .wpml-ls.wpml-ls-legacy-list-horizontal li.wpml-ls-current-language > a,
        .wpml-ls.wpml-ls-legacy-list-vertical li.wpml-ls-current-language > a,
        .wcml_currency_switcher.wcml-horizontal-list li.wcml-cs-active-currency > a,
        .wcml_currency_switcher.wcml-vertical-list li.wcml-cs-active-currency > a,
        div.wpml-ls li.wpml-ls-current-language:hover > a,
        div.wcml_currency_switcher li.wcml-cs-active-currency:hover > a,
        .ovic-product-price-filter .price-item:hover,
		.post-category ul li,
		.post-item.style-11 .readmore:hover,
		.post-item.style-12 .readmore:hover,
		body.search .post-item.style-07 .readmore:hover,
		.block-search .btn-submit:hover,
		.block-search .category select:hover,
		.widget_search .search-submit:hover,
		.widget_product_search button[type="submit"]:hover,
		.widget_categories ul li.current-cat > a,
		.widget_product_categories ul li.current-cat > a,
		.widget .product_list_widget > li ins,
		.price ins,
		div.ovic-pinmap .ovic-pin .ovic-wc-price ins,
        .woocommerce-product-gallery a.compare:hover,
        .entry-summary a.compare:hover,
        .product-item a.compare:hover,
        a.yith-wcqv-button:hover,
        a.yith-wcqv-button:focus,
        .yith-wcwl-add-to-wishlist a:hover,
		table.variations .data-val a.active,
		table.variations .data-val a:hover,
        .woocommerce-product-gallery .ovic-magnific-popup span,
		.product-item.style-02 .add-to-cart > a:hover,
		.product-item.style-14 .add-to-cart > a:hover,
		.product-item.style-20 .add-to-cart > a:hover,
		.ovic-custom-heading.style-14 .button:hover,
		.ovic-custom-heading.style-15 .button:hover,
		.ovic-custom-heading.style-16 .button:hover,
		.ovic-newsletter.style-01 .submit-newsletter:hover,
		.ovic-newsletter.style-02 .submit-newsletter:hover,
		.ovic-custom-heading.style-05 a:hover,
		.ovic-category.style-02 .button:hover,
		.ovic-category.style-03 .button:hover,
		.product-item.style-06 .add-to-cart > a:hover,
		.ovic-newsletter.style-04 .submit-newsletter:hover,
		.ovic-newsletter.style-03 .submit-newsletter:hover,
		.ovic-person.default .name,
		.ovic-custom-heading.style-10 .title,
		.blog-item.style-02 .readmore,
		.blog-item.style-12 .readmore:hover,
		.ovic-newsletter.style-06 .title,
		.ovic-products.style-10 .button-products .button:hover,
		.ovic-products.style-10 .button-products .button:focus,
		.ovic-newsletter.style-07 .submit-newsletter:hover,
		.ovic-newsletter.style-14 .submit-newsletter:hover,
		.widget_layered_nav .color-group > *.selected:not(:hover),
		.widget_layered_nav .list-group > *.selected > *:not(a),
		.widget_layered_nav .list-group > *.selected > a:not(:hover),
		.widget_layered_nav .inline-group > *.selected:not(:hover),
		.ovic-custom-heading.style-17 .title strong,
		.ovic-person.style-03 .name,
		.ovic-person.style-03 .positions,
		.error-404 a,
		div.wcmp_vendor_banner_template.template1 a.wcmp_vendor_detail:hover,
		.widget .tagcloud *.view-all:hover,
		.ovic-custom-heading.style-20 .title strong,
		.ovic-custom-heading.style-19 .button:hover,
		.header.style-09 .block-minicart .woo-cart-link:hover .count,
		.ovic-newsletter.style-10 .submit-newsletter:hover,
		.header.style-12 .header-top ul.top-bar-menu > li > a .icon,
		body.page #secondary .dokan-category-menu #cat-drop-stack > ul li.parent-cat-wrap a:hover,
		body.dokan-dashboard ul.subsubsub li.active a,
		body.dokan-dashboard .dokan-orders-content .dokan-orders-area ul.order-statuses-filter li.active a,
		.product-item.style-13 .add-to-cart a:hover,
		.product-item.style-15 .add-to-cart a:hover,
    	.ovic-custommenu.style-06 li a::before,
		.header.style-21 ~ .header-sticky .logo .logo-text,
		.header.style-21 .logo .logo-text,
		.ovic-iconbox.style-05 .icon,
		.ovic-countdown.style-01 .button:hover,
		.product-item.style-12 .price > span > *:not(del),
		.product-item.style-15 .price > span > *:not(del),
		.product-item.style-16 .price > span > *:not(del),
		.product-item.style-17 .price > span > *:not(del),
		.product-item.style-23 .price > span > *:not(del),
		.product-item.style-24 .price > span > *:not(del),
		.quickview-style-02 #yith-quick-view-content .entry-summary .price > span > *:not(del),
		.ovic-custom-heading.style-24 .title,
		.product-item.style-11 .product-toggle,
		.ovic-custom-heading.style-26.size-small .button:hover,
		.ovic-video.style-02 .video,
		.ovic-custom-heading.style-28 .button:hover,
		.ovic-custom-heading.style-29 .button:hover,
		.ovic-pricing-box:hover .icon,
		.product-item.style-21 .add-to-cart a:hover,
		.product-item.style-25 .add-to-cart a:hover,
		.ovic-custom-heading.style-03 .button:hover,
		.product-item.style-22 .add-to-cart > a:hover,
		.product-item.style-22 .add-to-cart > a:focus,
		.product-item.style-27 .add-to-cart > a:hover,
		.product-item.style-27 .add-to-cart > a:focus,
		.ovic-custom-heading.style-33 .button:hover,
		.ovic-custom-heading.style-33 .button:focus,
		.ovic-custom-heading.style-30 .button:hover,
		.ovic-custom-heading.style-30 .button:focus,
		.ovic-custom-heading.style-30 .ocolus-countdown > *,
		.ovic-custom-heading.style-31 .button:hover,
		.block-portfolio-title .filter-item.active
		{
		    color: ' . $main_color_hover . ';
		}
		body .tooltip-inner,
		blockquote::before,
		.add-to-cart::before,
		.added_to_cart:hover,
        .added_to_cart:focus,
        .button:hover,
        .button:focus,
        button:hover,
        input[type="submit"]:hover,
		a.backtotop:hover,
        .logo .logo-text .dot::before,
		#ship-to-different-address label input[type="checkbox"]:checked + span::before,
		.slick-dots li.slick-active button,
		.slick-dots li:hover button,
		.ui-slider .ui-slider-range,
		.ui-slider .ui-slider-handle,
		.post-item.style-14 .post-category ul li a,
		.modes-mode:hover .button-inner > span,
		.modes-mode.active .button-inner > span,
		.desc_01 .woocommerce-tabs > ul > li a::after,
		.woocommerce-product-gallery .flex-control-nav .slick-arrow:hover,
		.product-notify-mailchimp .product-notify-inner,
		.woocommerce-cart-form .shop_table tbody .product-remove a,
		.wishlist_table tbody .product-remove a,
		.block-minicart .woo-cart-link .count,
		.ovic-custom-heading.style-03 .title::after,
		.ovic-products .products-head::after,
		.ovic-category.style-01 .second-slide .category-item.slick-current,
		.ovic-category.style-01 .second-slide .category-item:hover,
		.ovic-tabs.style-01 .tabs .tab-item a::after,
        .blog-item.style-10 .post-category ul,
        .blog-item.style-11 .post-category ul,
        .product-item.style-07 .add-to-cart > a,
		.vc_wp_tagcloud .widget .tagcloud a:hover,
		.ovic-newsletter.style-06 .submit-newsletter,
		.widget_layered_nav .list-group li > a:hover::before,
		.widget_layered_nav .list-group li.selected > *::before,
		.widget_layered_nav .inline-group > a:hover::before,
		.widget_layered_nav .inline-group > *.selected::before,
		.dot-line .slick-dots li button,
		div.wcmp_regi_main .button:hover,
		#wcmp_vendor_reviews .submit:hover,
		.coupon-code label,
		.ovic-google-maps .direction-maps,
		.block-search.style-02 .woo-search-link:hover::before,
		.block-search.style-02 .woo-search-link:hover::after,
		.ovic-category.style-04 .category-item .title a:hover,
		.comments-area .comment-reply-link:hover,
		.product-item.style-11 .product-info,
		.header.style-09 .block-minicart .woo-cart-link:hover,
		.product-item.style-12 a.yith-wcqv-button:hover,
		.vc_btn3-container .vc_btn3.vc_btn3-style-ovic-button:focus,
		.vc_btn3-container .vc_btn3.vc_btn3-style-ovic-button:hover,
		.ovic-custom-heading.style-22::after,
		.ovic-custom-heading.style-23,
		.ovic-newsletter.style-11 .submit-newsletter,
		.header.style-19 .header-bot,
    	.nav-square-arrow .slick-slider .slick-arrow:hover,
		.quickview-style-02 #yith-quick-view-content .ocolus-share-socials a:hover,
		.product-item.style-15 .product-labels > .onsale,
		.ovic-video.style-02 .video:hover,
		.ovic-custom-heading.style-18 .content,
		.ovic-accordion .vc_btn3-container .vc_btn3.vc_btn3-style-ovic-button,
		.ovic-pricing-box .button,
		.header.style-18 .block-nav-category .block-title:hover,
		.header.style-18 .block-search.style-03 .btn-submit:hover,
        .block-nav-category .block-title:hover .icon::before,
        .block-nav-category .block-title:hover .icon::after,
        .product-item.style-26 .process-availability .process,
        .product-item.style-28 a.yith-wcqv-button,
        .product-item.style-28 .yith-wcwl-add-to-wishlist a,
        .product-item.style-28 .add-to-cart > a,
        .vc_btn3-container .vc_btn3.vc_btn3-style-ovic-button.ovic-button-3,
        .ovic-iconbox.style-02:hover,
        .portfolio-item .thumb-link::after
		{
		    background-color: ' . $main_color_hover . ';
		}
		.chosen-container-single .chosen-drop .chosen-search input[type=text]:focus,
		.ovic-newsletter .input-text:focus,
        .ovic-newsletter .input-focus,
		.blog-item.style-09 .readmore:hover,
		.ovic-custom-heading.style-01 .button:hover,
		.block-search.style-03 .input-focus,
		.product-item.style-17 .add-to-cart .single_add_to_cart_button:hover,
		.product-item.style-17 .add-to-cart .added_to_cart:hover,
		.product-item.style-17 .add-to-cart > a:hover,
		.vc_btn3-container .vc_btn3.vc_btn3-style-ovic-button.ovic-button-3::before
		{
		    border-color: ' . $main_color_hover . ';
		}
		.add-to-cart::after,
		body .tooltip.top .tooltip-arrow
		{
		    border-top-color: ' . $main_color_hover . ';
		}
		body .tooltip.bottom .tooltip-arrow
		{
		    border-bottom-color: ' . $main_color_hover . ';
		}
		body .tooltip.left .tooltip-arrow,
		.product-item.style-22 .add-to-cart::after
		{
		    border-left-color: ' . $main_color_hover . ';
		}
		body .tooltip.right .tooltip-arrow
		{
		    border-right-color: ' . $main_color_hover . ';
		}
		.block-search .search-field:focus
		{
		    box-shadow: 0 -1px ' . $main_color_hover . ' inset;
		}
		.header.style-04 .block-search .search-field:focus
		{
		    box-shadow: 0 -2px ' . $main_color_hover . ' inset;
		}
        .product-item.list a.compare:hover,
        .product-item.list a.yith-wcqv-button:hover,
        .product-item.list .yith-wcwl-add-to-wishlist a:hover,
        .header.style-22 .block-search .search-field:focus
        {
            box-shadow: 0 0 0 1px ' . $main_color_hover . ' inset;
        }
        .product-item.style-28 .product-inner:hover
        {
            box-shadow: 0 0 0 3px ' . $main_color_hover . ' inset;
        }
        @media (max-width: 767px){
            .ocolus-sticky-add-to-cart .percent{
                background-color: ' . $main_color_hover . ';
            }
        }
        
		';
		$css = preg_replace( '/\s+/', ' ', $css );
		wp_add_inline_style(
			'ocolus-custom-css',
			apply_filters( 'main_custom_css', $css )
		);
	}

	add_action( 'wp_enqueue_scripts', 'ocolus_custom_inline_css', 999 );
}
if ( !function_exists( 'ocolus_hex2RGB' ) ) {
	function ocolus_hex2RGB( $hexStr, $returnAsString = false, $seperator = ',' )
	{
		$hexStr   = preg_replace( "/[^0-9A-Fa-f]/", '', $hexStr ); // Gets a proper hex string
		$rgbArray = array();
		if ( strlen( $hexStr ) == 6 ) { //If a proper hex code, convert using bitwise operation. No overhead... faster
			$colorVal          = hexdec( $hexStr );
			$rgbArray['red']   = 0xFF & ( $colorVal >> 0x10 );
			$rgbArray['green'] = 0xFF & ( $colorVal >> 0x8 );
			$rgbArray['blue']  = 0xFF & $colorVal;
		} elseif ( strlen( $hexStr ) == 3 ) { //if shorthand notation, need some string manipulations
			$rgbArray['red']   = hexdec( str_repeat( substr( $hexStr, 0, 1 ), 2 ) );
			$rgbArray['green'] = hexdec( str_repeat( substr( $hexStr, 1, 1 ), 2 ) );
			$rgbArray['blue']  = hexdec( str_repeat( substr( $hexStr, 2, 1 ), 2 ) );
		} else {
			return false; //Invalid hex color code
		}

		return $returnAsString ? implode( $seperator, $rgbArray ) : $rgbArray; // returns the rgb string or the associative array
	}
}