<?php
if ( !class_exists( 'Ocolus_Sample_Settings' ) ) {
	class Ocolus_Sample_Settings
	{
		public function __construct()
		{
			// Filter Sample Data Menu
			add_filter( 'import_sample_data_menu_args', array( $this, 'import_sample_data_menu_args' ) );
			add_filter( 'import_sample_data_packages', array( $this, 'import_sample_data_packages' ) );
			add_filter( 'import_sample_data_required_plugins', array( $this, 'import_sample_data_required_plugins' ) );
			add_filter( 'import_sample_data_demo_site_pattern', array( $this, 'import_sample_data_demo_site_pattern' ) );
			add_action( 'import_sample_data_after_install_sample_data', array( $this, 'import_sample_data_after_install_sample_data' ), 10, 1 );
		}

		public function import_sample_data_demo_site_pattern( $demo_site_pattern )
		{
			$demo_site_pattern = 'https?(%3A|:)[%2F\\\\/]+(rc|demo|ocolus)\.kutethemes\.net';

			return $demo_site_pattern;
		}

		public function import_sample_data_required_plugins( $plugins )
		{
			$plugins = array(
				array(
					'name'        => 'WPBakery Visual Composer', // The plugin name
					'slug'        => 'js_composer', // The plugin slug (typically the folder name)
					'source'      => esc_url( 'https://plugins.kutethemes.net/js_composer.zip' ), // The plugin source
					'source_type' => 'external',
					'file_path'   => 'js_composer/js_composer.php',
				),
				array(
					'name'        => 'Revolution Slider', // The plugin name
					'slug'        => 'revslider', // The plugin slug (typically the folder name)
					'source'      => esc_url( 'https://plugins.kutethemes.net/revslider.zip' ), // The plugin source
					'source_type' => 'external',
					'file_path'   => 'revslider/revslider.php',
				),
				array(
					'name'        => 'WooCommerce',
					'slug'        => 'woocommerce',
					'required'    => true,
					'file_path'   => 'woocommerce/woocommerce.php',
					'source_type' => 'repo', // Plugins On wordpress.org
				),
				array(
					'name'        => 'Contact Form 7',
					'slug'        => 'contact-form-7',
					'required'    => true,
					'file_path'   => 'contact-form-7/wp-contact-form-7.php',
					'source_type' => 'repo', // Plugins On wordpress.org
				),
				array(
					'name'        => 'Mailchimp for WordPress',
					'slug'        => 'mailchimp-for-wp',
					'required'    => true,
					'file_path'   => 'mailchimp-for-wp/mailchimp-for-wp.php',
					'source_type' => 'repo', // Plugins On wordpress.org
				),
			);

			return $plugins;
		}

		/**
		 * Change Menu Sample dataß.
		 *
		 * @param   array $uri Remote URI for fetching content.
		 *
		 * @return  array
		 */
		public function import_sample_data_menu_args( $args )
		{
			$args = array(
				'parent_slug' => 'ocolus-dashboard',
				'page_title'  => esc_html__( 'Sample Data', 'ocolus' ),
				'menu_title'  => esc_html__( 'Sample Data', 'ocolus' ),
				'capability'  => 'manage_options',
				'menu_slug'   => 'ocolus-sample-data',
				'function'    => 'Import_Sample_Data_Dashboard::dashboard',
			);

			return $args;
		}

		public function import_sample_data_packages( $packages )
		{
			return array(
				'main' => array(
					'id'        => 'main',
					'name'      => 'Import Theme demo',
					'thumbnail' => get_theme_file_uri( 'screenshot.jpg' ),
					'demo'      => esc_url( 'https://ocolus.kutethemes.net' ),
					'download'  => get_theme_file_uri( 'framework/importer/sample-data.zip' ),
					'tags'      => array( 'all', 'simple' ),
					'main'      => true,
				),
				//and more...
			);
		}

		public function import_sample_data_after_install_sample_data( $package )
		{
			$menus    = get_terms( 'nav_menu', array( 'hide_empty' => true ) );
			$home_url = get_home_url();
			if ( !empty( $menus ) && isset( $data['id'] ) ) {
				foreach ( $menus as $menu ) {
					$items = wp_get_nav_menu_items( $menu->term_id );
					if ( !empty( $items ) ) {
						foreach ( $items as $item ) {
							$_menu_item_type = get_post_meta( $item->ID, '_menu_item_type', true );
							$_menu_item_url  = get_post_meta( $item->ID, '_menu_item_url', true );
							if ( $_menu_item_type == 'custom' ) {
								$_menu_item_url = str_replace( "https://ocolus.kutethemes.net", $home_url, $_menu_item_url );
								$_menu_item_url = str_replace( "http://ocolus.kutethemes.net", $home_url, $_menu_item_url );
								update_post_meta( $item->ID, '_menu_item_url', $_menu_item_url );
							}
						}
					}
				}
			}
		}
	}

	new Ocolus_Sample_Settings();
}
if ( !class_exists( 'Ocolus_Import_Config' ) ) {
	class Ocolus_Import_Config
	{
		public function __construct()
		{
			add_filter( 'ovic_import_config', array( $this, '_import_config' ) );
			add_filter( 'ovic_import_wooCommerce_attributes', array( $this, '_import_wooCommerce_attributes' ) );
		}

		public function _import_wooCommerce_attributes()
		{
			$attributes = array(
				array(
					'attribute_label'   => 'Capacity',
					'attribute_name'    => 'capacity',
					'attribute_type'    => 'box_style', // text, box_style, select
					'attribute_orderby' => 'menu_order',
					'attribute_public'  => '0',
				),
				array(
					'attribute_label'   => 'Size',
					'attribute_name'    => 'size',
					'attribute_type'    => 'box_style', // text, box_style, select
					'attribute_orderby' => 'menu_order',
					'attribute_public'  => '0',
				),
				array(
					'attribute_label'   => 'Color',
					'attribute_name'    => 'color',
					'attribute_type'    => 'box_style', // text, box_style, select
					'attribute_orderby' => 'menu_order',
					'attribute_public'  => '0',
				),
			);

			return $attributes;
		}

		public function _import_config( $data )
		{
			$path          = "/framework/importer";
			$data_demo     = array();
			$registed_menu = array(
				'primary' => esc_html__( 'Primary Menu', 'ocolus' ),
				'account' => esc_html__( 'Account Menu', 'ocolus' ),
			);
			$menu_location = array(
				'primary' => 'Primary Menu',
				'account' => 'Account Menu',
			);
			$demos         = array(
				'01', '02', '04', '05', '06', '07',
				'09', '13', '23', '25', '27',
			);
			foreach ( $demos as $demo ) {
				$data_demo[] = array(
					'name'           => "Demo {$demo}",
					'slug'           => "home-{$demo}",
					'menus'          => $registed_menu,
					'homepage'       => "Home {$demo}",
					'blogpage'       => "Blog",
					'preview'        => get_theme_file_uri( "$path/demo/home-{$demo}/home-{$demo}.jpg" ),
					'demo_link'      => "https://ocolus.kutethemes.net/home-{$demo}",
					'menu_locations' => $menu_location,
					'theme_option'   => get_template_directory() . "$path/main/theme-options.txt",
					'content_path'   => get_template_directory() . "$path/demo/home-{$demo}/data/content.xml",
					'widget_path'    => get_template_directory() . "$path/main/widgets.wie",
					'revslider_path' => get_template_directory() . "$path/demo/home-{$demo}/revsliders/",
				);
			}
			$data['data_import'] = array(
				'main_demo'      => 'https://ocolus.kutethemes.net',
				'theme_option'   => get_template_directory() . "$path/main/theme-options.txt", // key: _ovic_customize_options
				'content_path'   => get_template_directory() . "$path/main/content.xml",
				'widget_path'    => get_template_directory() . "$path/main/widgets.wie",
				'revslider_path' => get_template_directory() . "$path/revsliders/",
			);
			$data['data_demos']  = $data_demo;
			$data['woo_single']  = 800;
			$data['woo_catalog'] = 262;
			$data['woo_ratio']   = '262:360';

			return $data;
		}
	}
}