<?php
if ( !defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}
/**
 *
 * HOOK FUNCTION
 **/
add_filter( 'get_pagenum_link', 'ocolus_pagenum_link' );
/**
 *
 * TEMPLATES FUNCTION
 **/
if ( !function_exists( 'ocolus_post_thumbnail' ) ) {
	function ocolus_post_thumbnail( $width, $height, $placeholder = true, $readmore = false, $date = false )
	{
		$width  = apply_filters( 'ocolus_post_thumbnail_width', $width );
		$height = apply_filters( 'ocolus_post_thumbnail_height', $height );
		?>
        <div class="post-thumb">
            <a href="<?php the_permalink(); ?>" class="thumb-link">
                <figure>
					<?php
					$thumb = ocolus_resize_image( get_post_thumbnail_id(), $width, $height, true, true, $placeholder );
					echo wp_specialchars_decode( $thumb['img'] );
					?>
                </figure>
				<?php if ( $readmore ) : ?>
                    <span class="readmore-wrap">
                        <span class="readmore-inner">
                            <span class="readmore"><?php echo esc_html__( 'Read More', 'ocolus' ); ?></span>
                        </span>
                    </span>
				<?php endif; ?>
				<?php if ( $date ) : ?>
                    <span class="date-post">
                        <span class="date"><?php echo get_the_date( 'd' ); ?></span>
                        <span class="month"><?php echo get_the_date( 'F' ); ?></span>
                    </span>
				<?php endif; ?>
            </a>
			<?php do_action( 'ocolus_post_thumbnail_inner' ); ?>
        </div>
		<?php
	}
}
if ( !function_exists( 'ocolus_scroll_sticky' ) ) {
	function ocolus_scroll_sticky()
	{
		global $post;
		$sticky_heading = ocolus_get_option( 'sticky_post_title' );
		if ( $sticky_heading == 1 ) : ?>
            <div class="scroll-percent">
                <div class="recent-post">
					<?php $link = get_permalink( $post->ID ); ?>
                    <span class="reading">
					<?php echo esc_html__( 'Reading Now', 'ocolus' ); ?>
                </span>
                    <h2 class="post-title">
                        <span><?php echo esc_html( $post->post_title ); ?></span>
                    </h2>
					<?php if ( comments_open( $post->ID ) ) : ?>
                        <a href="<?php echo esc_url( $link . '#commentform' ); ?>"
                           class="message ocolus-message-to-comment">
                            <span class="icomoon-Comment"></span>
                        </a>
					<?php endif; ?>
                </div>
                <span class="percent"></span>
            </div>
		<?php endif;
	}
}
if ( !function_exists( 'ocolus_pagenum_link' ) ) {
	function ocolus_pagenum_link( $result )
	{
		$result = remove_query_arg( 'ocolus_raw_content', $result );

		return $result;
	}
}
if ( !function_exists( 'ocolus_post_pagination' ) ) {
	function ocolus_post_pagination()
	{
		$pagination = ocolus_get_option( 'blog_pagination', 'pagination' );
		if ( get_post_type() == 'portfolio' ) {
			$pagination = ocolus_get_option( 'portfolio_pagination', 'pagination' );
		}
		global $wp_query;
		$max   = $wp_query->max_num_pages;
		$paged = ( get_query_var( 'paged' ) ) ? get_query_var( 'paged' ) : 1;
		echo '<div class="pagination-nav type-' . $pagination . '">';
		if ( $pagination == 'pagination' ) {
			// Don't print empty markup if there's only one page.
			if ( $max >= 2 ) {
				echo get_the_posts_pagination( array(
						'screen_reader_text' => '&nbsp;',
						'before_page_number' => '',
						'prev_text'          => '<span class="fa fa-caret-left"></span>',
						'next_text'          => '<span class="fa fa-caret-right"></span>',
					)
				);
			}
		} else {
			$next_post = get_next_posts_page_link();
			if ( !empty( $next_post ) && $max >= 2 ) {
				if ( $pagination == 'load_more' ) {
					?>
                    <a href="#" class="button-loadmore"
                       data-url="<?php echo esc_attr( $next_post ); ?>"
                       data-total="<?php echo esc_attr( $max ); ?>"
                       data-current="<?php echo esc_attr( $paged ); ?>">
						<?php echo esc_html__( 'LOAD MORE', 'ocolus' ); ?>
                    </a>
					<?php
				} else {
					?>
                    <span class="button-loadmore"
                          data-url="<?php echo esc_attr( $next_post ); ?>"
                          data-total="<?php echo esc_attr( $max ); ?>"
                          data-current="<?php echo esc_attr( $paged ); ?>">
                        <?php echo esc_html__( 'LOADING', 'ocolus' ); ?>
                    </span>
					<?php
				}
			}
		}
		echo '</div>';
	}
}
if ( !function_exists( 'ocolus_pagination_thumb' ) ) {
	function ocolus_pagination_thumb()
	{
		$prev_post = get_previous_post();
		$next_post = get_next_post();
		?>
        <nav class="pagination-thumb">
			<?php if ( !empty( $next_post ) ):
				$image = has_post_thumbnail( $next_post->ID ) ? wp_get_attachment_image_url( get_post_thumbnail_id( $next_post->ID ), 'full' ) : '';
				?>
                <div class="other-post next" style="background-image: url(<?php echo esc_url( $image ); ?>)">
                    <div class="icon"><span class="fa fa-long-arrow-left"></span></div>
                    <div class="info">
						<?php ocolus_post_category( $next_post->ID ); ?>
                        <h4 class="name"><?php echo esc_html( $next_post->post_title ) ?></h4>
                    </div>
                    <a href="<?php the_permalink( $next_post->ID ); ?>"></a>
                </div>
			<?php endif; ?>
			<?php if ( !empty( $prev_post ) ):
				$image = has_post_thumbnail( $prev_post->ID ) ? wp_get_attachment_image_url( get_post_thumbnail_id( $prev_post->ID ), 'full' ) : '';
				?>
                <div class="other-post prev" style="background-image: url(<?php echo esc_url( $image ); ?>)">
                    <div class="info">
						<?php ocolus_post_category( $prev_post->ID ); ?>
                        <h4 class="name"><?php echo esc_html( $prev_post->post_title ) ?></h4>
                    </div>
                    <div class="icon"><span class="fa fa-long-arrow-right"></span></div>
                    <a href="<?php the_permalink( $prev_post->ID ); ?>"></a>
                </div>
			<?php endif; ?>
        </nav>
		<?php
	}
}
if ( !function_exists( 'ocolus_pagination_portfolio' ) ) {
	function ocolus_pagination_portfolio()
	{
		$prev_post = get_previous_post();
		$next_post = get_next_post();
		?>
        <nav class="pagination-thumb">
			<?php if ( !empty( $next_post ) ): ?>
                <div class="other-post prev">
                    <a href="<?php the_permalink( $next_post->ID ); ?>">
                        <span class="icomoon-Left-arrow icon"></span>
                        <span class="info">
                            <span class="text"><?php echo esc_html__( 'Previous Project', 'ocolus' ); ?></span>
                            <span class="name"><?php echo esc_html( $next_post->post_title ) ?></span>
                        </span>
                    </a>
                </div>
			<?php endif; ?>
            <span class="icomoon-Grid"></span>
			<?php if ( !empty( $prev_post ) ): ?>
                <div class="other-post next">
                    <a href="<?php the_permalink( $prev_post->ID ); ?>">
                        <span class="info">
                            <span class="text"><?php echo esc_html__( 'Next Project', 'ocolus' ); ?></span>
                            <span class="name"><?php echo esc_html( $prev_post->post_title ) ?></span>
                        </span>
                        <span class="icomoon-Right-arrow icon"></span>
                    </a>
                </div>
			<?php endif; ?>
        </nav>
		<?php
	}
}
if ( !function_exists( 'ocolus_post_title' ) ) {
	function ocolus_post_title( $wrap = true )
	{
		if ( get_the_title() ) {
			if ( $wrap == true ) {
				echo '<h2 class="post-title"><a href="' . get_permalink() . '">' . get_the_title() . '</a></h2>';
			} else {
				echo '<h2 class="post-title"><span>' . get_the_title() . '</span></h2>';
			}
		}
	}
}
if ( !function_exists( 'ocolus_post_breadcrumb' ) ) {
	function ocolus_post_breadcrumb()
	{
		if ( is_home() ) : ?>
            <div class="page-header style-1">
				<?php if ( is_front_page() ) : ?>
                    <h1 class="page-title">
						<?php esc_html_e( 'Latest Posts', 'ocolus' ); ?>
                    </h1>
					<?php do_action( 'ovic_breadcrumb' ); ?>
				<?php else: ?>
                    <h1 class="page-title">
						<?php single_post_title(); ?>
                    </h1>
					<?php do_action( 'ovic_breadcrumb' ); ?>
				<?php endif; ?>
            </div>
		<?php elseif ( is_single() ) : ?>
            <div class="page-header style-2">
				<?php do_action( 'ovic_breadcrumb' ); ?>
            </div>
		<?php elseif ( is_page() ) : ?>
            <div class="page-header style-1">
                <h1 class="page-title">
					<?php single_post_title(); ?>
                </h1>
				<?php do_action( 'ovic_breadcrumb' ); ?>
            </div>
		<?php else: ?>
            <div class="page-header style-1">
				<?php if ( is_search() ) : ?>
                    <h1 class="page-title">
						<?php printf( esc_html__( 'Search Results for: "%s"', 'ocolus' ), '<span class="search-results">' . get_search_query() . '</span>' ); ?>
                    </h1>
					<?php do_action( 'ovic_breadcrumb' ); ?>
				<?php else: ?>
                    <h1 class="page-title">
						<?php the_archive_title( '', '' ); ?>
                    </h1>
					<?php do_action( 'ovic_breadcrumb' ); ?>
					<?php the_archive_description( '<div class="taxonomy-description">', '</div>' ); ?>
				<?php endif; ?>
            </div>
		<?php endif;
	}
}
if ( !function_exists( 'ocolus_post_meta_single' ) ) {
	function ocolus_post_meta_single()
	{
		?>
        <div class="meta-data">
			<?php ocolus_post_category(); ?>
            <h1 class="post-title"><span><?php the_title(); ?></span></h1>
            <div class="list-meta">
				<?php ocolus_post_author(); ?>
                <div class="date">
					<?php echo get_the_date(); ?>
                </div>
                <div class="comment">
					<?php comments_number(
						esc_html__( '0 Comments', 'ocolus' ),
						esc_html__( '1 Comment', 'ocolus' ),
						esc_html__( '% Comments', 'ocolus' )
					); ?>
                </div>
				<?php do_action( 'ovic_simple_likes_button' ); ?>
            </div>
        </div>
		<?php
	}
}
if ( !function_exists( 'ocolus_portfolio_meta_single' ) ) {
	function ocolus_portfolio_meta_single()
	{
		?>
        <div class="meta-data">
            <div class="post-date">
                <span class="title"><?php echo esc_html__( 'DATE', 'ocolus' ) ?></span>
                <span class="date">
                    <?php echo get_the_date(); ?>
                </span>
            </div>
			<?php ocolus_post_taxonomy(
				null,
				'portfolio-client',
				esc_html__( 'CLIENT', 'ocolus' )
			); ?>
			<?php ocolus_post_taxonomy(
				null,
				'portfolio-team',
				esc_html__( 'TEAM', 'ocolus' )
			); ?>
			<?php ocolus_post_taxonomy(
				null,
				'portfolio-service',
				esc_html__( 'SERVICE', 'ocolus' )
			); ?>
        </div>
		<?php
	}
}
if ( !function_exists( 'ocolus_post_readmore' ) ) {
	function ocolus_post_readmore()
	{
		?>
        <a href="<?php the_permalink(); ?>" class="button readmore">
            <span><?php echo esc_html__( 'Read More', 'ocolus' ); ?></span>
        </a>
		<?php
	}
}
if ( !function_exists( 'ocolus_callback_comment' ) ) {
	/**
	 * Ocolus comment template
	 *
	 * @param array $comment the comment array.
	 * @param array $args the comment args.
	 * @param int   $depth the comment depth.
	 *
	 * @since 1.0.0
	 */
	function ocolus_callback_comment( $comment, $args, $depth )
	{
		if ( 'div' == $args['style'] ) {
			$tag       = 'div ';
			$add_below = 'comment';
		} else {
			$tag       = 'li ';
			$add_below = 'div-comment';
		}
		?>
        <<?php echo esc_attr( $tag ); ?><?php comment_class( empty( $args['has_children'] ) ? '' : 'parent' ) ?> id="comment-<?php echo get_comment_ID(); ?>">
        <div class="comment-body">
            <div class="comment-meta">
				<?php if ( get_avatar( $comment, 48 ) ): ?>
                    <div class="comment-avatar">
                        <figure><?php echo get_avatar( $comment, 48 ); ?></figure>
                    </div>
				<?php endif; ?>
                <div class="comment-metadata">
                    <div class="comment-author vcard">
						<?php printf( wp_kses_post( '<cite class="fn">%s</cite>', 'ocolus' ), get_comment_author_link() ); ?>
                    </div>
                    <div class="comment-date">
                        <a href="<?php echo esc_url( htmlspecialchars( get_comment_link( get_comment_ID() ) ) ); ?>">
							<?php echo '<time datetime="' . get_comment_date() . '">' . get_comment_date() . '</time>'; ?>
                        </a>
                    </div>
					<?php edit_comment_link( esc_html__( 'Edit', 'ocolus' ), '<span class="edit-link">', '</span>' ); ?>
                </div>
            </div>
			<?php if ( '0' == $comment->comment_approved ) : ?>
                <div class="comment-approve">
                    <em class="comment-awaiting-moderation"><?php esc_attr_e( '(Your comment is awaiting moderation.)', 'ocolus' ); ?></em>
                </div>
			<?php endif; ?>
			<?php echo ( 'div' != $args['style'] ) ? '<div id="div-comment-' . get_comment_ID() . '" class="comment-content">' : '' ?>
            <div class="comment-text">
				<?php comment_text(); ?>
            </div>
			<?php comment_reply_link( array_merge( $args, array( 'add_below' => $add_below, 'depth' => $depth, 'max_depth' => $args['max_depth'] ) ) ); ?>
			<?php echo 'div' != $args['style'] ? '</div>' : ''; ?>
        </div>
		<?php
	}
}
if ( !function_exists( 'ocolus_post_excerpt' ) ) {
	function ocolus_post_excerpt( $count = 35 )
	{
		?>
        <div class="post-excerpt">
			<?php
			if ( $count == null ) {
				echo apply_filters( 'the_excerpt', get_the_excerpt() );
			} else {
				echo wp_trim_words( apply_filters( 'the_excerpt', get_the_excerpt() ), $count, esc_html__( '...', 'ocolus' ) );
			}
			?>
        </div>
		<?php
	}
}
if ( !function_exists( 'ocolus_post_content' ) ) {
	function ocolus_post_content()
	{
		if ( !is_search() ):
			?>
            <div class="post-content">
				<?php
				/* translators: %s: Name of current post */
				the_content( sprintf(
						__( 'Continue reading %s', 'ocolus' ),
						the_title( '<span class="screen-reader-text">', '</span>', false )
					)
				);
				wp_link_pages( array(
						'before'      => '<div class="post-pagination"><span class="title">' . esc_html__( 'Pages:', 'ocolus' ) . '</span>',
						'after'       => '</div>',
						'link_before' => '<span>',
						'link_after'  => '</span>',
					)
				);
				?>
            </div>
		<?php
		endif;
	}
}
if ( !function_exists( 'ocolus_post_author' ) ) {
	function ocolus_post_author()
	{
		?>
        <a class="author" href="<?php echo esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ) ?>">
            <span><?php echo esc_html__( 'By', 'ocolus' ); ?></span>
			<?php the_author(); ?>
        </a>
		<?php
	}
}
if ( !function_exists( 'ocolus_info_author' ) ) {
	function ocolus_info_author()
	{
		$author_id = get_the_author_meta( 'ID' );
		if ( get_the_author_meta( 'description' ) != '' ):
			?>
            <div class="content-author">
                <div class="avatar">
					<?php echo get_avatar( $author_id, 170 ); ?>
                </div>
                <div class="info">
                    <a class="name" href="<?php echo esc_url( get_author_posts_url( $author_id ) ) ?>">
						<?php the_author(); ?>
                    </a>
                    <p class="desc"><?php echo nl2br( get_the_author_meta( 'description' ) ); ?></p>
					<?php ocolus_author_social( $author_id ); ?>
                </div>
            </div>
		<?php
		endif;
	}
}
if ( !function_exists( 'ocolus_post_tags' ) ) {
	function ocolus_post_tags()
	{
		$get_term_tag = get_the_terms( get_the_ID(), 'post_tag' );
		if ( !is_wp_error( $get_term_tag ) && !empty( $get_term_tag ) && !is_search() ) : ?>
            <div class="post-tags">
				<?php the_tags( '<ul><li>', '</li><li>', '</li></ul>' ); ?>
            </div>
		<?php endif;
	}
}
if ( !function_exists( 'ocolus_post_category' ) ) {
	function ocolus_post_category( $id = null )
	{
		if ( $id == null ) {
			$id = get_the_ID();
		}
		$get_term_cat = get_the_terms( $id, 'category' );
		if ( !is_wp_error( $get_term_cat ) && !empty( $get_term_cat ) && !is_search() ) : ?>
            <div class="post-category">
				<?php the_category( '', '', $id ); ?>
            </div>
		<?php endif;
	}
}
if ( !function_exists( 'ocolus_post_taxonomy' ) ) {
	function ocolus_post_taxonomy( $id = null, $tax_name = 'category', $title = '' )
	{
		if ( $id == null ) {
			$id = get_the_ID();
		}
		$taxonomies = get_the_terms( $id, $tax_name );
		if ( !is_wp_error( $taxonomies ) && !empty( $taxonomies ) && !is_search() ) : ?>
            <div class="post-taxonomy">
				<?php if ( $title != '' ): ?>
                    <span class="title"><?php echo esc_html( $title ); ?></span>
				<?php endif; ?>
                <ul>
					<?php foreach ( $taxonomies as $taxonomy ) : ?>
						<?php $link = get_term_link( $taxonomy->term_id, $tax_name ); ?>
                        <li>
                            <a href="<?php echo esc_url( $link ); ?>">
								<?php echo esc_html( $taxonomy->name ); ?>
                            </a>
                        </li>
					<?php endforeach; ?>
                </ul>
            </div>
		<?php endif;
	}
}
if ( !function_exists( 'ocolus_share_button' ) ) {
	function ocolus_share_button()
	{
		$enable = ocolus_get_option( 'enable_share' );
		if ( $enable != 1 )
			return;
		ocolus_share_social();
	}
}
if ( !function_exists( 'ocolus_portfolio_block_filter' ) ) {
	function ocolus_portfolio_block_filter()
	{
		$title        = ocolus_get_option( 'portfolio_title', '' );
		$desc         = ocolus_get_option( 'portfolio_desc', '' );
		$categories   = ocolus_get_option( 'portfolio_cat' );
		$class_active = '';
		if ( is_post_type_archive( 'portfolio' ) ) {
			$class_active = ' active';
		}
		?>
        <div class="block-portfolio-title">
            <div class="block-title">
                <h1 class="page-title">
					<?php
					if ( !empty( $title ) && is_post_type_archive( 'portfolio' ) ) {
						echo esc_html( $title );
					} else {
						the_archive_title( '', '' );
					}
					?>
                </h1>
				<?php
				if ( !empty( $desc ) && is_post_type_archive( 'portfolio' ) ) {
					echo '<p class="taxonomy-description">' . wp_specialchars_decode( $desc ) . '</p>';
				} else {
					the_archive_description( '<p class="taxonomy-description">', '</p>' );
				}
				?>
            </div>
			<?php if ( !empty( $categories ) ): ?>
                <div class="block-filter">
                    <ul>
                        <li class="filter-item<?php echo esc_attr( $class_active ); ?>">
                            <a href="<?php echo get_post_type_archive_link( 'portfolio' ); ?>">
								<?php echo esc_html__( 'All', 'ocolus' ); ?>
                            </a>
                        </li>
						<?php foreach ( $categories as $cat_id ) : ?>
							<?php
							$active       = '';
							$current_term = get_queried_object();
							if ( !empty( $current_term ) && !empty( $current_term->term_id ) && $current_term->term_id == $cat_id ) {
								$active = ' active';
							}
							$term = get_term_by( 'id', $cat_id, 'portfolio-category' );
							$url  = get_term_link( $term->term_id, 'portfolio-category' );
							?>
                            <li class="filter-item<?php echo esc_attr( $active ); ?>">
                                <a href="<?php echo esc_url( $url ); ?>">
									<?php echo esc_html( $term->name ); ?>
                                </a>
                            </li>
						<?php endforeach; ?>
                    </ul>
                </div>
			<?php endif; ?>
        </div>
		<?php
	}
}