(function ($) {
    'use strict';

    document.addEventListener('DOMContentLoaded', function () {
        /**
         *
         * <div class="wrapper-main-content" style="position: relative;">
         *     <div class="wrap-sticky-content">
         *         <div class="sticky-content" data-top="10" data-bottom="10" data-screen="1199">
         *     </div>
         *     <div class="normal-content">
         * </div>
         *
         * @use: $('.sticky-content').ocolus_sticky_sidebar();
         * */
        $.fn.ocolus_sticky_sidebar = function () {
            var _this = $(this);
            if ( _this.closest('.wrapper-main-content').length ) {
                if ( _this.closest('.sticky-content-wrap').length === 0 ) {
                    _this.wrap('<div class="sticky-content-wrap"></div>');
                }
                _this.on('ocolus_sticky_sidebar', function () {
                    _this.each(function () {
                        var _wrap_content    = $(this).closest('.wrapper-main-content'),
                            _wrap_sticky     = $(this).closest('.sticky-content-wrap'),
                            _sidebar_content = $(this);

                        var _StickyScrollTop    = 0,
                            _StickyScrollBottom = 0,
                            _StickyScrollScreen = 767,
                            _lastScrollTop      = 0;


                        if ( _sidebar_content.data('top') !== undefined && _sidebar_content.data('top') !== '' ) {
                            _StickyScrollTop += _sidebar_content.data('top');
                        }
                        if ( $('.scroll-percent').length ) {
                            _StickyScrollTop += $('.scroll-percent').outerHeight();
                        }
                        if ( $('.header-sticky').length ) {
                            _StickyScrollTop += $('.header-sticky').outerHeight();
                        }
                        if ( _sidebar_content.data('bottom') !== undefined && _sidebar_content.data('bottom') !== '' ) {
                            _StickyScrollBottom = _sidebar_content.data('bottom');
                        }
                        if ( _sidebar_content.data('screen') !== undefined && _sidebar_content.data('screen') !== '' ) {
                            _StickyScrollScreen = _sidebar_content.data('screen');
                        }
                        if ( $('body').hasClass('admin-bar') ) {
                            _StickyScrollTop += $('#wpadminbar').outerHeight();
                        }
                        _wrap_sticky.css({
                            'min-height': '1px',
                            'display': 'inline',
                        });
                        _wrap_content.css({
                            'position': 'relative',
                        });
                        $(window).on('scroll ocolus_load_more_post', function () {
                            if ( $(window).innerWidth() > _StickyScrollScreen ) {
                                /* SIDEBAR */
                                var _scroll_window       = $(window).scrollTop(),
                                    _offset_sidebar      = _sidebar_content.offset(),
                                    _offset_content      = _wrap_content.offset(),
                                    _full_height_content = _wrap_content.height() + _offset_content.top,
                                    _full_height_sidebar = _sidebar_content.outerHeight() + _scroll_window + _StickyScrollTop + _StickyScrollBottom;

                                /* SCROLL DOWN */
                                if ( _scroll_window > _lastScrollTop ) {
                                    if ( _full_height_sidebar > _full_height_content ) {
                                        _sidebar_content.addClass('block-sticky').css({
                                            top: 'auto',
                                            bottom: _StickyScrollBottom,
                                            position: 'absolute',
                                            width: '',
                                        });
                                    } else if ( _offset_sidebar.top - _StickyScrollTop < _scroll_window ) {
                                        _sidebar_content.addClass('sticky').css({
                                            top: _StickyScrollTop,
                                            position: 'fixed',
                                            bottom: 'auto',
                                            width: _sidebar_content.width(),
                                        });
                                    }
                                } else {
                                    /* SCROLL UP */
                                    if ( _offset_sidebar.top >= _scroll_window ) {
                                        if ( _offset_content.top - _StickyScrollTop > _scroll_window ) {
                                            _sidebar_content.removeClass('sticky').css({
                                                top: 'auto',
                                                bottom: 'auto',
                                                position: 'inherit',
                                                width: '',
                                            });
                                        } else if ( _offset_sidebar.top - _StickyScrollTop > _scroll_window ) {
                                            _sidebar_content.removeClass('block-sticky').css({
                                                top: _StickyScrollTop,
                                                position: 'fixed',
                                                bottom: 'auto',
                                                width: _sidebar_content.width(),
                                            });
                                        }
                                    }
                                }
                                _lastScrollTop = _scroll_window;
                            }
                        });
                    });
                }).trigger('ocolus_sticky_sidebar');
                $(window).on('resize', function () {
                    if ( $(window).width() > 767 ) {
                        var _wrap_content = _this.closest('.wrapper-main-content'),
                            _wrap_static  = _wrap_content.find('.sticky-static-content');

                        if ( _wrap_static.length ) {
                            var _content_width = _wrap_content.outerWidth(true),
                                _static_width  = _wrap_static.outerWidth(true);

                            _this.css({
                                width: (_content_width - _static_width),
                            });
                        }
                    }
                });
            }
        };

        if ( $('.sticky-content').length ) {
            $('.sticky-content').ocolus_sticky_sidebar();
        }
    }, false);
})(window.jQuery);