(function ($) {
    'use strict';

    window.addEventListener('load', function () {
        if ( $('.ovic-magnific-popup').length ) {
            $('.ovic-magnific-popup').each(function () {
                var _this   = $(this),
                    _items  = [],
                    _config = [];

                if ( _this.hasClass('video') ) {
                    _items = {
                        src: _this.attr('href'),
                        type: 'iframe'
                    };
                }
                if ( _this.hasClass('inline-content') ) {
                    _items = {
                        src: $(_this.data('content')),
                        type: 'inline'
                    };
                }
                if ( _this.hasClass('popup-content') ) {
                    _items = {
                        src: _this.data('popup'),
                        type: 'inline'
                    };
                }
                if ( _this.hasClass('ajax-content') ) {
                    _items = {
                        src: _this.attr('href'),
                        type: 'ajax'
                    };
                }
                _this.magnificPopup({
                    items: _items,
                    type: 'image', // this is a default type
                    callbacks: {
                        open: function() {
                            $(window).trigger('resize');
                        },
                    }
                });
            });
        }
    }, false);
})(window.jQuery);