(function ($) {
    'use strict';

    function ocolus_cols($isotope) {
        var row   = 1,
            width = $isotope.width(),
            col   = $isotope.attr("data-cols");

        if ( col === undefined || col === 0 ) {
            return 0;
        }
        if ( col == "1" ) {
            return 1;
        }
        if ( col == "2" ) {
            row = 2;
            if ( width < 720 ) {
                row = 1;
            }
            return row;
        }
        if ( col == "3" ) {
            row = 3;
            if ( width < 720 ) {
                row = 1;
            } else if ( width >= 720 && width < 960 ) {
                row = 2;
            } else if ( width >= 960 ) {
                row = 3;
            }
            return row;
        }
        if ( col == "4" ) {
            row = 4;
            if ( width < 480 ) {
                row = 1;
            } else if ( width >= 480 && width < 960 ) {
                row = 2;
            } else if ( width >= 960 && width < 1140 ) {
                row = 3;
            } else if ( width >= 1140 ) {
                row = 4;
            }
            return row;
        }
        if ( col == "5" ) {
            row = 5;
            if ( width < 480 ) {
                row = 1;
            } else if ( width >= 480 && width < 720 ) {
                row = 2;
            } else if ( width >= 720 && width < 960 ) {
                row = 3;
            } else if ( width >= 960 && width < 1140 ) {
                row = 4;
            } else if ( width >= 1140 ) {
                row = 5;
            }
            return row;
        }
        if ( col == "6" ) {
            row = 6;
            if ( width < 480 ) {
                row = 1;
            } else if ( width >= 480 && width < 720 ) {
                row = 2;
            } else if ( width >= 720 && width < 960 ) {
                row = 3;
            } else if ( width >= 960 && width < 1140 ) {
                row = 4;
            } else if ( width >= 1140 ) {
                row = 6;
            }
            return row;
        }
    }

    function ocolus_grid($isotope) {
        if ( ocolus_cols($isotope) !== 0 ) {
            var col   = ocolus_cols($isotope),
                item  = $isotope.find('.isotope-item'),
                width = $isotope.width(),
                row   = width / col;
            row       = Math.floor(row);
            item.css('width', row);
        }
    }

    $.fn.ocolus_isotope_grid = function () {
        var _this = $(this);
        _this.on('ocolus_isotope_grid', function () {
            _this.each(function () {
                var $this   = $(this),
                    $layout = $this.data('layout'),
                    $grid   = $this.isotope({
                        percentPosition: true,
                        itemSelector: '.isotope-item',
                        layoutMode: $layout,
                        masonry: {
                            columnWidth: 100,
                            fitWidth: true,
                            horizontalOrder: true
                        }
                    });
                ocolus_grid($this);
                $grid.imagesLoaded(function () {
                    $grid.isotope('layout');
                });
            });
        }).trigger('ocolus_isotope_grid');
        $(window).on('resize ocolus_better_equal_elems', function () {
            _this.trigger('ocolus_isotope_grid');
        });
    };
    document.addEventListener("DOMContentLoaded", function () {
        if ( $('.ocolus-isotope').length ) {
            $('.ocolus-isotope').ocolus_isotope_grid();
        }
    });
})(window.jQuery);