(function ($) {
    'use strict';

    var date_format = function (data, number) {
        var text_number = '',
            text_format = '';

        if ( data.days_text !== undefined ) {
            text_number = '%D';
            if ( number === false ) {
                text_number = '00';
            }
            text_format += '<span class="days"><span class="number">' + text_number + '</span><span class="text">' + data.days_text + '</span></span>';
        }
        if ( data.hrs_text !== undefined ) {
            text_number = '%H';
            if ( data.days_text === undefined ) {
                text_number = '%I';
            }
            if ( number === false ) {
                text_number = '00';
            }
            text_format += '<span class="hours"><span class="number">' + text_number + '</span><span class="text">' + data.hrs_text + '</span></span>';
        }
        if ( data.mins_text !== undefined ) {
            text_number = '%M';
            if ( data.hrs_text === undefined ) {
                text_number = '%N';
            }
            if ( number === false ) {
                text_number = '00';
            }
            text_format += '<span class="mins"><span class="number">' + text_number + '</span><span class="text">' + data.mins_text + '</span></span>';
        }
        if ( data.secs_text !== undefined ) {
            text_number = '%S';
            if ( data.mins_text === undefined ) {
                text_number = '%T';
            }
            if ( number === false ) {
                text_number = '00';
            }
            text_format += '<span class="secs"><span class="number">' + text_number + '</span><span class="text">' + data.secs_text + '</span></span>';
        }

        return text_format;
    };

    $.fn.ocolus_countdown = function () {
        var $this = $(this);
        $this.on('ocolus_countdown', function () {
            $this.each(function () {
                var el             = $(this),
                    data           = el.data('params'),
                    text_countdown = '';

                el.countdown(el.data('datetime'), {elapse: true})
                    .on('update.countdown', function (event) {
                        if ( event.elapsed ) {
                            text_countdown = event.strftime(date_format(data, false));
                        } else {
                            text_countdown = event.strftime(date_format(data, true));
                        }
                        el.html(text_countdown);
                    });
            });
        }).trigger('ocolus_countdown');
    };
    $(document).on('ocolus_countdown', function (event) {
        if ( $(event.target).closest('.equal-container.better-height').length && $.fn.ocolus_better_equal_elems ) {
            $(event.target).closest('.equal-container.better-height').ocolus_better_equal_elems();
        }
    });

    document.addEventListener("DOMContentLoaded", function () {
        if ( $('.ocolus-countdown').length ) {
            $('.ocolus-countdown').ocolus_countdown();
        }
    });
})(window.jQuery);