<?php
/**
 * The main template file
 *
 * This is the most generic template file in a WordPress theme
 * and one of the two required files for a theme (the other being style.css).
 * It is used to display a page when nothing more specific matches a query.
 * E.g., it puts together the home page when no home.php file exists.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package WordPress
 * @subpackage Ocolus
 * @since 1.0
 * @version 1.0
 */
get_header();
$full_width = ocolus_get_option( 'portfolio_full_width' );
$gutter     = ocolus_get_option( 'portfolio_gutter' );
$post_style = ocolus_get_option( 'portfolio_list_style', 'grid' );
if ( is_search() ) {
	$post_style = 'grid';
}
/* CLASS */
$main_class            = array( "site-content portfolio-archive", "portfolio-{$post_style}", "space-{$gutter}" );
$main_class['content'] = "container";
if ( $full_width == 1 ) {
	$main_class['content'] = "";
}
wp_enqueue_script( 'ocolus-grid-isotope' );
?>
    <!-- .site-content-contain -->
    <div id="content" class="<?php echo implode( ' ', $main_class ); ?>">

        <div id="primary" class="content-area">
            <main id="main" class="site-main" role="main">

				<?php
				get_template_part( "templates/portfolio/portfolio-content/{$post_style}" );
				?>

            </main><!-- #main -->
        </div><!-- #primary -->

    </div><!-- .site-content-contain -->
<?php get_footer();
