<?php
/**
 * The template for displaying 404 pages (not found)
 *
 * @link https://codex.wordpress.org/Creating_an_Error_404_Page
 *
 * @package WordPress
 * @subpackage Ocolus
 * @since 1.0
 * @version 1.0
 */
get_header();
?>
    <div class="wrap">
        <div id="primary" class="content-area">
            <main id="main" class="site-main" role="main">
                <section class="error-404 not-found">
                    <div class="container">
                        <figure class="img"></figure>
                        <h1 class="page-title"><?php _e( 'Oops! I&rsquo;m embarrassed...', 'ocolus' ); ?></h1>
                        <p>
                            <?php
                            _e( 'It may be that someone or something has eaten the page.', 'ocolus'
                            ); ?>
                        </p>
                        <p>
                            <?php
                            _e( 'Apologize for this inconvenience. Please try searching for something else or', 'ocolus'
                            ); ?>
                            <a href="<?php echo esc_url( home_url( '/' ) ); ?>"><?php _e( 'Back To Homepage', 'ocolus' ); ?></a>
                        </p>
                        <?php $unique_id = esc_attr( uniqid( 'search-form-' ) ); ?>
                        <form role="search" method="get" class="search-form"
                              action="<?php echo esc_url( home_url( '/' ) ); ?>">
                            <label>
                                <input type="search" id="<?php echo esc_attr( $unique_id ); ?>" class="search-field"
                                       placeholder="<?php echo esc_attr_x( 'Your keyword', 'placeholder', 'ocolus' ); ?>"
                                       value="<?php echo get_search_query(); ?>" name="s"/>
                            </label>
                            <button type="submit" class="search-submit">
                                <?php _e( 'SEARCH', 'ocolus' ); ?>
                            </button>
                        </form>
                    </div>
                </section><!-- .error-404 -->
            </main><!-- #main -->
        </div><!-- #primary -->
    </div><!-- .wrap -->
<?php get_footer();
